/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.data.IMultiController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;

public abstract class BaseValueEditor<T extends Control>
implements IValueEditor {
    private static final String RESULTS_EDIT_CONTEXT_ID = "org.jkiss.dbeaver.ui.context.resultset.edit";
    protected final IValueController valueController;
    protected T control;
    protected boolean dirty;
    protected boolean autoSaveEnabled;

    protected BaseValueEditor(IValueController valueController) {
        this.valueController = valueController;
    }

    @Override
    public void createControl() {
        T control = this.createControl(this.valueController.getEditPlaceholder());
        this.setControl(control);
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public void setControl(T control) {
        this.control = control;
        if (this.control != null && control != this.valueController.getEditPlaceholder()) {
            this.initInlineControl((Control)this.control);
        }
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller) throws DBCException {
    }

    protected abstract T createControl(Composite var1);

    protected void initInlineControl(Control inlineControl) {
        boolean isInline;
        boolean bl = isInline = this.valueController.getEditType() == IValueController.EditType.INLINE;
        if (isInline) {
            UIUtils.isInDialog((Control)inlineControl);
        }
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.valueController.getValueSite(), (Control)inlineControl);
        EditorUtils.trackControlContext((IWorkbenchSite)this.valueController.getValueSite(), (Control)inlineControl, (String)RESULTS_EDIT_CONTEXT_ID);
        if (isInline) {
            inlineControl.setFont(this.valueController.getEditPlaceholder().getFont());
            inlineControl.setFocus();
            if (this.valueController instanceof IMultiController) {
                inlineControl.addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 4) {
                            if (!BaseValueEditor.this.valueController.isReadOnly()) {
                                BaseValueEditor.this.saveValue();
                            }
                            ((IMultiController)((Object)BaseValueEditor.this.valueController)).closeInlineEditor();
                            e.doit = false;
                            e.detail = 0;
                        } else if (e.detail == 2) {
                            ((IMultiController)((Object)BaseValueEditor.this.valueController)).closeInlineEditor();
                            e.doit = false;
                            e.detail = 0;
                        } else if (e.detail == 16 || e.detail == 8) {
                            BaseValueEditor.this.saveValue();
                            ((IMultiController)((Object)BaseValueEditor.this.valueController)).nextInlineEditor(e.detail == 16);
                            e.doit = false;
                            e.detail = 0;
                        }
                    }
                });
                if (!UIUtils.isInDialog((Control)inlineControl)) {
                    this.addAutoSaveSupport(inlineControl);
                }
            }
        }
        ControlModifyListener modifyListener = new ControlModifyListener();
        this.control.addListener(24, (Listener)modifyListener);
        this.control.addListener(13, (Listener)modifyListener);
    }

    private void addAutoSaveSupport(Control inlineControl) {
        inlineControl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!BaseValueEditor.this.valueController.isReadOnly()) {
                    BaseValueEditor.this.saveValue();
                }
                if (BaseValueEditor.this.valueController instanceof IMultiController) {
                    ((IMultiController)((Object)BaseValueEditor.this.valueController)).closeInlineEditor();
                }
            }
        });
    }

    protected void saveValue() {
        try {
            Object newValue = this.extractEditorValue();
            if (this.dirty || this.control instanceof Combo || this.control instanceof CCombo || this.control instanceof List) {
                this.valueController.updateSelectionValue(newValue);
            }
        }
        catch (DBException e) {
            if (this.valueController instanceof IMultiController) {
                ((IMultiController)((Object)this.valueController)).closeInlineEditor();
            }
            DBWorkbench.getPlatformUI().showError("Value save", "Can't save edited value", (Throwable)e);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isAutoSaveEnabled() {
        return this.autoSaveEnabled;
    }

    public void setAutoSaveEnabled(boolean autoSaveEnabled) {
        this.autoSaveEnabled = autoSaveEnabled;
    }

    private class ControlModifyListener
    implements Listener {
        private ControlModifyListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 13 && !this.isListControl(event.widget)) {
                return;
            }
            BaseValueEditor.this.setDirty(true);
            if (BaseValueEditor.this.autoSaveEnabled && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("resultset.edit.value.autoupdate")) {
                BaseValueEditor.this.saveValue();
            }
        }

        private boolean isListControl(Widget control) {
            return !(control instanceof StyledText) && !(control instanceof Text) && !(control instanceof Table) && !(control instanceof Tree);
        }
    }
}

