/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComplexValue;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDReference;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.data.IMultiController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.IValueEditorStandalone;
import org.jkiss.dbeaver.ui.data.IValueManager;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerRegistry;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ComplexObjectEditor
extends TreeViewer {
    private static final Log log = Log.getLog(ComplexObjectEditor.class);
    private final IValueController parentController;
    private final IValueEditor editor;
    private DBCExecutionContext executionContext;
    private final TreeEditor treeEditor;
    private IValueEditor curCellEditor;
    private Color backgroundAdded;
    private Color backgroundDeleted;
    private Color backgroundModified;
    private CopyAction copyNameAction;
    private CopyAction copyValueAction;
    private Action addElementAction;
    private Action removeElementAction;
    private Map<Object, ComplexElement[]> childrenMap = new IdentityHashMap<Object, ComplexElement[]>();

    public ComplexObjectEditor(IValueController parentController, IValueEditor editor, int style) {
        super(parentController.getEditPlaceholder(), style | 4 | 0x10000);
        this.parentController = parentController;
        this.editor = editor;
        ITheme currentTheme = parentController.getValueSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme();
        this.backgroundAdded = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.new.background");
        this.backgroundDeleted = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.deleted.background");
        this.backgroundModified = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.modified.background");
        final Tree treeControl = super.getTree();
        treeControl.setHeaderVisible(true);
        treeControl.setLinesVisible(true);
        treeControl.addControlListener((ControlListener)new ControlAdapter(){
            private boolean packing = false;

            public void controlResized(ControlEvent e) {
                if (!this.packing) {
                    this.packing = true;
                    UIUtils.packColumns((Tree)treeControl, (boolean)true, (float[])new float[]{0.2f, 0.8f});
                    if (treeControl.getColumn(0).getWidth() < 100) {
                        treeControl.getColumn(0).setWidth(100);
                    }
                    treeControl.removeControlListener((ControlListener)this);
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this, (int)2);
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setMoveable(true);
        column.getColumn().setText(UIMessages.ui_properties_name);
        column.setLabelProvider((CellLabelProvider)new PropsLabelProvider(true));
        column = new TreeViewerColumn((TreeViewer)this, 0);
        column.getColumn().setWidth(120);
        column.getColumn().setMoveable(true);
        column.getColumn().setText(UIMessages.ui_properties_value);
        column.setLabelProvider((CellLabelProvider)new PropsLabelProvider(false));
        this.treeEditor = new TreeEditor(treeControl);
        this.treeEditor.horizontalAlignment = 131072;
        this.treeEditor.verticalAlignment = 0x1000000;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.minimumWidth = 50;
        treeControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem item = treeControl.getItem(new Point(e.x, e.y));
                if (item != null && UIUtils.getColumnAtPos((TreeItem)item, (int)e.x, (int)e.y) == 1) {
                    ComplexObjectEditor.this.showEditor(item, false);
                }
            }
        });
        treeControl.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    TreeItem[] selection = treeControl.getSelection();
                    if (selection.length == 0) {
                        return;
                    }
                    if (ComplexObjectEditor.this.treeEditor.getEditor() != null && !ComplexObjectEditor.this.treeEditor.getEditor().isDisposed()) {
                        e.doit = true;
                        return;
                    }
                    ComplexObjectEditor.this.showEditor(selection[0], (e.stateMask & 0x20000) == 131072);
                    e.doit = false;
                    e.detail = 0;
                }
            }
        });
        super.setContentProvider((IContentProvider)new StructContentProvider());
        this.copyNameAction = new CopyAction(true);
        this.copyValueAction = new CopyAction(false);
        this.addElementAction = new AddElementAction();
        this.removeElementAction = new RemoveElementAction();
        this.addElementAction.setEnabled(true);
        this.removeElementAction.setEnabled(false);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null || selection.isEmpty()) {
                    ComplexObjectEditor.this.copyNameAction.setEnabled(false);
                    ComplexObjectEditor.this.copyValueAction.setEnabled(false);
                    ComplexObjectEditor.this.removeElementAction.setEnabled(false);
                    ComplexObjectEditor.this.addElementAction.setEnabled(ComplexObjectEditor.this.getInput() instanceof DBDCollection);
                } else {
                    ComplexObjectEditor.this.copyNameAction.setEnabled(true);
                    ComplexObjectEditor.this.copyValueAction.setEnabled(true);
                    Object element = selection.getFirstElement();
                    if (element instanceof ArrayItem) {
                        ComplexObjectEditor.this.removeElementAction.setEnabled(true);
                        ComplexObjectEditor.this.addElementAction.setEnabled(true);
                    }
                }
            }
        });
        this.createContextMenu();
    }

    private void createContextMenu() {
        Control control = this.getControl();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(control);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (!ComplexObjectEditor.this.getSelection().isEmpty()) {
                    manager.add((IAction)ComplexObjectEditor.this.copyNameAction);
                    manager.add((IAction)ComplexObjectEditor.this.copyValueAction);
                    manager.add((IContributionItem)new Separator());
                }
                try {
                    ComplexObjectEditor.this.parentController.getValueManager().contributeActions((IContributionManager)manager, ComplexObjectEditor.this.parentController, ComplexObjectEditor.this.editor);
                }
                catch (DBCException e) {
                    log.error((Object)e);
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
    }

    public DBDComplexValue getInput() {
        return (DBDComplexValue)super.getInput();
    }

    public void setModel(DBCExecutionContext executionContext, DBDComplexValue value) {
        this.getTree().setRedraw(false);
        try {
            this.executionContext = executionContext;
            this.childrenMap.clear();
            this.setInput(value);
            this.expandToLevel(2);
        }
        finally {
            this.getTree().setRedraw(true);
        }
    }

    private void showEditor(TreeItem item, boolean advanced) {
        this.disposeOldEditor();
        if (item == null) {
            return;
        }
        try {
            ComplexValueController valueController = new ComplexValueController((ComplexElement)item.getData(), advanced ? IValueController.EditType.EDITOR : IValueController.EditType.INLINE);
            this.curCellEditor = valueController.getValueManager().createEditor(valueController);
            if (this.curCellEditor != null) {
                this.curCellEditor.createControl();
                if (this.curCellEditor instanceof IValueEditorStandalone) {
                    ((IValueEditorStandalone)this.curCellEditor).showValueEditor();
                } else if (this.curCellEditor.getControl() != null) {
                    this.treeEditor.setEditor(this.curCellEditor.getControl(), item, 1);
                }
                if (!advanced) {
                    this.curCellEditor.primeEditorValue(valueController.getValue());
                }
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Cell editor", "Can't open cell editor", (Throwable)e);
        }
    }

    private void disposeOldEditor() {
        this.curCellEditor = null;
        Control oldEditor = this.treeEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
    }

    public Object extractValue() {
        DBDComplexValue complexValue = this.getInput();
        ComplexElement[] items = this.childrenMap.get(complexValue);
        if (complexValue instanceof DBDValueCloneable) {
            try {
                complexValue = (DBDComplexValue)((DBDValueCloneable)complexValue).cloneValue((DBRProgressMonitor)new VoidProgressMonitor());
            }
            catch (DBCException e) {
                log.error((Object)"Error cloning complex value", (Throwable)e);
            }
        }
        if (complexValue instanceof DBDComposite) {
            int i = 0;
            while (i < items.length) {
                ((DBDComposite)complexValue).setAttributeValue(((CompositeField)items[i]).attribute, items[i].value);
                ++i;
            }
        } else if (complexValue instanceof DBDCollection && items != null) {
            Object[] newValues = new Object[items.length];
            int i = 0;
            while (i < items.length) {
                newValues[i] = items[i].value;
                ++i;
            }
            ((DBDCollection)complexValue).setContents(newValues);
        }
        return complexValue;
    }

    private String getColumnText(ComplexElement obj, int columnIndex, DBDDisplayFormat format) {
        if (obj instanceof CompositeField) {
            CompositeField field = (CompositeField)obj;
            if (columnIndex == 0) {
                return field.attribute.getName();
            }
            return this.getValueText(field.valueHandler, (DBSTypedObject)field.attribute, field.value, format);
        }
        if (obj instanceof ArrayItem) {
            ArrayItem item = (ArrayItem)obj;
            if (columnIndex == 0) {
                return String.valueOf(item.index);
            }
            return this.getValueText(item.array.valueHandler, (DBSTypedObject)item.array.componentType, item.value, format);
        }
        return String.valueOf(columnIndex);
    }

    private String getValueText(@NotNull DBDValueHandler valueHandler, @NotNull DBSTypedObject type, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBDCollection) {
            return "[" + ((DBDCollection)value).getComponentType().getName() + " - " + ((DBDCollection)value).getItemCount() + "]";
        }
        if (value instanceof DBDComposite) {
            return "[" + ((DBDComposite)value).getDataType().getName() + "]";
        }
        if (value instanceof DBDReference) {
            return "--> [" + ((DBDReference)value).getReferencedType().getName() + "]";
        }
        return valueHandler.getValueDisplayString(type, value, format);
    }

    @NotNull
    private ArrayInfo makeArrayInfo(DBDCollection array) {
        ArrayInfo arrayInfo = new ArrayInfo();
        arrayInfo.componentType = array.getComponentType();
        arrayInfo.valueHandler = DBUtils.findValueHandler((DBPDataSource)arrayInfo.componentType.getDataSource(), (DBSTypedObject)arrayInfo.componentType);
        return arrayInfo;
    }

    private void shiftArrayItems(ComplexElement[] arrayItems, int startIndex, int inc) {
        int i = startIndex;
        while (i < arrayItems.length) {
            ((ArrayItem)arrayItems[i]).index += inc;
            ++i;
        }
    }

    public void contributeActions(IContributionManager manager) {
        manager.add((IAction)this.addElementAction);
        manager.add((IAction)this.removeElementAction);
    }

    private class AddElementAction
    extends Action {
        public AddElementAction() {
            super("Add element", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_ADD));
        }

        public void run() {
            ArrayItem newItem;
            DBDCollection collection = (DBDCollection)ComplexObjectEditor.this.getInput();
            Object[] arrayItems = (ComplexElement[])ComplexObjectEditor.this.childrenMap.get(collection);
            if (arrayItems == null) {
                log.error((Object)"Can't find children items for add");
                return;
            }
            ITreeSelection selection = ComplexObjectEditor.this.getStructuredSelection();
            if (selection.isEmpty()) {
                newItem = new ArrayItem(ComplexObjectEditor.this.makeArrayInfo(collection), 0, null);
            } else {
                ArrayItem curItem = (ArrayItem)selection.getFirstElement();
                newItem = new ArrayItem(curItem.array, curItem.index + 1, null);
            }
            ComplexObjectEditor.this.shiftArrayItems((ComplexElement[])arrayItems, newItem.index, 1);
            arrayItems = (ComplexElement[])ArrayUtils.insertArea(ComplexElement.class, (Object[])arrayItems, (int)newItem.index, (Object[])new ComplexElement[]{newItem});
            ComplexObjectEditor.this.childrenMap.put(collection, arrayItems);
            ComplexObjectEditor.this.refresh();
            Widget treeItem = ComplexObjectEditor.this.findItem(newItem);
            if (treeItem != null) {
                ComplexObjectEditor.this.showEditor((TreeItem)treeItem, false);
            }
        }
    }

    private static class ArrayInfo {
        private DBDValueHandler valueHandler;
        private DBSDataType componentType;

        private ArrayInfo() {
        }
    }

    private static class ArrayItem
    extends ComplexElement {
        final ArrayInfo array;
        int index;

        private ArrayItem(ArrayInfo array, int index, Object value) {
            this.array = array;
            this.index = index;
            this.value = value;
        }
    }

    private static class ComplexElement {
        boolean created;
        boolean modified;
        Object value;

        private ComplexElement() {
        }
    }

    private class ComplexValueController
    implements IValueController,
    IMultiController {
        private final ComplexElement item;
        private final DBDValueHandler valueHandler;
        private final DBSTypedObject type;
        private final String name;
        private final Object value;
        private final IValueController.EditType editType;

        public ComplexValueController(ComplexElement obj, IValueController.EditType editType) throws DBCException {
            this.item = obj;
            if (this.item instanceof CompositeField) {
                CompositeField field = (CompositeField)this.item;
                this.valueHandler = field.valueHandler;
                this.type = field.attribute;
                this.name = field.attribute.getName();
                this.value = field.value;
            } else if (this.item instanceof ArrayItem) {
                ArrayItem arrayItem = (ArrayItem)this.item;
                this.valueHandler = arrayItem.array.valueHandler;
                this.type = arrayItem.array.componentType;
                this.name = String.valueOf(this.type.getTypeName()) + "[" + arrayItem.index + "]";
                this.value = arrayItem.value;
            } else {
                throw new DBCException("Unsupported complex object element: " + this.item);
            }
            this.editType = editType;
        }

        @Override
        @NotNull
        public DBCExecutionContext getExecutionContext() {
            return ComplexObjectEditor.this.executionContext;
        }

        @Override
        public String getValueName() {
            return this.name;
        }

        @Override
        public DBSTypedObject getValueType() {
            return this.type;
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.value;
        }

        @Override
        public void updateValue(Object value, boolean updatePresentation) {
            if (CommonUtils.equalObjects((Object)this.item.value, (Object)value)) {
                return;
            }
            this.item.value = value;
            this.item.modified = true;
            if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("resultset.edit.value.autoupdate")) {
                ComplexObjectEditor.this.parentController.updateValue(ComplexObjectEditor.this.extractValue(), false);
            }
            ComplexObjectEditor.this.refresh(this.item);
        }

        @Override
        public void updateSelectionValue(Object value) {
            this.updateValue(value, true);
        }

        @Override
        public DBDValueHandler getValueHandler() {
            return this.valueHandler;
        }

        @Override
        public IValueManager getValueManager() {
            DBSTypedObject valueType = this.getValueType();
            return ValueManagerRegistry.findValueManager(this.getExecutionContext().getDataSource(), valueType, this.getValueHandler().getValueObjectType(valueType));
        }

        @Override
        public IValueController.EditType getEditType() {
            return this.editType;
        }

        @Override
        public boolean isReadOnly() {
            return ComplexObjectEditor.this.parentController.isReadOnly();
        }

        @Override
        public IWorkbenchPartSite getValueSite() {
            return ComplexObjectEditor.this.parentController.getValueSite();
        }

        @Override
        public Composite getEditPlaceholder() {
            return ComplexObjectEditor.this.getTree();
        }

        @Override
        public void refreshEditor() {
            ComplexObjectEditor.this.parentController.refreshEditor();
        }

        @Override
        public void showMessage(String message, DBPMessageType messageType) {
        }

        @Override
        public void closeInlineEditor() {
            ComplexObjectEditor.this.disposeOldEditor();
        }

        @Override
        public void nextInlineEditor(boolean next) {
            ComplexObjectEditor.this.disposeOldEditor();
        }
    }

    private static class CompositeField
    extends ComplexElement {
        final DBSAttributeBase attribute;
        DBDValueHandler valueHandler;

        private CompositeField(DBPDataSource dataSource, DBSAttributeBase attribute, @Nullable Object value) {
            this.attribute = attribute;
            this.value = value;
            this.valueHandler = DBUtils.findValueHandler((DBPDataSource)dataSource, (DBSTypedObject)attribute);
        }
    }

    private class CopyAction
    extends Action {
        private final boolean isName;

        public CopyAction(boolean isName) {
            super(String.valueOf(WorkbenchMessages.Workbench_copy) + " " + ComplexObjectEditor.this.getTree().getColumn(isName ? 0 : 1).getText());
            this.isName = isName;
        }

        public void run() {
            String text;
            ITreeSelection selection = ComplexObjectEditor.this.getStructuredSelection();
            if (!selection.isEmpty() && (text = ComplexObjectEditor.this.getColumnText((ComplexElement)selection.getFirstElement(), this.isName ? 0 : 1, DBDDisplayFormat.NATIVE)) != null) {
                UIUtils.setClipboardContents((Display)ComplexObjectEditor.this.getTree().getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)text);
            }
        }
    }

    private class PropsLabelProvider
    extends CellLabelProvider {
        private final boolean isName;

        public PropsLabelProvider(boolean isName) {
            this.isName = isName;
        }

        public String getText(ComplexElement obj, int columnIndex) {
            return ComplexObjectEditor.this.getColumnText(obj, columnIndex, DBDDisplayFormat.UI);
        }

        public String getToolTipText(Object obj) {
            if (obj instanceof CompositeField) {
                return String.valueOf(((CompositeField)obj).attribute.getName()) + " " + ((CompositeField)obj).attribute.getTypeName();
            }
            return null;
        }

        public void update(ViewerCell cell) {
            ComplexElement element = (ComplexElement)cell.getElement();
            cell.setText(this.getText(element, cell.getColumnIndex()));
            if (element.created) {
                cell.setBackground(ComplexObjectEditor.this.backgroundAdded);
            } else if (element.modified) {
                cell.setBackground(ComplexObjectEditor.this.backgroundModified);
            } else {
                cell.setBackground(null);
            }
        }
    }

    private class RemoveElementAction
    extends Action {
        public RemoveElementAction() {
            super("Remove element", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_DELETE));
        }

        public void run() {
            ITreeSelection selection = ComplexObjectEditor.this.getStructuredSelection();
            if (selection.isEmpty()) {
                return;
            }
            DBDCollection collection = (DBDCollection)ComplexObjectEditor.this.getInput();
            Object[] arrayItems = (ComplexElement[])ComplexObjectEditor.this.childrenMap.get(collection);
            if (arrayItems == null) {
                log.error((Object)"Can't find children items for delete");
                return;
            }
            ArrayItem item = (ArrayItem)selection.getFirstElement();
            ComplexObjectEditor.this.shiftArrayItems((ComplexElement[])arrayItems, item.index, -1);
            arrayItems = (ComplexElement[])ArrayUtils.remove(ComplexElement.class, (Object[])arrayItems, (Object)item);
            ComplexObjectEditor.this.childrenMap.put(collection, arrayItems);
            ComplexObjectEditor.this.refresh();
        }
    }

    class StructContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        @Nullable
        public Object getParent(Object child) {
            return null;
        }

        public ComplexElement[] getChildren(Object parent) {
            Object value;
            ComplexElement[] children = (ComplexElement[])ComplexObjectEditor.this.childrenMap.get(parent);
            if (children != null) {
                return children;
            }
            if (parent instanceof DBDComposite) {
                DBDComposite structure = (DBDComposite)parent;
                try {
                    DBSAttributeBase[] attributes = structure.getAttributes();
                    children = new CompositeField[attributes.length];
                    int i = 0;
                    while (i < attributes.length) {
                        DBSAttributeBase attr = attributes[i];
                        Object value2 = structure.getAttributeValue(attr);
                        children[i] = new CompositeField(structure.getDataType().getDataSource(), attr, value2);
                        ++i;
                    }
                }
                catch (DBException e) {
                    log.error((Object)"Error getting structure meta data", (Throwable)e);
                }
            } else if (parent instanceof DBDCollection) {
                DBDCollection array = (DBDCollection)parent;
                ArrayInfo arrayInfo = ComplexObjectEditor.this.makeArrayInfo(array);
                children = new ArrayItem[array.getItemCount()];
                int i = 0;
                while (i < children.length) {
                    children[i] = new ArrayItem(arrayInfo, i, array.getItem(i));
                    ++i;
                }
            } else if (parent instanceof DBDReference) {
                final DBDReference reference = (DBDReference)parent;
                DBRRunnableWithResult<Object> runnable = new DBRRunnableWithResult<Object>(){

                    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            Throwable throwable = null;
                            Object var3_5 = null;
                            try (DBCSession session = ComplexObjectEditor.this.executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Read reference value");){
                                this.result = reference.getReferencedObject(session);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (DBCException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                UIUtils.runInUI((DBRRunnableWithProgress)runnable);
                children = this.getChildren(runnable.getResult());
            } else if (parent instanceof CompositeField) {
                Object value3 = ((CompositeField)parent).value;
                if (this.isComplexType(value3)) {
                    children = this.getChildren(value3);
                }
            } else if (parent instanceof ArrayItem && this.isComplexType(value = ((ArrayItem)parent).value)) {
                children = this.getChildren(value);
            }
            if (children != null) {
                ComplexObjectEditor.this.childrenMap.put(parent, children);
            }
            return children;
        }

        private boolean isComplexType(Object value) {
            return value instanceof DBDComplexValue;
        }

        public boolean hasChildren(Object parent) {
            return parent instanceof DBDComposite || parent instanceof DBDCollection || parent instanceof DBDReference || parent instanceof CompositeField && this.hasChildren(((CompositeField)parent).value) || parent instanceof ArrayItem && this.hasChildren(((ArrayItem)parent).value);
        }
    }
}

