/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.HashSet;
import java.util.Set;

public class CompoundAssignment
implements Matcher<CompoundAssignmentTree> {
    private static final Set<Tree.Kind> COMPOUND_ASSIGNMENT_OPERATORS = new HashSet<Tree.Kind>(11);
    private final Set<Tree.Kind> operators;
    private final Matcher<ExpressionTree> receiverMatcher;
    private final Matcher<ExpressionTree> expressionMatcher;

    public CompoundAssignment(Set<Tree.Kind> operators, Matcher<ExpressionTree> receiverMatcher, Matcher<ExpressionTree> expressionMatcher) {
        this.operators = CompoundAssignment.validateOperators(operators);
        if (receiverMatcher == null) {
            throw new NullPointerException("CompoundAssignment receiver matcher is null");
        }
        if (expressionMatcher == null) {
            throw new NullPointerException("CompoundAssignment expression matcher is null");
        }
        this.receiverMatcher = receiverMatcher;
        this.expressionMatcher = expressionMatcher;
    }

    @Override
    public boolean matches(CompoundAssignmentTree compoundAssignmentTree, VisitorState state) {
        if (!this.operators.contains((Object)compoundAssignmentTree.getKind())) {
            return false;
        }
        return this.receiverMatcher.matches(compoundAssignmentTree.getVariable(), state) && this.expressionMatcher.matches(compoundAssignmentTree.getExpression(), state);
    }

    private static Set<Tree.Kind> validateOperators(Set<Tree.Kind> kinds) {
        for (Tree.Kind kind : kinds) {
            if (COMPOUND_ASSIGNMENT_OPERATORS.contains((Object)kind)) continue;
            throw new IllegalArgumentException(kind.name() + " is not a compound-assignment operator.");
        }
        return kinds;
    }

    static {
        COMPOUND_ASSIGNMENT_OPERATORS.add(Tree.Kind.AND_ASSIGNMENT);
        COMPOUND_ASSIGNMENT_OPERATORS.add(Tree.Kind.DIVIDE_ASSIGNMENT);
        COMPOUND_ASSIGNMENT_OPERATORS.add(Tree.Kind.LEFT_SHIFT_ASSIGNMENT);
        COMPOUND_ASSIGNMENT_OPERATORS.add(Tree.Kind.MINUS_ASSIGNMENT);
        COMPOUND_ASSIGNMENT_OPERATORS.add(Tree.Kind.MULTIPLY_ASSIGNMENT);
        COMPOUND_ASSIGNMENT_OPERATORS.add(Tree.Kind.OR_ASSIGNMENT);
        COMPOUND_ASSIGNMENT_OPERATORS.add(Tree.Kind.PLUS_ASSIGNMENT);
        COMPOUND_ASSIGNMENT_OPERATORS.add(Tree.Kind.REMAINDER_ASSIGNMENT);
        COMPOUND_ASSIGNMENT_OPERATORS.add(Tree.Kind.RIGHT_SHIFT_ASSIGNMENT);
        COMPOUND_ASSIGNMENT_OPERATORS.add(Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT);
        COMPOUND_ASSIGNMENT_OPERATORS.add(Tree.Kind.XOR_ASSIGNMENT);
    }
}

