(function() {
  var PaneResizeHandleElement,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  PaneResizeHandleElement = (function(superClass) {
    extend(PaneResizeHandleElement, superClass);

    function PaneResizeHandleElement() {
      return PaneResizeHandleElement.__super__.constructor.apply(this, arguments);
    }

    PaneResizeHandleElement.prototype.createdCallback = function() {
      this.resizePane = this.resizePane.bind(this);
      this.resizeStopped = this.resizeStopped.bind(this);
      return this.subscribeToDOMEvents();
    };

    PaneResizeHandleElement.prototype.subscribeToDOMEvents = function() {
      this.addEventListener('dblclick', this.resizeToFitContent.bind(this));
      return this.addEventListener('mousedown', this.resizeStarted.bind(this));
    };

    PaneResizeHandleElement.prototype.attachedCallback = function() {
      if (this.parentElement) {
        this.isHorizontal = this.parentElement.classList.contains("horizontal");
        return this.classList.add(this.isHorizontal ? 'horizontal' : 'vertical');
      }
    };

    PaneResizeHandleElement.prototype.detachedCallback = function() {
      return this.resizeStopped();
    };

    PaneResizeHandleElement.prototype.resizeToFitContent = function() {
      var ref, ref1;
      if ((ref = this.previousSibling) != null) {
        ref.model.setFlexScale(1);
      }
      return (ref1 = this.nextSibling) != null ? ref1.model.setFlexScale(1) : void 0;
    };

    PaneResizeHandleElement.prototype.resizeStarted = function(e) {
      e.stopPropagation();
      document.addEventListener('mousemove', this.resizePane);
      return document.addEventListener('mouseup', this.resizeStopped);
    };

    PaneResizeHandleElement.prototype.resizeStopped = function() {
      document.removeEventListener('mousemove', this.resizePane);
      return document.removeEventListener('mouseup', this.resizeStopped);
    };

    PaneResizeHandleElement.prototype.calcRatio = function(ratio1, ratio2, total) {
      var allRatio;
      allRatio = ratio1 + ratio2;
      return [total * ratio1 / allRatio, total * ratio2 / allRatio];
    };

    PaneResizeHandleElement.prototype.setFlexGrow = function(prevSize, nextSize) {
      var flexGrows, totalScale;
      this.prevModel = this.previousSibling.model;
      this.nextModel = this.nextSibling.model;
      totalScale = this.prevModel.getFlexScale() + this.nextModel.getFlexScale();
      flexGrows = this.calcRatio(prevSize, nextSize, totalScale);
      this.prevModel.setFlexScale(flexGrows[0]);
      return this.nextModel.setFlexScale(flexGrows[1]);
    };

    PaneResizeHandleElement.prototype.fixInRange = function(val, minValue, maxValue) {
      return Math.min(Math.max(val, minValue), maxValue);
    };

    PaneResizeHandleElement.prototype.resizePane = function(arg) {
      var bottomHeight, clientX, clientY, leftWidth, rightWidth, topHeight, totalHeight, totalWidth, which;
      clientX = arg.clientX, clientY = arg.clientY, which = arg.which;
      if (which !== 1) {
        return this.resizeStopped();
      }
      if (!((this.previousSibling != null) && (this.nextSibling != null))) {
        return this.resizeStopped();
      }
      if (this.isHorizontal) {
        totalWidth = this.previousSibling.clientWidth + this.nextSibling.clientWidth;
        leftWidth = clientX - this.previousSibling.getBoundingClientRect().left;
        leftWidth = this.fixInRange(leftWidth, 0, totalWidth);
        rightWidth = totalWidth - leftWidth;
        return this.setFlexGrow(leftWidth, rightWidth);
      } else {
        totalHeight = this.previousSibling.clientHeight + this.nextSibling.clientHeight;
        topHeight = clientY - this.previousSibling.getBoundingClientRect().top;
        topHeight = this.fixInRange(topHeight, 0, totalHeight);
        bottomHeight = totalHeight - topHeight;
        return this.setFlexGrow(topHeight, bottomHeight);
      }
    };

    return PaneResizeHandleElement;

  })(HTMLElement);

  module.exports = PaneResizeHandleElement = document.registerElement('atom-pane-resize-handle', {
    prototype: PaneResizeHandleElement.prototype
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
