(function() {
  var ApplicationDelegate, AtomEnvironment, Clipboard, CompileCache, FileSystemBlobStore, ModuleCache, NativeCompileCache, TextEditor, TextEditorComponent, clipboard;

  AtomEnvironment = require('./atom-environment');

  ApplicationDelegate = require('./application-delegate');

  Clipboard = require('./clipboard');

  TextEditor = require('./text-editor');

  TextEditorComponent = require('./text-editor-component');

  FileSystemBlobStore = require('./file-system-blob-store');

  NativeCompileCache = require('./native-compile-cache');

  CompileCache = require('./compile-cache');

  ModuleCache = require('./module-cache');

  if (global.isGeneratingSnapshot) {
    require('about');
    require('archive-view');
    require('autocomplete-atom-api');
    require('autocomplete-css');
    require('autocomplete-html');
    require('autocomplete-plus');
    require('autocomplete-snippets');
    require('autoflow');
    require('autosave');
    require('background-tips');
    require('bookmarks');
    require('bracket-matcher');
    require('command-palette');
    require('deprecation-cop');
    require('dev-live-reload');
    require('encoding-selector');
    require('exception-reporting');
    require('dalek');
    require('find-and-replace');
    require('fuzzy-finder');
    require('github');
    require('git-diff');
    require('go-to-line');
    require('grammar-selector');
    require('image-view');
    require('incompatible-packages');
    require('keybinding-resolver');
    require('language-c');
    require('language-html');
    require('language-javascript');
    require('language-ruby');
    require('language-typescript');
    require('line-ending-selector');
    require('link');
    require('markdown-preview');
    require('metrics');
    require('notifications');
    require('open-on-github');
    require('package-generator');
    require('settings-view');
    require('snippets');
    require('spell-check');
    require('status-bar');
    require('styleguide');
    require('symbols-view');
    require('tabs');
    require('timecop');
    require('tree-view');
    require('update-package-dependencies');
    require('welcome');
    require('whitespace');
    require('wrap-guide');
  }

  clipboard = new Clipboard;

  TextEditor.setClipboard(clipboard);

  TextEditor.viewForItem = function(item) {
    return atom.views.getView(item);
  };

  global.atom = new AtomEnvironment({
    clipboard: clipboard,
    applicationDelegate: new ApplicationDelegate,
    enablePersistence: true
  });

  TextEditor.setScheduler(global.atom.views);

  global.atom.preloadPackages();

  module.exports = function(arg) {
    var base, blobStore, devMode, env, exportsPath, getWindowLoadSettings, ipcRenderer, path, ref, resourcePath, updateProcessEnv;
    blobStore = arg.blobStore;
    updateProcessEnv = require('./update-process-env').updateProcessEnv;
    path = require('path');
    require('./window');
    getWindowLoadSettings = require('./get-window-load-settings');
    ipcRenderer = require('electron').ipcRenderer;
    ref = getWindowLoadSettings(), resourcePath = ref.resourcePath, devMode = ref.devMode, env = ref.env;
    require('./electron-shims');
    exportsPath = path.join(resourcePath, 'exports');
    require('module').globalPaths.push(exportsPath);
    process.env.NODE_PATH = exportsPath;
    if (!devMode) {
      if ((base = process.env).NODE_ENV == null) {
        base.NODE_ENV = 'production';
      }
    }
    global.atom.initialize({
      window: window,
      document: document,
      blobStore: blobStore,
      configDirPath: process.env.ATOM_HOME,
      env: process.env
    });
    return global.atom.startEditorWindow().then(function() {
      var windowFocused;
      windowFocused = function() {
        window.removeEventListener('focus', windowFocused);
        return setTimeout((function() {
          return document.querySelector('atom-workspace').focus();
        }), 0);
      };
      window.addEventListener('focus', windowFocused);
      return ipcRenderer.on('environment', function(event, env) {
        return updateProcessEnv(env);
      });
    });
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
