(function() {
  var IgnoredNames, Minimatch;

  Minimatch = null;

  module.exports = IgnoredNames = (function() {
    function IgnoredNames() {
      var error, i, ignoredName, ignoredNames, len, ref;
      this.ignoredPatterns = [];
      if (Minimatch == null) {
        Minimatch = require('minimatch').Minimatch;
      }
      ignoredNames = (ref = atom.config.get('core.ignoredNames')) != null ? ref : [];
      if (typeof ignoredNames === 'string') {
        ignoredNames = [ignoredNames];
      }
      for (i = 0, len = ignoredNames.length; i < len; i++) {
        ignoredName = ignoredNames[i];
        if (ignoredName) {
          try {
            this.ignoredPatterns.push(new Minimatch(ignoredName, {
              matchBase: true,
              dot: true
            }));
          } catch (error1) {
            error = error1;
            atom.notifications.addWarning("Error parsing ignore pattern (" + ignoredName + ")", {
              detail: error.message
            });
          }
        }
      }
    }

    IgnoredNames.prototype.matches = function(filePath) {
      var i, ignoredPattern, len, ref;
      ref = this.ignoredPatterns;
      for (i = 0, len = ref.length; i < len; i++) {
        ignoredPattern = ref[i];
        if (ignoredPattern.match(filePath)) {
          return true;
        }
      }
      return false;
    };

    return IgnoredNames;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
