Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _mruItemView = require('./mru-item-view');

var _mruItemView2 = _interopRequireDefault(_mruItemView);

var _atom = require('atom');

'use babel';

var displayListConfigKey = 'tabs.displayMruTabList';

var MRUListView = (function () {
  function MRUListView() {
    _classCallCheck(this, MRUListView);
  }

  _createClass(MRUListView, [{
    key: 'initialize',
    value: function initialize(pane) {
      this.ownerDiv = document.createElement('div');
      this.element = document.createElement('ol');
      this.ownerDiv.appendChild(this.element);
      this.ownerDiv.classList.add('select-list', 'tabs-mru-switcher');

      this.pane = pane;
      this.pendingShow = false;
      this.subscribe();
      this.panel = atom.workspace.addModalPanel({
        item: this.ownerDiv,
        visible: false
      });
      this.element.classList.add('list-group');

      this.displayMruList = atom.config.get(displayListConfigKey);
      this.hideClickHandler = this.hide.bind(this);
      this.preventPropagationClickHandler = this.preventPropagation.bind(this);
    }
  }, {
    key: 'subscribe',
    value: function subscribe() {
      var _this = this;

      this.subscriptions = new _atom.CompositeDisposable();

      this.subscriptions.add(atom.config.observe(displayListConfigKey, function (newValue) {
        return _this.displayMruList = newValue;
      }));

      /* Check for existence of events. Allows package tests to pass until this
      change hits stable. */
      if (typeof this.pane.onChooseNextMRUItem === 'function') {
        /* Because the chosen item is passed in the callback, both the
        ChooseNext and ChooseLast events can call our our single choose
        method. */
        this.subscriptions.add(this.pane.onChooseNextMRUItem(function (item) {
          return _this.choose(item);
        }));
        this.subscriptions.add(this.pane.onChooseLastMRUItem(function (item) {
          return _this.choose(item);
        }));

        this.subscriptions.add(this.pane.onDoneChoosingMRUItem(function () {
          return _this.stopChoosing();
        }));
      }

      this.subscriptions.add(this.pane.onDidDestroy(function () {
        return _this.destroy();
      }));

      this.subscriptions.add(atom.commands.add('atom-workspace', {
        'core:cancel': function coreCancel(event) {
          if (_this.hide()) event.stopPropagation();
        }
      }));
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      this.panel.destroy();
    }
  }, {
    key: 'choose',
    value: function choose(selectedItem) {
      if (this.displayMruList) {
        this.pendingShow = true;
        this.show(selectedItem);
      }
    }
  }, {
    key: 'stopChoosing',
    value: function stopChoosing() {
      if (this.displayMruList) {
        this.pendingShow = false;
        this.hide();
      }
    }
  }, {
    key: 'show',
    value: function show(selectedItem) {
      var _this2 = this;

      var selectedViewElement = undefined;
      if (!this.panel.visible) {
        window.setTimeout(function () {
          if (!_this2.pendingShow) return;
          selectedViewElement = _this2.buildListView(selectedItem);
          _this2.panel.show();
          _this2.addClickHandlers();
          _this2.scrollToItemView(selectedViewElement);
        }, 150);
      } else {
        selectedViewElement = this.updateSelectedItem(selectedItem);
        this.scrollToItemView(selectedViewElement);
      }
    }
  }, {
    key: 'preventPropagation',
    value: function preventPropagation() {
      event.stopPropagation();
    }
  }, {
    key: 'addClickHandlers',
    value: function addClickHandlers() {
      document.body.addEventListener('click', this.hideClickHandler);
      this.ownerDiv.addEventListener('click', this.preventPropagationClickHandler);
    }
  }, {
    key: 'removeClickHandler',
    value: function removeClickHandler() {
      document.body.removeEventListener('click', this.hideClickHandler);
      this.ownerDiv.removeEventListener('click', this.preventPropagationClickHandler);
    }
  }, {
    key: 'hide',
    value: function hide() {
      var willClose = this.panel.visible;
      if (willClose) {
        this.removeClickHandler();
        this.panel.hide();
      }
      return willClose;
    }
  }, {
    key: 'updateSelectedItem',
    value: function updateSelectedItem(selectedItem) {
      var selectedView = undefined;
      for (var viewElement of this.element.children) {
        if (viewElement.itemViewData.item === selectedItem) {
          viewElement.itemViewData.select();
          selectedView = viewElement;
        } else viewElement.itemViewData.unselect();
      }
      return selectedView;
    }
  }, {
    key: 'scrollToItemView',
    value: function scrollToItemView(view) {
      var desiredTop = view.offsetTop;
      var desiredBottom = desiredTop + view.offsetHeight;

      if (desiredTop < this.element.scrollTop) {
        this.element.scrollTop = desiredTop;
      } else if (desiredBottom > this.element.scrollTop + this.element.clientHeight) {
        this.element.scrollTop = desiredBottom - this.element.clientHeight;
      }
    }
  }, {
    key: 'buildListView',
    value: function buildListView(selectedItem) {
      /* Making this more efficient, and not simply building the view for the
      entire stack every time it's shown, has significant complexity cost.
      The pane system completely owns the MRU stack. Adding events and
      handlers to incrementally update the UI here would mean two copies of
      the stack to maintain and keep in sync. Let's take on that complexity
      only if this exhibits real-world performance issues. */
      while (this.element.firstChild) this.element.removeChild(this.element.firstChild);

      var selectedViewElement = undefined;
      /* We're inserting each item at the top so we traverse the stack from
      the bottom, resulting in the most recently used item at the top of the
      UI. */
      for (var i = this.pane.itemStack.length - 1; i >= 0; i--) {
        var item = this.pane.itemStack[i];
        var itemView = new _mruItemView2['default']();
        itemView.initialize(this, item);
        if (itemView.disposables) {
          this.subscriptions.add(itemView.disposables);
        }
        this.element.appendChild(itemView.element);
        if (item === selectedItem) {
          itemView.select();
          selectedViewElement = itemView;
        }
      }
      return selectedViewElement.element;
    }
  }]);

  return MRUListView;
})();

exports['default'] = MRUListView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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