Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var TagGenerator = (function () {
  function TagGenerator(path1, scopeName) {
    _classCallCheck(this, TagGenerator);

    this.path = path1;
    this.scopeName = scopeName;
  }

  _createClass(TagGenerator, [{
    key: 'getPackageRoot',
    value: function getPackageRoot() {
      var _atom$getLoadSettings = atom.getLoadSettings();

      var resourcePath = _atom$getLoadSettings.resourcePath;

      var currentFileWasRequiredFromSnapshot = !_fsPlus2['default'].isAbsolute(__dirname);
      var packageRoot = currentFileWasRequiredFromSnapshot ? _path2['default'].join(resourcePath, 'node_modules', 'symbols-view') : _path2['default'].resolve(__dirname, '..');

      if (_path2['default'].extname(resourcePath) === '.asar' && packageRoot.indexOf(resourcePath) === 0) {
        return _path2['default'].join(resourcePath + '.unpacked', 'node_modules', 'symbols-view');
      } else {
        return packageRoot;
      }
    }
  }, {
    key: 'parseTagLine',
    value: function parseTagLine(line) {
      var sections = line.split('\t');
      if (sections.length > 3) {
        return {
          position: new _atom.Point(parseInt(sections[2], 10) - 1),
          name: sections[0]
        };
      }
      return null;
    }
  }, {
    key: 'getLanguage',
    value: function getLanguage() {
      if (['.cson', '.gyp'].includes(_path2['default'].extname(this.path))) {
        return 'Cson';
      }

      switch (this.scopeName) {
        case 'source.c':
          return 'C';
        case 'source.cpp':
          return 'C++';
        case 'source.clojure':
          return 'Lisp';
        case 'source.capnp':
          return 'Capnp';
        case 'source.cfscript':
          return 'ColdFusion';
        case 'source.cfscript.embedded':
          return 'ColdFusion';
        case 'source.coffee':
          return 'CoffeeScript';
        case 'source.css':
          return 'Css';
        case 'source.css.less':
          return 'Css';
        case 'source.css.scss':
          return 'Css';
        case 'source.elixir':
          return 'Elixir';
        case 'source.fountain':
          return 'Fountain';
        case 'source.gfm':
          return 'Markdown';
        case 'source.go':
          return 'Go';
        case 'source.java':
          return 'Java';
        case 'source.js':
          return 'JavaScript';
        case 'source.js.jsx':
          return 'JavaScript';
        case 'source.jsx':
          return 'JavaScript';
        case 'source.json':
          return 'Json';
        case 'source.julia':
          return 'Julia';
        case 'source.makefile':
          return 'Make';
        case 'source.objc':
          return 'C';
        case 'source.objcpp':
          return 'C++';
        case 'source.python':
          return 'Python';
        case 'source.ruby':
          return 'Ruby';
        case 'source.sass':
          return 'Sass';
        case 'source.yaml':
          return 'Yaml';
        case 'text.html':
          return 'Html';
        case 'text.html.php':
          return 'Php';
        case 'text.tex.latex':
          return 'Latex';
        case 'text.html.cfml':
          return 'ColdFusion';
      }
      return undefined;
    }
  }, {
    key: 'generate',
    value: function generate() {
      var _this = this;

      var tags = {};
      var packageRoot = this.getPackageRoot();
      var command = 'ctags';
      var defaultCtagsFile = _path2['default'].join(packageRoot, 'lib', 'ctags-config');
      var args = ['--options=' + defaultCtagsFile, '--fields=+KS'];

      if (atom.config.get('symbols-view.useEditorGrammarAsCtagsLanguage')) {
        var language = this.getLanguage();
        if (language) {
          args.push('--language-force=' + language);
        }
      }

      args.push('-nf', '-', this.path);

      return new Promise(function (resolve) {
        var result = undefined,
            tag = undefined;
        return new _atom.BufferedProcess({
          command: command,
          args: args,
          stdout: function stdout(lines) {
            return (function () {
              result = [];
              for (var line of Array.from(lines.split('\n'))) {
                var item = undefined;
                if (tag = _this.parseTagLine(line)) {
                  item = tags[tag.position.row] ? tags[tag.position.row] : tags[tag.position.row] = tag;
                }
                result.push(item);
              }
              return result;
            })();
          },
          stderr: function stderr() {},
          exit: function exit() {
            tags = (function () {
              result = [];
              for (var row in tags) {
                tag = tags[row];
                result.push(tag);
              }
              return result;
            })();
            return resolve(tags);
          }
        });
      });
    }
  }]);

  return TagGenerator;
})();

exports['default'] = TagGenerator;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzQuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9zeW1ib2xzLXZpZXcvbGliL3RhZy1nZW5lcmF0b3IuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7O29CQUV1QyxNQUFNOztvQkFDNUIsTUFBTTs7OztzQkFDUixTQUFTOzs7O0lBRUgsWUFBWTtBQUNwQixXQURRLFlBQVksQ0FDbkIsS0FBSyxFQUFFLFNBQVMsRUFBRTswQkFEWCxZQUFZOztBQUU3QixRQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQztBQUNsQixRQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztHQUM1Qjs7ZUFKa0IsWUFBWTs7V0FNakIsMEJBQUc7a0NBQ1EsSUFBSSxDQUFDLGVBQWUsRUFBRTs7VUFBdEMsWUFBWSx5QkFBWixZQUFZOztBQUNuQixVQUFNLGtDQUFrQyxHQUFHLENBQUMsb0JBQUcsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDO0FBQ3JFLFVBQU0sV0FBVyxHQUFHLGtDQUFrQyxHQUNsRCxrQkFBSyxJQUFJLENBQUMsWUFBWSxFQUFFLGNBQWMsRUFBRSxjQUFjLENBQUMsR0FDdkQsa0JBQUssT0FBTyxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsQ0FBQzs7QUFFbEMsVUFBSSxrQkFBSyxPQUFPLENBQUMsWUFBWSxDQUFDLEtBQUssT0FBTyxJQUFJLFdBQVcsQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxFQUFFO0FBQ3JGLGVBQU8sa0JBQUssSUFBSSxDQUFJLFlBQVksZ0JBQWEsY0FBYyxFQUFFLGNBQWMsQ0FBQyxDQUFDO09BQzlFLE1BQU07QUFDTCxlQUFPLFdBQVcsQ0FBQztPQUNwQjtLQUNGOzs7V0FFVyxzQkFBQyxJQUFJLEVBQUU7QUFDakIsVUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUNoQyxVQUFJLFFBQVEsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO0FBQ3ZCLGVBQU87QUFDTCxrQkFBUSxFQUFFLGdCQUFVLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0FBQ2xELGNBQUksRUFBRSxRQUFRLENBQUMsQ0FBQyxDQUFDO1NBQ2xCLENBQUM7T0FDSDtBQUNELGFBQU8sSUFBSSxDQUFDO0tBQ2I7OztXQUVVLHVCQUFHO0FBQ1osVUFBSSxDQUFDLE9BQU8sRUFBRSxNQUFNLENBQUMsQ0FBQyxRQUFRLENBQUMsa0JBQUssT0FBTyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFO0FBQ3ZELGVBQU8sTUFBTSxDQUFDO09BQ2Y7O0FBRUQsY0FBUSxJQUFJLENBQUMsU0FBUztBQUNwQixhQUFLLFVBQVU7QUFBa0IsaUJBQU8sR0FBRyxDQUFDO0FBQUEsQUFDNUMsYUFBSyxZQUFZO0FBQWdCLGlCQUFPLEtBQUssQ0FBQztBQUFBLEFBQzlDLGFBQUssZ0JBQWdCO0FBQVksaUJBQU8sTUFBTSxDQUFDO0FBQUEsQUFDL0MsYUFBSyxjQUFjO0FBQWMsaUJBQU8sT0FBTyxDQUFDO0FBQUEsQUFDaEQsYUFBSyxpQkFBaUI7QUFBVyxpQkFBTyxZQUFZLENBQUM7QUFBQSxBQUNyRCxhQUFLLDBCQUEwQjtBQUFFLGlCQUFPLFlBQVksQ0FBQztBQUFBLEFBQ3JELGFBQUssZUFBZTtBQUFhLGlCQUFPLGNBQWMsQ0FBQztBQUFBLEFBQ3ZELGFBQUssWUFBWTtBQUFnQixpQkFBTyxLQUFLLENBQUM7QUFBQSxBQUM5QyxhQUFLLGlCQUFpQjtBQUFXLGlCQUFPLEtBQUssQ0FBQztBQUFBLEFBQzlDLGFBQUssaUJBQWlCO0FBQVcsaUJBQU8sS0FBSyxDQUFDO0FBQUEsQUFDOUMsYUFBSyxlQUFlO0FBQWEsaUJBQU8sUUFBUSxDQUFDO0FBQUEsQUFDakQsYUFBSyxpQkFBaUI7QUFBVyxpQkFBTyxVQUFVLENBQUM7QUFBQSxBQUNuRCxhQUFLLFlBQVk7QUFBZ0IsaUJBQU8sVUFBVSxDQUFDO0FBQUEsQUFDbkQsYUFBSyxXQUFXO0FBQWlCLGlCQUFPLElBQUksQ0FBQztBQUFBLEFBQzdDLGFBQUssYUFBYTtBQUFlLGlCQUFPLE1BQU0sQ0FBQztBQUFBLEFBQy9DLGFBQUssV0FBVztBQUFpQixpQkFBTyxZQUFZLENBQUM7QUFBQSxBQUNyRCxhQUFLLGVBQWU7QUFBYSxpQkFBTyxZQUFZLENBQUM7QUFBQSxBQUNyRCxhQUFLLFlBQVk7QUFBZ0IsaUJBQU8sWUFBWSxDQUFDO0FBQUEsQUFDckQsYUFBSyxhQUFhO0FBQWUsaUJBQU8sTUFBTSxDQUFDO0FBQUEsQUFDL0MsYUFBSyxjQUFjO0FBQWMsaUJBQU8sT0FBTyxDQUFDO0FBQUEsQUFDaEQsYUFBSyxpQkFBaUI7QUFBVyxpQkFBTyxNQUFNLENBQUM7QUFBQSxBQUMvQyxhQUFLLGFBQWE7QUFBZSxpQkFBTyxHQUFHLENBQUM7QUFBQSxBQUM1QyxhQUFLLGVBQWU7QUFBYSxpQkFBTyxLQUFLLENBQUM7QUFBQSxBQUM5QyxhQUFLLGVBQWU7QUFBYSxpQkFBTyxRQUFRLENBQUM7QUFBQSxBQUNqRCxhQUFLLGFBQWE7QUFBZSxpQkFBTyxNQUFNLENBQUM7QUFBQSxBQUMvQyxhQUFLLGFBQWE7QUFBZSxpQkFBTyxNQUFNLENBQUM7QUFBQSxBQUMvQyxhQUFLLGFBQWE7QUFBZSxpQkFBTyxNQUFNLENBQUM7QUFBQSxBQUMvQyxhQUFLLFdBQVc7QUFBaUIsaUJBQU8sTUFBTSxDQUFDO0FBQUEsQUFDL0MsYUFBSyxlQUFlO0FBQWEsaUJBQU8sS0FBSyxDQUFDO0FBQUEsQUFDOUMsYUFBSyxnQkFBZ0I7QUFBWSxpQkFBTyxPQUFPLENBQUM7QUFBQSxBQUNoRCxhQUFLLGdCQUFnQjtBQUFZLGlCQUFPLFlBQVksQ0FBQztBQUFBLE9BQ3REO0FBQ0QsYUFBTyxTQUFTLENBQUM7S0FDbEI7OztXQUVPLG9CQUFHOzs7QUFDVCxVQUFJLElBQUksR0FBRyxFQUFFLENBQUM7QUFDZCxVQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsY0FBYyxFQUFFLENBQUM7QUFDMUMsVUFBTSxPQUFPLEdBQUcsT0FBTyxDQUFDO0FBQ3hCLFVBQU0sZ0JBQWdCLEdBQUcsa0JBQUssSUFBSSxDQUFDLFdBQVcsRUFBRSxLQUFLLEVBQUUsY0FBYyxDQUFDLENBQUM7QUFDdkUsVUFBTSxJQUFJLEdBQUcsZ0JBQWMsZ0JBQWdCLEVBQUksY0FBYyxDQUFDLENBQUM7O0FBRS9ELFVBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsOENBQThDLENBQUMsRUFBRTtBQUNuRSxZQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7QUFDcEMsWUFBSSxRQUFRLEVBQUU7QUFDWixjQUFJLENBQUMsSUFBSSx1QkFBcUIsUUFBUSxDQUFHLENBQUM7U0FDM0M7T0FDRjs7QUFFRCxVQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxHQUFHLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDOztBQUVqQyxhQUFPLElBQUksT0FBTyxDQUFDLFVBQUMsT0FBTyxFQUFLO0FBQzlCLFlBQUksTUFBTSxZQUFBO1lBQUUsR0FBRyxZQUFBLENBQUM7QUFDaEIsZUFBTywwQkFBb0I7QUFDekIsaUJBQU8sRUFBRSxPQUFPO0FBQ2hCLGNBQUksRUFBRSxJQUFJO0FBQ1YsZ0JBQU0sRUFBRSxnQkFBQyxLQUFLLEVBQUs7QUFDakIsbUJBQU8sQ0FBQyxZQUFNO0FBQ1osb0JBQU0sR0FBRyxFQUFFLENBQUM7QUFDWixtQkFBSyxJQUFNLElBQUksSUFBSSxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUMsRUFBRTtBQUNoRCxvQkFBSSxJQUFJLFlBQUEsQ0FBQztBQUNULG9CQUFJLEdBQUcsR0FBRyxNQUFLLFlBQVksQ0FBQyxJQUFJLENBQUMsRUFBRTtBQUNqQyxzQkFBSSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxHQUFJLElBQUksQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxHQUFHLEdBQUcsQUFBQyxDQUFDO2lCQUN6RjtBQUNELHNCQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO2VBQ25CO0FBQ0QscUJBQU8sTUFBTSxDQUFDO2FBQ2YsQ0FBQSxFQUFHLENBQUM7V0FDTjtBQUNELGdCQUFNLEVBQUEsa0JBQUcsRUFBRTtBQUNYLGNBQUksRUFBQSxnQkFBRztBQUNMLGdCQUFJLEdBQUksQ0FBQyxZQUFNO0FBQ2Isb0JBQU0sR0FBRyxFQUFFLENBQUM7QUFDWixtQkFBSyxJQUFNLEdBQUcsSUFBSSxJQUFJLEVBQUU7QUFDdEIsbUJBQUcsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7QUFDaEIsc0JBQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7ZUFDbEI7QUFDRCxxQkFBTyxNQUFNLENBQUM7YUFDZixDQUFBLEVBQUcsQUFBQyxDQUFDO0FBQ04sbUJBQU8sT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1dBQ3RCO1NBQ0YsQ0FBQyxDQUFDO09BQ0osQ0FBQyxDQUFDO0tBQ0o7OztTQXhIa0IsWUFBWTs7O3FCQUFaLFlBQVkiLCJmaWxlIjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNC4wL291dC9hcHAvbm9kZV9tb2R1bGVzL3N5bWJvbHMtdmlldy9saWIvdGFnLWdlbmVyYXRvci5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAYmFiZWwgKi9cblxuaW1wb3J0IHsgQnVmZmVyZWRQcm9jZXNzLCBQb2ludCB9IGZyb20gJ2F0b20nO1xuaW1wb3J0IHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgZnMgZnJvbSAnZnMtcGx1cyc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFRhZ0dlbmVyYXRvciB7XG4gIGNvbnN0cnVjdG9yKHBhdGgxLCBzY29wZU5hbWUpIHtcbiAgICB0aGlzLnBhdGggPSBwYXRoMTtcbiAgICB0aGlzLnNjb3BlTmFtZSA9IHNjb3BlTmFtZTtcbiAgfVxuXG4gIGdldFBhY2thZ2VSb290KCkge1xuICAgIGNvbnN0IHtyZXNvdXJjZVBhdGh9ID0gYXRvbS5nZXRMb2FkU2V0dGluZ3MoKTtcbiAgICBjb25zdCBjdXJyZW50RmlsZVdhc1JlcXVpcmVkRnJvbVNuYXBzaG90ID0gIWZzLmlzQWJzb2x1dGUoX19kaXJuYW1lKTtcbiAgICBjb25zdCBwYWNrYWdlUm9vdCA9IGN1cnJlbnRGaWxlV2FzUmVxdWlyZWRGcm9tU25hcHNob3RcbiAgICAgID8gcGF0aC5qb2luKHJlc291cmNlUGF0aCwgJ25vZGVfbW9kdWxlcycsICdzeW1ib2xzLXZpZXcnKVxuICAgICAgOiBwYXRoLnJlc29sdmUoX19kaXJuYW1lLCAnLi4nKTtcblxuICAgIGlmIChwYXRoLmV4dG5hbWUocmVzb3VyY2VQYXRoKSA9PT0gJy5hc2FyJyAmJiBwYWNrYWdlUm9vdC5pbmRleE9mKHJlc291cmNlUGF0aCkgPT09IDApIHtcbiAgICAgIHJldHVybiBwYXRoLmpvaW4oYCR7cmVzb3VyY2VQYXRofS51bnBhY2tlZGAsICdub2RlX21vZHVsZXMnLCAnc3ltYm9scy12aWV3Jyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBwYWNrYWdlUm9vdDtcbiAgICB9XG4gIH1cblxuICBwYXJzZVRhZ0xpbmUobGluZSkge1xuICAgIGxldCBzZWN0aW9ucyA9IGxpbmUuc3BsaXQoJ1xcdCcpO1xuICAgIGlmIChzZWN0aW9ucy5sZW5ndGggPiAzKSB7XG4gICAgICByZXR1cm4ge1xuICAgICAgICBwb3NpdGlvbjogbmV3IFBvaW50KHBhcnNlSW50KHNlY3Rpb25zWzJdLCAxMCkgLSAxKSxcbiAgICAgICAgbmFtZTogc2VjdGlvbnNbMF0sXG4gICAgICB9O1xuICAgIH1cbiAgICByZXR1cm4gbnVsbDtcbiAgfVxuXG4gIGdldExhbmd1YWdlKCkge1xuICAgIGlmIChbJy5jc29uJywgJy5neXAnXS5pbmNsdWRlcyhwYXRoLmV4dG5hbWUodGhpcy5wYXRoKSkpIHtcbiAgICAgIHJldHVybiAnQ3Nvbic7XG4gICAgfVxuXG4gICAgc3dpdGNoICh0aGlzLnNjb3BlTmFtZSkge1xuICAgICAgY2FzZSAnc291cmNlLmMnOiAgICAgICAgICAgICAgICAgcmV0dXJuICdDJztcbiAgICAgIGNhc2UgJ3NvdXJjZS5jcHAnOiAgICAgICAgICAgICAgIHJldHVybiAnQysrJztcbiAgICAgIGNhc2UgJ3NvdXJjZS5jbG9qdXJlJzogICAgICAgICAgIHJldHVybiAnTGlzcCc7XG4gICAgICBjYXNlICdzb3VyY2UuY2FwbnAnOiAgICAgICAgICAgICByZXR1cm4gJ0NhcG5wJztcbiAgICAgIGNhc2UgJ3NvdXJjZS5jZnNjcmlwdCc6ICAgICAgICAgIHJldHVybiAnQ29sZEZ1c2lvbic7XG4gICAgICBjYXNlICdzb3VyY2UuY2ZzY3JpcHQuZW1iZWRkZWQnOiByZXR1cm4gJ0NvbGRGdXNpb24nO1xuICAgICAgY2FzZSAnc291cmNlLmNvZmZlZSc6ICAgICAgICAgICAgcmV0dXJuICdDb2ZmZWVTY3JpcHQnO1xuICAgICAgY2FzZSAnc291cmNlLmNzcyc6ICAgICAgICAgICAgICAgcmV0dXJuICdDc3MnO1xuICAgICAgY2FzZSAnc291cmNlLmNzcy5sZXNzJzogICAgICAgICAgcmV0dXJuICdDc3MnO1xuICAgICAgY2FzZSAnc291cmNlLmNzcy5zY3NzJzogICAgICAgICAgcmV0dXJuICdDc3MnO1xuICAgICAgY2FzZSAnc291cmNlLmVsaXhpcic6ICAgICAgICAgICAgcmV0dXJuICdFbGl4aXInO1xuICAgICAgY2FzZSAnc291cmNlLmZvdW50YWluJzogICAgICAgICAgcmV0dXJuICdGb3VudGFpbic7XG4gICAgICBjYXNlICdzb3VyY2UuZ2ZtJzogICAgICAgICAgICAgICByZXR1cm4gJ01hcmtkb3duJztcbiAgICAgIGNhc2UgJ3NvdXJjZS5nbyc6ICAgICAgICAgICAgICAgIHJldHVybiAnR28nO1xuICAgICAgY2FzZSAnc291cmNlLmphdmEnOiAgICAgICAgICAgICAgcmV0dXJuICdKYXZhJztcbiAgICAgIGNhc2UgJ3NvdXJjZS5qcyc6ICAgICAgICAgICAgICAgIHJldHVybiAnSmF2YVNjcmlwdCc7XG4gICAgICBjYXNlICdzb3VyY2UuanMuanN4JzogICAgICAgICAgICByZXR1cm4gJ0phdmFTY3JpcHQnO1xuICAgICAgY2FzZSAnc291cmNlLmpzeCc6ICAgICAgICAgICAgICAgcmV0dXJuICdKYXZhU2NyaXB0JztcbiAgICAgIGNhc2UgJ3NvdXJjZS5qc29uJzogICAgICAgICAgICAgIHJldHVybiAnSnNvbic7XG4gICAgICBjYXNlICdzb3VyY2UuanVsaWEnOiAgICAgICAgICAgICByZXR1cm4gJ0p1bGlhJztcbiAgICAgIGNhc2UgJ3NvdXJjZS5tYWtlZmlsZSc6ICAgICAgICAgIHJldHVybiAnTWFrZSc7XG4gICAgICBjYXNlICdzb3VyY2Uub2JqYyc6ICAgICAgICAgICAgICByZXR1cm4gJ0MnO1xuICAgICAgY2FzZSAnc291cmNlLm9iamNwcCc6ICAgICAgICAgICAgcmV0dXJuICdDKysnO1xuICAgICAgY2FzZSAnc291cmNlLnB5dGhvbic6ICAgICAgICAgICAgcmV0dXJuICdQeXRob24nO1xuICAgICAgY2FzZSAnc291cmNlLnJ1YnknOiAgICAgICAgICAgICAgcmV0dXJuICdSdWJ5JztcbiAgICAgIGNhc2UgJ3NvdXJjZS5zYXNzJzogICAgICAgICAgICAgIHJldHVybiAnU2Fzcyc7XG4gICAgICBjYXNlICdzb3VyY2UueWFtbCc6ICAgICAgICAgICAgICByZXR1cm4gJ1lhbWwnO1xuICAgICAgY2FzZSAndGV4dC5odG1sJzogICAgICAgICAgICAgICAgcmV0dXJuICdIdG1sJztcbiAgICAgIGNhc2UgJ3RleHQuaHRtbC5waHAnOiAgICAgICAgICAgIHJldHVybiAnUGhwJztcbiAgICAgIGNhc2UgJ3RleHQudGV4LmxhdGV4JzogICAgICAgICAgIHJldHVybiAnTGF0ZXgnO1xuICAgICAgY2FzZSAndGV4dC5odG1sLmNmbWwnOiAgICAgICAgICAgcmV0dXJuICdDb2xkRnVzaW9uJztcbiAgICB9XG4gICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgfVxuXG4gIGdlbmVyYXRlKCkge1xuICAgIGxldCB0YWdzID0ge307XG4gICAgY29uc3QgcGFja2FnZVJvb3QgPSB0aGlzLmdldFBhY2thZ2VSb290KCk7XG4gICAgY29uc3QgY29tbWFuZCA9ICdjdGFncyc7XG4gICAgY29uc3QgZGVmYXVsdEN0YWdzRmlsZSA9IHBhdGguam9pbihwYWNrYWdlUm9vdCwgJ2xpYicsICdjdGFncy1jb25maWcnKTtcbiAgICBjb25zdCBhcmdzID0gW2AtLW9wdGlvbnM9JHtkZWZhdWx0Q3RhZ3NGaWxlfWAsICctLWZpZWxkcz0rS1MnXTtcblxuICAgIGlmIChhdG9tLmNvbmZpZy5nZXQoJ3N5bWJvbHMtdmlldy51c2VFZGl0b3JHcmFtbWFyQXNDdGFnc0xhbmd1YWdlJykpIHtcbiAgICAgIGNvbnN0IGxhbmd1YWdlID0gdGhpcy5nZXRMYW5ndWFnZSgpO1xuICAgICAgaWYgKGxhbmd1YWdlKSB7XG4gICAgICAgIGFyZ3MucHVzaChgLS1sYW5ndWFnZS1mb3JjZT0ke2xhbmd1YWdlfWApO1xuICAgICAgfVxuICAgIH1cblxuICAgIGFyZ3MucHVzaCgnLW5mJywgJy0nLCB0aGlzLnBhdGgpO1xuXG4gICAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlKSA9PiB7XG4gICAgICBsZXQgcmVzdWx0LCB0YWc7XG4gICAgICByZXR1cm4gbmV3IEJ1ZmZlcmVkUHJvY2Vzcyh7XG4gICAgICAgIGNvbW1hbmQ6IGNvbW1hbmQsXG4gICAgICAgIGFyZ3M6IGFyZ3MsXG4gICAgICAgIHN0ZG91dDogKGxpbmVzKSA9PiB7XG4gICAgICAgICAgcmV0dXJuICgoKSA9PiB7XG4gICAgICAgICAgICByZXN1bHQgPSBbXTtcbiAgICAgICAgICAgIGZvciAoY29uc3QgbGluZSBvZiBBcnJheS5mcm9tKGxpbmVzLnNwbGl0KCdcXG4nKSkpIHtcbiAgICAgICAgICAgICAgbGV0IGl0ZW07XG4gICAgICAgICAgICAgIGlmICh0YWcgPSB0aGlzLnBhcnNlVGFnTGluZShsaW5lKSkge1xuICAgICAgICAgICAgICAgIGl0ZW0gPSB0YWdzW3RhZy5wb3NpdGlvbi5yb3ddID8gdGFnc1t0YWcucG9zaXRpb24ucm93XSA6ICh0YWdzW3RhZy5wb3NpdGlvbi5yb3ddID0gdGFnKTtcbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICByZXN1bHQucHVzaChpdGVtKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiByZXN1bHQ7XG4gICAgICAgICAgfSkoKTtcbiAgICAgICAgfSxcbiAgICAgICAgc3RkZXJyKCkge30sXG4gICAgICAgIGV4aXQoKSB7XG4gICAgICAgICAgdGFncyA9ICgoKCkgPT4ge1xuICAgICAgICAgICAgcmVzdWx0ID0gW107XG4gICAgICAgICAgICBmb3IgKGNvbnN0IHJvdyBpbiB0YWdzKSB7XG4gICAgICAgICAgICAgIHRhZyA9IHRhZ3Nbcm93XTtcbiAgICAgICAgICAgICAgcmVzdWx0LnB1c2godGFnKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiByZXN1bHQ7XG4gICAgICAgICAgfSkoKSk7XG4gICAgICAgICAgcmV0dXJuIHJlc29sdmUodGFncyk7XG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9KTtcbiAgfVxufVxuIl19