(function() {
  var Disposable, FileInfoView, fs, url;

  Disposable = require('atom').Disposable;

  url = require('url');

  fs = require('fs-plus');

  module.exports = FileInfoView = (function() {
    function FileInfoView() {
      var clickHandler;
      this.element = document.createElement('status-bar-file');
      this.element.classList.add('file-info', 'inline-block');
      this.currentPath = document.createElement('a');
      this.currentPath.classList.add('current-path');
      this.element.appendChild(this.currentPath);
      this.element.currentPath = this.currentPath;
      this.element.getActiveItem = this.getActiveItem.bind(this);
      this.activeItemSubscription = atom.workspace.getCenter().onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.subscribeToActiveItem();
        };
      })(this));
      this.subscribeToActiveItem();
      this.registerTooltip();
      clickHandler = (function(_this) {
        return function(event) {
          var isShiftClick, text;
          isShiftClick = event.shiftKey;
          _this.showCopiedTooltip(isShiftClick);
          text = _this.getActiveItemCopyText(isShiftClick);
          atom.clipboard.write(text);
          return setTimeout(function() {
            return _this.clearCopiedTooltip();
          }, 2000);
        };
      })(this);
      this.currentPath.addEventListener('click', clickHandler);
      this.clickSubscription = new Disposable((function(_this) {
        return function() {
          return _this.currentPath.removeEventListener('click', clickHandler);
        };
      })(this));
    }

    FileInfoView.prototype.registerTooltip = function() {
      return this.tooltip = atom.tooltips.add(this.element, {
        title: function() {
          return "Click to copy absolute file path (Shift + Click to copy relative path)";
        }
      });
    };

    FileInfoView.prototype.clearCopiedTooltip = function() {
      var ref;
      if ((ref = this.copiedTooltip) != null) {
        ref.dispose();
      }
      return this.registerTooltip();
    };

    FileInfoView.prototype.showCopiedTooltip = function(copyRelativePath) {
      var ref, ref1, text;
      if ((ref = this.tooltip) != null) {
        ref.dispose();
      }
      if ((ref1 = this.copiedTooltip) != null) {
        ref1.dispose();
      }
      text = this.getActiveItemCopyText(copyRelativePath);
      return this.copiedTooltip = atom.tooltips.add(this.element, {
        title: "Copied: " + text,
        trigger: 'click',
        delay: {
          show: 0
        }
      });
    };

    FileInfoView.prototype.getActiveItemCopyText = function(copyRelativePath) {
      var activeItem, path, relativized;
      activeItem = this.getActiveItem();
      path = activeItem != null ? typeof activeItem.getPath === "function" ? activeItem.getPath() : void 0 : void 0;
      if (path == null) {
        return (activeItem != null ? typeof activeItem.getTitle === "function" ? activeItem.getTitle() : void 0 : void 0) || '';
      }
      if (copyRelativePath) {
        relativized = atom.project.relativize(path);
        if (relativized !== path) {
          return relativized;
        }
      }
      if ((path != null ? path.indexOf('://') : void 0) > 0) {
        path = url.parse(path).path;
      }
      return path;
    };

    FileInfoView.prototype.subscribeToActiveItem = function() {
      var activeItem, ref, ref1;
      if ((ref = this.modifiedSubscription) != null) {
        ref.dispose();
      }
      if ((ref1 = this.titleSubscription) != null) {
        ref1.dispose();
      }
      if (activeItem = this.getActiveItem()) {
        if (this.updateCallback == null) {
          this.updateCallback = (function(_this) {
            return function() {
              return _this.update();
            };
          })(this);
        }
        if (typeof activeItem.onDidChangeTitle === 'function') {
          this.titleSubscription = activeItem.onDidChangeTitle(this.updateCallback);
        } else if (typeof activeItem.on === 'function') {
          activeItem.on('title-changed', this.updateCallback);
          this.titleSubscription = {
            dispose: (function(_this) {
              return function() {
                return typeof activeItem.off === "function" ? activeItem.off('title-changed', _this.updateCallback) : void 0;
              };
            })(this)
          };
        }
        this.modifiedSubscription = typeof activeItem.onDidChangeModified === "function" ? activeItem.onDidChangeModified(this.updateCallback) : void 0;
      }
      return this.update();
    };

    FileInfoView.prototype.destroy = function() {
      var ref, ref1, ref2, ref3, ref4;
      this.activeItemSubscription.dispose();
      if ((ref = this.titleSubscription) != null) {
        ref.dispose();
      }
      if ((ref1 = this.modifiedSubscription) != null) {
        ref1.dispose();
      }
      if ((ref2 = this.clickSubscription) != null) {
        ref2.dispose();
      }
      if ((ref3 = this.copiedTooltip) != null) {
        ref3.dispose();
      }
      return (ref4 = this.tooltip) != null ? ref4.dispose() : void 0;
    };

    FileInfoView.prototype.getActiveItem = function() {
      return atom.workspace.getCenter().getActivePaneItem();
    };

    FileInfoView.prototype.update = function() {
      var ref;
      this.updatePathText();
      return this.updateBufferHasModifiedText((ref = this.getActiveItem()) != null ? typeof ref.isModified === "function" ? ref.isModified() : void 0 : void 0);
    };

    FileInfoView.prototype.updateBufferHasModifiedText = function(isModified) {
      if (isModified) {
        this.element.classList.add('buffer-modified');
        return this.isModified = true;
      } else {
        this.element.classList.remove('buffer-modified');
        return this.isModified = false;
      }
    };

    FileInfoView.prototype.updatePathText = function() {
      var path, ref, ref1, relativized, title;
      if (path = (ref = this.getActiveItem()) != null ? typeof ref.getPath === "function" ? ref.getPath() : void 0 : void 0) {
        relativized = atom.project.relativize(path);
        return this.currentPath.textContent = relativized != null ? fs.tildify(relativized) : path;
      } else if (title = (ref1 = this.getActiveItem()) != null ? typeof ref1.getTitle === "function" ? ref1.getTitle() : void 0 : void 0) {
        return this.currentPath.textContent = title;
      } else {
        return this.currentPath.textContent = '';
      }
    };

    return FileInfoView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
