(function() {
  var CursorPositionView, Disposable;

  Disposable = require('atom').Disposable;

  module.exports = CursorPositionView = (function() {
    function CursorPositionView() {
      var ref;
      this.viewUpdatePending = false;
      this.element = document.createElement('status-bar-cursor');
      this.element.classList.add('cursor-position', 'inline-block');
      this.goToLineLink = document.createElement('a');
      this.goToLineLink.classList.add('inline-block');
      this.element.appendChild(this.goToLineLink);
      this.formatString = (ref = atom.config.get('status-bar.cursorPositionFormat')) != null ? ref : '%L:%C';
      this.activeItemSubscription = atom.workspace.onDidChangeActiveTextEditor((function(_this) {
        return function(activeEditor) {
          return _this.subscribeToActiveTextEditor();
        };
      })(this));
      this.subscribeToConfig();
      this.subscribeToActiveTextEditor();
      this.tooltip = atom.tooltips.add(this.element, {
        title: (function(_this) {
          return function() {
            return "Line " + _this.row + ", Column " + _this.column;
          };
        })(this)
      });
      this.handleClick();
    }

    CursorPositionView.prototype.destroy = function() {
      var ref, ref1, ref2;
      this.activeItemSubscription.dispose();
      if ((ref = this.cursorSubscription) != null) {
        ref.dispose();
      }
      this.tooltip.dispose();
      if ((ref1 = this.configSubscription) != null) {
        ref1.dispose();
      }
      this.clickSubscription.dispose();
      return (ref2 = this.updateSubscription) != null ? ref2.dispose() : void 0;
    };

    CursorPositionView.prototype.subscribeToActiveTextEditor = function() {
      var ref, ref1, selectionsMarkerLayer;
      if ((ref = this.cursorSubscription) != null) {
        ref.dispose();
      }
      selectionsMarkerLayer = (ref1 = atom.workspace.getActiveTextEditor()) != null ? ref1.selectionsMarkerLayer : void 0;
      this.cursorSubscription = selectionsMarkerLayer != null ? selectionsMarkerLayer.onDidUpdate(this.scheduleUpdate.bind(this)) : void 0;
      return this.scheduleUpdate();
    };

    CursorPositionView.prototype.subscribeToConfig = function() {
      var ref;
      if ((ref = this.configSubscription) != null) {
        ref.dispose();
      }
      return this.configSubscription = atom.config.observe('status-bar.cursorPositionFormat', (function(_this) {
        return function(value) {
          _this.formatString = value != null ? value : '%L:%C';
          return _this.scheduleUpdate();
        };
      })(this));
    };

    CursorPositionView.prototype.handleClick = function() {
      var clickHandler;
      clickHandler = function() {
        return atom.commands.dispatch(atom.views.getView(atom.workspace.getActiveTextEditor()), 'go-to-line:toggle');
      };
      this.element.addEventListener('click', clickHandler);
      return this.clickSubscription = new Disposable((function(_this) {
        return function() {
          return _this.element.removeEventListener('click', clickHandler);
        };
      })(this));
    };

    CursorPositionView.prototype.scheduleUpdate = function() {
      if (this.viewUpdatePending) {
        return;
      }
      this.viewUpdatePending = true;
      return this.updateSubscription = atom.views.updateDocument((function(_this) {
        return function() {
          var position, ref;
          _this.viewUpdatePending = false;
          if (position = (ref = atom.workspace.getActiveTextEditor()) != null ? ref.getCursorBufferPosition() : void 0) {
            _this.row = position.row + 1;
            _this.column = position.column + 1;
            _this.goToLineLink.textContent = _this.formatString.replace('%L', _this.row).replace('%C', _this.column);
            return _this.element.classList.remove('hide');
          } else {
            _this.goToLineLink.textContent = '';
            return _this.element.classList.add('hide');
          }
        };
      })(this));
    };

    return CursorPositionView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNC4wL291dC9hcHAvbm9kZV9tb2R1bGVzL3N0YXR1cy1iYXIvbGliL2N1cnNvci1wb3NpdGlvbi12aWV3LmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUE7O0VBQUMsYUFBYyxPQUFBLENBQVEsTUFBUjs7RUFFZixNQUFNLENBQUMsT0FBUCxHQUNNO0lBQ1MsNEJBQUE7QUFDWCxVQUFBO01BQUEsSUFBQyxDQUFBLGlCQUFELEdBQXFCO01BRXJCLElBQUMsQ0FBQSxPQUFELEdBQVcsUUFBUSxDQUFDLGFBQVQsQ0FBdUIsbUJBQXZCO01BQ1gsSUFBQyxDQUFBLE9BQU8sQ0FBQyxTQUFTLENBQUMsR0FBbkIsQ0FBdUIsaUJBQXZCLEVBQTBDLGNBQTFDO01BQ0EsSUFBQyxDQUFBLFlBQUQsR0FBZ0IsUUFBUSxDQUFDLGFBQVQsQ0FBdUIsR0FBdkI7TUFDaEIsSUFBQyxDQUFBLFlBQVksQ0FBQyxTQUFTLENBQUMsR0FBeEIsQ0FBNEIsY0FBNUI7TUFDQSxJQUFDLENBQUEsT0FBTyxDQUFDLFdBQVQsQ0FBcUIsSUFBQyxDQUFBLFlBQXRCO01BRUEsSUFBQyxDQUFBLFlBQUQsOEVBQXFFO01BRXJFLElBQUMsQ0FBQSxzQkFBRCxHQUEwQixJQUFJLENBQUMsU0FBUyxDQUFDLDJCQUFmLENBQTJDLENBQUEsU0FBQSxLQUFBO2VBQUEsU0FBQyxZQUFEO2lCQUFrQixLQUFDLENBQUEsMkJBQUQsQ0FBQTtRQUFsQjtNQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBM0M7TUFFMUIsSUFBQyxDQUFBLGlCQUFELENBQUE7TUFDQSxJQUFDLENBQUEsMkJBQUQsQ0FBQTtNQUVBLElBQUMsQ0FBQSxPQUFELEdBQVcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFkLENBQWtCLElBQUMsQ0FBQSxPQUFuQixFQUE0QjtRQUFBLEtBQUEsRUFBTyxDQUFBLFNBQUEsS0FBQTtpQkFBQSxTQUFBO21CQUFHLE9BQUEsR0FBUSxLQUFDLENBQUEsR0FBVCxHQUFhLFdBQWIsR0FBd0IsS0FBQyxDQUFBO1VBQTVCO1FBQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFQO09BQTVCO01BRVgsSUFBQyxDQUFBLFdBQUQsQ0FBQTtJQWxCVzs7aUNBb0JiLE9BQUEsR0FBUyxTQUFBO0FBQ1AsVUFBQTtNQUFBLElBQUMsQ0FBQSxzQkFBc0IsQ0FBQyxPQUF4QixDQUFBOztXQUNtQixDQUFFLE9BQXJCLENBQUE7O01BQ0EsSUFBQyxDQUFBLE9BQU8sQ0FBQyxPQUFULENBQUE7O1lBQ21CLENBQUUsT0FBckIsQ0FBQTs7TUFDQSxJQUFDLENBQUEsaUJBQWlCLENBQUMsT0FBbkIsQ0FBQTs0REFDbUIsQ0FBRSxPQUFyQixDQUFBO0lBTk87O2lDQVFULDJCQUFBLEdBQTZCLFNBQUE7QUFDM0IsVUFBQTs7V0FBbUIsQ0FBRSxPQUFyQixDQUFBOztNQUNBLHFCQUFBLCtEQUE0RCxDQUFFO01BQzlELElBQUMsQ0FBQSxrQkFBRCxtQ0FBc0IscUJBQXFCLENBQUUsV0FBdkIsQ0FBbUMsSUFBQyxDQUFBLGNBQWMsQ0FBQyxJQUFoQixDQUFxQixJQUFyQixDQUFuQzthQUN0QixJQUFDLENBQUEsY0FBRCxDQUFBO0lBSjJCOztpQ0FNN0IsaUJBQUEsR0FBbUIsU0FBQTtBQUNqQixVQUFBOztXQUFtQixDQUFFLE9BQXJCLENBQUE7O2FBQ0EsSUFBQyxDQUFBLGtCQUFELEdBQXNCLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBWixDQUFvQixpQ0FBcEIsRUFBdUQsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFDLEtBQUQ7VUFDM0UsS0FBQyxDQUFBLFlBQUQsbUJBQWdCLFFBQVE7aUJBQ3hCLEtBQUMsQ0FBQSxjQUFELENBQUE7UUFGMkU7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQXZEO0lBRkw7O2lDQU1uQixXQUFBLEdBQWEsU0FBQTtBQUNYLFVBQUE7TUFBQSxZQUFBLEdBQWUsU0FBQTtlQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBZCxDQUF1QixJQUFJLENBQUMsS0FBSyxDQUFDLE9BQVgsQ0FBbUIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxtQkFBZixDQUFBLENBQW5CLENBQXZCLEVBQWlGLG1CQUFqRjtNQUFIO01BQ2YsSUFBQyxDQUFBLE9BQU8sQ0FBQyxnQkFBVCxDQUEwQixPQUExQixFQUFtQyxZQUFuQzthQUNBLElBQUMsQ0FBQSxpQkFBRCxHQUFxQixJQUFJLFVBQUosQ0FBZSxDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUE7aUJBQUcsS0FBQyxDQUFBLE9BQU8sQ0FBQyxtQkFBVCxDQUE2QixPQUE3QixFQUFzQyxZQUF0QztRQUFIO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFmO0lBSFY7O2lDQUtiLGNBQUEsR0FBZ0IsU0FBQTtNQUNkLElBQVUsSUFBQyxDQUFBLGlCQUFYO0FBQUEsZUFBQTs7TUFFQSxJQUFDLENBQUEsaUJBQUQsR0FBcUI7YUFDckIsSUFBQyxDQUFBLGtCQUFELEdBQXNCLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBWCxDQUEwQixDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUE7QUFDOUMsY0FBQTtVQUFBLEtBQUMsQ0FBQSxpQkFBRCxHQUFxQjtVQUNyQixJQUFHLFFBQUEsNkRBQStDLENBQUUsdUJBQXRDLENBQUEsVUFBZDtZQUNFLEtBQUMsQ0FBQSxHQUFELEdBQU8sUUFBUSxDQUFDLEdBQVQsR0FBZTtZQUN0QixLQUFDLENBQUEsTUFBRCxHQUFVLFFBQVEsQ0FBQyxNQUFULEdBQWtCO1lBQzVCLEtBQUMsQ0FBQSxZQUFZLENBQUMsV0FBZCxHQUE0QixLQUFDLENBQUEsWUFBWSxDQUFDLE9BQWQsQ0FBc0IsSUFBdEIsRUFBNEIsS0FBQyxDQUFBLEdBQTdCLENBQWlDLENBQUMsT0FBbEMsQ0FBMEMsSUFBMUMsRUFBZ0QsS0FBQyxDQUFBLE1BQWpEO21CQUM1QixLQUFDLENBQUEsT0FBTyxDQUFDLFNBQVMsQ0FBQyxNQUFuQixDQUEwQixNQUExQixFQUpGO1dBQUEsTUFBQTtZQU1FLEtBQUMsQ0FBQSxZQUFZLENBQUMsV0FBZCxHQUE0QjttQkFDNUIsS0FBQyxDQUFBLE9BQU8sQ0FBQyxTQUFTLENBQUMsR0FBbkIsQ0FBdUIsTUFBdkIsRUFQRjs7UUFGOEM7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQTFCO0lBSlI7Ozs7O0FBakRsQiIsInNvdXJjZXNDb250ZW50IjpbIntEaXNwb3NhYmxlfSA9IHJlcXVpcmUgJ2F0b20nXG5cbm1vZHVsZS5leHBvcnRzID1cbmNsYXNzIEN1cnNvclBvc2l0aW9uVmlld1xuICBjb25zdHJ1Y3RvcjogLT5cbiAgICBAdmlld1VwZGF0ZVBlbmRpbmcgPSBmYWxzZVxuXG4gICAgQGVsZW1lbnQgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdzdGF0dXMtYmFyLWN1cnNvcicpXG4gICAgQGVsZW1lbnQuY2xhc3NMaXN0LmFkZCgnY3Vyc29yLXBvc2l0aW9uJywgJ2lubGluZS1ibG9jaycpXG4gICAgQGdvVG9MaW5lTGluayA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2EnKVxuICAgIEBnb1RvTGluZUxpbmsuY2xhc3NMaXN0LmFkZCgnaW5saW5lLWJsb2NrJylcbiAgICBAZWxlbWVudC5hcHBlbmRDaGlsZChAZ29Ub0xpbmVMaW5rKVxuXG4gICAgQGZvcm1hdFN0cmluZyA9IGF0b20uY29uZmlnLmdldCgnc3RhdHVzLWJhci5jdXJzb3JQb3NpdGlvbkZvcm1hdCcpID8gJyVMOiVDJ1xuXG4gICAgQGFjdGl2ZUl0ZW1TdWJzY3JpcHRpb24gPSBhdG9tLndvcmtzcGFjZS5vbkRpZENoYW5nZUFjdGl2ZVRleHRFZGl0b3IgKGFjdGl2ZUVkaXRvcikgPT4gQHN1YnNjcmliZVRvQWN0aXZlVGV4dEVkaXRvcigpXG5cbiAgICBAc3Vic2NyaWJlVG9Db25maWcoKVxuICAgIEBzdWJzY3JpYmVUb0FjdGl2ZVRleHRFZGl0b3IoKVxuXG4gICAgQHRvb2x0aXAgPSBhdG9tLnRvb2x0aXBzLmFkZChAZWxlbWVudCwgdGl0bGU6ID0+IFwiTGluZSAje0Byb3d9LCBDb2x1bW4gI3tAY29sdW1ufVwiKVxuXG4gICAgQGhhbmRsZUNsaWNrKClcblxuICBkZXN0cm95OiAtPlxuICAgIEBhY3RpdmVJdGVtU3Vic2NyaXB0aW9uLmRpc3Bvc2UoKVxuICAgIEBjdXJzb3JTdWJzY3JpcHRpb24/LmRpc3Bvc2UoKVxuICAgIEB0b29sdGlwLmRpc3Bvc2UoKVxuICAgIEBjb25maWdTdWJzY3JpcHRpb24/LmRpc3Bvc2UoKVxuICAgIEBjbGlja1N1YnNjcmlwdGlvbi5kaXNwb3NlKClcbiAgICBAdXBkYXRlU3Vic2NyaXB0aW9uPy5kaXNwb3NlKClcblxuICBzdWJzY3JpYmVUb0FjdGl2ZVRleHRFZGl0b3I6IC0+XG4gICAgQGN1cnNvclN1YnNjcmlwdGlvbj8uZGlzcG9zZSgpXG4gICAgc2VsZWN0aW9uc01hcmtlckxheWVyID0gYXRvbS53b3Jrc3BhY2UuZ2V0QWN0aXZlVGV4dEVkaXRvcigpPy5zZWxlY3Rpb25zTWFya2VyTGF5ZXJcbiAgICBAY3Vyc29yU3Vic2NyaXB0aW9uID0gc2VsZWN0aW9uc01hcmtlckxheWVyPy5vbkRpZFVwZGF0ZShAc2NoZWR1bGVVcGRhdGUuYmluZCh0aGlzKSlcbiAgICBAc2NoZWR1bGVVcGRhdGUoKVxuXG4gIHN1YnNjcmliZVRvQ29uZmlnOiAtPlxuICAgIEBjb25maWdTdWJzY3JpcHRpb24/LmRpc3Bvc2UoKVxuICAgIEBjb25maWdTdWJzY3JpcHRpb24gPSBhdG9tLmNvbmZpZy5vYnNlcnZlICdzdGF0dXMtYmFyLmN1cnNvclBvc2l0aW9uRm9ybWF0JywgKHZhbHVlKSA9PlxuICAgICAgQGZvcm1hdFN0cmluZyA9IHZhbHVlID8gJyVMOiVDJ1xuICAgICAgQHNjaGVkdWxlVXBkYXRlKClcblxuICBoYW5kbGVDbGljazogLT5cbiAgICBjbGlja0hhbmRsZXIgPSAtPiBhdG9tLmNvbW1hbmRzLmRpc3BhdGNoKGF0b20udmlld3MuZ2V0VmlldyhhdG9tLndvcmtzcGFjZS5nZXRBY3RpdmVUZXh0RWRpdG9yKCkpLCAnZ28tdG8tbGluZTp0b2dnbGUnKVxuICAgIEBlbGVtZW50LmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKVxuICAgIEBjbGlja1N1YnNjcmlwdGlvbiA9IG5ldyBEaXNwb3NhYmxlID0+IEBlbGVtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKVxuXG4gIHNjaGVkdWxlVXBkYXRlOiAtPlxuICAgIHJldHVybiBpZiBAdmlld1VwZGF0ZVBlbmRpbmdcblxuICAgIEB2aWV3VXBkYXRlUGVuZGluZyA9IHRydWVcbiAgICBAdXBkYXRlU3Vic2NyaXB0aW9uID0gYXRvbS52aWV3cy51cGRhdGVEb2N1bWVudCA9PlxuICAgICAgQHZpZXdVcGRhdGVQZW5kaW5nID0gZmFsc2VcbiAgICAgIGlmIHBvc2l0aW9uID0gYXRvbS53b3Jrc3BhY2UuZ2V0QWN0aXZlVGV4dEVkaXRvcigpPy5nZXRDdXJzb3JCdWZmZXJQb3NpdGlvbigpXG4gICAgICAgIEByb3cgPSBwb3NpdGlvbi5yb3cgKyAxXG4gICAgICAgIEBjb2x1bW4gPSBwb3NpdGlvbi5jb2x1bW4gKyAxXG4gICAgICAgIEBnb1RvTGluZUxpbmsudGV4dENvbnRlbnQgPSBAZm9ybWF0U3RyaW5nLnJlcGxhY2UoJyVMJywgQHJvdykucmVwbGFjZSgnJUMnLCBAY29sdW1uKVxuICAgICAgICBAZWxlbWVudC5jbGFzc0xpc3QucmVtb3ZlKCdoaWRlJylcbiAgICAgIGVsc2VcbiAgICAgICAgQGdvVG9MaW5lTGluay50ZXh0Q29udGVudCA9ICcnXG4gICAgICAgIEBlbGVtZW50LmNsYXNzTGlzdC5hZGQoJ2hpZGUnKVxuIl19
