Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _async = require('async');

var _async2 = _interopRequireDefault(_async);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var UpdatesPanel = (function () {
  function UpdatesPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, UpdatesPanel);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();
    this.updatingPackages = [];
    this.packageCards = [];

    _etch2['default'].initialize(this);

    this.refs.updateAllButton.style.display = 'none';
    this.checkForUpdates();

    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.disposables.add(this.packageManager.on('package-updating theme-updating', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.checkButton.disabled = true;
      _this.updatingPackages.push(pack);
    }));

    this.disposables.add(this.packageManager.on('package-updated theme-updated package-update-failed theme-update-failed', function (_ref2) {
      var pack = _ref2.pack;
      var error = _ref2.error;

      if (error != null) {
        _this.refs.updateErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
      }

      for (var i = 0; i < _this.updatingPackages.length; i++) {
        var update = _this.updatingPackages[i];
        if (update.name === pack.name) {
          _this.updatingPackages.splice(i, 1);
        }
      }

      if (!_this.updatingPackages.length) {
        _this.refs.checkButton.disabled = false;
      }
    }));
  }

  _createClass(UpdatesPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.clearPackageCards();
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'panels-item' },
        _etch2['default'].dom(
          'section',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container updates-container' },
            _etch2['default'].dom(
              'div',
              { className: 'updates-heading-container' },
              _etch2['default'].dom(
                'h1',
                { className: 'section-heading icon icon-cloud-download' },
                'Available Updates'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'section-heading updates-btn-group' },
                _etch2['default'].dom(
                  'button',
                  {
                    ref: 'checkButton',
                    className: 'update-all-button btn',
                    onclick: function () {
                      _this2.checkForUpdates(true);
                    } },
                  'Check for Updates'
                ),
                _etch2['default'].dom(
                  'button',
                  {
                    ref: 'updateAllButton',
                    className: 'update-all-button btn btn-primary',
                    onclick: function () {
                      _this2.updateAll();
                    } },
                  'Update All'
                )
              )
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'versionPinnedPackagesMessage', className: 'alert alert-warning icon icon-alert' },
              'The following packages are pinned to their current version and are not being checked for updates: ',
              _etch2['default'].dom(
                'strong',
                null,
                this.packageManager.getVersionPinnedPackages().join(', ')
              )
            ),
            _etch2['default'].dom('div', { ref: 'updateErrors' }),
            _etch2['default'].dom(
              'div',
              { ref: 'checkingMessage', className: 'alert alert-info icon icon-hourglass' },
              'Checking for updates…'
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'noUpdatesMessage', className: 'alert alert-info icon icon-heart' },
              'All of your installed packages are up to date!'
            ),
            _etch2['default'].dom('div', { ref: 'updatesContainer', className: 'container package-container' })
          )
        )
      );
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'beforeShow',
    value: function beforeShow(opts) {
      var _this3 = this;

      if (opts && opts.back) {
        this.refs.breadcrumb.textContent = opts.back;
        this.refs.breadcrumb.onclick = function () {
          _this3.settingsView.showPanel(opts.back);
        };
      }

      if (opts && opts.updates) {
        this.availableUpdates = opts.updates;
        this.addUpdateViews();
      } else {
        this.availableUpdates = [];
        this.clearPackageCards();
        this.checkForUpdates();
      }

      if (this.packageManager.getVersionPinnedPackages().length === 0) {
        this.refs.versionPinnedPackagesMessage.style.display = 'none';
      }
    }

    // Check for updates and display them
  }, {
    key: 'checkForUpdates',
    value: _asyncToGenerator(function* (clearCache) {
      this.refs.noUpdatesMessage.style.display = 'none';
      this.refs.updateAllButton.disabled = true;
      this.refs.checkButton.disabled = true;
      this.refs.checkingMessage.style.display = '';

      try {
        this.availableUpdates = yield this.packageManager.getOutdated(clearCache);
        this.refs.checkButton.disabled = false;
        this.addUpdateViews();
      } catch (error) {
        this.refs.checkButton.disabled = false;
        this.refs.checkingMessage.style.display = 'none';
        this.refs.updateErrors.appendChild(new _errorView2['default'](this.packageManager, error).element);
      }
    })
  }, {
    key: 'addUpdateViews',
    value: function addUpdateViews() {
      if (this.availableUpdates.length > 0) {
        this.refs.updateAllButton.style.display = '';
        this.refs.updateAllButton.disabled = false;
      }
      this.refs.checkingMessage.style.display = 'none';
      this.clearPackageCards();
      if (this.availableUpdates.length === 0) {
        this.refs.noUpdatesMessage.style.display = '';
      }

      for (var pack of this.availableUpdates) {
        var packageCard = new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Updates' });
        this.refs.updatesContainer.appendChild(packageCard.element);
        this.packageCards.push(packageCard);
      }
    }
  }, {
    key: 'updateAll',
    value: _asyncToGenerator(function* () {
      this.refs.checkButton.disabled = true;
      this.refs.updateAllButton.disabled = true;

      var updatingPackages = this.updatingPackages;
      var successfulUpdatesCount = 0;
      var failedUpdatesCount = 0;

      var concurrency = atom.config.get('settings-view.packageUpdateConcurrency') > 0 ? atom.config.get('settings-view.packageUpdateConcurrency') : Number.POSITIVE_INFINITY;

      var queue = _async2['default'].queue(function (packageCard, callback) {
        var onUpdateCompleted = function onUpdateCompleted(err) {
          err == null ? successfulUpdatesCount++ : failedUpdatesCount++;
        };

        if (updatingPackages.includes(packageCard.pack)) {
          callback();
        } else {
          packageCard.update().then(onUpdateCompleted, onUpdateCompleted).then(callback);
        }
      }, concurrency);

      var queueDrainedPromise = new Promise(function (resolve) {
        queue.drain = resolve;
      });

      for (var packageCard of this.packageCards) {
        queue.push(packageCard);
      }

      yield queueDrainedPromise;

      if (successfulUpdatesCount > 0) {
        var message = 'Restart Atom to complete the update of ' + successfulUpdatesCount + ' ' + pluralize('package', successfulUpdatesCount) + ':';
        var detail = '';
        this.packageCards.forEach(function (card) {
          detail += card.pack.name + '@' + card.pack.version + ' -> ' + card.pack.latestVersion + '\n';
        });
        detail.trim();

        var buttons = [{
          text: 'Restart',
          onDidClick: function onDidClick() {
            return atom.restartApplication();
          }
        }];
        atom.notifications.addSuccess(message, { dismissable: true, buttons: buttons, detail: detail });
      }

      if (failedUpdatesCount === 0) {
        this.refs.checkButton.disabled = false;
        this.refs.updateAllButton.style.display = 'none';
      } else {
        this.refs.checkButton.disabled = false;
        this.refs.updateAllButton.disabled = false;
      }
    })
  }, {
    key: 'clearPackageCards',
    value: function clearPackageCards() {
      var packageCard = null;
      while (packageCard = this.packageCards.pop()) {
        packageCard.destroy();
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return UpdatesPanel;
})();

exports['default'] = UpdatesPanel;

function pluralize(word, count) {
  return count > 1 ? word + 's' : word;
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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