Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _generalPanel = require('./general-panel');

var _generalPanel2 = _interopRequireDefault(_generalPanel);

var _editorPanel = require('./editor-panel');

var _editorPanel2 = _interopRequireDefault(_editorPanel);

var _packageDetailView = require('./package-detail-view');

var _packageDetailView2 = _interopRequireDefault(_packageDetailView);

var _keybindingsPanel = require('./keybindings-panel');

var _keybindingsPanel2 = _interopRequireDefault(_keybindingsPanel);

var _installPanel = require('./install-panel');

var _installPanel2 = _interopRequireDefault(_installPanel);

var _themesPanel = require('./themes-panel');

var _themesPanel2 = _interopRequireDefault(_themesPanel);

var _installedPackagesPanel = require('./installed-packages-panel');

var _installedPackagesPanel2 = _interopRequireDefault(_installedPackagesPanel);

var _updatesPanel = require('./updates-panel');

var _updatesPanel2 = _interopRequireDefault(_updatesPanel);

var _uriHandlerPanel = require('./uri-handler-panel');

var _uriHandlerPanel2 = _interopRequireDefault(_uriHandlerPanel);

var _packageManager = require('./package-manager');

var _packageManager2 = _interopRequireDefault(_packageManager);

var SettingsView = (function () {
  function SettingsView() {
    var _this = this;

    var _ref = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    var uri = _ref.uri;
    var packageManager = _ref.packageManager;
    var snippetsProvider = _ref.snippetsProvider;
    var activePanel = _ref.activePanel;

    _classCallCheck(this, SettingsView);

    this.uri = uri;
    this.packageManager = packageManager;
    this.snippetsProvider = snippetsProvider;
    this.deferredPanel = activePanel;
    this.destroyed = false;

    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
    process.nextTick(function () {
      return _this.initializePanels();
    });
  }

  _createClass(SettingsView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.destroyed = true;
      this.disposables.dispose();
      for (var _name in this.panelsByName) {
        var panel = this.panelsByName[_name];
        panel.destroy();
      }

      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'settings-view pane-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'config-menu', ref: 'sidebar' },
          _etch2['default'].dom(
            'ul',
            { className: 'panels-menu nav nav-pills nav-stacked', ref: 'panelMenu' },
            _etch2['default'].dom('div', { className: 'panel-menu-separator', ref: 'menuSeparator' })
          ),
          _etch2['default'].dom(
            'div',
            { className: 'button-area' },
            _etch2['default'].dom(
              'button',
              { className: 'btn btn-default icon icon-link-external', ref: 'openDotAtom' },
              'Open Config Folder'
            )
          )
        ),
        _etch2['default'].dom('div', { className: 'panels', tabIndex: '-1', ref: 'panels' })
      );
    }

    // This prevents the view being actually disposed when closed
    // If you remove it you will need to ensure the cached settingsView
    // in main.coffee is correctly released on close as well...
  }, {
    key: 'onDidChangeTitle',
    value: function onDidChangeTitle() {
      return new _atom.Disposable();
    }
  }, {
    key: 'initializePanels',
    value: function initializePanels() {
      var _this2 = this;

      if (this.refs.panels.children.length > 1) {
        return;
      }

      this.panelsByName = {};
      var clickHandler = function clickHandler(event) {
        var target = event.target.closest('.panels-menu li a, .panels-packages li a');
        if (target) {
          _this2.showPanel(target.closest('li').name);
        }
      };
      this.element.addEventListener('click', clickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.element.removeEventListener('click', clickHandler);
      }));

      var focusHandler = function focusHandler() {
        _this2.focusActivePanel();
      };
      this.element.addEventListener('focus', focusHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.element.removeEventListener('focus', focusHandler);
      }));

      var openDotAtomClickHandler = function openDotAtomClickHandler() {
        atom.open({ pathsToOpen: [atom.getConfigDirPath()] });
      };
      this.refs.openDotAtom.addEventListener('click', openDotAtomClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.refs.openDotAtom.removeEventListener('click', openDotAtomClickHandler);
      }));

      this.addCorePanel('Core', 'settings', function () {
        return new _generalPanel2['default']();
      });
      this.addCorePanel('Editor', 'code', function () {
        return new _editorPanel2['default']();
      });
      if (atom.config.getSchema('core.uriHandlerRegistration').type !== 'any') {
        // "feature flag" based on core support for URI handling
        this.addCorePanel('URI Handling', 'link', function () {
          return new _uriHandlerPanel2['default']();
        });
      }
      if (process.platform === 'win32' && require('atom').WinShell != null) {
        (function () {
          var SystemPanel = require('./system-windows-panel');
          _this2.addCorePanel('System', 'device-desktop', function () {
            return new SystemPanel();
          });
        })();
      }
      this.addCorePanel('Keybindings', 'keyboard', function () {
        return new _keybindingsPanel2['default']();
      });
      this.addCorePanel('Packages', 'package', function () {
        return new _installedPackagesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Themes', 'paintcan', function () {
        return new _themesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Updates', 'cloud-download', function () {
        return new _updatesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Install', 'plus', function () {
        return new _installPanel2['default'](_this2, _this2.packageManager);
      });

      this.showDeferredPanel();

      if (!this.activePanel) {
        this.showPanel('Core');
      }

      if (document.body.contains(this.element)) {
        this.refs.sidebar.style.width = this.refs.sidebar.offsetWidth;
      }
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: 'SettingsView',
        version: 2,
        activePanel: this.activePanel != null ? this.activePanel : this.deferredPanel,
        uri: this.uri
      };
    }
  }, {
    key: 'getPackages',
    value: function getPackages() {
      var _this3 = this;

      var bundledPackageMetadataCache = undefined;
      var left = undefined;
      if (this.packages != null) {
        return this.packages;
      }

      this.packages = atom.packages.getLoadedPackages();

      try {
        var packageMetadata = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'package.json'));
        bundledPackageMetadataCache = packageMetadata ? packageMetadata._atomPackages : null;
      } catch (error) {}

      // Include disabled packages so they can be re-enabled from the UI
      var disabledPackages = atom.config.get('core.disabledPackages') || [];
      for (var packageName of disabledPackages) {
        var metadata;
        var packagePath = atom.packages.resolvePackagePath(packageName);
        if (!packagePath) {
          continue;
        }

        try {
          metadata = require(_path2['default'].join(packagePath, 'package.json'));
        } catch (error) {
          if (bundledPackageMetadataCache && bundledPackageMetadataCache[packageName]) {
            metadata = bundledPackageMetadataCache[packageName].metadata;
          }
        }
        if (metadata == null) {
          continue;
        }

        var _name2 = metadata.name != null ? metadata.name : packageName;
        if (!_underscorePlus2['default'].findWhere(this.packages, { name: _name2 })) {
          this.packages.push({ name: _name2, metadata: metadata, path: packagePath });
        }
      }

      this.packages.sort(function (pack1, pack2) {
        var title1 = _this3.packageManager.getPackageTitle(pack1);
        var title2 = _this3.packageManager.getPackageTitle(pack2);
        return title1.localeCompare(title2);
      });

      return this.packages;
    }
  }, {
    key: 'addCorePanel',
    value: function addCorePanel(name, iconName, panel) {
      var panelMenuItem = document.createElement('li');
      panelMenuItem.name = name;
      panelMenuItem.setAttribute('name', name);

      var a = document.createElement('a');
      a.classList.add('icon', 'icon-' + iconName);
      a.textContent = name;
      panelMenuItem.appendChild(a);

      this.refs.menuSeparator.parentElement.insertBefore(panelMenuItem, this.refs.menuSeparator);
      this.addPanel(name, panel);
    }
  }, {
    key: 'addPanel',
    value: function addPanel(name, panelCreateCallback) {
      if (this.panelCreateCallbacks == null) {
        this.panelCreateCallbacks = {};
      }
      this.panelCreateCallbacks[name] = panelCreateCallback;
      if (this.deferredPanel && this.deferredPanel.name === name) {
        this.showDeferredPanel();
      }
    }
  }, {
    key: 'getOrCreatePanel',
    value: function getOrCreatePanel(name, options) {
      var _this4 = this;

      var panel = this.panelsByName ? this.panelsByName[name] : null;
      // These nested conditionals are not great but I feel like it's the most
      // expedient thing to do - I feel like the "right way" involves refactoring
      // this whole file.
      if (!panel) {
        var callback = this.panelCreateCallbacks ? this.panelCreateCallbacks[name] : null;

        if (options && options.pack && !callback) {
          callback = function () {
            if (!options.pack.metadata) {
              var metadata = _underscorePlus2['default'].clone(options.pack);
              options.pack.metadata = metadata;
            }
            return new _packageDetailView2['default'](options.pack, _this4, _this4.packageManager, _this4.snippetsProvider);
          };
        }

        if (callback) {
          panel = callback();
          if (this.panelsByName == null) {
            this.panelsByName = {};
          }
          this.panelsByName[name] = panel;
          if (this.panelCreateCallbacks) {
            delete this.panelCreateCallbacks[name];
          }
        }
      }

      return panel;
    }
  }, {
    key: 'makePanelMenuActive',
    value: function makePanelMenuActive(name) {
      var previouslyActivePanel = this.refs.sidebar.querySelector('.active');
      if (previouslyActivePanel) {
        previouslyActivePanel.classList.remove('active');
      }

      var newActivePanel = this.refs.sidebar.querySelector('[name=\'' + name + '\']');
      if (newActivePanel) {
        newActivePanel.classList.add('active');
      }
    }
  }, {
    key: 'focusActivePanel',
    value: function focusActivePanel() {
      // Pass focus to panel that is currently visible
      for (var i = 0; i < this.refs.panels.children.length; i++) {
        var child = this.refs.panels.children[i];
        if (child.offsetWidth > 0) {
          child.focus();
        }
      }
    }
  }, {
    key: 'showDeferredPanel',
    value: function showDeferredPanel() {
      if (this.deferredPanel) {
        var _deferredPanel = this.deferredPanel;
        var _name3 = _deferredPanel.name;
        var options = _deferredPanel.options;

        this.showPanel(_name3, options);
      }
    }

    // Public: show a panel.
    //
    // * `name` {String} the name of the panel to show
    // * `options` {Object} an options hash. Will be passed to `beforeShow()` on
    //   the panel. Options may include (but are not limited to):
    //   * `uri` the URI the panel was launched from
  }, {
    key: 'showPanel',
    value: function showPanel(name, options) {
      var panel = this.getOrCreatePanel(name, options);
      if (panel) {
        this.appendPanel(panel, options);
        this.makePanelMenuActive(name);
        this.setActivePanel(name, options);
        this.deferredPanel = null;
      } else {
        this.deferredPanel = { name: name, options: options };
      }
    }
  }, {
    key: 'showPanelForURI',
    value: function showPanelForURI(uri) {
      var regex = /config\/([a-z]+)\/?([a-zA-Z0-9_-]+)?/i;
      var match = regex.exec(uri);

      if (match) {
        var path1 = match[1];
        var path2 = match[2];

        if (path1 === 'packages' && path2 != null) {
          this.showPanel(path2, {
            uri: uri,
            pack: { name: path2 },
            back: atom.packages.getLoadedPackage(path2) ? 'Packages' : null
          });
        } else {
          var panelName = path1[0].toUpperCase() + path1.slice(1);
          this.showPanel(panelName, { uri: uri });
        }
      }
    }
  }, {
    key: 'appendPanel',
    value: function appendPanel(panel, options) {
      for (var i = 0; i < this.refs.panels.children.length; i++) {
        this.refs.panels.children[i].style.display = 'none';
      }

      if (!this.refs.panels.contains(panel.element)) {
        this.refs.panels.appendChild(panel.element);
      }

      if (panel.beforeShow) {
        panel.beforeShow(options);
      }
      panel.show();
      panel.focus();
    }
  }, {
    key: 'setActivePanel',
    value: function setActivePanel(name) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      this.activePanel = { name: name, options: options };
    }
  }, {
    key: 'removePanel',
    value: function removePanel(name) {
      var panel = this.panelsByName ? this.panelsByName[name] : null;
      if (panel) {
        panel.destroy();
        delete this.panelsByName[name];
      }
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Settings';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'tools';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.uri;
    }
  }, {
    key: 'isEqual',
    value: function isEqual(other) {
      return other instanceof SettingsView;
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return SettingsView;
})();

exports['default'] = SettingsView;
module.exports = exports['default'];
/* The tabindex attr below ensures that clicks in a panel item won't
cause this view to gain focus. This is important because when this view
gains focus (e.g. immediately after atom displays it), it focuses the
currently active panel item. If that focusing causes the active panel to
scroll (e.g. because the active panel itself passes focus on to a search
box at the top of a scrolled panel), then the browser will not fire the
click event on the element within the panel on which the user originally
clicked (e.g. a package card). This would prevent us from showing a
package detail view when clicking on a package card. Phew! */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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