Object.defineProperty(exports, '__esModule', {
  value: true
});
var _bind = Function.prototype.bind;

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x2, _x3, _x4) { var _again = true; _function: while (_again) { var object = _x2, property = _x3, receiver = _x4; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x2 = parent; _x3 = property; _x4 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _collapsibleSectionPanel = require('./collapsible-section-panel');

var _collapsibleSectionPanel2 = _interopRequireDefault(_collapsibleSectionPanel);

var _richDescription = require('./rich-description');

var SCOPED_SETTINGS = ['autoIndent', 'autoIndentOnPaste', 'invisibles', 'nonWordCharacters', 'preferredLineLength', 'scrollPastEnd', 'showIndentGuide', 'showInvisibles', 'softWrap', 'softWrapAtPreferredLineLength', 'softWrapHangingIndent', 'tabLength', 'tabType'];

var SettingsPanel = (function (_CollapsibleSectionPanel) {
  _inherits(SettingsPanel, _CollapsibleSectionPanel);

  function SettingsPanel() {
    var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, SettingsPanel);

    _get(Object.getPrototypeOf(SettingsPanel.prototype), 'constructor', this).call(this);
    var namespace = options.namespace;
    this.element = document.createElement('section');
    this.element.classList.add('section', 'settings-panel');
    this.options = options;
    this.disposables = new _atom.CompositeDisposable();
    var settings = undefined;
    if (this.options.scopeName) {
      namespace = 'editor';
      settings = {};
      for (var _name of SCOPED_SETTINGS) {
        settings[_name] = atom.config.get(_name, { scope: [this.options.scopeName] });
      }
    } else {
      settings = atom.config.get(namespace);
    }

    this.element.appendChild(this.elementForSettings(namespace, settings));

    this.disposables.add(this.bindInputFields());
    this.disposables.add(this.bindSelectFields());
    this.disposables.add(this.bindEditors());
    this.disposables.add(this.bindTooltips());
    this.disposables.add(this.handleEvents());
  }

  /*
   * Space Pen Helpers
   */

  _createClass(SettingsPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'elementForSettings',
    value: function elementForSettings(namespace, settings) {
      if (_underscorePlus2['default'].isEmpty(settings)) {
        return document.createDocumentFragment();
      }

      var title = this.options.title;

      var includeTitle = this.options.includeTitle != null ? this.options.includeTitle : true;
      if (includeTitle) {
        if (title == null) {
          title = _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(namespace)) + ' Settings';
        }
      } else {
        if (title == null) {
          title = "Settings";
        }
      }

      var icon = this.options.icon != null ? this.options.icon : 'gear';
      var note = this.options.note;

      var sortedSettings = this.sortSettings(namespace, settings);

      var container = document.createElement('div');
      container.classList.add('section-container');

      var heading = document.createElement('div');
      heading.classList.add('block', 'section-heading', 'icon', 'icon-' + icon);
      heading.textContent = title;
      container.appendChild(heading);

      if (note) {
        container.insertAdjacentHTML('beforeend', note);
      }

      var body = document.createElement('div');
      body.classList.add('section-body');
      for (var _name2 of sortedSettings) {
        body.appendChild(elementForSetting(namespace, _name2, settings[_name2]));
      }
      container.appendChild(body);

      return container;
    }
  }, {
    key: 'sortSettings',
    value: function sortSettings(namespace, settings) {
      return _sortSettings(namespace, settings);
    }
  }, {
    key: 'bindInputFields',
    value: function bindInputFields() {
      var _this = this;

      var disposables = Array.from(this.element.querySelectorAll('input[id]')).map(function (input) {
        var name = input.id;
        var type = input.type;

        _this.observe(name, function (value) {
          if (type === 'checkbox') {
            input.checked = value;
          } else {
            if (type === 'color') {
              if (value && value.toHexString && value.toHexString()) {
                value = value.toHexString();
              }
            }

            if (value) {
              input.value = value;
            }
          }
        });

        var changeHandler = function changeHandler() {
          var value = input.value;
          if (type === 'checkbox') {
            value = input.checked;
          } else {
            value = _this.parseValue(type, value);
          }

          if (type === 'color') {
            // This is debounced since the color wheel fires lots of events
            // as you are dragging it around
            clearTimeout(_this.colorDebounceTimeout);
            _this.colorDebounceTimeout = setTimeout(function () {
              _this.set(name, value);
            }, 100);
          } else {
            _this.set(name, value);
          }
        };

        input.addEventListener('change', changeHandler);
        return new _atom.Disposable(function () {
          return input.removeEventListener('change', changeHandler);
        });
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'observe',
    value: function observe(name, callback) {
      var params = { sources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }
      this.disposables.add(atom.config.observe(name, params, callback));
    }
  }, {
    key: 'isDefault',
    value: function isDefault(name) {
      var params = { sources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }
      var defaultValue = this.getDefault(name);
      var value = atom.config.get(name, params);
      return value == null || defaultValue === value;
    }
  }, {
    key: 'getDefault',
    value: function getDefault(name) {
      var params = { excludeSources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }

      var defaultValue = atom.config.get(name, params);
      if (this.options.scopeName != null) {
        // If the unscoped default is the same as the scoped default, check the actual config.cson
        // to make sure that there isn't a non-default value that is overriding the scoped value
        // For example: the default editor.tabLength is 2, but if someone sets it to 4
        // the above check still returns 2 and not 4 for a scoped editor.tabLength,
        // because it bypasses config.cson.
        if (atom.config.get(name, { excludeSources: [atom.config.getUserConfigPath()] }) === defaultValue) {
          defaultValue = atom.config.get(name);
        }
      }
      return defaultValue;
    }
  }, {
    key: 'set',
    value: function set(name, value) {
      if (this.options.scopeName) {
        if (value === undefined) {
          atom.config.unset(name, { scopeSelector: this.options.scopeName });
          return true;
        } else {
          return atom.config.set(name, value, { scopeSelector: this.options.scopeName });
        }
      } else {
        return atom.config.set(name, value);
      }
    }
  }, {
    key: 'setText',
    value: function setText(editor, name, type, value) {
      var stringValue = undefined;
      if (this.isDefault(name)) {
        stringValue = '';
      } else {
        stringValue = this.valueToString(value) || '';
      }

      if (stringValue === editor.getText() || _underscorePlus2['default'].isEqual(value, this.parseValue(type, editor.getText()))) {
        return;
      }

      editor.setText(stringValue);
      editor.moveToEndOfLine();
    }
  }, {
    key: 'bindSelectFields',
    value: function bindSelectFields() {
      var _this2 = this;

      var disposables = Array.from(this.element.querySelectorAll('select[id]')).map(function (select) {
        var name = select.id;
        _this2.observe(name, function (value) {
          return select.value = value;
        });
        var changeHandler = function changeHandler() {
          _this2.set(name, select.value);
        };
        select.addEventListener('change', changeHandler);
        return new _atom.Disposable(function () {
          return select.removeEventListener('change', changeHandler);
        });
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'bindEditors',
    value: function bindEditors() {
      var _this3 = this;

      var disposables = Array.from(this.element.querySelectorAll('atom-text-editor')).map(function (editorElement) {
        var editor = editorElement.getModel();
        var name = editorElement.id;
        var type = editorElement.getAttribute('type');
        var defaultValue = _this3.valueToString(_this3.getDefault(name));

        if (defaultValue != null) {
          editor.setPlaceholderText('Default: ' + defaultValue);
        }

        var subscriptions = new _atom.CompositeDisposable();

        var focusHandler = function focusHandler() {
          if (_this3.isDefault(name)) {
            editor.setText((left = _this3.valueToString(_this3.getDefault(name))) != null ? left : '');
          }
        };
        editorElement.addEventListener('focus', focusHandler);
        subscriptions.add(new _atom.Disposable(function () {
          return editorElement.removeEventListener('focus', focusHandler);
        }));

        var blurHandler = function blurHandler() {
          if (_this3.isDefault(name)) {
            editor.setText('');
          }
        };
        editorElement.addEventListener('blur', blurHandler);
        subscriptions.add(new _atom.Disposable(function () {
          return editorElement.removeEventListener('blur', blurHandler);
        }));

        _this3.observe(name, function (value) {
          _this3.setText(editor, name, type, value);
        });

        subscriptions.add(editor.onDidStopChanging(function () {
          var _atom$config$getSchema = atom.config.getSchema(name);

          var minimum = _atom$config$getSchema.minimum;
          var maximum = _atom$config$getSchema.maximum;

          var value = _this3.parseValue(type, editor.getText());
          if (minimum != null && value < minimum) {
            _this3.set(name, minimum);
            _this3.setText(editor, name, type, minimum);
          } else if (maximum != null && value > maximum) {
            _this3.set(name, maximum);
            _this3.setText(editor, name, type, maximum);
          } else if (!_this3.set(name, value)) {
            _this3.setText(editor, name, type, atom.config.get(name));
          }
        }));

        return subscriptions;
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'bindTooltips',
    value: function bindTooltips() {
      var _this4 = this;

      var disposables = Array.from(this.element.querySelectorAll('input[id], select[id], atom-text-editor[id]')).map(function (element) {
        var schema = atom.config.getSchema(element.id);
        var defaultValue = _this4.valueToString(_this4.getDefault(element.id));
        if (defaultValue != null) {
          if (schema['enum'] && _underscorePlus2['default'].findWhere(schema['enum'], { value: defaultValue })) {
            defaultValue = _underscorePlus2['default'].findWhere(schema['enum'], { value: defaultValue }).description;
          }
          return atom.tooltips.add(element, {
            title: 'Default: ' + defaultValue,
            delay: { show: 100 },
            placement: 'auto left'
          });
        } else {
          return new _atom.Disposable(function () {}); // no-op
        }
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'valueToString',
    value: function valueToString(value) {
      if (Array.isArray(value)) {
        return value.join(', ') || null;
      } else if (value != null) {
        return value.toString();
      } else {
        return null;
      }
    }
  }, {
    key: 'parseValue',
    value: function parseValue(type, value) {
      if (value === '') {
        return undefined;
      } else if (type === 'number') {
        var floatValue = parseFloat(value);
        if (isNaN(floatValue)) {
          return value;
        } else {
          return floatValue;
        }
      } else if (type === 'array') {
        var arrayValue = (value || '').split(',');
        return arrayValue.filter(function (val) {
          return val;
        }).map(function (val) {
          return val.trim();
        });
      } else {
        return value;
      }
    }
  }]);

  return SettingsPanel;
})(_collapsibleSectionPanel2['default']);

exports['default'] = SettingsPanel;
var isEditableArray = function isEditableArray(array) {
  for (var item of array) {
    if (!_underscorePlus2['default'].isString(item)) {
      return false;
    }
  }
  return true;
};

function _sortSettings(namespace, settings) {
  return _underscorePlus2['default'].chain(settings).keys().sortBy(function (name) {
    return name;
  }).sortBy(function (name) {
    var schema = atom.config.getSchema(namespace + '.' + name);
    return schema ? schema.order : null;
  }).value();
}

function elementForSetting(namespace, name, value) {
  if (namespace === 'core') {
    if (name === 'themes') {
      return document.createDocumentFragment();
    } // Handled in the Themes panel
    if (name === 'disabledPackages') {
      return document.createDocumentFragment();
    } // Handled in the Packages panel
    if (name === 'customFileTypes') {
      return document.createDocumentFragment();
    }
    if (name === 'uriHandlerRegistration') {
      return document.createDocumentFragment();
    } // Handled in the URI Handler panel
  }

  if (namespace === 'editor') {
    // There's no global default for these, they are defined by language packages
    if (['commentStart', 'commentEnd', 'increaseIndentPattern', 'decreaseIndentPattern', 'foldEndPattern'].includes(name)) {
      return document.createDocumentFragment();
    }
  }

  var controlGroup = document.createElement('div');
  controlGroup.classList.add('control-group');

  var controls = document.createElement('div');
  controls.classList.add('controls');
  controlGroup.appendChild(controls);

  var schema = atom.config.getSchema(namespace + '.' + name);
  if (schema && schema['enum']) {
    controls.appendChild(elementForOptions(namespace, name, value));
  } else if (schema && schema.type === 'color') {
    controls.appendChild(elementForColor(namespace, name, value));
  } else if (_underscorePlus2['default'].isBoolean(value) || schema && schema.type === 'boolean') {
    controls.appendChild(elementForCheckbox(namespace, name, value));
  } else if (_underscorePlus2['default'].isArray(value) || schema && schema.type === 'array') {
    if (isEditableArray(value)) {
      controls.appendChild(elementForArray(namespace, name, value));
    }
  } else if (_underscorePlus2['default'].isObject(value) || schema && schema.type === 'object') {
    controls.appendChild(elementForObject(namespace, name, value));
  } else {
    controls.appendChild(elementForEditor(namespace, name, value));
  }

  return controlGroup;
}

function getSettingTitle(keyPath, name) {
  if (name == null) {
    name = '';
  }
  var schema = atom.config.getSchema(keyPath);
  var title = schema != null ? schema.title : null;
  return title || _underscorePlus2['default'].uncamelcase(name).split('.').map(_underscorePlus2['default'].capitalize).join(' ');
}

function elementForOptions(namespace, name, value) {
  var keyPath = namespace + '.' + name;
  var schema = atom.config.getSchema(keyPath);
  var options = schema && schema['enum'] ? schema['enum'] : [];

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);

  fragment.appendChild(label);

  var select = document.createElement('select');
  select.id = keyPath;
  select.classList.add('form-control');
  for (var option of options) {
    var optionElement = document.createElement('option');
    if (option.hasOwnProperty('value')) {
      optionElement.value = option.value;
      optionElement.textContent = option.description;
    } else {
      optionElement.value = option;
      optionElement.textContent = option;
    }
    select.appendChild(optionElement);
  }

  fragment.appendChild(select);

  return fragment;
}

function elementForCheckbox(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var div = document.createElement('div');
  div.classList.add('checkbox');

  var label = document.createElement('label');
  label['for'] = keyPath;

  var input = document.createElement('input');
  input.id = keyPath;
  input.type = 'checkbox';
  input.classList.add('input-checkbox');
  label.appendChild(input);

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);
  div.appendChild(label);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  div.appendChild(descriptionDiv);

  return div;
}

function elementForColor(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var div = document.createElement('div');
  div.classList.add('color');

  var label = document.createElement('label');
  label['for'] = keyPath;

  var input = document.createElement('input');
  input.id = keyPath;
  input.type = 'color';
  label.appendChild(input);

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);
  div.appendChild(label);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  div.appendChild(descriptionDiv);

  return div;
}

function elementForEditor(namespace, name, value) {
  var keyPath = namespace + '.' + name;
  var type = _underscorePlus2['default'].isNumber(value) ? 'number' : 'string';

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);
  fragment.appendChild(label);

  var controls = document.createElement('div');
  controls.classList.add('controls');

  var editorContainer = document.createElement('div');
  editorContainer.classList.add('editor-container');

  var editor = new _atom.TextEditor({ mini: true });
  editor.element.id = keyPath;
  editor.element.setAttribute('type', type);
  editorContainer.appendChild(editor.element);
  controls.appendChild(editorContainer);
  fragment.appendChild(controls);

  return fragment;
}

function elementForArray(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);
  fragment.appendChild(label);

  var controls = document.createElement('div');
  controls.classList.add('controls');

  var editorContainer = document.createElement('div');
  editorContainer.classList.add('editor-container');

  var editor = new _atom.TextEditor({ mini: true });
  editor.element.id = keyPath;
  editor.element.setAttribute('type', 'array');
  editorContainer.appendChild(editor.element);
  controls.appendChild(editorContainer);
  fragment.appendChild(controls);

  return fragment;
}

function elementForObject(namespace, name, value) {
  if (_underscorePlus2['default'].keys(value).length === 0) {
    return document.createDocumentFragment();
  } else {
    var keyPath = namespace + '.' + name;
    var schema = atom.config.getSchema(keyPath);
    var isCollapsed = schema.collapsed === true;

    var section = document.createElement('section');
    section.classList.add('sub-section');
    if (isCollapsed) {
      section.classList.add('collapsed');
    }

    var h3 = document.createElement('h3');
    h3.classList.add('sub-section-heading', 'has-items');
    h3.textContent = getSettingTitle(keyPath, name);
    section.appendChild(h3);

    var div = document.createElement('div');
    div.classList.add('sub-section-body');
    for (var key of _sortSettings(keyPath, value)) {
      div.appendChild(elementForSetting(namespace, name + '.' + key, value[key]));
    }
    section.appendChild(div);

    return section;
  }
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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