Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _atom = require('atom');

// View to display the snippets that a package has registered.

var PackageSnippetsView = (function () {
  function PackageSnippetsView(pack, snippetsProvider) {
    var _this = this;

    _classCallCheck(this, PackageSnippetsView);

    this.pack = pack;
    this.namespace = this.pack.name;
    this.snippetsProvider = snippetsProvider;
    this.packagePath = _path2['default'].join(pack.path, _path2['default'].sep);
    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.updateSnippetsView();

    var packagesWithSnippetsDisabled = atom.config.get('core.packagesWithSnippetsDisabled') || [];
    this.refs.snippetToggle.checked = !packagesWithSnippetsDisabled.includes(this.namespace);

    var changeHandler = function changeHandler(event) {
      event.stopPropagation();
      var value = _this.refs.snippetToggle.checked;
      if (value) {
        atom.config.removeAtKeyPath('core.packagesWithSnippetsDisabled', _this.namespace);
      } else {
        atom.config.pushAtKeyPath('core.packagesWithSnippetsDisabled', _this.namespace);
      }
      _this.updateSnippetsView();
    };

    this.refs.snippetToggle.addEventListener('change', changeHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.snippetToggle.removeEventListener('change', changeHandler);
    }));
  }

  _createClass(PackageSnippetsView, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'section',
        { className: 'section' },
        _etch2['default'].dom(
          'div',
          { className: 'section-heading icon icon-code' },
          'Snippets'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'checkbox' },
          _etch2['default'].dom(
            'label',
            { 'for': 'toggleSnippets' },
            _etch2['default'].dom('input', { id: 'toggleSnippets', className: 'input-checkbox', type: 'checkbox', ref: 'snippetToggle' }),
            _etch2['default'].dom(
              'div',
              { className: 'setting-title' },
              'Enable'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'setting-description' },
            "Disable this if you want to prevent this package’s snippets from appearing as suggestions or if you want to customize them in your snippets file."
          )
        ),
        _etch2['default'].dom(
          'table',
          { className: 'package-snippets-table table native-key-bindings text', tabIndex: -1 },
          _etch2['default'].dom(
            'thead',
            null,
            _etch2['default'].dom(
              'tr',
              null,
              _etch2['default'].dom(
                'th',
                null,
                'Trigger'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Name'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Scope'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Body'
              )
            )
          ),
          _etch2['default'].dom('tbody', { ref: 'snippets' })
        )
      );
    }
  }, {
    key: 'getSnippetProperties',
    value: function getSnippetProperties() {
      var packageProperties = {};
      for (var _ref2 of this.snippetsProvider.getSnippets()) {
        var _name = _ref2.name;
        var properties = _ref2.properties;
        var selectorString = _ref2.selectorString;

        if (_name && _name.indexOf && _name.indexOf(this.packagePath) === 0) {
          var object = properties.snippets != null ? properties.snippets : {};
          for (var key in object) {
            var snippet = object[key];
            if (snippet != null) {
              snippet.selectorString = selectorString;
              if (packageProperties[key] == null) {
                packageProperties[key] = snippet;
              }
            }
          }
        }
      }

      return _underscorePlus2['default'].values(packageProperties).sort(function (snippet1, snippet2) {
        var prefix1 = snippet1.prefix != null ? snippet1.prefix : '';
        var prefix2 = snippet2.prefix != null ? snippet2.prefix : '';
        return prefix1.localeCompare(prefix2);
      });
    }
  }, {
    key: 'getSnippets',
    value: function getSnippets(callback) {
      var _this2 = this;

      var snippetsPackage = atom.packages.getLoadedPackage('snippets');
      var snippetsModule = snippetsPackage ? snippetsPackage.mainModule : null;
      if (snippetsModule) {
        if (snippetsModule.loaded) {
          callback(this.getSnippetProperties());
        } else {
          snippetsModule.onDidLoadSnippets(function () {
            return callback(_this2.getSnippetProperties());
          });
        }
      } else {
        callback([]);
      }
    }
  }, {
    key: 'updateSnippetsView',
    value: function updateSnippetsView() {
      var _this3 = this;

      var packagesWithSnippetsDisabled = atom.config.get('core.packagesWithSnippetsDisabled') || [];
      var snippetsDisabled = packagesWithSnippetsDisabled.includes(this.namespace);

      this.getSnippets(function (snippets) {
        _this3.refs.snippets.innerHTML = '';

        if (snippetsDisabled) {
          _this3.refs.snippets.classList.add('text-subtle');
        } else {
          _this3.refs.snippets.classList.remove('text-subtle');
        }

        for (var _ref32 of snippets) {
          var body = _ref32.body;
          var bodyText = _ref32.bodyText;
          var _name2 = _ref32.name;
          var prefix = _ref32.prefix;
          var selectorString = _ref32.selectorString;

          if (_name2 == null) {
            _name2 = '';
          }

          if (prefix == null) {
            prefix = '';
          }

          if (body == null) {
            body = bodyText || '';
          }

          if (selectorString == null) {
            selectorString = '';
          }

          var row = document.createElement('tr');

          var prefixTd = document.createElement('td');
          prefixTd.classList.add('snippet-prefix');
          prefixTd.textContent = prefix;
          row.appendChild(prefixTd);

          var nameTd = document.createElement('td');
          nameTd.textContent = _name2;
          row.appendChild(nameTd);

          var scopeTd = document.createElement('td');
          scopeTd.classList.add('snippet-scope-name');
          scopeTd.textContent = selectorString;
          row.appendChild(scopeTd);

          var bodyTd = document.createElement('td');
          bodyTd.classList.add('snippet-body');
          row.appendChild(bodyTd);

          _this3.refs.snippets.appendChild(row);
          _this3.createButtonsForSnippetRow(bodyTd, { body: body, prefix: prefix, scope: selectorString, name: _name2 });
        }

        if (_this3.refs.snippets.children.length > 0) {
          _this3.element.style.display = '';
        } else {
          _this3.element.style.display = 'none';
        }
      });
    }
  }, {
    key: 'createButtonsForSnippetRow',
    value: function createButtonsForSnippetRow(td, _ref4) {
      var _this4 = this;

      var scope = _ref4.scope;
      var body = _ref4.body;
      var name = _ref4.name;
      var prefix = _ref4.prefix;

      var buttonContainer = document.createElement('div');
      buttonContainer.classList.add('btn-group', 'btn-group-xs');

      var viewButton = document.createElement('button');
      var copyButton = document.createElement('button');

      viewButton.setAttribute('type', 'button');
      viewButton.textContent = 'View';
      viewButton.classList.add('btn', 'snippet-view-btn');

      var tooltip = atom.tooltips.add(viewButton, {
        title: body,
        html: false,
        trigger: 'click',
        placement: 'auto left',
        'class': 'snippet-body-tooltip'
      });

      this.disposables.add(tooltip);

      copyButton.setAttribute('type', 'button');
      copyButton.textContent = 'Copy';
      copyButton.classList.add('btn', 'snippet-copy-btn');

      copyButton.addEventListener('click', function (event) {
        event.preventDefault();
        return _this4.writeSnippetToClipboard({ scope: scope, body: body, name: name, prefix: prefix });
      });

      buttonContainer.appendChild(viewButton);
      buttonContainer.appendChild(copyButton);

      td.appendChild(buttonContainer);
    }
  }, {
    key: 'writeSnippetToClipboard',
    value: function writeSnippetToClipboard(_ref5) {
      var scope = _ref5.scope;
      var body = _ref5.body;
      var name = _ref5.name;
      var prefix = _ref5.prefix;

      var content = undefined;
      var extension = _path2['default'].extname(this.snippetsProvider.getUserSnippetsPath());
      body = body.replace(/\n/g, '\\n').replace(/\t/g, '\\t');
      if (extension === '.cson') {
        body = body.replace(/'/g, '\\\'');
        content = '\n\'' + scope + '\':\n  \'' + name + '\':\n    \'prefix\': \'' + prefix + '\'\n    \'body\': \'' + body + '\'\n';
      } else {
        body = body.replace(/"/g, '\\"');
        content = '\n  "' + scope + '": {\n    "' + name + '": {\n      "prefix": "' + prefix + '",\n      "body": "' + body + '"\n    }\n  }\n';
      }

      atom.clipboard.write(content);
    }
  }]);

  return PackageSnippetsView;
})();

exports['default'] = PackageSnippetsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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