Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _keybindingsPanel = require('./keybindings-panel');

var _keybindingsPanel2 = _interopRequireDefault(_keybindingsPanel);

// Displays the keybindings for a package namespace

var PackageKeymapView = (function () {
  function PackageKeymapView(pack) {
    var _this = this;

    _classCallCheck(this, PackageKeymapView);

    this.pack = pack;
    this.otherPlatformPattern = new RegExp('\\.platform-(?!' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b)');
    this.namespace = this.pack.name;
    this.disposables = new _atom.CompositeDisposable();
    _etch2['default'].initialize(this);

    var packagesWithKeymapsDisabled = atom.config.get('core.packagesWithKeymapsDisabled') || [];
    this.refs.keybindingToggle.checked = !packagesWithKeymapsDisabled.includes(this.namespace);

    var changeHandler = function changeHandler(event) {
      event.stopPropagation();
      var value = _this.refs.keybindingToggle.checked;
      if (value) {
        atom.config.removeAtKeyPath('core.packagesWithKeymapsDisabled', _this.namespace);
      } else {
        atom.config.pushAtKeyPath('core.packagesWithKeymapsDisabled', _this.namespace);
      }

      _this.updateKeyBindingView();
    };
    this.refs.keybindingToggle.addEventListener('change', changeHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.keybindingToggle.removeEventListener('change', changeHandler);
    }));

    var copyIconClickHandler = function copyIconClickHandler(event) {
      var target = event.target.closest('.copy-icon');
      if (target) {
        event.preventDefault();
        event.stopPropagation();
        _this.writeKeyBindingToClipboard(target.closest('tr').dataset);
      }
    };
    this.element.addEventListener('click', copyIconClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.element.removeEventListener('click', copyIconClickHandler);
    }));

    this.updateKeyBindingView();

    var hasKeymaps = false;
    for (var _ref3 of atom.packages.getLoadedPackage(this.namespace).keymaps) {
      var _ref2 = _slicedToArray(_ref3, 2);

      var packageKeymapsPath = _ref2[0];
      var map = _ref2[1];

      if (map.length > 0) {
        hasKeymaps = true;
        break;
      }
    }

    if (this.refs.keybindingItems.children.length === 0 && !hasKeymaps) {
      this.element.style.display = 'none';
    }
  }

  _createClass(PackageKeymapView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'section',
        { className: 'section' },
        _etch2['default'].dom(
          'div',
          { className: 'section-heading icon icon-keyboard' },
          'Keybindings'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'checkbox' },
          _etch2['default'].dom(
            'label',
            { 'for': 'toggleKeybindings' },
            _etch2['default'].dom('input', { id: 'toggleKeybindings', className: 'input-checkbox', type: 'checkbox', ref: 'keybindingToggle' }),
            _etch2['default'].dom(
              'div',
              { className: 'setting-title' },
              'Enable'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'setting-description' },
            "Disable this if you want to bind your own keystrokes for this package's commands in your keymap."
          )
        ),
        _etch2['default'].dom(
          'table',
          { className: 'package-keymap-table table native-key-bindings text', tabIndex: '-1' },
          _etch2['default'].dom(
            'thead',
            null,
            _etch2['default'].dom(
              'tr',
              null,
              _etch2['default'].dom(
                'th',
                null,
                'Keystroke'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Command'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Selector'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Source'
              )
            )
          ),
          _etch2['default'].dom('tbody', { ref: 'keybindingItems' })
        )
      );
    }
  }, {
    key: 'updateKeyBindingView',
    value: function updateKeyBindingView() {
      this.refs.keybindingItems.innerHTML = '';

      var packagesWithKeymapsDisabled = atom.config.get('core.packagesWithKeymapsDisabled') || [];
      var keybindingsDisabled = packagesWithKeymapsDisabled.includes(this.namespace);
      if (keybindingsDisabled) {
        this.refs.keybindingItems.classList.add('text-subtle');
      } else {
        this.refs.keybindingItems.classList.remove('text-subtle');
      }

      var keyBindings = [];
      if (atom.keymaps.build) {
        for (var _ref43 of atom.packages.getLoadedPackage(this.namespace).keymaps) {
          var _ref42 = _slicedToArray(_ref43, 2);

          var keymapPath = _ref42[0];
          var keymap = _ref42[1];

          keyBindings.push.apply(keyBindings, _toConsumableArray(atom.keymaps.build(this.namespace, keymap, 0, false)));
        }
      } else {
        // Backwards compatibility for Atom <= 1.19
        for (var keyBinding of atom.keymaps.getKeyBindings()) {
          var command = keyBinding.command;

          if (command && command.indexOf && command.indexOf(this.namespace + ':') === 0) {
            keyBindings.push(keyBinding);
          }
        }
      }

      for (var keyBinding of keyBindings) {
        var command = keyBinding.command;
        var keystrokes = keyBinding.keystrokes;
        var selector = keyBinding.selector;
        var source = keyBinding.source;

        if (!command) {
          continue;
        }

        if (this.otherPlatformPattern.test(selector)) {
          continue;
        }

        var keyBindingRow = document.createElement('tr');
        keyBindingRow.dataset.selector = selector;
        keyBindingRow.dataset.keystrokes = keystrokes;
        keyBindingRow.dataset.command = command;

        var keystrokesTd = document.createElement('td');

        var copyIconSpan = document.createElement('span');
        copyIconSpan.classList.add('icon', 'icon-clippy', 'copy-icon');
        keystrokesTd.appendChild(copyIconSpan);

        var keystrokesSpan = document.createElement('span');
        keystrokesSpan.textContent = keystrokes;
        keystrokesTd.appendChild(keystrokesSpan);

        keyBindingRow.appendChild(keystrokesTd);

        var commandTd = document.createElement('td');
        commandTd.textContent = command;
        keyBindingRow.appendChild(commandTd);

        var selectorTd = document.createElement('td');
        selectorTd.textContent = selector;
        keyBindingRow.appendChild(selectorTd);

        var sourceTd = document.createElement('td');
        sourceTd.textContent = _keybindingsPanel2['default'].determineSource(source);
        keyBindingRow.appendChild(sourceTd);

        this.refs.keybindingItems.appendChild(keyBindingRow);
      }
    }
  }, {
    key: 'writeKeyBindingToClipboard',
    value: function writeKeyBindingToClipboard(_ref5) {
      var selector = _ref5.selector;
      var keystrokes = _ref5.keystrokes;
      var command = _ref5.command;

      var content = undefined;
      var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());
      if (keymapExtension === '.cson') {
        content = '\'' + selector + '\':\n  \'' + keystrokes + '\': \'' + command + '\'';
      } else {
        content = '"' + selector + '": {\n  "' + keystrokes + '": "' + command + '"\n}';
      }

      atom.clipboard.write(content);
    }
  }]);

  return PackageKeymapView;
})();

exports['default'] = PackageKeymapView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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