Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atom = require('atom');

var _settingsPanel = require('./settings-panel');

var _settingsPanel2 = _interopRequireDefault(_settingsPanel);

// View to display the grammars that a package has registered.

var PackageGrammarsView = (function () {
  function PackageGrammarsView(packagePath) {
    var _this = this;

    _classCallCheck(this, PackageGrammarsView);

    this.element = document.createElement('section');
    this.element.classList.add('package-grammars');

    this.grammarSettings = document.createElement('div');
    this.element.appendChild(this.grammarSettings);

    this.disposables = new _atom.CompositeDisposable();
    this.packagePath = _path2['default'].join(packagePath, _path2['default'].sep);
    this.addGrammars();
    this.disposables.add(atom.grammars.onDidAddGrammar(function () {
      return _this.addGrammars();
    }));
    this.disposables.add(atom.grammars.onDidUpdateGrammar(function () {
      return _this.addGrammars();
    }));
  }

  _createClass(PackageGrammarsView, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'getPackageGrammars',
    value: function getPackageGrammars() {
      var packageGrammars = [];
      var grammars = atom.grammars.grammars != null ? atom.grammars.grammars : [];
      for (var grammar of grammars) {
        if (grammar.path) {
          if (grammar.path.indexOf(this.packagePath) === 0) {
            packageGrammars.push(grammar);
          }
        }
      }
      return packageGrammars.sort(function (grammar1, grammar2) {
        var name1 = grammar1.name || grammar1.scopeName || '';
        var name2 = grammar2.name || grammar2.scopeName || '';
        return name1.localeCompare(name2);
      });
    }
  }, {
    key: 'addGrammarHeading',
    value: function addGrammarHeading(grammar, panel) {
      var container = document.createElement('div');
      container.classList.add('native-key-bindings', 'text');
      container.tabIndex = -1;

      var grammarScope = document.createElement('div');
      grammarScope.classList.add('grammar-scope');

      var scopeStrong = document.createElement('strong');
      scopeStrong.textContent = 'Scope: ';
      grammarScope.appendChild(scopeStrong);

      var scopeSpan = document.createElement('span');
      scopeSpan.textContent = grammar.scopeName != null ? grammar.scopeName : '';
      grammarScope.appendChild(scopeSpan);
      container.appendChild(grammarScope);

      var grammarFileTypes = document.createElement('div');
      grammarFileTypes.classList.add('grammar-filetypes');

      var fileTypesStrong = document.createElement('strong');
      fileTypesStrong.textContent = 'File Types: ';
      grammarFileTypes.appendChild(fileTypesStrong);

      var fileTypes = grammar.fileTypes || [];
      var fileTypesSpan = document.createElement('span');
      fileTypesSpan.textContent = fileTypes.join(', ');
      grammarFileTypes.appendChild(fileTypesSpan);
      container.appendChild(grammarFileTypes);

      var sectionBody = panel.element.querySelector('.section-body');
      sectionBody.parentElement.insertBefore(container, sectionBody);
    }
  }, {
    key: 'addGrammars',
    value: function addGrammars() {
      this.grammarSettings.innerHTML = '';
      for (var grammar of this.getPackageGrammars()) {
        var scopeName = grammar.scopeName;
        var _name = grammar.name;

        if (!scopeName || !_name) {
          continue;
        }

        if (!scopeName.startsWith('.')) {
          scopeName = '.' + scopeName;
        }

        var title = _name + ' Grammar';
        var panel = new _settingsPanel2['default']({ title: title, scopeName: scopeName, icon: 'puzzle' });
        this.addGrammarHeading(grammar, panel);
        this.grammarSettings.appendChild(panel.element);
      }
    }
  }]);

  return PackageGrammarsView;
})();

exports['default'] = PackageGrammarsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzQuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9zZXR0aW5ncy12aWV3L2xpYi9wYWNrYWdlLWdyYW1tYXJzLXZpZXcuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7O29CQUVpQixNQUFNOzs7O29CQUNXLE1BQU07OzZCQUNkLGtCQUFrQjs7Ozs7O0lBR3ZCLG1CQUFtQjtBQUMxQixXQURPLG1CQUFtQixDQUN6QixXQUFXLEVBQUU7OzswQkFEUCxtQkFBbUI7O0FBRXBDLFFBQUksQ0FBQyxPQUFPLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsQ0FBQTtBQUNoRCxRQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsa0JBQWtCLENBQUMsQ0FBQTs7QUFFOUMsUUFBSSxDQUFDLGVBQWUsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFBO0FBQ3BELFFBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsQ0FBQTs7QUFFOUMsUUFBSSxDQUFDLFdBQVcsR0FBRywrQkFBeUIsQ0FBQTtBQUM1QyxRQUFJLENBQUMsV0FBVyxHQUFHLGtCQUFLLElBQUksQ0FBQyxXQUFXLEVBQUUsa0JBQUssR0FBRyxDQUFDLENBQUE7QUFDbkQsUUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFBO0FBQ2xCLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsZUFBZSxDQUFDO2FBQU0sTUFBSyxXQUFXLEVBQUU7S0FBQSxDQUFDLENBQUMsQ0FBQTtBQUM3RSxRQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLGtCQUFrQixDQUFDO2FBQU0sTUFBSyxXQUFXLEVBQUU7S0FBQSxDQUFDLENBQUMsQ0FBQTtHQUNqRjs7ZUFia0IsbUJBQW1COztXQWU5QixtQkFBRztBQUNULFVBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxFQUFFLENBQUE7QUFDMUIsVUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUUsQ0FBQTtLQUN0Qjs7O1dBRWtCLDhCQUFHO0FBQ3BCLFVBQU0sZUFBZSxHQUFHLEVBQUUsQ0FBQTtBQUMxQixVQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsSUFBSSxJQUFJLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLEdBQUcsRUFBRSxDQUFBO0FBQzdFLFdBQUssSUFBSSxPQUFPLElBQUksUUFBUSxFQUFFO0FBQzVCLFlBQUksT0FBTyxDQUFDLElBQUksRUFBRTtBQUNoQixjQUFJLE9BQU8sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLEVBQUU7QUFDaEQsMkJBQWUsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUE7V0FDOUI7U0FDRjtPQUNGO0FBQ0QsYUFBTyxlQUFlLENBQUMsSUFBSSxDQUFDLFVBQVUsUUFBUSxFQUFFLFFBQVEsRUFBRTtBQUN4RCxZQUFNLEtBQUssR0FBRyxRQUFRLENBQUMsSUFBSSxJQUFJLFFBQVEsQ0FBQyxTQUFTLElBQUksRUFBRSxDQUFBO0FBQ3ZELFlBQU0sS0FBSyxHQUFHLFFBQVEsQ0FBQyxJQUFJLElBQUksUUFBUSxDQUFDLFNBQVMsSUFBSSxFQUFFLENBQUE7QUFDdkQsZUFBTyxLQUFLLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFBO09BQ2xDLENBQUMsQ0FBQTtLQUNIOzs7V0FFaUIsMkJBQUMsT0FBTyxFQUFFLEtBQUssRUFBRTtBQUNqQyxVQUFNLFNBQVMsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFBO0FBQy9DLGVBQVMsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLHFCQUFxQixFQUFFLE1BQU0sQ0FBQyxDQUFBO0FBQ3RELGVBQVMsQ0FBQyxRQUFRLEdBQUcsQ0FBQyxDQUFDLENBQUE7O0FBRXZCLFVBQU0sWUFBWSxHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUE7QUFDbEQsa0JBQVksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFBOztBQUUzQyxVQUFNLFdBQVcsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFBO0FBQ3BELGlCQUFXLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQTtBQUNuQyxrQkFBWSxDQUFDLFdBQVcsQ0FBQyxXQUFXLENBQUMsQ0FBQTs7QUFFckMsVUFBTSxTQUFTLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsQ0FBQTtBQUNoRCxlQUFTLENBQUMsV0FBVyxHQUFHLE9BQU8sQ0FBQyxTQUFTLElBQUksSUFBSSxHQUFHLE9BQU8sQ0FBQyxTQUFTLEdBQUcsRUFBRSxDQUFBO0FBQzFFLGtCQUFZLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxDQUFBO0FBQ25DLGVBQVMsQ0FBQyxXQUFXLENBQUMsWUFBWSxDQUFDLENBQUE7O0FBRW5DLFVBQU0sZ0JBQWdCLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQTtBQUN0RCxzQkFBZ0IsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLG1CQUFtQixDQUFDLENBQUE7O0FBRW5ELFVBQU0sZUFBZSxHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUMsUUFBUSxDQUFDLENBQUE7QUFDeEQscUJBQWUsQ0FBQyxXQUFXLEdBQUcsY0FBYyxDQUFBO0FBQzVDLHNCQUFnQixDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsQ0FBQTs7QUFFN0MsVUFBTSxTQUFTLEdBQUcsT0FBTyxDQUFDLFNBQVMsSUFBSSxFQUFFLENBQUE7QUFDekMsVUFBTSxhQUFhLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsQ0FBQTtBQUNwRCxtQkFBYSxDQUFDLFdBQVcsR0FBRyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFBO0FBQ2hELHNCQUFnQixDQUFDLFdBQVcsQ0FBQyxhQUFhLENBQUMsQ0FBQTtBQUMzQyxlQUFTLENBQUMsV0FBVyxDQUFDLGdCQUFnQixDQUFDLENBQUE7O0FBRXZDLFVBQU0sV0FBVyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLGVBQWUsQ0FBQyxDQUFBO0FBQ2hFLGlCQUFXLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FBQyxTQUFTLEVBQUUsV0FBVyxDQUFDLENBQUE7S0FDL0Q7OztXQUVXLHVCQUFHO0FBQ2IsVUFBSSxDQUFDLGVBQWUsQ0FBQyxTQUFTLEdBQUcsRUFBRSxDQUFBO0FBQ25DLFdBQUssSUFBSSxPQUFPLElBQUksSUFBSSxDQUFDLGtCQUFrQixFQUFFLEVBQUU7WUFDeEMsU0FBUyxHQUFVLE9BQU8sQ0FBMUIsU0FBUztZQUFFLEtBQUksR0FBSSxPQUFPLENBQWYsSUFBSTs7QUFDcEIsWUFBSSxDQUFDLFNBQVMsSUFBSSxDQUFDLEtBQUksRUFBRTtBQUN2QixtQkFBUTtTQUNUOztBQUVELFlBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxFQUFFO0FBQzlCLG1CQUFTLFNBQU8sU0FBUyxBQUFFLENBQUE7U0FDNUI7O0FBRUQsWUFBTSxLQUFLLEdBQU0sS0FBSSxhQUFVLENBQUE7QUFDL0IsWUFBTSxLQUFLLEdBQUcsK0JBQWtCLEVBQUMsS0FBSyxFQUFMLEtBQUssRUFBRSxTQUFTLEVBQVQsU0FBUyxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUMsQ0FBQyxDQUFBO0FBQ25FLFlBQUksQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLENBQUE7QUFDdEMsWUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFBO09BQ2hEO0tBQ0Y7OztTQXhGa0IsbUJBQW1COzs7cUJBQW5CLG1CQUFtQiIsImZpbGUiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM0LjAvb3V0L2FwcC9ub2RlX21vZHVsZXMvc2V0dGluZ3Mtdmlldy9saWIvcGFja2FnZS1ncmFtbWFycy12aWV3LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBiYWJlbCAqL1xuXG5pbXBvcnQgcGF0aCBmcm9tICdwYXRoJ1xuaW1wb3J0IHtDb21wb3NpdGVEaXNwb3NhYmxlfSBmcm9tICdhdG9tJ1xuaW1wb3J0IFNldHRpbmdzUGFuZWwgZnJvbSAnLi9zZXR0aW5ncy1wYW5lbCdcblxuLy8gVmlldyB0byBkaXNwbGF5IHRoZSBncmFtbWFycyB0aGF0IGEgcGFja2FnZSBoYXMgcmVnaXN0ZXJlZC5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFBhY2thZ2VHcmFtbWFyc1ZpZXcge1xuICBjb25zdHJ1Y3RvciAocGFja2FnZVBhdGgpIHtcbiAgICB0aGlzLmVsZW1lbnQgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdzZWN0aW9uJylcbiAgICB0aGlzLmVsZW1lbnQuY2xhc3NMaXN0LmFkZCgncGFja2FnZS1ncmFtbWFycycpXG5cbiAgICB0aGlzLmdyYW1tYXJTZXR0aW5ncyA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2RpdicpXG4gICAgdGhpcy5lbGVtZW50LmFwcGVuZENoaWxkKHRoaXMuZ3JhbW1hclNldHRpbmdzKVxuXG4gICAgdGhpcy5kaXNwb3NhYmxlcyA9IG5ldyBDb21wb3NpdGVEaXNwb3NhYmxlKClcbiAgICB0aGlzLnBhY2thZ2VQYXRoID0gcGF0aC5qb2luKHBhY2thZ2VQYXRoLCBwYXRoLnNlcClcbiAgICB0aGlzLmFkZEdyYW1tYXJzKClcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChhdG9tLmdyYW1tYXJzLm9uRGlkQWRkR3JhbW1hcigoKSA9PiB0aGlzLmFkZEdyYW1tYXJzKCkpKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKGF0b20uZ3JhbW1hcnMub25EaWRVcGRhdGVHcmFtbWFyKCgpID0+IHRoaXMuYWRkR3JhbW1hcnMoKSkpXG4gIH1cblxuICBkZXN0cm95ICgpIHtcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmRpc3Bvc2UoKVxuICAgIHRoaXMuZWxlbWVudC5yZW1vdmUoKVxuICB9XG5cbiAgZ2V0UGFja2FnZUdyYW1tYXJzICgpIHtcbiAgICBjb25zdCBwYWNrYWdlR3JhbW1hcnMgPSBbXVxuICAgIGNvbnN0IGdyYW1tYXJzID0gYXRvbS5ncmFtbWFycy5ncmFtbWFycyAhPSBudWxsID8gYXRvbS5ncmFtbWFycy5ncmFtbWFycyA6IFtdXG4gICAgZm9yIChsZXQgZ3JhbW1hciBvZiBncmFtbWFycykge1xuICAgICAgaWYgKGdyYW1tYXIucGF0aCkge1xuICAgICAgICBpZiAoZ3JhbW1hci5wYXRoLmluZGV4T2YodGhpcy5wYWNrYWdlUGF0aCkgPT09IDApIHtcbiAgICAgICAgICBwYWNrYWdlR3JhbW1hcnMucHVzaChncmFtbWFyKVxuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICAgIHJldHVybiBwYWNrYWdlR3JhbW1hcnMuc29ydChmdW5jdGlvbiAoZ3JhbW1hcjEsIGdyYW1tYXIyKSB7XG4gICAgICBjb25zdCBuYW1lMSA9IGdyYW1tYXIxLm5hbWUgfHwgZ3JhbW1hcjEuc2NvcGVOYW1lIHx8ICcnXG4gICAgICBjb25zdCBuYW1lMiA9IGdyYW1tYXIyLm5hbWUgfHwgZ3JhbW1hcjIuc2NvcGVOYW1lIHx8ICcnXG4gICAgICByZXR1cm4gbmFtZTEubG9jYWxlQ29tcGFyZShuYW1lMilcbiAgICB9KVxuICB9XG5cbiAgYWRkR3JhbW1hckhlYWRpbmcgKGdyYW1tYXIsIHBhbmVsKSB7XG4gICAgY29uc3QgY29udGFpbmVyID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2JylcbiAgICBjb250YWluZXIuY2xhc3NMaXN0LmFkZCgnbmF0aXZlLWtleS1iaW5kaW5ncycsICd0ZXh0JylcbiAgICBjb250YWluZXIudGFiSW5kZXggPSAtMVxuXG4gICAgY29uc3QgZ3JhbW1hclNjb3BlID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2JylcbiAgICBncmFtbWFyU2NvcGUuY2xhc3NMaXN0LmFkZCgnZ3JhbW1hci1zY29wZScpXG5cbiAgICBjb25zdCBzY29wZVN0cm9uZyA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ3N0cm9uZycpXG4gICAgc2NvcGVTdHJvbmcudGV4dENvbnRlbnQgPSAnU2NvcGU6ICdcbiAgICBncmFtbWFyU2NvcGUuYXBwZW5kQ2hpbGQoc2NvcGVTdHJvbmcpXG5cbiAgICBjb25zdCBzY29wZVNwYW4gPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdzcGFuJylcbiAgICBzY29wZVNwYW4udGV4dENvbnRlbnQgPSBncmFtbWFyLnNjb3BlTmFtZSAhPSBudWxsID8gZ3JhbW1hci5zY29wZU5hbWUgOiAnJ1xuICAgIGdyYW1tYXJTY29wZS5hcHBlbmRDaGlsZChzY29wZVNwYW4pXG4gICAgY29udGFpbmVyLmFwcGVuZENoaWxkKGdyYW1tYXJTY29wZSlcblxuICAgIGNvbnN0IGdyYW1tYXJGaWxlVHlwZXMgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKVxuICAgIGdyYW1tYXJGaWxlVHlwZXMuY2xhc3NMaXN0LmFkZCgnZ3JhbW1hci1maWxldHlwZXMnKVxuXG4gICAgY29uc3QgZmlsZVR5cGVzU3Ryb25nID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnc3Ryb25nJylcbiAgICBmaWxlVHlwZXNTdHJvbmcudGV4dENvbnRlbnQgPSAnRmlsZSBUeXBlczogJ1xuICAgIGdyYW1tYXJGaWxlVHlwZXMuYXBwZW5kQ2hpbGQoZmlsZVR5cGVzU3Ryb25nKVxuXG4gICAgY29uc3QgZmlsZVR5cGVzID0gZ3JhbW1hci5maWxlVHlwZXMgfHwgW11cbiAgICBjb25zdCBmaWxlVHlwZXNTcGFuID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnc3BhbicpXG4gICAgZmlsZVR5cGVzU3Bhbi50ZXh0Q29udGVudCA9IGZpbGVUeXBlcy5qb2luKCcsICcpXG4gICAgZ3JhbW1hckZpbGVUeXBlcy5hcHBlbmRDaGlsZChmaWxlVHlwZXNTcGFuKVxuICAgIGNvbnRhaW5lci5hcHBlbmRDaGlsZChncmFtbWFyRmlsZVR5cGVzKVxuXG4gICAgY29uc3Qgc2VjdGlvbkJvZHkgPSBwYW5lbC5lbGVtZW50LnF1ZXJ5U2VsZWN0b3IoJy5zZWN0aW9uLWJvZHknKVxuICAgIHNlY3Rpb25Cb2R5LnBhcmVudEVsZW1lbnQuaW5zZXJ0QmVmb3JlKGNvbnRhaW5lciwgc2VjdGlvbkJvZHkpXG4gIH1cblxuICBhZGRHcmFtbWFycyAoKSB7XG4gICAgdGhpcy5ncmFtbWFyU2V0dGluZ3MuaW5uZXJIVE1MID0gJydcbiAgICBmb3IgKGxldCBncmFtbWFyIG9mIHRoaXMuZ2V0UGFja2FnZUdyYW1tYXJzKCkpIHtcbiAgICAgIGxldCB7c2NvcGVOYW1lLCBuYW1lfSA9IGdyYW1tYXJcbiAgICAgIGlmICghc2NvcGVOYW1lIHx8ICFuYW1lKSB7XG4gICAgICAgIGNvbnRpbnVlXG4gICAgICB9XG5cbiAgICAgIGlmICghc2NvcGVOYW1lLnN0YXJ0c1dpdGgoJy4nKSkge1xuICAgICAgICBzY29wZU5hbWUgPSBgLiR7c2NvcGVOYW1lfWBcbiAgICAgIH1cblxuICAgICAgY29uc3QgdGl0bGUgPSBgJHtuYW1lfSBHcmFtbWFyYFxuICAgICAgY29uc3QgcGFuZWwgPSBuZXcgU2V0dGluZ3NQYW5lbCh7dGl0bGUsIHNjb3BlTmFtZSwgaWNvbjogJ3B1enpsZSd9KVxuICAgICAgdGhpcy5hZGRHcmFtbWFySGVhZGluZyhncmFtbWFyLCBwYW5lbClcbiAgICAgIHRoaXMuZ3JhbW1hclNldHRpbmdzLmFwcGVuZENoaWxkKHBhbmVsLmVsZW1lbnQpXG4gICAgfVxuICB9XG59XG4iXX0=