Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _electron = require('electron');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _utils = require('./utils');

var marked = null;

var PackageCard = (function () {
  function PackageCard(pack, settingsView, packageManager) {
    var options = arguments.length <= 3 || arguments[3] === undefined ? {} : arguments[3];

    _classCallCheck(this, PackageCard);

    this.pack = pack;
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();

    // It might be useful to either wrap this.pack in a class that has a
    // ::validate method, or add a method here. At the moment I think all cases
    // of malformed package metadata are handled here and in ::content but belt
    // and suspenders, you know
    this.client = this.packageManager.getClient();
    this.type = this.pack.theme ? 'theme' : 'package';
    this.name = this.pack.name;
    this.onSettingsView = options.onSettingsView;

    if (this.pack.latestVersion !== this.pack.version) {
      this.newVersion = this.pack.latestVersion;
    }

    if (this.pack.apmInstallSource && this.pack.apmInstallSource.type === 'git') {
      if (this.pack.apmInstallSource.sha !== this.pack.latestSha) {
        this.newSha = this.pack.latestSha;
      }
    }

    // Default to displaying the download count
    if (!options.stats) {
      options.stats = { downloads: true };
    }

    _etch2['default'].initialize(this);

    this.displayStats(options);
    this.handlePackageEvents();
    this.handleButtonEvents(options);
    this.loadCachedMetadata();

    // themes have no status and cannot be dis/enabled
    if (this.type === 'theme') {
      this.refs.statusIndicator.remove();
      this.refs.enablementButton.remove();
    }

    if (atom.packages.isBundledPackage(this.pack.name)) {
      this.refs.installButtonGroup.remove();
      this.refs.uninstallButton.remove();
    }

    if (!this.newVersion && !this.newSha) {
      this.refs.updateButtonGroup.style.display = 'none';
    }

    this.hasCompatibleVersion = true;
    this.updateInterfaceState();
  }

  _createClass(PackageCard, [{
    key: 'render',
    value: function render() {
      var displayName = (this.pack.gitUrlInfo ? this.pack.gitUrlInfo.project : this.pack.name) || '';
      var owner = (0, _utils.ownerFromRepository)(this.pack.repository);
      var description = this.pack.description || '';

      return _etch2['default'].dom(
        'div',
        { className: 'package-card col-lg-8' },
        _etch2['default'].dom(
          'div',
          { ref: 'statsContainer', className: 'stats pull-right' },
          _etch2['default'].dom(
            'span',
            { ref: 'packageStars', className: 'stats-item' },
            _etch2['default'].dom('span', { ref: 'stargazerIcon', className: 'icon icon-star' }),
            _etch2['default'].dom('span', { ref: 'stargazerCount', className: 'value' })
          ),
          _etch2['default'].dom(
            'span',
            { ref: 'packageDownloads', className: 'stats-item' },
            _etch2['default'].dom('span', { ref: 'downloadIcon', className: 'icon icon-cloud-download' }),
            _etch2['default'].dom('span', { ref: 'downloadCount', className: 'value' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'body' },
          _etch2['default'].dom(
            'h4',
            { className: 'card-name' },
            _etch2['default'].dom(
              'a',
              { className: 'package-name', ref: 'packageName' },
              displayName
            ),
            _etch2['default'].dom(
              'span',
              null,
              ' '
            ),
            _etch2['default'].dom(
              'span',
              { className: 'package-version' },
              _etch2['default'].dom(
                'span',
                { ref: 'versionValue', className: 'value' },
                String(this.pack.version)
              )
            ),
            _etch2['default'].dom(
              'span',
              { className: 'deprecation-badge highlight-warning inline-block' },
              'Deprecated'
            )
          ),
          _etch2['default'].dom(
            'span',
            { ref: 'packageDescription', className: 'package-description' },
            description
          ),
          _etch2['default'].dom('div', { ref: 'packageMessage', className: 'package-message' })
        ),
        _etch2['default'].dom(
          'div',
          { className: 'meta' },
          _etch2['default'].dom(
            'div',
            { ref: 'metaUserContainer', className: 'meta-user' },
            _etch2['default'].dom(
              'a',
              { ref: 'avatarLink', href: 'https://atom.io/users/' + owner },
              _etch2['default'].dom('img', { ref: 'avatar', className: 'avatar', src: 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7' })
            ),
            _etch2['default'].dom(
              'a',
              { ref: 'loginLink', className: 'author', href: 'https://atom.io/users/' + owner },
              owner
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'meta-controls' },
            _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'div',
                { ref: 'updateButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'updateButton' },
                  'Update'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'installAlternativeButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'installAlternativeButton' },
                  'Install Alternative'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'installButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'installButton' },
                  'Install'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'packageActionButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-gear settings', ref: 'settingsButton' },
                  'Settings'
                ),
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-trashcan uninstall-button', ref: 'uninstallButton' },
                  'Uninstall'
                ),
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-playback-pause enablement', ref: 'enablementButton' },
                  _etch2['default'].dom(
                    'span',
                    { className: 'disable-text' },
                    'Disable'
                  )
                ),
                _etch2['default'].dom('button', { type: 'button', className: 'btn status-indicator', tabIndex: '-1', ref: 'statusIndicator' })
              )
            )
          )
        )
      );
    }
  }, {
    key: 'locateCompatiblePackageVersion',
    value: function locateCompatiblePackageVersion(callback) {
      var _this = this;

      this.packageManager.loadCompatiblePackageVersion(this.pack.name, function (err, pack) {
        if (err != null) {
          console.error(err);
        }

        var packageVersion = pack.version;

        // A compatible version exist, we activate the install button and
        // set this.installablePack so that the install action installs the
        // compatible version of the package.
        if (packageVersion) {
          _this.refs.versionValue.textContent = packageVersion;
          if (packageVersion !== _this.pack.version) {
            _this.refs.versionValue.classList.add('text-warning');
            _this.refs.packageMessage.classList.add('text-warning');
            _this.refs.packageMessage.textContent = 'Version ' + packageVersion + ' is not the latest version available for this package, but it\'s the latest that is compatible with your version of Atom.';
          }

          _this.installablePack = pack;
          _this.hasCompatibleVersion = true;
        } else {
          _this.hasCompatibleVersion = false;
          _this.refs.versionValue.classList.add('text-error');
          _this.refs.packageMessage.classList.add('text-error');
          _this.refs.packageMessage.insertAdjacentText('beforeend', 'There\'s no version of this package that is compatible with your Atom version. The version must satisfy ' + _this.pack.engines.atom + '.');
          console.error('No available version compatible with the installed Atom version: ' + atom.getVersion());
        }

        callback();
      });
    }
  }, {
    key: 'handleButtonEvents',
    value: function handleButtonEvents(options) {
      var _this2 = this;

      if (options && options.onSettingsView) {
        this.refs.settingsButton.style.display = 'none';
      } else {
        (function () {
          var clickHandler = function clickHandler(event) {
            event.stopPropagation();
            _this2.settingsView.showPanel(_this2.pack.name, { back: options ? options.back : null, pack: _this2.pack });
          };

          _this2.element.addEventListener('click', clickHandler);
          _this2.disposables.add(new _atom.Disposable(function () {
            _this2.element.removeEventListener('click', clickHandler);
          }));

          _this2.refs.settingsButton.addEventListener('click', clickHandler);
          _this2.disposables.add(new _atom.Disposable(function () {
            _this2.refs.settingsButton.removeEventListener('click', clickHandler);
          }));
        })();
      }

      var installButtonClickHandler = function installButtonClickHandler(event) {
        event.stopPropagation();
        _this2.install();
      };
      this.refs.installButton.addEventListener('click', installButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.installButton.removeEventListener('click', installButtonClickHandler);
      }));

      var uninstallButtonClickHandler = function uninstallButtonClickHandler(event) {
        event.stopPropagation();
        _this2.uninstall();
      };
      this.refs.uninstallButton.addEventListener('click', uninstallButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.uninstallButton.removeEventListener('click', uninstallButtonClickHandler);
      }));

      var installAlternativeButtonClickHandler = function installAlternativeButtonClickHandler(event) {
        event.stopPropagation();
        _this2.installAlternative();
      };
      this.refs.installAlternativeButton.addEventListener('click', installAlternativeButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.installAlternativeButton.removeEventListener('click', installAlternativeButtonClickHandler);
      }));

      var updateButtonClickHandler = function updateButtonClickHandler(event) {
        event.stopPropagation();
        _this2.update().then(function () {
          var buttons = [{
            text: 'Restart',
            onDidClick: function onDidClick() {
              return atom.restartApplication();
            }
          }];
          var detail = _this2.pack.version + ' -> ' + _this2.pack.latestVersion;

          atom.notifications.addSuccess('Restart Atom to complete the update of `' + _this2.pack.name + '`.', {
            dismissable: true, buttons: buttons, detail: detail
          });
        });
      };
      this.refs.updateButton.addEventListener('click', updateButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.updateButton.removeEventListener('click', updateButtonClickHandler);
      }));

      var packageNameClickHandler = function packageNameClickHandler(event) {
        event.stopPropagation();
        var packageType = _this2.pack.theme ? 'themes' : 'packages';
        _electron.shell.openExternal('https://atom.io/' + packageType + '/' + _this2.pack.name);
      };
      this.refs.packageName.addEventListener('click', packageNameClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.packageName.removeEventListener('click', packageNameClickHandler);
      }));

      var enablementButtonClickHandler = function enablementButtonClickHandler(event) {
        event.stopPropagation();
        event.preventDefault();
        if (_this2.isDisabled()) {
          atom.packages.enablePackage(_this2.pack.name);
        } else {
          atom.packages.disablePackage(_this2.pack.name);
        }
      };
      this.refs.enablementButton.addEventListener('click', enablementButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.enablementButton.removeEventListener('click', enablementButtonClickHandler);
      }));

      var packageMessageClickHandler = function packageMessageClickHandler(event) {
        var target = event.target.closest('a');
        if (target) {
          event.stopPropagation();
          event.preventDefault();
          if (target.href && target.href.startsWith('atom:')) {
            atom.workspace.open(target.href);
          }
        }
      };
      this.refs.packageMessage.addEventListener('click', packageMessageClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.packageMessage.removeEventListener('click', packageMessageClickHandler);
      }));
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'loadCachedMetadata',
    value: function loadCachedMetadata() {
      var _this3 = this;

      this.client.avatar((0, _utils.ownerFromRepository)(this.pack.repository), function (err, avatarPath) {
        if (avatarPath) {
          _this3.refs.avatar.src = 'file://' + avatarPath;
        }
      });

      this.client['package'](this.pack.name, function (err, data) {
        // We don't need to actually handle the error here, we can just skip
        // showing the download count if there's a problem.
        if (!err) {
          if (data == null) {
            data = {};
          }

          if (_this3.pack.apmInstallSource && _this3.pack.apmInstallSource.type === 'git') {
            _this3.refs.downloadIcon.classList.remove('icon-cloud-download');
            _this3.refs.downloadIcon.classList.add('icon-git-branch');
            _this3.refs.downloadCount.textContent = _this3.pack.apmInstallSource.sha.substr(0, 8);
          } else {
            _this3.refs.stargazerCount.textContent = data.stargazers_count ? data.stargazers_count.toLocaleString() : '';
            _this3.refs.downloadCount.textContent = data.downloads ? data.downloads.toLocaleString() : '';
          }
        }
      });
    }
  }, {
    key: 'updateInterfaceState',
    value: function updateInterfaceState() {
      this.refs.versionValue.textContent = (this.installablePack ? this.installablePack.version : null) || this.pack.version;
      if (this.pack.apmInstallSource && this.pack.apmInstallSource.type === 'git') {
        this.refs.downloadCount.textContent = this.pack.apmInstallSource.sha.substr(0, 8);
      }

      this.updateSettingsState();
      this.updateInstalledState();
      this.updateDisabledState();
      this.updateDeprecatedState();
    }
  }, {
    key: 'updateSettingsState',
    value: function updateSettingsState() {
      if (this.hasSettings() && !this.onSettingsView) {
        this.refs.settingsButton.style.display = '';
      } else {
        this.refs.settingsButton.style.display = 'none';
      }
    }

    // Section: disabled state updates

  }, {
    key: 'updateDisabledState',
    value: function updateDisabledState() {
      if (this.isDisabled()) {
        this.displayDisabledState();
      } else if (this.element.classList.contains('disabled')) {
        this.displayEnabledState();
      }
    }
  }, {
    key: 'displayEnabledState',
    value: function displayEnabledState() {
      this.element.classList.remove('disabled');
      if (this.type === 'theme') {
        this.refs.enablementButton.style.display = 'none';
      }
      this.refs.enablementButton.querySelector('.disable-text').textContent = 'Disable';
      this.refs.enablementButton.classList.add('icon-playback-pause');
      this.refs.enablementButton.classList.remove('icon-playback-play');
      this.refs.statusIndicator.classList.remove('is-disabled');
    }
  }, {
    key: 'displayDisabledState',
    value: function displayDisabledState() {
      this.element.classList.add('disabled');
      this.refs.enablementButton.querySelector('.disable-text').textContent = 'Enable';
      this.refs.enablementButton.classList.add('icon-playback-play');
      this.refs.enablementButton.classList.remove('icon-playback-pause');
      this.refs.statusIndicator.classList.add('is-disabled');
      if (this.isDeprecated()) {
        this.refs.enablementButton.disabled = true;
      } else {
        this.refs.enablementButton.disabled = false;
      }
    }

    // Section: installed state updates

  }, {
    key: 'updateInstalledState',
    value: function updateInstalledState() {
      if (this.isInstalled()) {
        this.displayInstalledState();
      } else {
        this.displayNotInstalledState();
      }
    }
  }, {
    key: 'displayInstalledState',
    value: function displayInstalledState() {
      if (this.newVersion || this.newSha) {
        this.refs.updateButtonGroup.style.display = '';
        if (this.newVersion) {
          this.refs.updateButton.textContent = 'Update to ' + this.newVersion;
        } else if (this.newSha) {
          this.refs.updateButton.textContent = 'Update to ' + this.newSha.substr(0, 8);
        }
      } else {
        this.refs.updateButtonGroup.style.display = 'none';
      }

      this.refs.installButtonGroup.style.display = 'none';
      this.refs.installAlternativeButtonGroup.style.display = 'none';
      this.refs.packageActionButtonGroup.style.display = '';
      this.refs.uninstallButton.style.display = '';
    }
  }, {
    key: 'displayNotInstalledState',
    value: function displayNotInstalledState() {
      var _this4 = this;

      this.refs.uninstallButton.style.display = 'none';
      var atomVersion = this.packageManager.normalizeVersion(atom.getVersion());
      if (!this.packageManager.satisfiesVersion(atomVersion, this.pack)) {
        this.hasCompatibleVersion = false;
        this.setNotInstalledStateButtons();
        this.locateCompatiblePackageVersion(function () {
          _this4.setNotInstalledStateButtons();
        });
      } else {
        this.setNotInstalledStateButtons();
      }
    }
  }, {
    key: 'setNotInstalledStateButtons',
    value: function setNotInstalledStateButtons() {
      if (!this.hasCompatibleVersion) {
        this.refs.installButtonGroup.style.display = 'none';
        this.refs.updateButtonGroup.style.display = 'none';
      } else if (this.newVersion || this.newSha) {
        this.refs.updateButtonGroup.style.display = '';
        this.refs.installButtonGroup.style.display = 'none';
      } else {
        this.refs.updateButtonGroup.style.display = 'none';
        this.refs.installButtonGroup.style.display = '';
      }
      this.refs.installAlternativeButtonGroup.style.display = 'none';
      this.refs.packageActionButtonGroup.style.display = 'none';
    }

    // Section: deprecated state updates

  }, {
    key: 'updateDeprecatedState',
    value: function updateDeprecatedState() {
      if (this.isDeprecated()) {
        this.displayDeprecatedState();
      } else if (this.element.classList.contains('deprecated')) {
        this.displayUndeprecatedState();
      }
    }
  }, {
    key: 'displayStats',
    value: function displayStats(options) {
      if (options && options.stats && options.stats.downloads) {
        this.refs.packageDownloads.style.display = '';
      } else {
        this.refs.packageDownloads.style.display = 'none';
      }

      if (options && options.stats && options.stats.stars) {
        this.refs.packageStars.style.display = '';
      } else {
        this.refs.packageStars.style.display = 'none';
      }
    }
  }, {
    key: 'displayUndeprecatedState',
    value: function displayUndeprecatedState() {
      this.element.classList.remove('deprecated');
      this.refs.packageMessage.classList.remove('text-warning');
      this.refs.packageMessage.textContent = '';
    }
  }, {
    key: 'displayDeprecatedState',
    value: function displayDeprecatedState() {
      this.element.classList.add('deprecated');
      this.refs.settingsButton.disabled = true;

      var info = this.getDeprecatedPackageMetadata();
      this.refs.packageMessage.classList.add('text-warning');

      var message = null;
      if (info && info.hasDeprecations) {
        message = this.getDeprecationMessage(this.newVersion);
      } else if (info && info.hasAlternative && info.alternative === 'core') {
        message = info.message != null ? info.message : 'The features in `' + this.pack.name + '` have been added to core.';
        message += ' Please uninstall this package.';
        this.refs.settingsButton.remove();
        this.refs.enablementButton.remove();
      } else if (info && info.hasAlternative && info.alternative) {
        var alt = info.alternative;
        var isInstalled = this.isInstalled();
        if (isInstalled && this.packageManager.isPackageInstalled(alt)) {
          message = '`' + this.pack.name + '` has been replaced by `' + alt + '` which is already installed. Please uninstall this package.';
          this.refs.settingsButton.remove();
          this.refs.enablementButton.remove();
        } else if (isInstalled) {
          message = '`' + this.pack.name + '` has been replaced by [`' + alt + '`](atom://config/install/package:' + alt + ').';
          this.refs.installAlternativeButton.textContent = 'Install ' + alt;
          this.refs.installAlternativeButtonGroup.style.display = '';
          this.refs.packageActionButtonGroup.style.display = '';
          this.refs.settingsButton.remove();
          this.refs.enablementButton.remove();
        } else {
          message = '`' + this.pack.name + '` has been replaced by [`' + alt + '`](atom://config/install/package:' + alt + ').';
          this.refs.installButtonGroup.style.display = 'none';
          this.refs.installAlternativeButtonGroup.style.display = 'none';
          this.refs.packageActionButtonGroup.style.display = 'none';
        }
      }

      if (message != null) {
        if (marked == null) {
          marked = require('marked');
        }

        this.refs.packageMessage.innerHTML = marked(message);
      }
    }
  }, {
    key: 'displayGitPackageInstallInformation',
    value: function displayGitPackageInstallInformation() {
      this.refs.metaUserContainer.remove();
      this.refs.statsContainer.remove();
      var gitUrlInfo = this.pack.gitUrlInfo;

      if (gitUrlInfo['default'] === 'shortcut') {
        this.refs.packageDescription.textContent = gitUrlInfo.https();
      } else {
        this.refs.packageDescription.textContent = gitUrlInfo.toString();
      }
      this.refs.installButton.classList.remove('icon-cloud-download');
      this.refs.installButton.classList.add('icon-git-commit');
      this.refs.updateButton.classList.remove('icon-cloud-download');
      this.refs.updateButton.classList.add('icon-git-commit');
    }
  }, {
    key: 'displayAvailableUpdate',
    value: function displayAvailableUpdate(newVersion) {
      this.newVersion = newVersion;
      this.updateInterfaceState();
    }
  }, {
    key: 'getDeprecationMessage',
    value: function getDeprecationMessage(newVersion) {
      var info = this.getDeprecatedPackageMetadata();
      if (!info || !info.hasDeprecations) {
        return;
      }

      if (newVersion) {
        if (this.isDeprecated(newVersion)) {
          return 'An update to `v' + newVersion + '` is available but still contains deprecations.';
        } else {
          return 'An update to `v' + newVersion + '` is available without deprecations.';
        }
      } else {
        if (this.isInstalled()) {
          return info.message != null ? info.message : 'This package has not been loaded due to using deprecated APIs. There is no update available.';
        } else {
          return 'This package has deprecations and is not installable.';
        }
      }
    }
  }, {
    key: 'handlePackageEvents',
    value: function handlePackageEvents() {
      var _this5 = this;

      var version = undefined;
      this.disposables.add(atom.packages.onDidDeactivatePackage(function (pack) {
        if (pack.name === _this5.pack.name) {
          _this5.updateDisabledState();
        }
      }));

      this.disposables.add(atom.packages.onDidActivatePackage(function (pack) {
        if (pack.name === _this5.pack.name) {
          _this5.updateDisabledState();
        }
      }));

      this.disposables.add(atom.config.onDidChange('core.disabledPackages', function () {
        _this5.updateDisabledState();
      }));

      this.subscribeToPackageEvent('package-installing theme-installing', function () {
        _this5.updateInterfaceState();
        _this5.refs.installButton.disabled = true;
        _this5.refs.installButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-updating theme-updating', function () {
        _this5.updateInterfaceState();
        _this5.refs.updateButton.disabled = true;
        _this5.refs.updateButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-installing-alternative', function () {
        _this5.updateInterfaceState();
        _this5.refs.installAlternativeButton.disabled = true;
        _this5.refs.installAlternativeButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-uninstalling theme-uninstalling', function () {
        _this5.updateInterfaceState();
        _this5.refs.enablementButton.disabled = true;
        _this5.refs.uninstallButton.disabled = true;
        _this5.refs.uninstallButton.classList.add('is-uninstalling');
      });

      this.subscribeToPackageEvent('package-installed package-install-failed theme-installed theme-install-failed', function () {
        var loadedPack = atom.packages.getLoadedPackage(_this5.pack.name);
        var version = loadedPack && loadedPack.metadata ? loadedPack.metadata.version : null;
        if (version) {
          _this5.pack.version = version;
        }
        _this5.refs.installButton.disabled = false;
        _this5.refs.installButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-updated theme-updated', function () {
        var loadedPack = atom.packages.getLoadedPackage(_this5.pack.name);
        var metadata = loadedPack ? loadedPack.metadata : null;
        if (metadata && metadata.version) {
          _this5.pack.version = metadata.version;
        }

        if (metadata && metadata.apmInstallSource) {
          _this5.pack.apmInstallSource = metadata.apmInstallSource;
        }

        _this5.newVersion = null;
        _this5.newSha = null;
        _this5.refs.updateButton.disabled = false;
        _this5.refs.updateButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-update-failed theme-update-failed', function () {
        _this5.refs.updateButton.disabled = false;
        _this5.refs.updateButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-uninstalled package-uninstall-failed theme-uninstalled theme-uninstall-failed', function () {
        _this5.newVersion = null;
        _this5.newSha = null;
        _this5.refs.enablementButton.disabled = false;
        _this5.refs.uninstallButton.disabled = false;
        _this5.refs.uninstallButton.classList.remove('is-uninstalling');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-installed-alternative package-install-alternative-failed', function () {
        _this5.refs.installAlternativeButton.disabled = false;
        _this5.refs.installAlternativeButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });
    }
  }, {
    key: 'isInstalled',
    value: function isInstalled() {
      return this.packageManager.isPackageInstalled(this.pack.name);
    }
  }, {
    key: 'isDisabled',
    value: function isDisabled() {
      return atom.packages.isPackageDisabled(this.pack.name);
    }
  }, {
    key: 'isDeprecated',
    value: function isDeprecated(version) {
      var packVersion = version != null ? version : this.pack.version;
      return atom.packages.isDeprecatedPackage(this.pack.name, packVersion);
    }
  }, {
    key: 'getDeprecatedPackageMetadata',
    value: function getDeprecatedPackageMetadata() {
      return atom.packages.getDeprecatedPackageMetadata(this.pack.name);
    }
  }, {
    key: 'hasSettings',
    value: function hasSettings() {
      return this.packageManager.packageHasSettings(this.pack.name);
    }
  }, {
    key: 'subscribeToPackageEvent',
    value: function subscribeToPackageEvent(event, callback) {
      var _this6 = this;

      this.disposables.add(this.packageManager.on(event, function (_ref) {
        var pack = _ref.pack;
        var error = _ref.error;

        if (pack.pack != null) {
          pack = pack.pack;
        }

        var packageName = pack.name;
        if (packageName === _this6.pack.name) {
          callback(pack, error);
        }
      }));
    }

    /*
    Section: Methods that should be on a Package model
    */

  }, {
    key: 'install',
    value: function install() {
      var _this7 = this;

      this.packageManager.install(this.installablePack != null ? this.installablePack : this.pack, function (error) {
        if (error != null) {
          console.error('Installing ' + _this7.type + ' ' + _this7.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        } else {
          // if a package was disabled before installing it, re-enable it
          if (_this7.isDisabled()) {
            atom.packages.enablePackage(_this7.pack.name);
          }
        }
      });
    }
  }, {
    key: 'update',
    value: function update() {
      var _this8 = this;

      if (!this.newVersion && !this.newSha) {
        return Promise.resolve();
      }

      var pack = this.installablePack != null ? this.installablePack : this.pack;
      var version = this.newVersion ? 'v' + this.newVersion : '#' + this.newSha.substr(0, 8);
      return new Promise(function (resolve, reject) {
        _this8.packageManager.update(pack, _this8.newVersion, function (error) {
          if (error != null) {
            atom.assert(false, 'Package update failed', function (assertionError) {
              assertionError.metadata = {
                type: _this8.type,
                name: pack.name,
                version: version,
                errorMessage: error.message,
                errorStack: error.stack,
                errorStderr: error.stderr
              };
            });
            console.error('Updating ' + _this8.type + ' ' + pack.name + ' to ' + version + ' failed:\n', error, error.stderr != null ? error.stderr : '');
            reject(error);
          } else {
            resolve();
          }
        });
      });
    }
  }, {
    key: 'uninstall',
    value: function uninstall() {
      var _this9 = this;

      this.packageManager.uninstall(this.pack, function (error) {
        if (error != null) {
          console.error('Uninstalling ' + _this9.type + ' ' + _this9.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        }
      });
    }
  }, {
    key: 'installAlternative',
    value: function installAlternative() {
      var _this10 = this;

      var metadata = this.getDeprecatedPackageMetadata();
      var loadedPack = atom.packages.getLoadedPackage(metadata ? metadata.alternative : null);
      if (!metadata || !metadata.hasAlternative || metadata.alternative === 'core' || loadedPack) {
        return;
      }

      this.packageManager.installAlternative(this.pack, metadata.alternative, function (error, _ref2) {
        var pack = _ref2.pack;
        var alternative = _ref2.alternative;

        if (error != null) {
          console.error('Installing alternative `' + alternative + '` ' + _this10.type + ' for ' + _this10.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        }
      });
    }
  }]);

  return PackageCard;
})();

exports['default'] = PackageCard;
module.exports = exports['default'];
/* A transparent gif so there is no "broken border" */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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