Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var KeybindingsPanel = (function () {
  function KeybindingsPanel() {
    var _this = this;

    _classCallCheck(this, KeybindingsPanel);

    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
    this.otherPlatformPattern = new RegExp('\\.platform-(?!' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b)');
    this.platformPattern = new RegExp('\\.platform-' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b');

    this.disposables.add(this.refs.searchEditor.onDidStopChanging(function () {
      _this.filterKeyBindings(_this.keyBindings, _this.refs.searchEditor.getText());
    }));

    this.disposables.add(atom.keymaps.onDidReloadKeymap(function () {
      _this.loadKeyBindings();
    }));
    this.disposables.add(atom.keymaps.onDidUnloadKeymap(function () {
      _this.loadKeyBindings();
    }));
    this.loadKeyBindings();
  }

  _createClass(KeybindingsPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'section',
          { className: 'keybinding-panel section' },
          _etch2['default'].dom(
            'div',
            { className: 'section-heading icon icon-keyboard' },
            'Keybindings'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'text native-key-bindings', tabIndex: '-1' },
            _etch2['default'].dom('span', { className: 'icon icon-question' }),
            _etch2['default'].dom(
              'span',
              null,
              'You can override these keybindings by copying '
            ),
            _etch2['default'].dom('span', { className: 'icon icon-clippy' }),
            _etch2['default'].dom(
              'span',
              null,
              'and pasting them into '
            ),
            _etch2['default'].dom(
              'a',
              { className: 'link', onclick: this.didClickOpenKeymapFile },
              'your keymap file'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'editor-container' },
            _etch2['default'].dom(_atom.TextEditor, { mini: true, ref: 'searchEditor', placeholderText: 'Search keybindings' })
          ),
          _etch2['default'].dom(
            'table',
            { className: 'native-key-bindings table text', tabIndex: '-1' },
            _etch2['default'].dom('col', { className: 'keystroke' }),
            _etch2['default'].dom('col', { className: 'command' }),
            _etch2['default'].dom('col', { className: 'source' }),
            _etch2['default'].dom('col', { className: 'selector' }),
            _etch2['default'].dom(
              'thead',
              null,
              _etch2['default'].dom(
                'tr',
                null,
                _etch2['default'].dom(
                  'th',
                  { className: 'keystroke' },
                  'Keystroke'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'command' },
                  'Command'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'source' },
                  'Source'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'selector' },
                  'Selector'
                )
              )
            ),
            _etch2['default'].dom('tbody', { ref: 'keybindingRows' })
          )
        )
      );
    }
  }, {
    key: 'loadKeyBindings',
    value: function loadKeyBindings() {
      this.refs.keybindingRows.innerHTML = '';
      this.keyBindings = _underscorePlus2['default'].sortBy(atom.keymaps.getKeyBindings(), 'keystrokes');
      this.appendKeyBindings(this.keyBindings);
      this.filterKeyBindings(this.keyBindings, this.refs.searchEditor.getText());
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.searchEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'filterKeyBindings',
    value: function filterKeyBindings(keyBindings, filterString) {
      this.refs.keybindingRows.innerHTML = '';
      for (var keyBinding of keyBindings) {
        var selector = keyBinding.selector;
        var keystrokes = keyBinding.keystrokes;
        var command = keyBinding.command;
        var source = keyBinding.source;

        source = KeybindingsPanel.determineSource(source);
        var searchString = ('' + selector + keystrokes + command + source).toLowerCase();
        if (!searchString) {
          continue;
        }

        var keywords = filterString.trim().toLowerCase().split(' ');
        if (keywords.every(function (keyword) {
          return searchString.indexOf(keyword) !== -1;
        })) {
          this.appendKeyBinding(keyBinding);
        }
      }
    }
  }, {
    key: 'appendKeyBindings',
    value: function appendKeyBindings(keyBindings) {
      for (var keyBinding of keyBindings) {
        this.appendKeyBinding(keyBinding);
      }
    }
  }, {
    key: 'appendKeyBinding',
    value: function appendKeyBinding(keyBinding) {
      if (!this.showSelector(keyBinding.selector)) {
        return;
      }

      var element = this.elementForKeyBinding(keyBinding);
      element.dataset.keyBinding = keyBinding;
      this.refs.keybindingRows.appendChild(element);
    }
  }, {
    key: 'showSelector',
    value: function showSelector(selector) {
      var _this2 = this;

      var segments = undefined;
      if (selector) {
        segments = selector.split(',') || [];
      } else {
        segments = [];
      }

      return segments.some(function (s) {
        return _this2.platformPattern.test(s) || !_this2.otherPlatformPattern.test(s);
      });
    }
  }, {
    key: 'elementForKeyBinding',
    value: function elementForKeyBinding(keyBinding) {
      var selector = keyBinding.selector;
      var keystrokes = keyBinding.keystrokes;
      var command = keyBinding.command;
      var source = keyBinding.source;

      source = KeybindingsPanel.determineSource(source);

      var tr = document.createElement('tr');
      if (source === 'User') {
        tr.classList.add('is-user');
      }

      var keystrokeTd = document.createElement('td');
      keystrokeTd.classList.add('keystroke');

      var copyIcon = document.createElement('span');
      copyIcon.classList.add('icon', 'icon-clippy', 'copy-icon');
      copyIcon.onclick = function () {
        var content = undefined;
        var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());
        escapedKeystrokes = keystrokes.replace(/\\/g, '\\\\'); // Escape backslashes
        if (keymapExtension === '.cson') {
          content = '\'' + selector + '\':\n  \'' + escapedKeystrokes + '\': \'' + command + '\'';
        } else {
          content = '"' + selector + '": {\n  "' + escapedKeystrokes + '": "' + command + '"\n}';
        }
        return atom.clipboard.write(content);
      };
      keystrokeTd.appendChild(copyIcon);

      var keystrokesSpan = document.createElement('span');
      keystrokesSpan.textContent = keystrokes;
      keystrokeTd.appendChild(keystrokesSpan);
      tr.appendChild(keystrokeTd);

      var commandTd = document.createElement('td');
      commandTd.classList.add('command');
      commandTd.textContent = command;
      tr.appendChild(commandTd);

      var sourceTd = document.createElement('td');
      sourceTd.classList.add('source');
      sourceTd.textContent = source;
      tr.appendChild(sourceTd);

      var selectorTd = document.createElement('td');
      selectorTd.classList.add('selector');
      selectorTd.textContent = selector;
      tr.appendChild(selectorTd);

      return tr;
    }
  }, {
    key: 'didClickOpenKeymapFile',
    value: function didClickOpenKeymapFile(e) {
      e.preventDefault();
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open-your-keymap');
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }

    // Private: Returns a user friendly description of where a keybinding was
    // loaded from.
    //
    // * filePath:
    //   The absolute path from which the keymap was loaded
    //
    // Returns one of:
    // * `Core` indicates it comes from a bundled package.
    // * `User` indicates that it was defined by a user.
    // * `<package-name>` the package which defined it.
    // * `Unknown` if an invalid path was passed in.
  }], [{
    key: 'determineSource',
    value: function determineSource(filePath) {
      if (!filePath) {
        return 'Unknown';
      }

      if (filePath.indexOf(_path2['default'].join(atom.getLoadSettings().resourcePath, 'keymaps')) === 0) {
        return 'Core';
      } else if (filePath === atom.keymaps.getUserKeymapPath()) {
        return 'User';
      } else {
        var pathParts = filePath.split(_path2['default'].sep);
        var packageNameIndex = pathParts.length - 3;
        var packageName = pathParts[packageNameIndex] != null ? pathParts[packageNameIndex] : '';
        return _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(packageName));
      }
    }
  }]);

  return KeybindingsPanel;
})();

exports['default'] = KeybindingsPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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