Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _electron = require('electron');

var _electron2 = _interopRequireDefault(_electron);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _hostedGitInfo = require('hosted-git-info');

var _hostedGitInfo2 = _interopRequireDefault(_hostedGitInfo);

var PackageNameRegex = /config\/install\/(package|theme):([a-z0-9-_]+)/i;

var InstallPanel = (function () {
  function InstallPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, InstallPanel);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();
    this.client = this.packageManager.getClient();
    this.atomIoURL = 'https://atom.io/packages';

    _etch2['default'].initialize(this);

    this.refs.searchMessage.style.display = 'none';

    this.refs.searchEditor.setPlaceholderText('Search packages');
    this.searchType = 'packages';
    this.disposables.add(this.packageManager.on('package-install-failed', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.searchErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
    }));
    this.disposables.add(this.packageManager.on('package-installed theme-installed', function (_ref2) {
      var pack = _ref2.pack;

      var gitUrlInfo = _this.currentGitPackageCard && _this.currentGitPackageCard.pack && _this.currentGitPackageCard.pack.gitUrlInfo ? _this.currentGitPackageCard.pack.gitUrlInfo : null;

      if (gitUrlInfo && gitUrlInfo === pack.gitUrlInfo) {
        _this.updateGitPackageCard(pack);
      }
    }));
    this.disposables.add(this.refs.searchEditor.onDidStopChanging(function () {
      _this.performSearch();
    }));
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.loadFeaturedPackages();
  }

  _createClass(InstallPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.searchEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'h1',
              { ref: 'installHeading', className: 'section-heading icon icon-plus' },
              'Install Packages'
            ),
            _etch2['default'].dom(
              'div',
              { className: 'text native-key-bindings', tabIndex: '-1' },
              _etch2['default'].dom('span', { className: 'icon icon-question' }),
              _etch2['default'].dom(
                'span',
                { ref: 'publishedToText' },
                'Packages are published to '
              ),
              _etch2['default'].dom(
                'a',
                { className: 'link', onclick: this.didClickOpenAtomIo.bind(this) },
                'atom.io'
              ),
              _etch2['default'].dom(
                'span',
                null,
                ' and are installed to ',
                _path2['default'].join(process.env.ATOM_HOME, 'packages')
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'search-container clearfix' },
              _etch2['default'].dom(
                'div',
                { className: 'editor-container' },
                _etch2['default'].dom(_atom.TextEditor, { mini: true, ref: 'searchEditor' })
              ),
              _etch2['default'].dom(
                'div',
                { className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { ref: 'searchPackagesButton', className: 'btn btn-default selected', onclick: this.didClickSearchPackagesButton.bind(this) },
                  'Packages'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'searchThemesButton', className: 'btn btn-default', onclick: this.didClickSearchThemesButton.bind(this) },
                  'Themes'
                )
              )
            ),
            _etch2['default'].dom('div', { ref: 'searchErrors' }),
            _etch2['default'].dom('div', { ref: 'searchMessage', className: 'alert alert-info search-message icon icon-search' }),
            _etch2['default'].dom('div', { ref: 'resultsContainer', className: 'container package-container' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom('div', { ref: 'featuredHeading', className: 'section-heading icon icon-star' }),
            _etch2['default'].dom('div', { ref: 'featuredErrors' }),
            _etch2['default'].dom('div', { ref: 'loadingMessage', className: 'alert alert-info icon icon-hourglass' }),
            _etch2['default'].dom('div', { ref: 'featuredContainer', className: 'container package-container' })
          )
        )
      );
    }
  }, {
    key: 'setSearchType',
    value: function setSearchType(searchType) {
      if (searchType === 'theme') {
        this.searchType = 'themes';
        this.refs.searchThemesButton.classList.add('selected');
        this.refs.searchPackagesButton.classList.remove('selected');
        this.refs.searchEditor.setPlaceholderText('Search themes');
        this.refs.publishedToText.textContent = 'Themes are published to ';
        this.atomIoURL = 'https://atom.io/themes';
        this.loadFeaturedPackages(true);
      } else if (searchType === 'package') {
        this.searchType = 'packages';
        this.refs.searchPackagesButton.classList.add('selected');
        this.refs.searchThemesButton.classList.remove('selected');
        this.refs.searchEditor.setPlaceholderText('Search packages');
        this.refs.publishedToText.textContent = 'Packages are published to ';
        this.atomIoURL = 'https://atom.io/packages';
        this.loadFeaturedPackages();
      }
    }
  }, {
    key: 'beforeShow',
    value: function beforeShow(options) {
      if (options && options.uri) {
        var query = this.extractQueryFromURI(options.uri);
        if (query != null) {
          var searchType = query.searchType;
          var packageName = query.packageName;

          this.setSearchType(searchType);
          this.refs.searchEditor.setText(packageName);
          this.performSearch();
        }
      }
    }
  }, {
    key: 'extractQueryFromURI',
    value: function extractQueryFromURI(uri) {
      var matches = PackageNameRegex.exec(uri);
      if (matches) {
        var _Array$from = Array.from(matches);

        var _Array$from2 = _slicedToArray(_Array$from, 3);

        var searchType = _Array$from2[1];
        var packageName = _Array$from2[2];

        return { searchType: searchType, packageName: packageName };
      } else {
        return null;
      }
    }
  }, {
    key: 'performSearch',
    value: function performSearch() {
      var query = this.refs.searchEditor.getText().trim().toLowerCase();
      if (query) {
        this.performSearchForQuery(query);
      }
    }
  }, {
    key: 'performSearchForQuery',
    value: function performSearchForQuery(query) {
      var gitUrlInfo = undefined;
      if (gitUrlInfo = _hostedGitInfo2['default'].fromUrl(query)) {
        var type = gitUrlInfo['default'];
        if (type === 'sshurl' || type === 'https' || type === 'shortcut') {
          this.showGitInstallPackageCard({ name: query, gitUrlInfo: gitUrlInfo });
        }
      } else {
        this.search(query);
      }
    }
  }, {
    key: 'showGitInstallPackageCard',
    value: function showGitInstallPackageCard(pack) {
      if (this.currentGitPackageCard) {
        this.currentGitPackageCard.destroy();
      }

      this.currentGitPackageCard = this.getPackageCardView(pack);
      this.currentGitPackageCard.displayGitPackageInstallInformation();
      this.replaceCurrentGitPackageCardView();
    }
  }, {
    key: 'updateGitPackageCard',
    value: function updateGitPackageCard(pack) {
      if (this.currentGitPackageCard) {
        this.currentGitPackageCard.destroy();
      }

      this.currentGitPackageCard = this.getPackageCardView(pack);
      this.replaceCurrentGitPackageCardView();
    }
  }, {
    key: 'replaceCurrentGitPackageCardView',
    value: function replaceCurrentGitPackageCardView() {
      this.refs.resultsContainer.innerHTML = '';
      this.addPackageCardView(this.refs.resultsContainer, this.currentGitPackageCard);
    }
  }, {
    key: 'search',
    value: _asyncToGenerator(function* (query) {
      this.refs.resultsContainer.innerHTML = '';
      this.refs.searchMessage.textContent = 'Searching ' + this.searchType + ' for “' + query + '”…';
      this.refs.searchMessage.style.display = '';

      var options = {};
      options[this.searchType] = true;

      try {
        var packages = (yield this.client.search(query, options)) || [];
        this.refs.resultsContainer.innerHTML = '';
        this.refs.searchMessage.style.display = 'none';
        if (packages.length === 0) {
          this.showNoResultMessage(query);
        }
        this.highlightExactMatch(this.refs.resultsContainer, query, packages);
        this.addCloseMatches(this.refs.resultsContainer, query, packages);
        this.addPackageViews(this.refs.resultsContainer, packages);
      } catch (error) {
        this.refs.searchMessage.style.display = 'none';
        this.refs.searchErrors.appendChild(new _errorView2['default'](this.packageManager, error).element);
      }
    })
  }, {
    key: 'showNoResultMessage',
    value: function showNoResultMessage(query) {
      this.refs.searchMessage.textContent = 'No ' + this.searchType.replace(/s$/, '') + ' results for “' + query + '”';
      this.refs.searchMessage.style.display = '';
    }
  }, {
    key: 'highlightExactMatch',
    value: function highlightExactMatch(container, query, packages) {
      var exactMatch = packages.filter(function (pkg) {
        return pkg.name.toLowerCase() === query;
      })[0];

      if (exactMatch) {
        this.addPackageCardView(container, this.getPackageCardView(exactMatch));
        packages.splice(packages.indexOf(exactMatch), 1);
      }
    }
  }, {
    key: 'addCloseMatches',
    value: function addCloseMatches(container, query, packages) {
      var matches = packages.filter(function (pkg) {
        return pkg.name.toLowerCase().indexOf(query) >= 0;
      });

      for (var pack of matches) {
        this.addPackageCardView(container, this.getPackageCardView(pack));
        packages.splice(packages.indexOf(pack), 1);
      }
    }
  }, {
    key: 'addPackageViews',
    value: function addPackageViews(container, packages) {
      for (var pack of packages) {
        this.addPackageCardView(container, this.getPackageCardView(pack));
      }
    }
  }, {
    key: 'addPackageCardView',
    value: function addPackageCardView(container, packageCard) {
      var packageRow = document.createElement('div');
      packageRow.classList.add('row');
      packageRow.appendChild(packageCard.element);
      container.appendChild(packageRow);
    }
  }, {
    key: 'getPackageCardView',
    value: function getPackageCardView(pack) {
      return new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Install' });
    }
  }, {
    key: 'filterPackages',
    value: function filterPackages(packages, themes) {
      return packages.filter(function (_ref3) {
        var theme = _ref3.theme;
        return themes ? theme : !theme;
      });
    }

    // Load and display the featured packages that are available to install.
  }, {
    key: 'loadFeaturedPackages',
    value: function loadFeaturedPackages(loadThemes) {
      var _this2 = this;

      if (loadThemes == null) {
        loadThemes = false;
      }
      this.refs.featuredContainer.innerHTML = '';

      if (loadThemes) {
        this.refs.installHeading.textContent = 'Install Themes';
        this.refs.featuredHeading.textContent = 'Featured Themes';
        this.refs.loadingMessage.textContent = 'Loading featured themes…';
      } else {
        this.refs.installHeading.textContent = 'Install Packages';
        this.refs.featuredHeading.textContent = 'Featured Packages';
        this.refs.loadingMessage.textContent = 'Loading featured packages…';
      }

      this.refs.loadingMessage.style.display = '';

      var handle = function handle(error) {
        _this2.refs.loadingMessage.style.display = 'none';
        _this2.refs.featuredErrors.appendChild(new _errorView2['default'](_this2.packageManager, error).element);
      };

      if (loadThemes) {
        this.client.featuredThemes(function (error, themes) {
          if (error) {
            handle(error);
          } else {
            _this2.refs.loadingMessage.style.display = 'none';
            _this2.refs.featuredHeading.textContent = 'Featured Themes';
            _this2.addPackageViews(_this2.refs.featuredContainer, themes);
          }
        });
      } else {
        this.client.featuredPackages(function (error, packages) {
          if (error) {
            handle(error);
          } else {
            _this2.refs.loadingMessage.style.display = 'none';
            _this2.refs.featuredHeading.textContent = 'Featured Packages';
            _this2.addPackageViews(_this2.refs.featuredContainer, packages);
          }
        });
      }
    }
  }, {
    key: 'didClickOpenAtomIo',
    value: function didClickOpenAtomIo(event) {
      event.preventDefault();
      _electron2['default'].shell.openExternal(this.atomIoURL);
    }
  }, {
    key: 'didClickSearchPackagesButton',
    value: function didClickSearchPackagesButton() {
      if (!this.refs.searchPackagesButton.classList.contains('selected')) {
        this.setSearchType('package');
      }

      this.performSearch();
    }
  }, {
    key: 'didClickSearchThemesButton',
    value: function didClickSearchThemesButton() {
      if (!this.refs.searchThemesButton.classList.contains('selected')) {
        this.setSearchType('theme');
      }

      this.performSearch();
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return InstallPanel;
})();

exports['default'] = InstallPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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