Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var CollapsibleSectionPanel = (function () {
  function CollapsibleSectionPanel() {
    _classCallCheck(this, CollapsibleSectionPanel);
  }

  _createClass(CollapsibleSectionPanel, [{
    key: 'notHiddenCardsLength',
    value: function notHiddenCardsLength(sectionElement) {
      return sectionElement.querySelectorAll('.package-card:not(.hidden)').length;
    }
  }, {
    key: 'updateSectionCount',
    value: function updateSectionCount(headerElement, countElement, packageCount, totalCount) {
      if (totalCount != null) {
        countElement.textContent = packageCount + '/' + totalCount;
      } else {
        countElement.textContent = packageCount;
      }

      if (packageCount > 0) {
        headerElement.classList.add("has-items");
      }
    }
  }, {
    key: 'updateSectionCounts',
    value: function updateSectionCounts() {
      this.resetSectionHasItems();

      var filterText = this.refs.filterEditor.getText();
      if (filterText === '') {
        this.updateUnfilteredSectionCounts();
      } else {
        this.updateFilteredSectionCounts();
      }
    }
  }, {
    key: 'handleEvents',
    value: function handleEvents() {
      var _this = this;

      var handler = function handler(e) {
        var target = e.target.closest('.sub-section .has-items');
        if (target) {
          target.parentNode.classList.toggle('collapsed');
        }
      };
      this.element.addEventListener('click', handler);
      return new _atom.Disposable(function () {
        return _this.element.removeEventListener('click', handler);
      });
    }
  }, {
    key: 'resetCollapsibleSections',
    value: function resetCollapsibleSections(headerSections) {
      for (var headerSection of headerSections) {
        this.resetCollapsibleSection(headerSection);
      }
    }
  }, {
    key: 'resetCollapsibleSection',
    value: function resetCollapsibleSection(headerSection) {
      headerSection.classList.remove('has-items');
    }
  }]);

  return CollapsibleSectionPanel;
})();

exports['default'] = CollapsibleSectionPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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