Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _electron = require('electron');

var _atom = require('atom');

var _url = require('url');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var GitHubFile = (function () {
  _createClass(GitHubFile, null, [{
    key: 'fromPath',

    // Public
    value: function fromPath(filePath) {
      return new GitHubFile(filePath);
    }
  }]);

  function GitHubFile(filePath) {
    _classCallCheck(this, GitHubFile);

    this.filePath = filePath;

    var _atom$project$relativizePath = atom.project.relativizePath(this.filePath);

    var _atom$project$relativizePath2 = _slicedToArray(_atom$project$relativizePath, 1);

    var rootDir = _atom$project$relativizePath2[0];

    if (rootDir != null) {
      var rootDirIndex = atom.project.getPaths().indexOf(rootDir);
      this.repo = atom.project.getRepositories()[rootDirIndex];
      this.type = 'none';
      if (this.repo && this.gitURL()) {
        if (this.isGitHubWikiURL(this.githubRepoURL())) {
          this.type = 'wiki';
        } else if (this.isGistURL(this.githubRepoURL())) {
          this.type = 'gist';
        } else {
          this.type = 'repo';
        }
      }
    }
  }

  // Public

  _createClass(GitHubFile, [{
    key: 'open',
    value: function open(lineRange) {
      if (this.validateRepo()) {
        this.openURLInBrowser(this.blobURL() + this.getLineRangeSuffix(lineRange));
      }
    }

    // Public
  }, {
    key: 'openOnMaster',
    value: function openOnMaster(lineRange) {
      if (this.validateRepo()) {
        this.openURLInBrowser(this.blobURLForMaster() + this.getLineRangeSuffix(lineRange));
      }
    }

    // Public
  }, {
    key: 'blame',
    value: function blame(lineRange) {
      if (this.validateRepo()) {
        if (this.type === 'repo') {
          this.openURLInBrowser(this.blameURL() + this.getLineRangeSuffix(lineRange));
        } else {
          atom.notifications.addWarning('Blames do not exist for ' + this.type + 's');
        }
      }
    }
  }, {
    key: 'history',
    value: function history() {
      if (this.validateRepo()) {
        this.openURLInBrowser(this.historyURL());
      }
    }
  }, {
    key: 'copyURL',
    value: function copyURL(lineRange) {
      if (this.validateRepo()) {
        atom.clipboard.write(this.shaURL() + this.getLineRangeSuffix(lineRange));
      }
    }
  }, {
    key: 'openBranchCompare',
    value: function openBranchCompare() {
      if (this.validateRepo()) {
        if (this.type === 'repo') {
          this.openURLInBrowser(this.branchCompareURL());
        } else {
          atom.notifications.addWarning('Branches do not exist for ' + this.type + 's');
        }
      }
    }
  }, {
    key: 'openIssues',
    value: function openIssues() {
      if (this.validateRepo()) {
        if (this.type === 'repo') {
          this.openURLInBrowser(this.issuesURL());
        } else {
          atom.notifications.addWarning('Issues do not exist for ' + this.type + 's');
        }
      }
    }
  }, {
    key: 'openPullRequests',
    value: function openPullRequests() {
      if (this.validateRepo()) {
        if (this.type === 'repo') {
          this.openURLInBrowser(this.pullRequestsURL());
        } else {
          atom.notifications.addWarning('Pull requests do not exist for ' + this.type + 's');
        }
      }
    }
  }, {
    key: 'openRepository',
    value: function openRepository() {
      if (this.validateRepo()) {
        this.openURLInBrowser(this.githubRepoURL());
      }
    }
  }, {
    key: 'getLineRangeSuffix',
    value: function getLineRangeSuffix(lineRange) {
      if (lineRange && this.type !== 'wiki' && atom.config.get('open-on-github.includeLineNumbersInUrls')) {
        lineRange = _atom.Range.fromObject(lineRange);
        var startRow = lineRange.start.row + 1;
        var endRow = lineRange.end.row + 1;

        if (startRow === endRow) {
          if (this.type === 'gist') {
            return '-L' + startRow;
          } else {
            return '#L' + startRow;
          }
        } else {
          if (this.type === 'gist') {
            return '-L' + startRow + '-L' + endRow;
          } else {
            return '#L' + startRow + '-L' + endRow;
          }
        }
      } else {
        return '';
      }
    }

    // Internal
  }, {
    key: 'validateRepo',
    value: function validateRepo() {
      if (!this.repo) {
        atom.notifications.addWarning('No repository found for path: ' + this.filePath + '.');
        return false;
      } else if (!this.gitURL()) {
        atom.notifications.addWarning('No URL defined for remote: ' + this.remoteName());
        return false;
      } else if (!this.githubRepoURL()) {
        atom.notifications.addWarning('Remote URL is not hosted on GitHub: ' + this.gitURL());
        return false;
      }
      return true;
    }

    // Internal
  }, {
    key: 'openURLInBrowser',
    value: function openURLInBrowser(url) {
      _electron.shell.openExternal(url);
    }

    // Internal
  }, {
    key: 'blobURL',
    value: function blobURL() {
      var gitHubRepoURL = this.githubRepoURL();
      var repoRelativePath = this.repoRelativePath();

      if (this.type === 'wiki') {
        return gitHubRepoURL + '/' + this.extractFileName(repoRelativePath);
      } else if (this.type === 'gist') {
        return gitHubRepoURL + '#file-' + this.encodeSegments(repoRelativePath.replace(/\./g, '-'));
      } else {
        return gitHubRepoURL + '/blob/' + this.remoteBranchName() + '/' + this.encodeSegments(repoRelativePath);
      }
    }

    // Internal
  }, {
    key: 'blobURLForMaster',
    value: function blobURLForMaster() {
      var gitHubRepoURL = this.githubRepoURL();

      if (this.type === 'repo') {
        return gitHubRepoURL + '/blob/master/' + this.encodeSegments(this.repoRelativePath());
      } else {
        return this.blobURL(); // Only repos have branches
      }
    }

    // Internal
  }, {
    key: 'shaURL',
    value: function shaURL() {
      var gitHubRepoURL = this.githubRepoURL();
      var encodedSHA = this.encodeSegments(this.sha());
      var repoRelativePath = this.repoRelativePath();

      if (this.type === 'wiki') {
        return gitHubRepoURL + '/' + this.extractFileName(repoRelativePath) + '/' + encodedSHA;
      } else if (this.type === 'gist') {
        return gitHubRepoURL + '/' + encodedSHA + '#file-' + this.encodeSegments(repoRelativePath.replace(/\./g, '-'));
      } else {
        return gitHubRepoURL + '/blob/' + encodedSHA + '/' + this.encodeSegments(repoRelativePath);
      }
    }

    // Internal
  }, {
    key: 'blameURL',
    value: function blameURL() {
      return this.githubRepoURL() + '/blame/' + this.remoteBranchName() + '/' + this.encodeSegments(this.repoRelativePath());
    }

    // Internal
  }, {
    key: 'historyURL',
    value: function historyURL() {
      var gitHubRepoURL = this.githubRepoURL();

      if (this.type === 'wiki') {
        return gitHubRepoURL + '/' + this.extractFileName(this.repoRelativePath()) + '/_history';
      } else if (this.type === 'gist') {
        return gitHubRepoURL + '/revisions';
      } else {
        return gitHubRepoURL + '/commits/' + this.remoteBranchName() + '/' + this.encodeSegments(this.repoRelativePath());
      }
    }

    // Internal
  }, {
    key: 'issuesURL',
    value: function issuesURL() {
      return this.githubRepoURL() + '/issues';
    }

    // Internal
  }, {
    key: 'pullRequestsURL',
    value: function pullRequestsURL() {
      return this.githubRepoURL() + '/pulls';
    }

    // Internal
  }, {
    key: 'branchCompareURL',
    value: function branchCompareURL() {
      return this.githubRepoURL() + '/compare/' + this.encodeSegments(this.branchName());
    }
  }, {
    key: 'encodeSegments',
    value: function encodeSegments() {
      var segments = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];

      return segments.split('/').map(function (segment) {
        return encodeURIComponent(segment);
      }).join('/');
    }

    // Internal
  }, {
    key: 'extractFileName',
    value: function extractFileName() {
      var relativePath = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];

      return _path2['default'].parse(relativePath).name;
    }

    // Internal
  }, {
    key: 'gitURL',
    value: function gitURL() {
      var remoteName = this.remoteName();
      if (remoteName != null) {
        return this.repo.getConfigValue('remote.' + remoteName + '.url', this.filePath);
      } else {
        return this.repo.getConfigValue('remote.origin.url', this.filePath);
      }
    }

    // Internal
  }, {
    key: 'githubRepoURL',
    value: function githubRepoURL() {
      var url = this.gitURL();

      if (url.match(/git@[^:]+:/)) {
        // git@github.com:user/repo.git
        url = url.replace(/^git@([^:]+):(.+)$/, function (match, host, repoPath) {
          repoPath = repoPath.replace(/^\/+/, '');
          return 'https://' + host + '/' + repoPath; // -> https://github.com/user/repo.git
        });
      } else if (url.match(/^ssh:\/\/git@([^/]+)\//)) {
          // ssh://git@github.com/user/repo.git
          url = 'https://' + url.substring(10); // -> https://github.com/user/repo.git
        } else if (url.match(/^git:\/\/[^/]+\//)) {
            // git://github.com/user/repo.git
            url = 'https' + url.substring(3); // -> https://github.com/user/repo.git
          } else if (url.match(/^https?:\/\/\w+@/)) {
              // https://user@github.com/user/repo.git
              url = url.replace(/^https?:\/\/\w+@/, 'https://'); // -> https://github.com/user/repo.git
            }

      // Remove trailing .git and trailing slashes
      url = url.replace(/\.git$/, '').replace(/\/+$/, '');
      // Change .wiki to /wiki
      url = url.replace(/\.wiki$/, '/wiki');

      if (!this.isBitbucketURL(url)) {
        return url;
      }
    }
  }, {
    key: 'isGistURL',
    value: function isGistURL(url) {
      try {
        var _parseURL = (0, _url.parse)(url);

        var host = _parseURL.host;

        return host === 'gist.github.com';
      } catch (error) {
        return false;
      }
    }
  }, {
    key: 'isGitHubWikiURL',
    value: function isGitHubWikiURL(url) {
      return (/\/wiki$/.test(url)
      );
    }
  }, {
    key: 'isBitbucketURL',
    value: function isBitbucketURL(url) {
      if (url.startsWith('git@bitbucket.org')) {
        return true;
      }

      try {
        var _parseURL2 = (0, _url.parse)(url);

        var host = _parseURL2.host;

        return host === 'bitbucket.org';
      } catch (error) {
        return false;
      }
    }

    // Internal
  }, {
    key: 'repoRelativePath',
    value: function repoRelativePath() {
      return this.repo.getRepo(this.filePath).relativize(this.filePath);
    }

    // Internal
  }, {
    key: 'remoteName',
    value: function remoteName() {
      var gitConfigRemote = this.repo.getConfigValue('atom.open-on-github.remote', this.filePath);

      if (gitConfigRemote) {
        return gitConfigRemote;
      }

      var shortBranch = this.repo.getShortHead(this.filePath);

      if (!shortBranch) {
        return null;
      }

      var branchRemote = this.repo.getConfigValue('branch.' + shortBranch + '.remote', this.filePath);

      if (branchRemote && branchRemote.length > 0) {
        return branchRemote;
      }

      return null;
    }

    // Internal
  }, {
    key: 'sha',
    value: function sha() {
      return this.repo.getReferenceTarget('HEAD', this.filePath);
    }

    // Internal
  }, {
    key: 'branchName',
    value: function branchName() {
      var shortBranch = this.repo.getShortHead(this.filePath);

      if (!shortBranch) {
        return null;
      }

      var branchMerge = this.repo.getConfigValue('branch.' + shortBranch + '.merge', this.filePath);
      if (!(branchMerge && branchMerge.length > 11)) {
        return shortBranch;
      }

      if (branchMerge.indexOf('refs/heads/') !== 0) {
        return shortBranch;
      }

      return branchMerge.substring(11);
    }

    // Internal
  }, {
    key: 'remoteBranchName',
    value: function remoteBranchName() {
      var gitConfigBranch = this.repo.getConfigValue('atom.open-on-github.branch', this.filePath);

      if (gitConfigBranch) {
        return gitConfigBranch;
      } else if (this.remoteName() != null) {
        return this.encodeSegments(this.branchName());
      } else {
        return 'master';
      }
    }
  }]);

  return GitHubFile;
})();

exports['default'] = GitHubFile;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzQuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9vcGVuLW9uLWdpdGh1Yi9saWIvZ2l0aHViLWZpbGUuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7d0JBRW9CLFVBQVU7O29CQUNWLE1BQU07O21CQUNNLEtBQUs7O29CQUNwQixNQUFNOzs7O0lBRUYsVUFBVTtlQUFWLFVBQVU7Ozs7V0FFYixrQkFBQyxRQUFRLEVBQUU7QUFDekIsYUFBTyxJQUFJLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQTtLQUNoQzs7O0FBRVcsV0FOTyxVQUFVLENBTWhCLFFBQVEsRUFBRTswQkFOSixVQUFVOztBQU8zQixRQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQTs7dUNBQ04sSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQzs7OztRQUFyRCxPQUFPOztBQUVkLFFBQUksT0FBTyxJQUFJLElBQUksRUFBRTtBQUNuQixVQUFNLFlBQVksR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQTtBQUM3RCxVQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsZUFBZSxFQUFFLENBQUMsWUFBWSxDQUFDLENBQUE7QUFDeEQsVUFBSSxDQUFDLElBQUksR0FBRyxNQUFNLENBQUE7QUFDbEIsVUFBSSxJQUFJLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxNQUFNLEVBQUUsRUFBRTtBQUM5QixZQUFJLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDLEVBQUU7QUFDOUMsY0FBSSxDQUFDLElBQUksR0FBRyxNQUFNLENBQUE7U0FDbkIsTUFBTSxJQUFJLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDLEVBQUU7QUFDL0MsY0FBSSxDQUFDLElBQUksR0FBRyxNQUFNLENBQUE7U0FDbkIsTUFBTTtBQUNMLGNBQUksQ0FBQyxJQUFJLEdBQUcsTUFBTSxDQUFBO1NBQ25CO09BQ0Y7S0FDRjtHQUNGOzs7O2VBeEJrQixVQUFVOztXQTJCeEIsY0FBQyxTQUFTLEVBQUU7QUFDZixVQUFJLElBQUksQ0FBQyxZQUFZLEVBQUUsRUFBRTtBQUN2QixZQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFBO09BQzNFO0tBQ0Y7Ozs7O1dBR1ksc0JBQUMsU0FBUyxFQUFFO0FBQ3ZCLFVBQUksSUFBSSxDQUFDLFlBQVksRUFBRSxFQUFFO0FBQ3ZCLFlBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQTtPQUNwRjtLQUNGOzs7OztXQUdLLGVBQUMsU0FBUyxFQUFFO0FBQ2hCLFVBQUksSUFBSSxDQUFDLFlBQVksRUFBRSxFQUFFO0FBQ3ZCLFlBQUksSUFBSSxDQUFDLElBQUksS0FBSyxNQUFNLEVBQUU7QUFDeEIsY0FBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUUsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQTtTQUM1RSxNQUFNO0FBQ0wsY0FBSSxDQUFDLGFBQWEsQ0FBQyxVQUFVLDhCQUE0QixJQUFJLENBQUMsSUFBSSxPQUFJLENBQUE7U0FDdkU7T0FDRjtLQUNGOzs7V0FFTyxtQkFBRztBQUNULFVBQUksSUFBSSxDQUFDLFlBQVksRUFBRSxFQUFFO0FBQ3ZCLFlBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUMsQ0FBQTtPQUN6QztLQUNGOzs7V0FFTyxpQkFBQyxTQUFTLEVBQUU7QUFDbEIsVUFBSSxJQUFJLENBQUMsWUFBWSxFQUFFLEVBQUU7QUFDdkIsWUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFBO09BQ3pFO0tBQ0Y7OztXQUVpQiw2QkFBRztBQUNuQixVQUFJLElBQUksQ0FBQyxZQUFZLEVBQUUsRUFBRTtBQUN2QixZQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssTUFBTSxFQUFFO0FBQ3hCLGNBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQyxDQUFBO1NBQy9DLE1BQU07QUFDTCxjQUFJLENBQUMsYUFBYSxDQUFDLFVBQVUsZ0NBQThCLElBQUksQ0FBQyxJQUFJLE9BQUksQ0FBQTtTQUN6RTtPQUNGO0tBQ0Y7OztXQUVVLHNCQUFHO0FBQ1osVUFBSSxJQUFJLENBQUMsWUFBWSxFQUFFLEVBQUU7QUFDdkIsWUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLE1BQU0sRUFBRTtBQUN4QixjQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDLENBQUE7U0FDeEMsTUFBTTtBQUNMLGNBQUksQ0FBQyxhQUFhLENBQUMsVUFBVSw4QkFBNEIsSUFBSSxDQUFDLElBQUksT0FBSSxDQUFBO1NBQ3ZFO09BQ0Y7S0FDRjs7O1dBRWdCLDRCQUFHO0FBQ2xCLFVBQUksSUFBSSxDQUFDLFlBQVksRUFBRSxFQUFFO0FBQ3ZCLFlBQUksSUFBSSxDQUFDLElBQUksS0FBSyxNQUFNLEVBQUU7QUFDeEIsY0FBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQyxDQUFBO1NBQzlDLE1BQU07QUFDTCxjQUFJLENBQUMsYUFBYSxDQUFDLFVBQVUscUNBQW1DLElBQUksQ0FBQyxJQUFJLE9BQUksQ0FBQTtTQUM5RTtPQUNGO0tBQ0Y7OztXQUVjLDBCQUFHO0FBQ2hCLFVBQUksSUFBSSxDQUFDLFlBQVksRUFBRSxFQUFFO0FBQ3ZCLFlBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUMsQ0FBQTtPQUM1QztLQUNGOzs7V0FFa0IsNEJBQUMsU0FBUyxFQUFFO0FBQzdCLFVBQUksU0FBUyxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssTUFBTSxJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLHlDQUF5QyxDQUFDLEVBQUU7QUFDbkcsaUJBQVMsR0FBRyxZQUFNLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQTtBQUN2QyxZQUFNLFFBQVEsR0FBRyxTQUFTLENBQUMsS0FBSyxDQUFDLEdBQUcsR0FBRyxDQUFDLENBQUE7QUFDeEMsWUFBTSxNQUFNLEdBQUcsU0FBUyxDQUFDLEdBQUcsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxDQUFBOztBQUVwQyxZQUFJLFFBQVEsS0FBSyxNQUFNLEVBQUU7QUFDdkIsY0FBSSxJQUFJLENBQUMsSUFBSSxLQUFLLE1BQU0sRUFBRTtBQUN4QiwwQkFBWSxRQUFRLENBQUU7V0FDdkIsTUFBTTtBQUNMLDBCQUFZLFFBQVEsQ0FBRTtXQUN2QjtTQUNGLE1BQU07QUFDTCxjQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssTUFBTSxFQUFFO0FBQ3hCLDBCQUFZLFFBQVEsVUFBSyxNQUFNLENBQUU7V0FDbEMsTUFBTTtBQUNMLDBCQUFZLFFBQVEsVUFBSyxNQUFNLENBQUU7V0FDbEM7U0FDRjtPQUNGLE1BQU07QUFDTCxlQUFPLEVBQUUsQ0FBQTtPQUNWO0tBQ0Y7Ozs7O1dBR1ksd0JBQUc7QUFDZCxVQUFJLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRTtBQUNkLFlBQUksQ0FBQyxhQUFhLENBQUMsVUFBVSxvQ0FBa0MsSUFBSSxDQUFDLFFBQVEsT0FBSSxDQUFBO0FBQ2hGLGVBQU8sS0FBSyxDQUFBO09BQ2IsTUFBTSxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxFQUFFO0FBQ3pCLFlBQUksQ0FBQyxhQUFhLENBQUMsVUFBVSxpQ0FBK0IsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFHLENBQUE7QUFDaEYsZUFBTyxLQUFLLENBQUE7T0FDYixNQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxFQUFFLEVBQUU7QUFDaEMsWUFBSSxDQUFDLGFBQWEsQ0FBQyxVQUFVLDBDQUF3QyxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUcsQ0FBQTtBQUNyRixlQUFPLEtBQUssQ0FBQTtPQUNiO0FBQ0QsYUFBTyxJQUFJLENBQUE7S0FDWjs7Ozs7V0FHZ0IsMEJBQUMsR0FBRyxFQUFFO0FBQ3JCLHNCQUFNLFlBQVksQ0FBQyxHQUFHLENBQUMsQ0FBQTtLQUN4Qjs7Ozs7V0FHTyxtQkFBRztBQUNULFVBQU0sYUFBYSxHQUFHLElBQUksQ0FBQyxhQUFhLEVBQUUsQ0FBQTtBQUMxQyxVQUFNLGdCQUFnQixHQUFHLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFBOztBQUVoRCxVQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssTUFBTSxFQUFFO0FBQ3hCLGVBQVUsYUFBYSxTQUFJLElBQUksQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLENBQUMsQ0FBRTtPQUNwRSxNQUFNLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxNQUFNLEVBQUU7QUFDL0IsZUFBVSxhQUFhLGNBQVMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUU7T0FDNUYsTUFBTTtBQUNMLGVBQVUsYUFBYSxjQUFTLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxTQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsZ0JBQWdCLENBQUMsQ0FBRTtPQUNuRztLQUNGOzs7OztXQUdnQiw0QkFBRztBQUNsQixVQUFNLGFBQWEsR0FBRyxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUE7O0FBRTFDLFVBQUksSUFBSSxDQUFDLElBQUksS0FBSyxNQUFNLEVBQUU7QUFDeEIsZUFBVSxhQUFhLHFCQUFnQixJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDLENBQUU7T0FDdEYsTUFBTTtBQUNMLGVBQU8sSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFBO09BQ3RCO0tBQ0Y7Ozs7O1dBR00sa0JBQUc7QUFDUixVQUFNLGFBQWEsR0FBRyxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUE7QUFDMUMsVUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQTtBQUNsRCxVQUFNLGdCQUFnQixHQUFHLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFBOztBQUVoRCxVQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssTUFBTSxFQUFFO0FBQ3hCLGVBQVUsYUFBYSxTQUFJLElBQUksQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLENBQUMsU0FBSSxVQUFVLENBQUU7T0FDbEYsTUFBTSxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssTUFBTSxFQUFFO0FBQy9CLGVBQVUsYUFBYSxTQUFJLFVBQVUsY0FBUyxJQUFJLENBQUMsY0FBYyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLENBQUMsQ0FBRTtPQUMxRyxNQUFNO0FBQ0wsZUFBVSxhQUFhLGNBQVMsVUFBVSxTQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsZ0JBQWdCLENBQUMsQ0FBRTtPQUN0RjtLQUNGOzs7OztXQUdRLG9CQUFHO0FBQ1YsYUFBVSxJQUFJLENBQUMsYUFBYSxFQUFFLGVBQVUsSUFBSSxDQUFDLGdCQUFnQixFQUFFLFNBQUksSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQyxDQUFFO0tBQ2xIOzs7OztXQUdVLHNCQUFHO0FBQ1osVUFBTSxhQUFhLEdBQUcsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFBOztBQUUxQyxVQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssTUFBTSxFQUFFO0FBQ3hCLGVBQVUsYUFBYSxTQUFJLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUMsZUFBVztPQUNwRixNQUFNLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxNQUFNLEVBQUU7QUFDL0IsZUFBVSxhQUFhLGdCQUFZO09BQ3BDLE1BQU07QUFDTCxlQUFVLGFBQWEsaUJBQVksSUFBSSxDQUFDLGdCQUFnQixFQUFFLFNBQUksSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQyxDQUFFO09BQzdHO0tBQ0Y7Ozs7O1dBR1MscUJBQUc7QUFDWCxhQUFVLElBQUksQ0FBQyxhQUFhLEVBQUUsYUFBUztLQUN4Qzs7Ozs7V0FHZSwyQkFBRztBQUNqQixhQUFVLElBQUksQ0FBQyxhQUFhLEVBQUUsWUFBUTtLQUN2Qzs7Ozs7V0FHZ0IsNEJBQUc7QUFDbEIsYUFBVSxJQUFJLENBQUMsYUFBYSxFQUFFLGlCQUFZLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUU7S0FDbkY7OztXQUVjLDBCQUFnQjtVQUFmLFFBQVEseURBQUcsRUFBRTs7QUFDM0IsYUFBTyxRQUFRLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxVQUFBLE9BQU87ZUFBSSxrQkFBa0IsQ0FBQyxPQUFPLENBQUM7T0FBQSxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFBO0tBQ2pGOzs7OztXQUdlLDJCQUFvQjtVQUFuQixZQUFZLHlEQUFHLEVBQUU7O0FBQ2hDLGFBQU8sa0JBQUssS0FBSyxDQUFDLFlBQVksQ0FBQyxDQUFDLElBQUksQ0FBQTtLQUNyQzs7Ozs7V0FHTSxrQkFBRztBQUNSLFVBQU0sVUFBVSxHQUFHLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQTtBQUNwQyxVQUFJLFVBQVUsSUFBSSxJQUFJLEVBQUU7QUFDdEIsZUFBTyxJQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsYUFBVyxVQUFVLFdBQVEsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFBO09BQzNFLE1BQU07QUFDTCxlQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxzQkFBc0IsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFBO09BQ3BFO0tBQ0Y7Ozs7O1dBR2EseUJBQUc7QUFDZixVQUFJLEdBQUcsR0FBRyxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUE7O0FBRXZCLFVBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsRUFBRTs7QUFDM0IsV0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsb0JBQW9CLEVBQUUsVUFBQyxLQUFLLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBSztBQUNqRSxrQkFBUSxHQUFHLFFBQVEsQ0FBQyxPQUFPLENBQUMsTUFBTSxFQUFFLEVBQUUsQ0FBQyxDQUFBO0FBQ3ZDLDhCQUFrQixJQUFJLFNBQUksUUFBUSxDQUFFO1NBQ3JDLENBQUMsQ0FBQTtPQUNILE1BQU0sSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLHdCQUF3QixDQUFDLEVBQUU7O0FBQzlDLGFBQUcsZ0JBQWMsR0FBRyxDQUFDLFNBQVMsQ0FBQyxFQUFFLENBQUMsQUFBRSxDQUFBO1NBQ3JDLE1BQU0sSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUFDLEVBQUU7O0FBQ3hDLGVBQUcsYUFBVyxHQUFHLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxBQUFFLENBQUE7V0FDakMsTUFBTSxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsRUFBRTs7QUFDeEMsaUJBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGtCQUFrQixFQUFFLFVBQVUsQ0FBQyxDQUFBO2FBQ2xEOzs7QUFHRCxTQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsRUFBRSxDQUFDLENBQUMsT0FBTyxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUMsQ0FBQTs7QUFFbkQsU0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsU0FBUyxFQUFFLE9BQU8sQ0FBQyxDQUFBOztBQUVyQyxVQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxHQUFHLENBQUMsRUFBRTtBQUM3QixlQUFPLEdBQUcsQ0FBQTtPQUNYO0tBQ0Y7OztXQUVTLG1CQUFDLEdBQUcsRUFBRTtBQUNkLFVBQUk7d0JBQ2EsZ0JBQVMsR0FBRyxDQUFDOztZQUFyQixJQUFJLGFBQUosSUFBSTs7QUFFWCxlQUFPLElBQUksS0FBSyxpQkFBaUIsQ0FBQTtPQUNsQyxDQUFDLE9BQU8sS0FBSyxFQUFFO0FBQ2QsZUFBTyxLQUFLLENBQUE7T0FDYjtLQUNGOzs7V0FFZSx5QkFBQyxHQUFHLEVBQUU7QUFDcEIsYUFBTyxVQUFTLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztRQUFBO0tBQzNCOzs7V0FFYyx3QkFBQyxHQUFHLEVBQUU7QUFDbkIsVUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLEVBQUU7QUFDdkMsZUFBTyxJQUFJLENBQUE7T0FDWjs7QUFFRCxVQUFJO3lCQUNhLGdCQUFTLEdBQUcsQ0FBQzs7WUFBckIsSUFBSSxjQUFKLElBQUk7O0FBRVgsZUFBTyxJQUFJLEtBQUssZUFBZSxDQUFBO09BQ2hDLENBQUMsT0FBTyxLQUFLLEVBQUU7QUFDZCxlQUFPLEtBQUssQ0FBQTtPQUNiO0tBQ0Y7Ozs7O1dBR2dCLDRCQUFHO0FBQ2xCLGFBQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUE7S0FDbEU7Ozs7O1dBR1Usc0JBQUc7QUFDWixVQUFNLGVBQWUsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyw0QkFBNEIsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUE7O0FBRTdGLFVBQUksZUFBZSxFQUFFO0FBQ25CLGVBQU8sZUFBZSxDQUFBO09BQ3ZCOztBQUVELFVBQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQTs7QUFFekQsVUFBSSxDQUFDLFdBQVcsRUFBRTtBQUNoQixlQUFPLElBQUksQ0FBQTtPQUNaOztBQUVELFVBQU0sWUFBWSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxhQUFXLFdBQVcsY0FBVyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUE7O0FBRTVGLFVBQUksWUFBWSxJQUFJLFlBQVksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO0FBQzNDLGVBQU8sWUFBWSxDQUFBO09BQ3BCOztBQUVELGFBQU8sSUFBSSxDQUFBO0tBQ1o7Ozs7O1dBR0csZUFBRztBQUNMLGFBQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFBO0tBQzNEOzs7OztXQUdVLHNCQUFHO0FBQ1osVUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFBOztBQUV6RCxVQUFJLENBQUMsV0FBVyxFQUFFO0FBQ2hCLGVBQU8sSUFBSSxDQUFBO09BQ1o7O0FBRUQsVUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLGFBQVcsV0FBVyxhQUFVLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQTtBQUMxRixVQUFJLEVBQUUsV0FBVyxJQUFJLFdBQVcsQ0FBQyxNQUFNLEdBQUcsRUFBRSxDQUFBLEFBQUMsRUFBRTtBQUM3QyxlQUFPLFdBQVcsQ0FBQTtPQUNuQjs7QUFFRCxVQUFJLFdBQVcsQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxFQUFFO0FBQzVDLGVBQU8sV0FBVyxDQUFBO09BQ25COztBQUVELGFBQU8sV0FBVyxDQUFDLFNBQVMsQ0FBQyxFQUFFLENBQUMsQ0FBQTtLQUNqQzs7Ozs7V0FHZ0IsNEJBQUc7QUFDbEIsVUFBTSxlQUFlLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsNEJBQTRCLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFBOztBQUU3RixVQUFJLGVBQWUsRUFBRTtBQUNuQixlQUFPLGVBQWUsQ0FBQTtPQUN2QixNQUFNLElBQUksSUFBSSxDQUFDLFVBQVUsRUFBRSxJQUFJLElBQUksRUFBRTtBQUNwQyxlQUFPLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUE7T0FDOUMsTUFBTTtBQUNMLGVBQU8sUUFBUSxDQUFBO09BQ2hCO0tBQ0Y7OztTQWxXa0IsVUFBVTs7O3FCQUFWLFVBQVUiLCJmaWxlIjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNC4wL291dC9hcHAvbm9kZV9tb2R1bGVzL29wZW4tb24tZ2l0aHViL2xpYi9naXRodWItZmlsZS5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAYmFiZWwgKi9cblxuaW1wb3J0IHtzaGVsbH0gZnJvbSAnZWxlY3Ryb24nXG5pbXBvcnQge1JhbmdlfSBmcm9tICdhdG9tJ1xuaW1wb3J0IHtwYXJzZSBhcyBwYXJzZVVSTH0gZnJvbSAndXJsJ1xuaW1wb3J0IHBhdGggZnJvbSAncGF0aCdcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgR2l0SHViRmlsZSB7XG4gIC8vIFB1YmxpY1xuICBzdGF0aWMgZnJvbVBhdGggKGZpbGVQYXRoKSB7XG4gICAgcmV0dXJuIG5ldyBHaXRIdWJGaWxlKGZpbGVQYXRoKVxuICB9XG5cbiAgY29uc3RydWN0b3IgKGZpbGVQYXRoKSB7XG4gICAgdGhpcy5maWxlUGF0aCA9IGZpbGVQYXRoXG4gICAgY29uc3QgW3Jvb3REaXJdID0gYXRvbS5wcm9qZWN0LnJlbGF0aXZpemVQYXRoKHRoaXMuZmlsZVBhdGgpXG5cbiAgICBpZiAocm9vdERpciAhPSBudWxsKSB7XG4gICAgICBjb25zdCByb290RGlySW5kZXggPSBhdG9tLnByb2plY3QuZ2V0UGF0aHMoKS5pbmRleE9mKHJvb3REaXIpXG4gICAgICB0aGlzLnJlcG8gPSBhdG9tLnByb2plY3QuZ2V0UmVwb3NpdG9yaWVzKClbcm9vdERpckluZGV4XVxuICAgICAgdGhpcy50eXBlID0gJ25vbmUnXG4gICAgICBpZiAodGhpcy5yZXBvICYmIHRoaXMuZ2l0VVJMKCkpIHtcbiAgICAgICAgaWYgKHRoaXMuaXNHaXRIdWJXaWtpVVJMKHRoaXMuZ2l0aHViUmVwb1VSTCgpKSkge1xuICAgICAgICAgIHRoaXMudHlwZSA9ICd3aWtpJ1xuICAgICAgICB9IGVsc2UgaWYgKHRoaXMuaXNHaXN0VVJMKHRoaXMuZ2l0aHViUmVwb1VSTCgpKSkge1xuICAgICAgICAgIHRoaXMudHlwZSA9ICdnaXN0J1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIHRoaXMudHlwZSA9ICdyZXBvJ1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgLy8gUHVibGljXG4gIG9wZW4gKGxpbmVSYW5nZSkge1xuICAgIGlmICh0aGlzLnZhbGlkYXRlUmVwbygpKSB7XG4gICAgICB0aGlzLm9wZW5VUkxJbkJyb3dzZXIodGhpcy5ibG9iVVJMKCkgKyB0aGlzLmdldExpbmVSYW5nZVN1ZmZpeChsaW5lUmFuZ2UpKVxuICAgIH1cbiAgfVxuXG4gIC8vIFB1YmxpY1xuICBvcGVuT25NYXN0ZXIgKGxpbmVSYW5nZSkge1xuICAgIGlmICh0aGlzLnZhbGlkYXRlUmVwbygpKSB7XG4gICAgICB0aGlzLm9wZW5VUkxJbkJyb3dzZXIodGhpcy5ibG9iVVJMRm9yTWFzdGVyKCkgKyB0aGlzLmdldExpbmVSYW5nZVN1ZmZpeChsaW5lUmFuZ2UpKVxuICAgIH1cbiAgfVxuXG4gIC8vIFB1YmxpY1xuICBibGFtZSAobGluZVJhbmdlKSB7XG4gICAgaWYgKHRoaXMudmFsaWRhdGVSZXBvKCkpIHtcbiAgICAgIGlmICh0aGlzLnR5cGUgPT09ICdyZXBvJykge1xuICAgICAgICB0aGlzLm9wZW5VUkxJbkJyb3dzZXIodGhpcy5ibGFtZVVSTCgpICsgdGhpcy5nZXRMaW5lUmFuZ2VTdWZmaXgobGluZVJhbmdlKSlcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIGF0b20ubm90aWZpY2F0aW9ucy5hZGRXYXJuaW5nKGBCbGFtZXMgZG8gbm90IGV4aXN0IGZvciAke3RoaXMudHlwZX1zYClcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBoaXN0b3J5ICgpIHtcbiAgICBpZiAodGhpcy52YWxpZGF0ZVJlcG8oKSkge1xuICAgICAgdGhpcy5vcGVuVVJMSW5Ccm93c2VyKHRoaXMuaGlzdG9yeVVSTCgpKVxuICAgIH1cbiAgfVxuXG4gIGNvcHlVUkwgKGxpbmVSYW5nZSkge1xuICAgIGlmICh0aGlzLnZhbGlkYXRlUmVwbygpKSB7XG4gICAgICBhdG9tLmNsaXBib2FyZC53cml0ZSh0aGlzLnNoYVVSTCgpICsgdGhpcy5nZXRMaW5lUmFuZ2VTdWZmaXgobGluZVJhbmdlKSlcbiAgICB9XG4gIH1cblxuICBvcGVuQnJhbmNoQ29tcGFyZSAoKSB7XG4gICAgaWYgKHRoaXMudmFsaWRhdGVSZXBvKCkpIHtcbiAgICAgIGlmICh0aGlzLnR5cGUgPT09ICdyZXBvJykge1xuICAgICAgICB0aGlzLm9wZW5VUkxJbkJyb3dzZXIodGhpcy5icmFuY2hDb21wYXJlVVJMKCkpXG4gICAgICB9IGVsc2Uge1xuICAgICAgICBhdG9tLm5vdGlmaWNhdGlvbnMuYWRkV2FybmluZyhgQnJhbmNoZXMgZG8gbm90IGV4aXN0IGZvciAke3RoaXMudHlwZX1zYClcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBvcGVuSXNzdWVzICgpIHtcbiAgICBpZiAodGhpcy52YWxpZGF0ZVJlcG8oKSkge1xuICAgICAgaWYgKHRoaXMudHlwZSA9PT0gJ3JlcG8nKSB7XG4gICAgICAgIHRoaXMub3BlblVSTEluQnJvd3Nlcih0aGlzLmlzc3Vlc1VSTCgpKVxuICAgICAgfSBlbHNlIHtcbiAgICAgICAgYXRvbS5ub3RpZmljYXRpb25zLmFkZFdhcm5pbmcoYElzc3VlcyBkbyBub3QgZXhpc3QgZm9yICR7dGhpcy50eXBlfXNgKVxuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gIG9wZW5QdWxsUmVxdWVzdHMgKCkge1xuICAgIGlmICh0aGlzLnZhbGlkYXRlUmVwbygpKSB7XG4gICAgICBpZiAodGhpcy50eXBlID09PSAncmVwbycpIHtcbiAgICAgICAgdGhpcy5vcGVuVVJMSW5Ccm93c2VyKHRoaXMucHVsbFJlcXVlc3RzVVJMKCkpXG4gICAgICB9IGVsc2Uge1xuICAgICAgICBhdG9tLm5vdGlmaWNhdGlvbnMuYWRkV2FybmluZyhgUHVsbCByZXF1ZXN0cyBkbyBub3QgZXhpc3QgZm9yICR7dGhpcy50eXBlfXNgKVxuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gIG9wZW5SZXBvc2l0b3J5ICgpIHtcbiAgICBpZiAodGhpcy52YWxpZGF0ZVJlcG8oKSkge1xuICAgICAgdGhpcy5vcGVuVVJMSW5Ccm93c2VyKHRoaXMuZ2l0aHViUmVwb1VSTCgpKVxuICAgIH1cbiAgfVxuXG4gIGdldExpbmVSYW5nZVN1ZmZpeCAobGluZVJhbmdlKSB7XG4gICAgaWYgKGxpbmVSYW5nZSAmJiB0aGlzLnR5cGUgIT09ICd3aWtpJyAmJiBhdG9tLmNvbmZpZy5nZXQoJ29wZW4tb24tZ2l0aHViLmluY2x1ZGVMaW5lTnVtYmVyc0luVXJscycpKSB7XG4gICAgICBsaW5lUmFuZ2UgPSBSYW5nZS5mcm9tT2JqZWN0KGxpbmVSYW5nZSlcbiAgICAgIGNvbnN0IHN0YXJ0Um93ID0gbGluZVJhbmdlLnN0YXJ0LnJvdyArIDFcbiAgICAgIGNvbnN0IGVuZFJvdyA9IGxpbmVSYW5nZS5lbmQucm93ICsgMVxuXG4gICAgICBpZiAoc3RhcnRSb3cgPT09IGVuZFJvdykge1xuICAgICAgICBpZiAodGhpcy50eXBlID09PSAnZ2lzdCcpIHtcbiAgICAgICAgICByZXR1cm4gYC1MJHtzdGFydFJvd31gXG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgcmV0dXJuIGAjTCR7c3RhcnRSb3d9YFxuICAgICAgICB9XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBpZiAodGhpcy50eXBlID09PSAnZ2lzdCcpIHtcbiAgICAgICAgICByZXR1cm4gYC1MJHtzdGFydFJvd30tTCR7ZW5kUm93fWBcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICByZXR1cm4gYCNMJHtzdGFydFJvd30tTCR7ZW5kUm93fWBcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gJydcbiAgICB9XG4gIH1cblxuICAvLyBJbnRlcm5hbFxuICB2YWxpZGF0ZVJlcG8gKCkge1xuICAgIGlmICghdGhpcy5yZXBvKSB7XG4gICAgICBhdG9tLm5vdGlmaWNhdGlvbnMuYWRkV2FybmluZyhgTm8gcmVwb3NpdG9yeSBmb3VuZCBmb3IgcGF0aDogJHt0aGlzLmZpbGVQYXRofS5gKVxuICAgICAgcmV0dXJuIGZhbHNlXG4gICAgfSBlbHNlIGlmICghdGhpcy5naXRVUkwoKSkge1xuICAgICAgYXRvbS5ub3RpZmljYXRpb25zLmFkZFdhcm5pbmcoYE5vIFVSTCBkZWZpbmVkIGZvciByZW1vdGU6ICR7dGhpcy5yZW1vdGVOYW1lKCl9YClcbiAgICAgIHJldHVybiBmYWxzZVxuICAgIH0gZWxzZSBpZiAoIXRoaXMuZ2l0aHViUmVwb1VSTCgpKSB7XG4gICAgICBhdG9tLm5vdGlmaWNhdGlvbnMuYWRkV2FybmluZyhgUmVtb3RlIFVSTCBpcyBub3QgaG9zdGVkIG9uIEdpdEh1YjogJHt0aGlzLmdpdFVSTCgpfWApXG4gICAgICByZXR1cm4gZmFsc2VcbiAgICB9XG4gICAgcmV0dXJuIHRydWVcbiAgfVxuXG4gIC8vIEludGVybmFsXG4gIG9wZW5VUkxJbkJyb3dzZXIgKHVybCkge1xuICAgIHNoZWxsLm9wZW5FeHRlcm5hbCh1cmwpXG4gIH1cblxuICAvLyBJbnRlcm5hbFxuICBibG9iVVJMICgpIHtcbiAgICBjb25zdCBnaXRIdWJSZXBvVVJMID0gdGhpcy5naXRodWJSZXBvVVJMKClcbiAgICBjb25zdCByZXBvUmVsYXRpdmVQYXRoID0gdGhpcy5yZXBvUmVsYXRpdmVQYXRoKClcblxuICAgIGlmICh0aGlzLnR5cGUgPT09ICd3aWtpJykge1xuICAgICAgcmV0dXJuIGAke2dpdEh1YlJlcG9VUkx9LyR7dGhpcy5leHRyYWN0RmlsZU5hbWUocmVwb1JlbGF0aXZlUGF0aCl9YFxuICAgIH0gZWxzZSBpZiAodGhpcy50eXBlID09PSAnZ2lzdCcpIHtcbiAgICAgIHJldHVybiBgJHtnaXRIdWJSZXBvVVJMfSNmaWxlLSR7dGhpcy5lbmNvZGVTZWdtZW50cyhyZXBvUmVsYXRpdmVQYXRoLnJlcGxhY2UoL1xcLi9nLCAnLScpKX1gXG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBgJHtnaXRIdWJSZXBvVVJMfS9ibG9iLyR7dGhpcy5yZW1vdGVCcmFuY2hOYW1lKCl9LyR7dGhpcy5lbmNvZGVTZWdtZW50cyhyZXBvUmVsYXRpdmVQYXRoKX1gXG4gICAgfVxuICB9XG5cbiAgLy8gSW50ZXJuYWxcbiAgYmxvYlVSTEZvck1hc3RlciAoKSB7XG4gICAgY29uc3QgZ2l0SHViUmVwb1VSTCA9IHRoaXMuZ2l0aHViUmVwb1VSTCgpXG5cbiAgICBpZiAodGhpcy50eXBlID09PSAncmVwbycpIHtcbiAgICAgIHJldHVybiBgJHtnaXRIdWJSZXBvVVJMfS9ibG9iL21hc3Rlci8ke3RoaXMuZW5jb2RlU2VnbWVudHModGhpcy5yZXBvUmVsYXRpdmVQYXRoKCkpfWBcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIHRoaXMuYmxvYlVSTCgpIC8vIE9ubHkgcmVwb3MgaGF2ZSBicmFuY2hlc1xuICAgIH1cbiAgfVxuXG4gIC8vIEludGVybmFsXG4gIHNoYVVSTCAoKSB7XG4gICAgY29uc3QgZ2l0SHViUmVwb1VSTCA9IHRoaXMuZ2l0aHViUmVwb1VSTCgpXG4gICAgY29uc3QgZW5jb2RlZFNIQSA9IHRoaXMuZW5jb2RlU2VnbWVudHModGhpcy5zaGEoKSlcbiAgICBjb25zdCByZXBvUmVsYXRpdmVQYXRoID0gdGhpcy5yZXBvUmVsYXRpdmVQYXRoKClcblxuICAgIGlmICh0aGlzLnR5cGUgPT09ICd3aWtpJykge1xuICAgICAgcmV0dXJuIGAke2dpdEh1YlJlcG9VUkx9LyR7dGhpcy5leHRyYWN0RmlsZU5hbWUocmVwb1JlbGF0aXZlUGF0aCl9LyR7ZW5jb2RlZFNIQX1gXG4gICAgfSBlbHNlIGlmICh0aGlzLnR5cGUgPT09ICdnaXN0Jykge1xuICAgICAgcmV0dXJuIGAke2dpdEh1YlJlcG9VUkx9LyR7ZW5jb2RlZFNIQX0jZmlsZS0ke3RoaXMuZW5jb2RlU2VnbWVudHMocmVwb1JlbGF0aXZlUGF0aC5yZXBsYWNlKC9cXC4vZywgJy0nKSl9YFxuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gYCR7Z2l0SHViUmVwb1VSTH0vYmxvYi8ke2VuY29kZWRTSEF9LyR7dGhpcy5lbmNvZGVTZWdtZW50cyhyZXBvUmVsYXRpdmVQYXRoKX1gXG4gICAgfVxuICB9XG5cbiAgLy8gSW50ZXJuYWxcbiAgYmxhbWVVUkwgKCkge1xuICAgIHJldHVybiBgJHt0aGlzLmdpdGh1YlJlcG9VUkwoKX0vYmxhbWUvJHt0aGlzLnJlbW90ZUJyYW5jaE5hbWUoKX0vJHt0aGlzLmVuY29kZVNlZ21lbnRzKHRoaXMucmVwb1JlbGF0aXZlUGF0aCgpKX1gXG4gIH1cblxuICAvLyBJbnRlcm5hbFxuICBoaXN0b3J5VVJMICgpIHtcbiAgICBjb25zdCBnaXRIdWJSZXBvVVJMID0gdGhpcy5naXRodWJSZXBvVVJMKClcblxuICAgIGlmICh0aGlzLnR5cGUgPT09ICd3aWtpJykge1xuICAgICAgcmV0dXJuIGAke2dpdEh1YlJlcG9VUkx9LyR7dGhpcy5leHRyYWN0RmlsZU5hbWUodGhpcy5yZXBvUmVsYXRpdmVQYXRoKCkpfS9faGlzdG9yeWBcbiAgICB9IGVsc2UgaWYgKHRoaXMudHlwZSA9PT0gJ2dpc3QnKSB7XG4gICAgICByZXR1cm4gYCR7Z2l0SHViUmVwb1VSTH0vcmV2aXNpb25zYFxuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gYCR7Z2l0SHViUmVwb1VSTH0vY29tbWl0cy8ke3RoaXMucmVtb3RlQnJhbmNoTmFtZSgpfS8ke3RoaXMuZW5jb2RlU2VnbWVudHModGhpcy5yZXBvUmVsYXRpdmVQYXRoKCkpfWBcbiAgICB9XG4gIH1cblxuICAvLyBJbnRlcm5hbFxuICBpc3N1ZXNVUkwgKCkge1xuICAgIHJldHVybiBgJHt0aGlzLmdpdGh1YlJlcG9VUkwoKX0vaXNzdWVzYFxuICB9XG5cbiAgLy8gSW50ZXJuYWxcbiAgcHVsbFJlcXVlc3RzVVJMICgpIHtcbiAgICByZXR1cm4gYCR7dGhpcy5naXRodWJSZXBvVVJMKCl9L3B1bGxzYFxuICB9XG5cbiAgLy8gSW50ZXJuYWxcbiAgYnJhbmNoQ29tcGFyZVVSTCAoKSB7XG4gICAgcmV0dXJuIGAke3RoaXMuZ2l0aHViUmVwb1VSTCgpfS9jb21wYXJlLyR7dGhpcy5lbmNvZGVTZWdtZW50cyh0aGlzLmJyYW5jaE5hbWUoKSl9YFxuICB9XG5cbiAgZW5jb2RlU2VnbWVudHMgKHNlZ21lbnRzID0gJycpIHtcbiAgICByZXR1cm4gc2VnbWVudHMuc3BsaXQoJy8nKS5tYXAoc2VnbWVudCA9PiBlbmNvZGVVUklDb21wb25lbnQoc2VnbWVudCkpLmpvaW4oJy8nKVxuICB9XG5cbiAgLy8gSW50ZXJuYWxcbiAgZXh0cmFjdEZpbGVOYW1lIChyZWxhdGl2ZVBhdGggPSAnJykge1xuICAgIHJldHVybiBwYXRoLnBhcnNlKHJlbGF0aXZlUGF0aCkubmFtZVxuICB9XG5cbiAgLy8gSW50ZXJuYWxcbiAgZ2l0VVJMICgpIHtcbiAgICBjb25zdCByZW1vdGVOYW1lID0gdGhpcy5yZW1vdGVOYW1lKClcbiAgICBpZiAocmVtb3RlTmFtZSAhPSBudWxsKSB7XG4gICAgICByZXR1cm4gdGhpcy5yZXBvLmdldENvbmZpZ1ZhbHVlKGByZW1vdGUuJHtyZW1vdGVOYW1lfS51cmxgLCB0aGlzLmZpbGVQYXRoKVxuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gdGhpcy5yZXBvLmdldENvbmZpZ1ZhbHVlKGByZW1vdGUub3JpZ2luLnVybGAsIHRoaXMuZmlsZVBhdGgpXG4gICAgfVxuICB9XG5cbiAgLy8gSW50ZXJuYWxcbiAgZ2l0aHViUmVwb1VSTCAoKSB7XG4gICAgbGV0IHVybCA9IHRoaXMuZ2l0VVJMKClcblxuICAgIGlmICh1cmwubWF0Y2goL2dpdEBbXjpdKzovKSkgeyAvLyBnaXRAZ2l0aHViLmNvbTp1c2VyL3JlcG8uZ2l0XG4gICAgICB1cmwgPSB1cmwucmVwbGFjZSgvXmdpdEAoW146XSspOiguKykkLywgKG1hdGNoLCBob3N0LCByZXBvUGF0aCkgPT4ge1xuICAgICAgICByZXBvUGF0aCA9IHJlcG9QYXRoLnJlcGxhY2UoL15cXC8rLywgJycpXG4gICAgICAgIHJldHVybiBgaHR0cHM6Ly8ke2hvc3R9LyR7cmVwb1BhdGh9YCAvLyAtPiBodHRwczovL2dpdGh1Yi5jb20vdXNlci9yZXBvLmdpdFxuICAgICAgfSlcbiAgICB9IGVsc2UgaWYgKHVybC5tYXRjaCgvXnNzaDpcXC9cXC9naXRAKFteL10rKVxcLy8pKSB7IC8vIHNzaDovL2dpdEBnaXRodWIuY29tL3VzZXIvcmVwby5naXRcbiAgICAgIHVybCA9IGBodHRwczovLyR7dXJsLnN1YnN0cmluZygxMCl9YCAvLyAtPiBodHRwczovL2dpdGh1Yi5jb20vdXNlci9yZXBvLmdpdFxuICAgIH0gZWxzZSBpZiAodXJsLm1hdGNoKC9eZ2l0OlxcL1xcL1teL10rXFwvLykpIHsgLy8gZ2l0Oi8vZ2l0aHViLmNvbS91c2VyL3JlcG8uZ2l0XG4gICAgICB1cmwgPSBgaHR0cHMke3VybC5zdWJzdHJpbmcoMyl9YCAvLyAtPiBodHRwczovL2dpdGh1Yi5jb20vdXNlci9yZXBvLmdpdFxuICAgIH0gZWxzZSBpZiAodXJsLm1hdGNoKC9eaHR0cHM/OlxcL1xcL1xcdytALykpIHsgLy8gaHR0cHM6Ly91c2VyQGdpdGh1Yi5jb20vdXNlci9yZXBvLmdpdFxuICAgICAgdXJsID0gdXJsLnJlcGxhY2UoL15odHRwcz86XFwvXFwvXFx3K0AvLCAnaHR0cHM6Ly8nKSAvLyAtPiBodHRwczovL2dpdGh1Yi5jb20vdXNlci9yZXBvLmdpdFxuICAgIH1cblxuICAgIC8vIFJlbW92ZSB0cmFpbGluZyAuZ2l0IGFuZCB0cmFpbGluZyBzbGFzaGVzXG4gICAgdXJsID0gdXJsLnJlcGxhY2UoL1xcLmdpdCQvLCAnJykucmVwbGFjZSgvXFwvKyQvLCAnJylcbiAgICAvLyBDaGFuZ2UgLndpa2kgdG8gL3dpa2lcbiAgICB1cmwgPSB1cmwucmVwbGFjZSgvXFwud2lraSQvLCAnL3dpa2knKVxuXG4gICAgaWYgKCF0aGlzLmlzQml0YnVja2V0VVJMKHVybCkpIHtcbiAgICAgIHJldHVybiB1cmxcbiAgICB9XG4gIH1cblxuICBpc0dpc3RVUkwgKHVybCkge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCB7aG9zdH0gPSBwYXJzZVVSTCh1cmwpXG5cbiAgICAgIHJldHVybiBob3N0ID09PSAnZ2lzdC5naXRodWIuY29tJ1xuICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICByZXR1cm4gZmFsc2VcbiAgICB9XG4gIH1cblxuICBpc0dpdEh1Yldpa2lVUkwgKHVybCkge1xuICAgIHJldHVybiAvXFwvd2lraSQvLnRlc3QodXJsKVxuICB9XG5cbiAgaXNCaXRidWNrZXRVUkwgKHVybCkge1xuICAgIGlmICh1cmwuc3RhcnRzV2l0aCgnZ2l0QGJpdGJ1Y2tldC5vcmcnKSkge1xuICAgICAgcmV0dXJuIHRydWVcbiAgICB9XG5cbiAgICB0cnkge1xuICAgICAgY29uc3Qge2hvc3R9ID0gcGFyc2VVUkwodXJsKVxuXG4gICAgICByZXR1cm4gaG9zdCA9PT0gJ2JpdGJ1Y2tldC5vcmcnXG4gICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgIHJldHVybiBmYWxzZVxuICAgIH1cbiAgfVxuXG4gIC8vIEludGVybmFsXG4gIHJlcG9SZWxhdGl2ZVBhdGggKCkge1xuICAgIHJldHVybiB0aGlzLnJlcG8uZ2V0UmVwbyh0aGlzLmZpbGVQYXRoKS5yZWxhdGl2aXplKHRoaXMuZmlsZVBhdGgpXG4gIH1cblxuICAvLyBJbnRlcm5hbFxuICByZW1vdGVOYW1lICgpIHtcbiAgICBjb25zdCBnaXRDb25maWdSZW1vdGUgPSB0aGlzLnJlcG8uZ2V0Q29uZmlnVmFsdWUoJ2F0b20ub3Blbi1vbi1naXRodWIucmVtb3RlJywgdGhpcy5maWxlUGF0aClcblxuICAgIGlmIChnaXRDb25maWdSZW1vdGUpIHtcbiAgICAgIHJldHVybiBnaXRDb25maWdSZW1vdGVcbiAgICB9XG5cbiAgICBjb25zdCBzaG9ydEJyYW5jaCA9IHRoaXMucmVwby5nZXRTaG9ydEhlYWQodGhpcy5maWxlUGF0aClcblxuICAgIGlmICghc2hvcnRCcmFuY2gpIHtcbiAgICAgIHJldHVybiBudWxsXG4gICAgfVxuXG4gICAgY29uc3QgYnJhbmNoUmVtb3RlID0gdGhpcy5yZXBvLmdldENvbmZpZ1ZhbHVlKGBicmFuY2guJHtzaG9ydEJyYW5jaH0ucmVtb3RlYCwgdGhpcy5maWxlUGF0aClcblxuICAgIGlmIChicmFuY2hSZW1vdGUgJiYgYnJhbmNoUmVtb3RlLmxlbmd0aCA+IDApIHtcbiAgICAgIHJldHVybiBicmFuY2hSZW1vdGVcbiAgICB9XG5cbiAgICByZXR1cm4gbnVsbFxuICB9XG5cbiAgLy8gSW50ZXJuYWxcbiAgc2hhICgpIHtcbiAgICByZXR1cm4gdGhpcy5yZXBvLmdldFJlZmVyZW5jZVRhcmdldCgnSEVBRCcsIHRoaXMuZmlsZVBhdGgpXG4gIH1cblxuICAvLyBJbnRlcm5hbFxuICBicmFuY2hOYW1lICgpIHtcbiAgICBjb25zdCBzaG9ydEJyYW5jaCA9IHRoaXMucmVwby5nZXRTaG9ydEhlYWQodGhpcy5maWxlUGF0aClcblxuICAgIGlmICghc2hvcnRCcmFuY2gpIHtcbiAgICAgIHJldHVybiBudWxsXG4gICAgfVxuXG4gICAgY29uc3QgYnJhbmNoTWVyZ2UgPSB0aGlzLnJlcG8uZ2V0Q29uZmlnVmFsdWUoYGJyYW5jaC4ke3Nob3J0QnJhbmNofS5tZXJnZWAsIHRoaXMuZmlsZVBhdGgpXG4gICAgaWYgKCEoYnJhbmNoTWVyZ2UgJiYgYnJhbmNoTWVyZ2UubGVuZ3RoID4gMTEpKSB7XG4gICAgICByZXR1cm4gc2hvcnRCcmFuY2hcbiAgICB9XG5cbiAgICBpZiAoYnJhbmNoTWVyZ2UuaW5kZXhPZigncmVmcy9oZWFkcy8nKSAhPT0gMCkge1xuICAgICAgcmV0dXJuIHNob3J0QnJhbmNoXG4gICAgfVxuXG4gICAgcmV0dXJuIGJyYW5jaE1lcmdlLnN1YnN0cmluZygxMSlcbiAgfVxuXG4gIC8vIEludGVybmFsXG4gIHJlbW90ZUJyYW5jaE5hbWUgKCkge1xuICAgIGNvbnN0IGdpdENvbmZpZ0JyYW5jaCA9IHRoaXMucmVwby5nZXRDb25maWdWYWx1ZSgnYXRvbS5vcGVuLW9uLWdpdGh1Yi5icmFuY2gnLCB0aGlzLmZpbGVQYXRoKVxuXG4gICAgaWYgKGdpdENvbmZpZ0JyYW5jaCkge1xuICAgICAgcmV0dXJuIGdpdENvbmZpZ0JyYW5jaFxuICAgIH0gZWxzZSBpZiAodGhpcy5yZW1vdGVOYW1lKCkgIT0gbnVsbCkge1xuICAgICAgcmV0dXJuIHRoaXMuZW5jb2RlU2VnbWVudHModGhpcy5icmFuY2hOYW1lKCkpXG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiAnbWFzdGVyJ1xuICAgIH1cbiAgfVxufVxuIl19