(function() {
  var CompositeDisposable, ImageEditor, _, imageExtensions, openURI, path;

  path = require('path');

  _ = require('underscore-plus');

  ImageEditor = require('./image-editor');

  CompositeDisposable = require('atom').CompositeDisposable;

  module.exports = {
    config: {
      defaultBackgroundColor: {
        type: "string",
        "enum": ["white", "black", "transparent"],
        "default": "transparent"
      }
    },
    activate: function() {
      this.statusViewAttached = null;
      this.disposables = new CompositeDisposable;
      this.disposables.add(atom.workspace.addOpener(openURI));
      return this.disposables.add(atom.workspace.getCenter().onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.attachImageEditorStatusView();
        };
      })(this)));
    },
    deactivate: function() {
      var ref;
      if ((ref = this.statusViewAttached) != null) {
        ref.destroy();
      }
      return this.disposables.dispose();
    },
    consumeStatusBar: function(statusBar) {
      this.statusBar = statusBar;
      return this.attachImageEditorStatusView();
    },
    attachImageEditorStatusView: function() {
      var ImageEditorStatusView;
      if (this.statusViewAttached) {
        return;
      }
      if (this.statusBar == null) {
        return;
      }
      if (!(atom.workspace.getCenter().getActivePaneItem() instanceof ImageEditor)) {
        return;
      }
      ImageEditorStatusView = require('./image-editor-status-view');
      this.statusViewAttached = new ImageEditorStatusView(this.statusBar);
      return this.statusViewAttached.attach();
    },
    deserialize: function(state) {
      return ImageEditor.deserialize(state);
    }
  };

  imageExtensions = ['.bmp', '.gif', '.ico', '.jpeg', '.jpg', '.png', '.webp'];

  openURI = function(uriToOpen) {
    var uriExtension;
    uriExtension = path.extname(uriToOpen).toLowerCase();
    if (_.include(imageExtensions, uriExtension)) {
      return new ImageEditor(uriToOpen);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
