Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

// View that renders the image of an {ImageEditor}.

var ImageEditorView = (function () {
  function ImageEditorView(editor) {
    var _this = this;

    _classCallCheck(this, ImageEditorView);

    this.editor = editor;
    this.emitter = new _atom.Emitter();
    this.disposables = new _atom.CompositeDisposable();
    this.imageSize = _fsPlus2['default'].statSync(this.editor.getPath()).size;
    this.loaded = false;
    this.mode = 'zoom-to-fit';
    this.percentageStep = 4;
    this.steps = [0.1, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 2, 3, 4, 5, 7.5, 10];
    _etch2['default'].initialize(this);

    this.refs.image.style.display = 'none';
    this.updateImageURI();

    this.disposables.add(this.editor.onDidChange(function () {
      return _this.updateImageURI();
    }));
    this.disposables.add(atom.commands.add(this.element, {
      'image-view:reload': function imageViewReload() {
        return _this.updateImageURI();
      },
      'image-view:zoom-in': function imageViewZoomIn() {
        return _this.zoomIn();
      },
      'image-view:zoom-out': function imageViewZoomOut() {
        return _this.zoomOut();
      },
      'image-view:zoom-to-fit': function imageViewZoomToFit() {
        return _this.zoomToFit();
      },
      'image-view:reset-zoom': function imageViewResetZoom() {
        return _this.resetZoom();
      },
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.refs.image.onload = function () {
      _this.refs.image.onload = null;
      _this.originalHeight = _this.refs.image.naturalHeight;
      _this.originalWidth = _this.refs.image.naturalWidth;
      _this.loaded = true;
      _this.refs.image.style.display = '';
      _this.defaultBackgroundColor = atom.config.get('image-view.defaultBackgroundColor');
      _this.refs.imageContainer.setAttribute('background', _this.defaultBackgroundColor);
      _this.emitter.emit('did-load');
    };

    this.disposables.add(atom.tooltips.add(this.refs.whiteTransparentBackgroundButton, { title: 'Use white transparent background' }));
    this.disposables.add(atom.tooltips.add(this.refs.blackTransparentBackgroundButton, { title: 'Use black transparent background' }));
    this.disposables.add(atom.tooltips.add(this.refs.transparentTransparentBackgroundButton, { title: 'Use transparent background' }));

    var clickHandler = function clickHandler(event) {
      event.preventDefault();
      event.stopPropagation();
      _this.changeBackground(event.target.value);
    };

    this.refs.whiteTransparentBackgroundButton.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.whiteTransparentBackgroundButton.removeEventListener('click', clickHandler);
    }));
    this.refs.blackTransparentBackgroundButton.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.blackTransparentBackgroundButton.removeEventListener('click', clickHandler);
    }));
    this.refs.transparentTransparentBackgroundButton.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.transparentTransparentBackgroundButton.removeEventListener('click', clickHandler);
    }));

    var zoomInClickHandler = function zoomInClickHandler() {
      _this.zoomIn();
    };
    this.refs.zoomInButton.addEventListener('click', zoomInClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.zoomInButton.removeEventListener('click', zoomInClickHandler);
    }));

    var zoomOutClickHandler = function zoomOutClickHandler() {
      _this.zoomOut();
    };
    this.refs.zoomOutButton.addEventListener('click', zoomOutClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.zoomOutButton.removeEventListener('click', zoomOutClickHandler);
    }));

    var resetZoomClickHandler = function resetZoomClickHandler() {
      _this.resetZoom();
    };
    this.refs.resetZoomButton.addEventListener('click', resetZoomClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.resetZoomButton.removeEventListener('click', resetZoomClickHandler);
    }));

    var zoomToFitClickHandler = function zoomToFitClickHandler() {
      _this.zoomToFit();
    };
    this.refs.zoomToFitButton.addEventListener('click', zoomToFitClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.zoomToFitButton.removeEventListener('click', zoomToFitClickHandler);
    }));
  }

  _createClass(ImageEditorView, [{
    key: 'onDidLoad',
    value: function onDidLoad(callback) {
      return this.emitter.on('did-load', callback);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.emitter.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'image-view', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'image-controls', ref: 'imageControls' },
          _etch2['default'].dom(
            'div',
            { className: 'image-controls-group' },
            _etch2['default'].dom(
              'a',
              { ref: 'whiteTransparentBackgroundButton', className: 'image-controls-color-white', value: 'white' },
              'white'
            ),
            _etch2['default'].dom(
              'a',
              { ref: 'blackTransparentBackgroundButton', className: 'image-controls-color-black', value: 'black' },
              'black'
            ),
            _etch2['default'].dom(
              'a',
              { ref: 'transparentTransparentBackgroundButton', className: 'image-controls-color-transparent', value: 'transparent' },
              'transparent'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'image-controls-group btn-group' },
            _etch2['default'].dom(
              'button',
              { className: 'btn', ref: 'zoomOutButton' },
              '-'
            ),
            _etch2['default'].dom(
              'button',
              { className: 'btn reset-zoom-button', ref: 'resetZoomButton' },
              'Auto'
            ),
            _etch2['default'].dom(
              'button',
              { className: 'btn', ref: 'zoomInButton' },
              '+'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'image-controls-group btn-group' },
            _etch2['default'].dom(
              'button',
              { className: 'btn zoom-to-fit-button selected', ref: 'zoomToFitButton' },
              'Zoom to fit'
            )
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'image-container zoom-to-fit', ref: 'imageContainer' },
          _etch2['default'].dom('img', { ref: 'image' })
        )
      );
    }
  }, {
    key: 'updateImageURI',
    value: function updateImageURI() {
      this.refs.image.src = this.editor.getEncodedURI() + '?time=' + Date.now();
    }

    // Zooms the image out by 25%.
  }, {
    key: 'zoomOut',
    value: function zoomOut() {
      this.percentageStep = Math.max(0, --this.percentageStep);
      this.adjustSize(this.percentageStep);
    }

    // Zooms the image in by 25%.
  }, {
    key: 'zoomIn',
    value: function zoomIn() {
      this.percentageStep = Math.min(this.steps.length - 1, ++this.percentageStep);
      this.adjustSize(this.percentageStep);
    }

    // Zooms the image to its normal width and height.
  }, {
    key: 'resetZoom',
    value: function resetZoom() {
      if (!this.loaded || this.element.offsetHeight === 0) {
        return;
      }

      this.mode = 'reset-zoom';
      this.refs.imageContainer.classList.remove('zoom-to-fit');
      this.refs.zoomToFitButton.classList.remove('selected');
      this.refs.image.style.width = this.originalWidth + 'px';
      this.refs.image.style.height = this.originalHeight + 'px';
      this.refs.resetZoomButton.textContent = '100%';
      this.percentageStep = 4;
    }

    // Zooms to fit the image, doesn't scale beyond actual size
  }, {
    key: 'zoomToFit',
    value: function zoomToFit() {
      if (!this.loaded || this.element.offsetHeight === 0) {
        return;
      }

      this.mode = 'zoom-to-fit';
      this.refs.imageContainer.classList.add('zoom-to-fit');
      this.refs.zoomToFitButton.classList.add('selected');
      this.refs.image.style.width = '';
      this.refs.image.style.height = '';
      this.refs.resetZoomButton.textContent = 'Auto';
      this.percentageStep = 4;
    }

    // Adjust the size of the image by the given multiplying factor.
    //
    // factor - A {Number} to multiply against the current size.
  }, {
    key: 'adjustSize',
    value: function adjustSize(percentageStep) {
      if (!this.loaded || this.element.offsetHeight === 0) {
        return;
      }

      if (this.mode === 'zoom-to-fit') {
        this.mode = 'zoom-manual';
        this.refs.imageContainer.classList.remove('zoom-to-fit');
        this.refs.zoomToFitButton.classList.remove('selected');
      } else if (this.mode === 'reset-zoom') {
        this.mode = 'zoom-manual';
      }

      var factor = this.steps[percentageStep];
      var newWidth = this.originalWidth * factor;
      var newHeight = this.originalHeight * factor;
      var percent = Math.max(1, Math.round(newWidth / this.originalWidth * 100));

      // Switch to pixelated rendering when image is bigger than 200%
      if (newWidth > this.originalWidth * 2) {
        this.refs.image.style.imageRendering = 'pixelated';
      } else {
        this.refs.image.style.imageRendering = '';
      }

      this.refs.image.style.width = newWidth + 'px';
      this.refs.image.style.height = newHeight + 'px';
      this.refs.resetZoomButton.textContent = percent + '%';
    }

    // Changes the background color of the image view.
    //
    // color - A {String} that gets used as class name.
  }, {
    key: 'changeBackground',
    value: function changeBackground(color) {
      if (this.loaded && this.element.offsetHeight > 0 && color) {
        this.refs.imageContainer.setAttribute('background', color);
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.refs.imageContainer.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.refs.imageContainer.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.refs.imageContainer.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.refs.imageContainer.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.refs.imageContainer.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.refs.imageContainer.scrollTop = this.refs.imageContainer.scrollHeight;
    }
  }]);

  return ImageEditorView;
})();

exports['default'] = ImageEditorView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzQuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9pbWFnZS12aWV3L2xpYi9pbWFnZS1lZGl0b3Itdmlldy5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7O3NCQUdlLFNBQVM7Ozs7b0JBQytCLE1BQU07O29CQUM1QyxNQUFNOzs7Ozs7SUFHRixlQUFlO0FBQ3RCLFdBRE8sZUFBZSxDQUNyQixNQUFNLEVBQUU7OzswQkFERixlQUFlOztBQUVoQyxRQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQTtBQUNwQixRQUFJLENBQUMsT0FBTyxHQUFHLG1CQUFhLENBQUE7QUFDNUIsUUFBSSxDQUFDLFdBQVcsR0FBRywrQkFBeUIsQ0FBQTtBQUM1QyxRQUFJLENBQUMsU0FBUyxHQUFHLG9CQUFHLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFBO0FBQ3hELFFBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFBO0FBQ25CLFFBQUksQ0FBQyxJQUFJLEdBQUcsYUFBYSxDQUFBO0FBQ3pCLFFBQUksQ0FBQyxjQUFjLEdBQUcsQ0FBQyxDQUFBO0FBQ3ZCLFFBQUksQ0FBQyxLQUFLLEdBQUcsQ0FBQyxHQUFHLEVBQUUsSUFBSSxFQUFFLEdBQUcsRUFBRSxJQUFJLEVBQUUsR0FBRyxFQUFFLElBQUksRUFBRSxHQUFHLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQTtBQUN4RSxzQkFBSyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUE7O0FBRXJCLFFBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO0FBQ3RDLFFBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQTs7QUFFckIsUUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUM7YUFBTSxNQUFLLGNBQWMsRUFBRTtLQUFBLENBQUMsQ0FBQyxDQUFBO0FBQzFFLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUU7QUFDbkQseUJBQW1CLEVBQUU7ZUFBTSxNQUFLLGNBQWMsRUFBRTtPQUFBO0FBQ2hELDBCQUFvQixFQUFFO2VBQU0sTUFBSyxNQUFNLEVBQUU7T0FBQTtBQUN6QywyQkFBcUIsRUFBRTtlQUFNLE1BQUssT0FBTyxFQUFFO09BQUE7QUFDM0MsOEJBQXdCLEVBQUU7ZUFBTSxNQUFLLFNBQVMsRUFBRTtPQUFBO0FBQ2hELDZCQUF1QixFQUFFO2VBQU0sTUFBSyxTQUFTLEVBQUU7T0FBQTtBQUMvQyxvQkFBYyxFQUFFLHNCQUFNO0FBQUUsY0FBSyxRQUFRLEVBQUUsQ0FBQTtPQUFFO0FBQ3pDLHNCQUFnQixFQUFFLHdCQUFNO0FBQUUsY0FBSyxVQUFVLEVBQUUsQ0FBQTtPQUFFO0FBQzdDLG9CQUFjLEVBQUUsc0JBQU07QUFBRSxjQUFLLE1BQU0sRUFBRSxDQUFBO09BQUU7QUFDdkMsc0JBQWdCLEVBQUUsd0JBQU07QUFBRSxjQUFLLFFBQVEsRUFBRSxDQUFBO09BQUU7QUFDM0Msd0JBQWtCLEVBQUUseUJBQU07QUFBRSxjQUFLLFdBQVcsRUFBRSxDQUFBO09BQUU7QUFDaEQsMkJBQXFCLEVBQUUsNEJBQU07QUFBRSxjQUFLLGNBQWMsRUFBRSxDQUFBO09BQUU7S0FDdkQsQ0FBQyxDQUFDLENBQUE7O0FBRUgsUUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLFlBQU07QUFDN0IsWUFBSyxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUE7QUFDN0IsWUFBSyxjQUFjLEdBQUcsTUFBSyxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBQTtBQUNuRCxZQUFLLGFBQWEsR0FBRyxNQUFLLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFBO0FBQ2pELFlBQUssTUFBTSxHQUFHLElBQUksQ0FBQTtBQUNsQixZQUFLLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUE7QUFDbEMsWUFBSyxzQkFBc0IsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFBO0FBQ2xGLFlBQUssSUFBSSxDQUFDLGNBQWMsQ0FBQyxZQUFZLENBQUMsWUFBWSxFQUFFLE1BQUssc0JBQXNCLENBQUMsQ0FBQTtBQUNoRixZQUFLLE9BQU8sQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUE7S0FDOUIsQ0FBQTs7QUFFRCxRQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLGdDQUFnQyxFQUFFLEVBQUMsS0FBSyxFQUFFLGtDQUFrQyxFQUFDLENBQUMsQ0FBQyxDQUFBO0FBQ2hJLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsZ0NBQWdDLEVBQUUsRUFBQyxLQUFLLEVBQUUsa0NBQWtDLEVBQUMsQ0FBQyxDQUFDLENBQUE7QUFDaEksUUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsRUFBRSxFQUFDLEtBQUssRUFBRSw0QkFBNEIsRUFBQyxDQUFDLENBQUMsQ0FBQTs7QUFFaEksUUFBTSxZQUFZLEdBQUcsU0FBZixZQUFZLENBQUksS0FBSyxFQUFLO0FBQzlCLFdBQUssQ0FBQyxjQUFjLEVBQUUsQ0FBQTtBQUN0QixXQUFLLENBQUMsZUFBZSxFQUFFLENBQUE7QUFDdkIsWUFBSyxnQkFBZ0IsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFBO0tBQzFDLENBQUE7O0FBRUQsUUFBSSxDQUFDLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUE7QUFDbEYsUUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMscUJBQWUsWUFBTTtBQUFFLFlBQUssSUFBSSxDQUFDLGdDQUFnQyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxZQUFZLENBQUMsQ0FBQTtLQUFFLENBQUMsQ0FBQyxDQUFBO0FBQ3JJLFFBQUksQ0FBQyxJQUFJLENBQUMsZ0NBQWdDLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLFlBQVksQ0FBQyxDQUFBO0FBQ2xGLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLHFCQUFlLFlBQU07QUFBRSxZQUFLLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUE7S0FBRSxDQUFDLENBQUMsQ0FBQTtBQUNySSxRQUFJLENBQUMsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSxZQUFZLENBQUMsQ0FBQTtBQUN4RixRQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxxQkFBZSxZQUFNO0FBQUUsWUFBSyxJQUFJLENBQUMsc0NBQXNDLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLFlBQVksQ0FBQyxDQUFBO0tBQUUsQ0FBQyxDQUFDLENBQUE7O0FBRTNJLFFBQU0sa0JBQWtCLEdBQUcsU0FBckIsa0JBQWtCLEdBQVM7QUFDL0IsWUFBSyxNQUFNLEVBQUUsQ0FBQTtLQUNkLENBQUE7QUFDRCxRQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsa0JBQWtCLENBQUMsQ0FBQTtBQUNwRSxRQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxxQkFBZSxZQUFNO0FBQUUsWUFBSyxJQUFJLENBQUMsWUFBWSxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxrQkFBa0IsQ0FBQyxDQUFBO0tBQUUsQ0FBQyxDQUFDLENBQUE7O0FBRXZILFFBQU0sbUJBQW1CLEdBQUcsU0FBdEIsbUJBQW1CLEdBQVM7QUFDaEMsWUFBSyxPQUFPLEVBQUUsQ0FBQTtLQUNmLENBQUE7QUFDRCxRQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsbUJBQW1CLENBQUMsQ0FBQTtBQUN0RSxRQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxxQkFBZSxZQUFNO0FBQUUsWUFBSyxJQUFJLENBQUMsYUFBYSxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxtQkFBbUIsQ0FBQyxDQUFBO0tBQUUsQ0FBQyxDQUFDLENBQUE7O0FBRXpILFFBQU0scUJBQXFCLEdBQUcsU0FBeEIscUJBQXFCLEdBQVM7QUFDbEMsWUFBSyxTQUFTLEVBQUUsQ0FBQTtLQUNqQixDQUFBO0FBQ0QsUUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLHFCQUFxQixDQUFDLENBQUE7QUFDMUUsUUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMscUJBQWUsWUFBTTtBQUFFLFlBQUssSUFBSSxDQUFDLGVBQWUsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUscUJBQXFCLENBQUMsQ0FBQTtLQUFFLENBQUMsQ0FBQyxDQUFBOztBQUU3SCxRQUFNLHFCQUFxQixHQUFHLFNBQXhCLHFCQUFxQixHQUFTO0FBQ2xDLFlBQUssU0FBUyxFQUFFLENBQUE7S0FDakIsQ0FBQTtBQUNELFFBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSxxQkFBcUIsQ0FBQyxDQUFBO0FBQzFFLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLHFCQUFlLFlBQU07QUFBRSxZQUFLLElBQUksQ0FBQyxlQUFlLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLHFCQUFxQixDQUFDLENBQUE7S0FBRSxDQUFDLENBQUMsQ0FBQTtHQUM5SDs7ZUFqRmtCLGVBQWU7O1dBbUZ4QixtQkFBQyxRQUFRLEVBQUU7QUFDbkIsYUFBTyxJQUFJLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxVQUFVLEVBQUUsUUFBUSxDQUFDLENBQUE7S0FDN0M7OztXQUVNLGtCQUFHLEVBQUU7OztXQUVKLG1CQUFHO0FBQ1QsVUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLEVBQUUsQ0FBQTtBQUMxQixVQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxDQUFBO0FBQ3RCLGFBQU8sa0JBQUssT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQzFCOzs7V0FFTSxrQkFBRztBQUNSLGFBQ0U7O1VBQUssU0FBUyxFQUFDLFlBQVksRUFBQyxRQUFRLEVBQUMsSUFBSTtRQUN2Qzs7WUFBSyxTQUFTLEVBQUMsZ0JBQWdCLEVBQUMsR0FBRyxFQUFDLGVBQWU7VUFDakQ7O2NBQUssU0FBUyxFQUFDLHNCQUFzQjtZQUNuQzs7Z0JBQUcsR0FBRyxFQUFDLGtDQUFrQyxFQUFDLFNBQVMsRUFBQyw0QkFBNEIsRUFBQyxLQUFLLEVBQUMsT0FBTzs7YUFBVTtZQUN4Rzs7Z0JBQUcsR0FBRyxFQUFDLGtDQUFrQyxFQUFDLFNBQVMsRUFBQyw0QkFBNEIsRUFBQyxLQUFLLEVBQUMsT0FBTzs7YUFBVTtZQUN4Rzs7Z0JBQUcsR0FBRyxFQUFDLHdDQUF3QyxFQUFDLFNBQVMsRUFBQyxrQ0FBa0MsRUFBQyxLQUFLLEVBQUMsYUFBYTs7YUFBZ0I7V0FDNUg7VUFDTjs7Y0FBSyxTQUFTLEVBQUMsZ0NBQWdDO1lBQzdDOztnQkFBUSxTQUFTLEVBQUMsS0FBSyxFQUFDLEdBQUcsRUFBQyxlQUFlOzthQUFXO1lBQ3REOztnQkFBUSxTQUFTLEVBQUMsdUJBQXVCLEVBQUMsR0FBRyxFQUFDLGlCQUFpQjs7YUFBYztZQUM3RTs7Z0JBQVEsU0FBUyxFQUFDLEtBQUssRUFBQyxHQUFHLEVBQUMsY0FBYzs7YUFBVztXQUNqRDtVQUNOOztjQUFLLFNBQVMsRUFBQyxnQ0FBZ0M7WUFDN0M7O2dCQUFRLFNBQVMsRUFBQyxpQ0FBaUMsRUFBQyxHQUFHLEVBQUMsaUJBQWlCOzthQUFxQjtXQUMxRjtTQUNGO1FBRU47O1lBQUssU0FBUyxFQUFDLDZCQUE2QixFQUFDLEdBQUcsRUFBQyxnQkFBZ0I7VUFDL0QsK0JBQUssR0FBRyxFQUFDLE9BQU8sR0FBTztTQUNuQjtPQUNGLENBQ1A7S0FDRjs7O1dBRWMsMEJBQUc7QUFDaEIsVUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxHQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsYUFBYSxFQUFFLGNBQVMsSUFBSSxDQUFDLEdBQUcsRUFBRSxBQUFFLENBQUE7S0FDMUU7Ozs7O1dBR08sbUJBQUc7QUFDVCxVQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFBO0FBQ3hELFVBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFBO0tBQ3JDOzs7OztXQUdNLGtCQUFHO0FBQ1IsVUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQTtBQUM1RSxVQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQTtLQUNyQzs7Ozs7V0FHUyxxQkFBRztBQUNYLFVBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxLQUFLLENBQUMsRUFBRTtBQUNuRCxlQUFNO09BQ1A7O0FBRUQsVUFBSSxDQUFDLElBQUksR0FBRyxZQUFZLENBQUE7QUFDeEIsVUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQTtBQUN4RCxVQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxDQUFBO0FBQ3RELFVBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUE7QUFDdkQsVUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQTtBQUN6RCxVQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFBO0FBQzlDLFVBQUksQ0FBQyxjQUFjLEdBQUcsQ0FBQyxDQUFBO0tBQ3hCOzs7OztXQUdTLHFCQUFHO0FBQ1gsVUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLEtBQUssQ0FBQyxFQUFFO0FBQ25ELGVBQU07T0FDUDs7QUFFRCxVQUFJLENBQUMsSUFBSSxHQUFHLGFBQWEsQ0FBQTtBQUN6QixVQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyxDQUFBO0FBQ3JELFVBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLENBQUE7QUFDbkQsVUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLEtBQUssR0FBRyxFQUFFLENBQUE7QUFDaEMsVUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLE1BQU0sR0FBRyxFQUFFLENBQUE7QUFDakMsVUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQTtBQUM5QyxVQUFJLENBQUMsY0FBYyxHQUFHLENBQUMsQ0FBQTtLQUN4Qjs7Ozs7OztXQUtVLG9CQUFDLGNBQWMsRUFBRTtBQUMxQixVQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksS0FBSyxDQUFDLEVBQUU7QUFDbkQsZUFBTTtPQUNQOztBQUVELFVBQUksSUFBSSxDQUFDLElBQUksS0FBSyxhQUFhLEVBQUU7QUFDL0IsWUFBSSxDQUFDLElBQUksR0FBRyxhQUFhLENBQUE7QUFDekIsWUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQTtBQUN4RCxZQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxDQUFBO09BQ3ZELE1BQU0sSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLFlBQVksRUFBRTtBQUNyQyxZQUFJLENBQUMsSUFBSSxHQUFHLGFBQWEsQ0FBQTtPQUMxQjs7QUFFRCxVQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQyxDQUFBO0FBQ3pDLFVBQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFBO0FBQzVDLFVBQU0sU0FBUyxHQUFHLElBQUksQ0FBQyxjQUFjLEdBQUcsTUFBTSxDQUFBO0FBQzlDLFVBQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsQUFBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLGFBQWEsR0FBSSxHQUFHLENBQUMsQ0FBQyxDQUFBOzs7QUFHOUUsVUFBSSxRQUFRLEdBQUksSUFBSSxDQUFDLGFBQWEsR0FBRyxDQUFDLEFBQUMsRUFBRTtBQUN2QyxZQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsY0FBYyxHQUFHLFdBQVcsQ0FBQTtPQUNuRCxNQUFNO0FBQ0wsWUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLGNBQWMsR0FBRyxFQUFFLENBQUE7T0FDMUM7O0FBRUQsVUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLEtBQUssR0FBRyxRQUFRLEdBQUcsSUFBSSxDQUFBO0FBQzdDLFVBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxNQUFNLEdBQUcsU0FBUyxHQUFHLElBQUksQ0FBQTtBQUMvQyxVQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLEdBQUcsT0FBTyxHQUFHLEdBQUcsQ0FBQTtLQUN0RDs7Ozs7OztXQUtnQiwwQkFBQyxLQUFLLEVBQUU7QUFDdkIsVUFBSSxJQUFJLENBQUMsTUFBTSxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxHQUFHLENBQUMsSUFBSSxLQUFLLEVBQUU7QUFDekQsWUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsWUFBWSxDQUFDLFlBQVksRUFBRSxLQUFLLENBQUMsQ0FBQTtPQUMzRDtLQUNGOzs7V0FFUSxvQkFBRztBQUNWLFVBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLFNBQVMsSUFBSSxRQUFRLENBQUMsSUFBSSxDQUFDLFlBQVksR0FBRyxFQUFFLENBQUE7S0FDdEU7OztXQUVVLHNCQUFHO0FBQ1osVUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxJQUFJLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBWSxHQUFHLEVBQUUsQ0FBQTtLQUN0RTs7O1dBRU0sa0JBQUc7QUFDUixVQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUE7S0FDaEU7OztXQUVRLG9CQUFHO0FBQ1YsVUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFBO0tBQ2hFOzs7V0FFVyx1QkFBRztBQUNiLFVBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUE7S0FDdkM7OztXQUVjLDBCQUFHO0FBQ2hCLFVBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxZQUFZLENBQUE7S0FDM0U7OztTQXZPa0IsZUFBZTs7O3FCQUFmLGVBQWUiLCJmaWxlIjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNC4wL291dC9hcHAvbm9kZV9tb2R1bGVzL2ltYWdlLXZpZXcvbGliL2ltYWdlLWVkaXRvci12aWV3LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBiYWJlbCAqL1xuLyoqIEBqc3ggZXRjaC5kb20gKi9cblxuaW1wb3J0IGZzIGZyb20gJ2ZzLXBsdXMnXG5pbXBvcnQge0VtaXR0ZXIsIENvbXBvc2l0ZURpc3Bvc2FibGUsIERpc3Bvc2FibGV9IGZyb20gJ2F0b20nXG5pbXBvcnQgZXRjaCBmcm9tICdldGNoJ1xuXG4vLyBWaWV3IHRoYXQgcmVuZGVycyB0aGUgaW1hZ2Ugb2YgYW4ge0ltYWdlRWRpdG9yfS5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEltYWdlRWRpdG9yVmlldyB7XG4gIGNvbnN0cnVjdG9yIChlZGl0b3IpIHtcbiAgICB0aGlzLmVkaXRvciA9IGVkaXRvclxuICAgIHRoaXMuZW1pdHRlciA9IG5ldyBFbWl0dGVyKClcbiAgICB0aGlzLmRpc3Bvc2FibGVzID0gbmV3IENvbXBvc2l0ZURpc3Bvc2FibGUoKVxuICAgIHRoaXMuaW1hZ2VTaXplID0gZnMuc3RhdFN5bmModGhpcy5lZGl0b3IuZ2V0UGF0aCgpKS5zaXplXG4gICAgdGhpcy5sb2FkZWQgPSBmYWxzZVxuICAgIHRoaXMubW9kZSA9ICd6b29tLXRvLWZpdCdcbiAgICB0aGlzLnBlcmNlbnRhZ2VTdGVwID0gNFxuICAgIHRoaXMuc3RlcHMgPSBbMC4xLCAwLjI1LCAwLjUsIDAuNzUsIDEuMCwgMS4yNSwgMS41LCAyLCAzLCA0LCA1LCA3LjUsIDEwXVxuICAgIGV0Y2guaW5pdGlhbGl6ZSh0aGlzKVxuXG4gICAgdGhpcy5yZWZzLmltYWdlLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB0aGlzLnVwZGF0ZUltYWdlVVJJKClcblxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKHRoaXMuZWRpdG9yLm9uRGlkQ2hhbmdlKCgpID0+IHRoaXMudXBkYXRlSW1hZ2VVUkkoKSkpXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQoYXRvbS5jb21tYW5kcy5hZGQodGhpcy5lbGVtZW50LCB7XG4gICAgICAnaW1hZ2UtdmlldzpyZWxvYWQnOiAoKSA9PiB0aGlzLnVwZGF0ZUltYWdlVVJJKCksXG4gICAgICAnaW1hZ2Utdmlldzp6b29tLWluJzogKCkgPT4gdGhpcy56b29tSW4oKSxcbiAgICAgICdpbWFnZS12aWV3Onpvb20tb3V0JzogKCkgPT4gdGhpcy56b29tT3V0KCksXG4gICAgICAnaW1hZ2Utdmlldzp6b29tLXRvLWZpdCc6ICgpID0+IHRoaXMuem9vbVRvRml0KCksXG4gICAgICAnaW1hZ2UtdmlldzpyZXNldC16b29tJzogKCkgPT4gdGhpcy5yZXNldFpvb20oKSxcbiAgICAgICdjb3JlOm1vdmUtdXAnOiAoKSA9PiB7IHRoaXMuc2Nyb2xsVXAoKSB9LFxuICAgICAgJ2NvcmU6bW92ZS1kb3duJzogKCkgPT4geyB0aGlzLnNjcm9sbERvd24oKSB9LFxuICAgICAgJ2NvcmU6cGFnZS11cCc6ICgpID0+IHsgdGhpcy5wYWdlVXAoKSB9LFxuICAgICAgJ2NvcmU6cGFnZS1kb3duJzogKCkgPT4geyB0aGlzLnBhZ2VEb3duKCkgfSxcbiAgICAgICdjb3JlOm1vdmUtdG8tdG9wJzogKCkgPT4geyB0aGlzLnNjcm9sbFRvVG9wKCkgfSxcbiAgICAgICdjb3JlOm1vdmUtdG8tYm90dG9tJzogKCkgPT4geyB0aGlzLnNjcm9sbFRvQm90dG9tKCkgfVxuICAgIH0pKVxuXG4gICAgdGhpcy5yZWZzLmltYWdlLm9ubG9hZCA9ICgpID0+IHtcbiAgICAgIHRoaXMucmVmcy5pbWFnZS5vbmxvYWQgPSBudWxsXG4gICAgICB0aGlzLm9yaWdpbmFsSGVpZ2h0ID0gdGhpcy5yZWZzLmltYWdlLm5hdHVyYWxIZWlnaHRcbiAgICAgIHRoaXMub3JpZ2luYWxXaWR0aCA9IHRoaXMucmVmcy5pbWFnZS5uYXR1cmFsV2lkdGhcbiAgICAgIHRoaXMubG9hZGVkID0gdHJ1ZVxuICAgICAgdGhpcy5yZWZzLmltYWdlLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICAgICAgdGhpcy5kZWZhdWx0QmFja2dyb3VuZENvbG9yID0gYXRvbS5jb25maWcuZ2V0KCdpbWFnZS12aWV3LmRlZmF1bHRCYWNrZ3JvdW5kQ29sb3InKVxuICAgICAgdGhpcy5yZWZzLmltYWdlQ29udGFpbmVyLnNldEF0dHJpYnV0ZSgnYmFja2dyb3VuZCcsIHRoaXMuZGVmYXVsdEJhY2tncm91bmRDb2xvcilcbiAgICAgIHRoaXMuZW1pdHRlci5lbWl0KCdkaWQtbG9hZCcpXG4gICAgfVxuXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQoYXRvbS50b29sdGlwcy5hZGQodGhpcy5yZWZzLndoaXRlVHJhbnNwYXJlbnRCYWNrZ3JvdW5kQnV0dG9uLCB7dGl0bGU6ICdVc2Ugd2hpdGUgdHJhbnNwYXJlbnQgYmFja2dyb3VuZCd9KSlcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChhdG9tLnRvb2x0aXBzLmFkZCh0aGlzLnJlZnMuYmxhY2tUcmFuc3BhcmVudEJhY2tncm91bmRCdXR0b24sIHt0aXRsZTogJ1VzZSBibGFjayB0cmFuc3BhcmVudCBiYWNrZ3JvdW5kJ30pKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKGF0b20udG9vbHRpcHMuYWRkKHRoaXMucmVmcy50cmFuc3BhcmVudFRyYW5zcGFyZW50QmFja2dyb3VuZEJ1dHRvbiwge3RpdGxlOiAnVXNlIHRyYW5zcGFyZW50IGJhY2tncm91bmQnfSkpXG5cbiAgICBjb25zdCBjbGlja0hhbmRsZXIgPSAoZXZlbnQpID0+IHtcbiAgICAgIGV2ZW50LnByZXZlbnREZWZhdWx0KClcbiAgICAgIGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpXG4gICAgICB0aGlzLmNoYW5nZUJhY2tncm91bmQoZXZlbnQudGFyZ2V0LnZhbHVlKVxuICAgIH1cblxuICAgIHRoaXMucmVmcy53aGl0ZVRyYW5zcGFyZW50QmFja2dyb3VuZEJ1dHRvbi5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIGNsaWNrSGFuZGxlcilcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChuZXcgRGlzcG9zYWJsZSgoKSA9PiB7IHRoaXMucmVmcy53aGl0ZVRyYW5zcGFyZW50QmFja2dyb3VuZEJ1dHRvbi5yZW1vdmVFdmVudExpc3RlbmVyKCdjbGljaycsIGNsaWNrSGFuZGxlcikgfSkpXG4gICAgdGhpcy5yZWZzLmJsYWNrVHJhbnNwYXJlbnRCYWNrZ3JvdW5kQnV0dG9uLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLmJsYWNrVHJhbnNwYXJlbnRCYWNrZ3JvdW5kQnV0dG9uLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKSB9KSlcbiAgICB0aGlzLnJlZnMudHJhbnNwYXJlbnRUcmFuc3BhcmVudEJhY2tncm91bmRCdXR0b24uYWRkRXZlbnRMaXN0ZW5lcignY2xpY2snLCBjbGlja0hhbmRsZXIpXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQobmV3IERpc3Bvc2FibGUoKCkgPT4geyB0aGlzLnJlZnMudHJhbnNwYXJlbnRUcmFuc3BhcmVudEJhY2tncm91bmRCdXR0b24ucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xpY2snLCBjbGlja0hhbmRsZXIpIH0pKVxuXG4gICAgY29uc3Qgem9vbUluQ2xpY2tIYW5kbGVyID0gKCkgPT4ge1xuICAgICAgdGhpcy56b29tSW4oKVxuICAgIH1cbiAgICB0aGlzLnJlZnMuem9vbUluQnV0dG9uLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgem9vbUluQ2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLnpvb21JbkJ1dHRvbi5yZW1vdmVFdmVudExpc3RlbmVyKCdjbGljaycsIHpvb21JbkNsaWNrSGFuZGxlcikgfSkpXG5cbiAgICBjb25zdCB6b29tT3V0Q2xpY2tIYW5kbGVyID0gKCkgPT4ge1xuICAgICAgdGhpcy56b29tT3V0KClcbiAgICB9XG4gICAgdGhpcy5yZWZzLnpvb21PdXRCdXR0b24uYWRkRXZlbnRMaXN0ZW5lcignY2xpY2snLCB6b29tT3V0Q2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLnpvb21PdXRCdXR0b24ucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xpY2snLCB6b29tT3V0Q2xpY2tIYW5kbGVyKSB9KSlcblxuICAgIGNvbnN0IHJlc2V0Wm9vbUNsaWNrSGFuZGxlciA9ICgpID0+IHtcbiAgICAgIHRoaXMucmVzZXRab29tKClcbiAgICB9XG4gICAgdGhpcy5yZWZzLnJlc2V0Wm9vbUJ1dHRvbi5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIHJlc2V0Wm9vbUNsaWNrSGFuZGxlcilcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChuZXcgRGlzcG9zYWJsZSgoKSA9PiB7IHRoaXMucmVmcy5yZXNldFpvb21CdXR0b24ucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xpY2snLCByZXNldFpvb21DbGlja0hhbmRsZXIpIH0pKVxuXG4gICAgY29uc3Qgem9vbVRvRml0Q2xpY2tIYW5kbGVyID0gKCkgPT4ge1xuICAgICAgdGhpcy56b29tVG9GaXQoKVxuICAgIH1cbiAgICB0aGlzLnJlZnMuem9vbVRvRml0QnV0dG9uLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgem9vbVRvRml0Q2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLnpvb21Ub0ZpdEJ1dHRvbi5yZW1vdmVFdmVudExpc3RlbmVyKCdjbGljaycsIHpvb21Ub0ZpdENsaWNrSGFuZGxlcikgfSkpXG4gIH1cblxuICBvbkRpZExvYWQgKGNhbGxiYWNrKSB7XG4gICAgcmV0dXJuIHRoaXMuZW1pdHRlci5vbignZGlkLWxvYWQnLCBjYWxsYmFjaylcbiAgfVxuXG4gIHVwZGF0ZSAoKSB7fVxuXG4gIGRlc3Ryb3kgKCkge1xuICAgIHRoaXMuZGlzcG9zYWJsZXMuZGlzcG9zZSgpXG4gICAgdGhpcy5lbWl0dGVyLmRpc3Bvc2UoKVxuICAgIHJldHVybiBldGNoLmRlc3Ryb3kodGhpcylcbiAgfVxuXG4gIHJlbmRlciAoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPSdpbWFnZS12aWV3JyB0YWJJbmRleD0nLTEnPlxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT0naW1hZ2UtY29udHJvbHMnIHJlZj0naW1hZ2VDb250cm9scyc+XG4gICAgICAgICAgPGRpdiBjbGFzc05hbWU9J2ltYWdlLWNvbnRyb2xzLWdyb3VwJz5cbiAgICAgICAgICAgIDxhIHJlZj0nd2hpdGVUcmFuc3BhcmVudEJhY2tncm91bmRCdXR0b24nIGNsYXNzTmFtZT0naW1hZ2UtY29udHJvbHMtY29sb3Itd2hpdGUnIHZhbHVlPSd3aGl0ZSc+d2hpdGU8L2E+XG4gICAgICAgICAgICA8YSByZWY9J2JsYWNrVHJhbnNwYXJlbnRCYWNrZ3JvdW5kQnV0dG9uJyBjbGFzc05hbWU9J2ltYWdlLWNvbnRyb2xzLWNvbG9yLWJsYWNrJyB2YWx1ZT0nYmxhY2snPmJsYWNrPC9hPlxuICAgICAgICAgICAgPGEgcmVmPSd0cmFuc3BhcmVudFRyYW5zcGFyZW50QmFja2dyb3VuZEJ1dHRvbicgY2xhc3NOYW1lPSdpbWFnZS1jb250cm9scy1jb2xvci10cmFuc3BhcmVudCcgdmFsdWU9J3RyYW5zcGFyZW50Jz50cmFuc3BhcmVudDwvYT5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0naW1hZ2UtY29udHJvbHMtZ3JvdXAgYnRuLWdyb3VwJz5cbiAgICAgICAgICAgIDxidXR0b24gY2xhc3NOYW1lPSdidG4nIHJlZj0nem9vbU91dEJ1dHRvbic+LTwvYnV0dG9uPlxuICAgICAgICAgICAgPGJ1dHRvbiBjbGFzc05hbWU9J2J0biByZXNldC16b29tLWJ1dHRvbicgcmVmPSdyZXNldFpvb21CdXR0b24nPkF1dG88L2J1dHRvbj5cbiAgICAgICAgICAgIDxidXR0b24gY2xhc3NOYW1lPSdidG4nIHJlZj0nem9vbUluQnV0dG9uJz4rPC9idXR0b24+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPGRpdiBjbGFzc05hbWU9J2ltYWdlLWNvbnRyb2xzLWdyb3VwIGJ0bi1ncm91cCc+XG4gICAgICAgICAgICA8YnV0dG9uIGNsYXNzTmFtZT0nYnRuIHpvb20tdG8tZml0LWJ1dHRvbiBzZWxlY3RlZCcgcmVmPSd6b29tVG9GaXRCdXR0b24nPlpvb20gdG8gZml0PC9idXR0b24+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvZGl2PlxuXG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPSdpbWFnZS1jb250YWluZXIgem9vbS10by1maXQnIHJlZj0naW1hZ2VDb250YWluZXInPlxuICAgICAgICAgIDxpbWcgcmVmPSdpbWFnZSc+PC9pbWc+XG4gICAgICAgIDwvZGl2PlxuICAgICAgPC9kaXY+XG4gICAgKVxuICB9XG5cbiAgdXBkYXRlSW1hZ2VVUkkgKCkge1xuICAgIHRoaXMucmVmcy5pbWFnZS5zcmMgPSBgJHt0aGlzLmVkaXRvci5nZXRFbmNvZGVkVVJJKCl9P3RpbWU9JHtEYXRlLm5vdygpfWBcbiAgfVxuXG4gIC8vIFpvb21zIHRoZSBpbWFnZSBvdXQgYnkgMjUlLlxuICB6b29tT3V0ICgpIHtcbiAgICB0aGlzLnBlcmNlbnRhZ2VTdGVwID0gTWF0aC5tYXgoMCwgLS10aGlzLnBlcmNlbnRhZ2VTdGVwKVxuICAgIHRoaXMuYWRqdXN0U2l6ZSh0aGlzLnBlcmNlbnRhZ2VTdGVwKVxuICB9XG5cbiAgLy8gWm9vbXMgdGhlIGltYWdlIGluIGJ5IDI1JS5cbiAgem9vbUluICgpIHtcbiAgICB0aGlzLnBlcmNlbnRhZ2VTdGVwID0gTWF0aC5taW4odGhpcy5zdGVwcy5sZW5ndGggLSAxLCArK3RoaXMucGVyY2VudGFnZVN0ZXApXG4gICAgdGhpcy5hZGp1c3RTaXplKHRoaXMucGVyY2VudGFnZVN0ZXApXG4gIH1cblxuICAvLyBab29tcyB0aGUgaW1hZ2UgdG8gaXRzIG5vcm1hbCB3aWR0aCBhbmQgaGVpZ2h0LlxuICByZXNldFpvb20gKCkge1xuICAgIGlmICghdGhpcy5sb2FkZWQgfHwgdGhpcy5lbGVtZW50Lm9mZnNldEhlaWdodCA9PT0gMCkge1xuICAgICAgcmV0dXJuXG4gICAgfVxuXG4gICAgdGhpcy5tb2RlID0gJ3Jlc2V0LXpvb20nXG4gICAgdGhpcy5yZWZzLmltYWdlQ29udGFpbmVyLmNsYXNzTGlzdC5yZW1vdmUoJ3pvb20tdG8tZml0JylcbiAgICB0aGlzLnJlZnMuem9vbVRvRml0QnV0dG9uLmNsYXNzTGlzdC5yZW1vdmUoJ3NlbGVjdGVkJylcbiAgICB0aGlzLnJlZnMuaW1hZ2Uuc3R5bGUud2lkdGggPSB0aGlzLm9yaWdpbmFsV2lkdGggKyAncHgnXG4gICAgdGhpcy5yZWZzLmltYWdlLnN0eWxlLmhlaWdodCA9IHRoaXMub3JpZ2luYWxIZWlnaHQgKyAncHgnXG4gICAgdGhpcy5yZWZzLnJlc2V0Wm9vbUJ1dHRvbi50ZXh0Q29udGVudCA9ICcxMDAlJ1xuICAgIHRoaXMucGVyY2VudGFnZVN0ZXAgPSA0XG4gIH1cblxuICAvLyBab29tcyB0byBmaXQgdGhlIGltYWdlLCBkb2Vzbid0IHNjYWxlIGJleW9uZCBhY3R1YWwgc2l6ZVxuICB6b29tVG9GaXQgKCkge1xuICAgIGlmICghdGhpcy5sb2FkZWQgfHwgdGhpcy5lbGVtZW50Lm9mZnNldEhlaWdodCA9PT0gMCkge1xuICAgICAgcmV0dXJuXG4gICAgfVxuXG4gICAgdGhpcy5tb2RlID0gJ3pvb20tdG8tZml0J1xuICAgIHRoaXMucmVmcy5pbWFnZUNvbnRhaW5lci5jbGFzc0xpc3QuYWRkKCd6b29tLXRvLWZpdCcpXG4gICAgdGhpcy5yZWZzLnpvb21Ub0ZpdEJ1dHRvbi5jbGFzc0xpc3QuYWRkKCdzZWxlY3RlZCcpXG4gICAgdGhpcy5yZWZzLmltYWdlLnN0eWxlLndpZHRoID0gJydcbiAgICB0aGlzLnJlZnMuaW1hZ2Uuc3R5bGUuaGVpZ2h0ID0gJydcbiAgICB0aGlzLnJlZnMucmVzZXRab29tQnV0dG9uLnRleHRDb250ZW50ID0gJ0F1dG8nXG4gICAgdGhpcy5wZXJjZW50YWdlU3RlcCA9IDRcbiAgfVxuXG4gIC8vIEFkanVzdCB0aGUgc2l6ZSBvZiB0aGUgaW1hZ2UgYnkgdGhlIGdpdmVuIG11bHRpcGx5aW5nIGZhY3Rvci5cbiAgLy9cbiAgLy8gZmFjdG9yIC0gQSB7TnVtYmVyfSB0byBtdWx0aXBseSBhZ2FpbnN0IHRoZSBjdXJyZW50IHNpemUuXG4gIGFkanVzdFNpemUgKHBlcmNlbnRhZ2VTdGVwKSB7XG4gICAgaWYgKCF0aGlzLmxvYWRlZCB8fCB0aGlzLmVsZW1lbnQub2Zmc2V0SGVpZ2h0ID09PSAwKSB7XG4gICAgICByZXR1cm5cbiAgICB9XG5cbiAgICBpZiAodGhpcy5tb2RlID09PSAnem9vbS10by1maXQnKSB7XG4gICAgICB0aGlzLm1vZGUgPSAnem9vbS1tYW51YWwnXG4gICAgICB0aGlzLnJlZnMuaW1hZ2VDb250YWluZXIuY2xhc3NMaXN0LnJlbW92ZSgnem9vbS10by1maXQnKVxuICAgICAgdGhpcy5yZWZzLnpvb21Ub0ZpdEJ1dHRvbi5jbGFzc0xpc3QucmVtb3ZlKCdzZWxlY3RlZCcpXG4gICAgfSBlbHNlIGlmICh0aGlzLm1vZGUgPT09ICdyZXNldC16b29tJykge1xuICAgICAgdGhpcy5tb2RlID0gJ3pvb20tbWFudWFsJ1xuICAgIH1cblxuICAgIGNvbnN0IGZhY3RvciA9IHRoaXMuc3RlcHNbcGVyY2VudGFnZVN0ZXBdXG4gICAgY29uc3QgbmV3V2lkdGggPSB0aGlzLm9yaWdpbmFsV2lkdGggKiBmYWN0b3JcbiAgICBjb25zdCBuZXdIZWlnaHQgPSB0aGlzLm9yaWdpbmFsSGVpZ2h0ICogZmFjdG9yXG4gICAgY29uc3QgcGVyY2VudCA9IE1hdGgubWF4KDEsIE1hdGgucm91bmQoKG5ld1dpZHRoIC8gdGhpcy5vcmlnaW5hbFdpZHRoKSAqIDEwMCkpXG5cbiAgICAvLyBTd2l0Y2ggdG8gcGl4ZWxhdGVkIHJlbmRlcmluZyB3aGVuIGltYWdlIGlzIGJpZ2dlciB0aGFuIDIwMCVcbiAgICBpZiAobmV3V2lkdGggPiAodGhpcy5vcmlnaW5hbFdpZHRoICogMikpIHtcbiAgICAgIHRoaXMucmVmcy5pbWFnZS5zdHlsZS5pbWFnZVJlbmRlcmluZyA9ICdwaXhlbGF0ZWQnXG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMucmVmcy5pbWFnZS5zdHlsZS5pbWFnZVJlbmRlcmluZyA9ICcnXG4gICAgfVxuXG4gICAgdGhpcy5yZWZzLmltYWdlLnN0eWxlLndpZHRoID0gbmV3V2lkdGggKyAncHgnXG4gICAgdGhpcy5yZWZzLmltYWdlLnN0eWxlLmhlaWdodCA9IG5ld0hlaWdodCArICdweCdcbiAgICB0aGlzLnJlZnMucmVzZXRab29tQnV0dG9uLnRleHRDb250ZW50ID0gcGVyY2VudCArICclJ1xuICB9XG5cbiAgLy8gQ2hhbmdlcyB0aGUgYmFja2dyb3VuZCBjb2xvciBvZiB0aGUgaW1hZ2Ugdmlldy5cbiAgLy9cbiAgLy8gY29sb3IgLSBBIHtTdHJpbmd9IHRoYXQgZ2V0cyB1c2VkIGFzIGNsYXNzIG5hbWUuXG4gIGNoYW5nZUJhY2tncm91bmQgKGNvbG9yKSB7XG4gICAgaWYgKHRoaXMubG9hZGVkICYmIHRoaXMuZWxlbWVudC5vZmZzZXRIZWlnaHQgPiAwICYmIGNvbG9yKSB7XG4gICAgICB0aGlzLnJlZnMuaW1hZ2VDb250YWluZXIuc2V0QXR0cmlidXRlKCdiYWNrZ3JvdW5kJywgY29sb3IpXG4gICAgfVxuICB9XG5cbiAgc2Nyb2xsVXAgKCkge1xuICAgIHRoaXMucmVmcy5pbWFnZUNvbnRhaW5lci5zY3JvbGxUb3AgLT0gZG9jdW1lbnQuYm9keS5vZmZzZXRIZWlnaHQgLyAyMFxuICB9XG5cbiAgc2Nyb2xsRG93biAoKSB7XG4gICAgdGhpcy5yZWZzLmltYWdlQ29udGFpbmVyLnNjcm9sbFRvcCArPSBkb2N1bWVudC5ib2R5Lm9mZnNldEhlaWdodCAvIDIwXG4gIH1cblxuICBwYWdlVXAgKCkge1xuICAgIHRoaXMucmVmcy5pbWFnZUNvbnRhaW5lci5zY3JvbGxUb3AgLT0gdGhpcy5lbGVtZW50Lm9mZnNldEhlaWdodFxuICB9XG5cbiAgcGFnZURvd24gKCkge1xuICAgIHRoaXMucmVmcy5pbWFnZUNvbnRhaW5lci5zY3JvbGxUb3AgKz0gdGhpcy5lbGVtZW50Lm9mZnNldEhlaWdodFxuICB9XG5cbiAgc2Nyb2xsVG9Ub3AgKCkge1xuICAgIHRoaXMucmVmcy5pbWFnZUNvbnRhaW5lci5zY3JvbGxUb3AgPSAwXG4gIH1cblxuICBzY3JvbGxUb0JvdHRvbSAoKSB7XG4gICAgdGhpcy5yZWZzLmltYWdlQ29udGFpbmVyLnNjcm9sbFRvcCA9IHRoaXMucmVmcy5pbWFnZUNvbnRhaW5lci5zY3JvbGxIZWlnaHRcbiAgfVxufVxuIl19