Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _imageEditor = require('./image-editor');

var _imageEditor2 = _interopRequireDefault(_imageEditor);

var _imageEditorView = require('./image-editor-view');

var _imageEditorView2 = _interopRequireDefault(_imageEditorView);

var _bytes = require('bytes');

var _bytes2 = _interopRequireDefault(_bytes);

var ImageEditorStatusView = (function () {
  function ImageEditorStatusView(statusBar) {
    var _this = this;

    _classCallCheck(this, ImageEditorStatusView);

    this.statusBar = statusBar;
    this.disposables = new _atom.CompositeDisposable();

    this.element = document.createElement('div');
    this.element.classList.add('status-image', 'inline-block');

    this.imageSizeStatus = document.createElement('span');
    this.imageSizeStatus.classList.add('image-size');
    this.element.appendChild(this.imageSizeStatus);

    this.attach();

    this.disposables.add(atom.workspace.getCenter().onDidChangeActivePaneItem(function () {
      _this.updateImageSize();
    }));
  }

  _createClass(ImageEditorStatusView, [{
    key: 'attach',
    value: function attach() {
      this.statusBarTile = this.statusBar.addLeftTile({ item: this });
      this.updateImageSize();
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.statusBarTile.destroy();
      this.disposables.dispose();
    }
  }, {
    key: 'getImageSize',
    value: function getImageSize(_ref) {
      var originalHeight = _ref.originalHeight;
      var originalWidth = _ref.originalWidth;
      var imageSize = _ref.imageSize;

      this.imageSizeStatus.textContent = originalWidth + 'x' + originalHeight + ' ' + (0, _bytes2['default'])(imageSize);
      this.imageSizeStatus.style.display = '';
    }
  }, {
    key: 'updateImageSize',
    value: function updateImageSize() {
      var _this2 = this;

      if (this.imageLoadDisposable) {
        this.imageLoadDisposable.dispose();
      }

      var editor = atom.workspace.getCenter().getActivePaneItem();
      if (editor instanceof _imageEditor2['default'] && editor.view instanceof _imageEditorView2['default']) {
        this.editorView = editor.view;
        if (this.editorView.loaded) {
          this.getImageSize(this.editorView);
        }

        this.imageLoadDisposable = this.editorView.onDidLoad(function () {
          if (editor === atom.workspace.getCenter().getActivePaneItem()) {
            _this2.getImageSize(_this2.editorView);
          }
        });
      } else {
        this.imageSizeStatus.style.display = 'none';
      }
    }
  }]);

  return ImageEditorStatusView;
})();

exports['default'] = ImageEditorStatusView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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