'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.watchWorkspaceItem = watchWorkspaceItem;

var _atom = require('atom');

var _uriPattern = require('./atom/uri-pattern');

var _uriPattern2 = _interopRequireDefault(_uriPattern);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ItemWatcher {
  constructor(workspace, pattern, component, stateKey) {
    this.updateActiveState = () => {
      const wasActive = this.activeItem;

      this.activeItem = this.isActiveItem();
      // Update the component's state if it's changed as a result
      if (wasActive && !this.activeItem) {
        return new Promise(resolve => this.component.setState({ [this.stateKey]: false }, resolve));
      } else if (!wasActive && this.activeItem) {
        return new Promise(resolve => this.component.setState({ [this.stateKey]: true }, resolve));
      } else {
        return Promise.resolve();
      }
    };

    this.itemMatches = item => item && item.getURI && this.pattern.matches(item.getURI()).ok();

    this.workspace = workspace;
    this.pattern = pattern instanceof _uriPattern2.default ? pattern : new _uriPattern2.default(pattern);
    this.component = component;
    this.stateKey = stateKey;

    this.activeItem = this.isActiveItem();
    this.subs = new _atom.CompositeDisposable();
  }

  isActiveItem() {
    for (const pane of this.workspace.getPanes()) {
      if (this.itemMatches(pane.getActiveItem())) {
        return true;
      }
    }
    return false;
  }

  setInitialState() {
    if (!this.component.state) {
      this.component.state = {};
    }
    this.component.state[this.stateKey] = this.activeItem;
    return this;
  }

  subscribeToWorkspace() {
    this.subs.dispose();
    this.subs = new _atom.CompositeDisposable(this.workspace.getCenter().onDidChangeActivePaneItem(this.updateActiveState));
    return this;
  }

  setPattern(pattern) {
    this.pattern = pattern instanceof _uriPattern2.default ? pattern : new _uriPattern2.default(pattern);

    return this.updateActiveState();
  }

  dispose() {
    this.subs.dispose();
  }
}

function watchWorkspaceItem(workspace, pattern, component, stateKey) {
  return new ItemWatcher(workspace, pattern, component, stateKey).setInitialState().subscribeToWorkspace();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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