'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareMergedEventView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _timeago = require('../../views/timeago');

var _timeago2 = _interopRequireDefault(_timeago);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareMergedEventView extends _react2.default.Component {

  render() {
    const { actor, mergeRefName, createdAt } = this.props.item;
    return _react2.default.createElement(
      'div',
      { className: 'merged-event' },
      _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'git-merge' }),
      actor && _react2.default.createElement('img', { className: 'author-avatar', src: actor.avatarUrl, alt: actor.login, title: actor.login }),
      _react2.default.createElement(
        'span',
        { className: 'merged-event-header' },
        _react2.default.createElement(
          'span',
          { className: 'username' },
          actor ? actor.login : 'someone'
        ),
        ' merged',
        ' ',
        this.renderCommit(),
        ' into',
        ' ',
        _react2.default.createElement(
          'span',
          { className: 'merge-ref' },
          mergeRefName
        ),
        ' on ',
        _react2.default.createElement(_timeago2.default, { time: createdAt })
      )
    );
  }

  renderCommit() {
    const { commit } = this.props.item;
    if (!commit) {
      return 'a commit';
    }

    return _react2.default.createElement(
      _react.Fragment,
      null,
      'commit ',
      _react2.default.createElement(
        'span',
        { className: 'sha' },
        commit.oid.slice(0, 8)
      )
    );
  }
}

exports.BareMergedEventView = BareMergedEventView;
BareMergedEventView.propTypes = {
  item: _propTypes2.default.shape({
    actor: _propTypes2.default.shape({
      avatarUrl: _propTypes2.default.string.isRequired,
      login: _propTypes2.default.string.isRequired
    }),
    commit: _propTypes2.default.shape({
      oid: _propTypes2.default.string.isRequired
    }),
    mergeRefName: _propTypes2.default.string.isRequired,
    createdAt: _propTypes2.default.string.isRequired
  }).isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareMergedEventView, {
  item: function () {
    const node = require('./__generated__/mergedEventView_item.graphql');

    if (node.hash && node.hash !== 'd265decf08c14d96c2ec47fd5852a956') {
      console.error('The definition of \'mergedEventView_item\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/mergedEventView_item.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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