'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareIssueCommentView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _timeago = require('../timeago');

var _timeago2 = _interopRequireDefault(_timeago);

var _githubDotcomMarkdown = require('../github-dotcom-markdown');

var _githubDotcomMarkdown2 = _interopRequireDefault(_githubDotcomMarkdown);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareIssueCommentView extends _react2.default.Component {

  render() {
    const comment = this.props.item;
    const author = comment.author;

    return _react2.default.createElement(
      'div',
      { className: 'issue timeline-item' },
      _react2.default.createElement(
        'div',
        { className: 'info-row' },
        _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'comment' }),
        author && _react2.default.createElement('img', { className: 'author-avatar', src: author.avatarUrl,
          alt: comment.author.login, title: comment.author.login
        }),
        _react2.default.createElement(
          'span',
          { className: 'comment-message-header' },
          author ? author.login : 'someone',
          ' commented',
          ' ',
          _react2.default.createElement(
            'a',
            { href: comment.url },
            _react2.default.createElement(_timeago2.default, { time: comment.createdAt })
          )
        )
      ),
      _react2.default.createElement(_githubDotcomMarkdown2.default, { html: comment.bodyHTML, switchToIssueish: this.props.switchToIssueish })
    );
  }
}

exports.BareIssueCommentView = BareIssueCommentView;
BareIssueCommentView.propTypes = {
  switchToIssueish: _propTypes2.default.func.isRequired,
  item: _propTypes2.default.shape({
    author: _propTypes2.default.shape({
      avatarUrl: _propTypes2.default.string.isRequired,
      login: _propTypes2.default.string.isRequired
    }),
    bodyHTML: _propTypes2.default.string.isRequired,
    createdAt: _propTypes2.default.string.isRequired,
    url: _propTypes2.default.string.isRequired
  }).isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareIssueCommentView, {
  item: function () {
    const node = require('./__generated__/issueCommentView_item.graphql');

    if (node.hash && node.hash !== 'adc36c52f51de14256693ab9e4eb84bb') {
      console.error('The definition of \'issueCommentView_item\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/issueCommentView_item.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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