'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareHeadRefForcePushedEventView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _timeago = require('../timeago');

var _timeago2 = _interopRequireDefault(_timeago);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareHeadRefForcePushedEventView extends _react2.default.Component {

  render() {
    const { actor, beforeCommit, afterCommit, createdAt } = this.props.item;
    const { headRefName, headRepositoryOwner, repository } = this.props.issueish;
    const branchPrefix = headRepositoryOwner.login !== repository.owner.login ? `${headRepositoryOwner.login}:` : '';
    return _react2.default.createElement(
      'div',
      { className: 'head-ref-force-pushed-event' },
      _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'repo-force-push' }),
      actor && _react2.default.createElement('img', { className: 'author-avatar', src: actor.avatarUrl, alt: actor.login, title: actor.login }),
      _react2.default.createElement(
        'span',
        { className: 'head-ref-force-pushed-event-header' },
        _react2.default.createElement(
          'span',
          { className: 'username' },
          actor ? actor.login : 'someone'
        ),
        ' force-pushed the ',
        branchPrefix + headRefName,
        ' branch from ',
        this.renderCommit(beforeCommit, 'an old commit'),
        ' to',
        ' ',
        this.renderCommit(afterCommit, 'a new commit'),
        ' at ',
        _react2.default.createElement(_timeago2.default, { time: createdAt })
      )
    );
  }

  renderCommit(commit, description) {
    if (!commit) {
      return description;
    }

    return _react2.default.createElement(
      'span',
      { className: 'sha' },
      commit.oid.slice(0, 8)
    );
  }
}

exports.BareHeadRefForcePushedEventView = BareHeadRefForcePushedEventView;
BareHeadRefForcePushedEventView.propTypes = {
  item: _propTypes2.default.shape({
    actor: _propTypes2.default.shape({
      avatarUrl: _propTypes2.default.string.isRequired,
      login: _propTypes2.default.string.isRequired
    }),
    beforeCommit: _propTypes2.default.shape({
      oid: _propTypes2.default.string.isRequired
    }),
    afterCommit: _propTypes2.default.shape({
      oid: _propTypes2.default.string.isRequired
    }),
    createdAt: _propTypes2.default.string.isRequired
  }).isRequired,
  issueish: _propTypes2.default.shape({
    headRefName: _propTypes2.default.string.isRequired,
    headRepositoryOwner: _propTypes2.default.shape({
      login: _propTypes2.default.string.isRequired
    }),
    repository: _propTypes2.default.shape({
      owner: _propTypes2.default.shape({
        login: _propTypes2.default.string.isRequired
      }).isRequired
    }).isRequired
  }).isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareHeadRefForcePushedEventView, {
  issueish: function () {
    const node = require('./__generated__/headRefForcePushedEventView_issueish.graphql');

    if (node.hash && node.hash !== '4c639070afc4a02cedf062d836d0dd7f') {
      console.error('The definition of \'headRefForcePushedEventView_issueish\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/headRefForcePushedEventView_issueish.graphql');
  },

  item: function () {
    const node = require('./__generated__/headRefForcePushedEventView_item.graphql');

    if (node.hash && node.hash !== 'fc403545674c57c1997c870805101ffb') {
      console.error('The definition of \'headRefForcePushedEventView_item\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/headRefForcePushedEventView_item.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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