'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareCrossReferencedEventsView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _timeago = require('../../views/timeago');

var _timeago2 = _interopRequireDefault(_timeago);

var _crossReferencedEventView = require('./cross-referenced-event-view');

var _crossReferencedEventView2 = _interopRequireDefault(_crossReferencedEventView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareCrossReferencedEventsView extends _react2.default.Component {

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'timeline-item cross-referenced-events' },
      _react2.default.createElement(
        'div',
        { className: 'info-row' },
        _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'bookmark' }),
        _react2.default.createElement(
          'span',
          { className: 'cross-referenced-event-header' },
          this.renderSummary()
        )
      ),
      this.renderEvents()
    );
  }

  renderSummary() {
    const first = this.props.nodes[0];
    if (this.props.nodes.length > 1) {
      return _react2.default.createElement(
        'span',
        null,
        'This was referenced ',
        _react2.default.createElement(_timeago2.default, { time: first.referencedAt })
      );
    } else {
      const type = {
        PullRequest: 'a pull request',
        Issue: 'an issue'
      }[first.source.__typename];
      let xrefClause = '';
      if (first.isCrossRepository) {
        const repo = first.source.repository;
        xrefClause = _react2.default.createElement(
          'span',
          null,
          'in ',
          _react2.default.createElement(
            'strong',
            null,
            repo.owner.login,
            '/',
            repo.name
          )
        );
      }
      return _react2.default.createElement(
        'span',
        null,
        _react2.default.createElement('img', { className: 'author-avatar', src: first.actor.avatarUrl,
          alt: first.actor.login, title: first.actor.login
        }),
        _react2.default.createElement(
          'strong',
          null,
          first.actor.login
        ),
        ' referenced this from ',
        type,
        ' ',
        xrefClause,
        _react2.default.createElement(_timeago2.default, { time: first.referencedAt })
      );
    }
  }

  renderEvents() {
    return this.props.nodes.map(node => {
      return _react2.default.createElement(_crossReferencedEventView2.default, { key: node.id, item: node });
    });
  }
}

exports.BareCrossReferencedEventsView = BareCrossReferencedEventsView;
BareCrossReferencedEventsView.propTypes = {
  nodes: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    referencedAt: _propTypes2.default.string.isRequired,
    isCrossRepository: _propTypes2.default.bool.isRequired,
    actor: _propTypes2.default.shape({
      avatarUrl: _propTypes2.default.string.isRequired,
      login: _propTypes2.default.string.isRequired
    }),
    source: _propTypes2.default.shape({
      __typename: _propTypes2.default.oneOf(['Issue', 'PullRequest']).isRequired,
      repository: _propTypes2.default.shape({
        name: _propTypes2.default.string.isRequired,
        owner: _propTypes2.default.shape({
          login: _propTypes2.default.string.isRequired
        }).isRequired
      }).isRequired
    }).isRequired
  }).isRequired).isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareCrossReferencedEventsView, {
  nodes: function () {
    const node = require('./__generated__/crossReferencedEventsView_nodes.graphql');

    if (node.hash && node.hash !== '5bbb7b39e10559bac4af2d6f9ff7a9e2') {
      console.error('The definition of \'crossReferencedEventsView_nodes\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/crossReferencedEventsView_nodes.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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