'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareCommitsView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _commitView = require('./commit-view');

var _commitView2 = _interopRequireDefault(_commitView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareCommitsView extends _react2.default.Component {

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'timeline-item commits' },
      this.renderSummary(),
      this.renderCommits()
    );
  }

  renderSummary() {
    if (this.props.nodes.length > 1) {
      const namesString = this.calculateNames(this.props.nodes);
      return _react2.default.createElement(
        'div',
        { className: 'info-row' },
        _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'repo-push' }),
        _react2.default.createElement(
          'span',
          { className: 'comment-message-header' },
          namesString,
          ' added some commits...'
        )
      );
    } else {
      return null;
    }
  }

  renderCommits() {
    return this.props.nodes.map(node => {
      return _react2.default.createElement(_commitView2.default, { key: node.id, item: node });
    });
  }

  calculateNames(commits) {
    let names = new Set();
    commits.forEach(commit => {
      let name = null;
      if (commit.author.user) {
        name = commit.author.user.login;
      } else if (commit.author.name) {
        name = commit.author.name;
      }

      if (name && !names.has(name)) {
        names.add(name);
      }
    });

    names = Array.from(names);
    if (names.length === 1) {
      return names[0];
    } else if (names.length === 2) {
      return `${names[0]} and ${names[1]}`;
    } else if (names.length > 2) {
      return `${names[0]}, ${names[1]}, and others`;
    } else {
      return 'Someone';
    }
  }
}

exports.BareCommitsView = BareCommitsView;
BareCommitsView.propTypes = {
  nodes: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    author: _propTypes2.default.shape({
      name: _propTypes2.default.string,
      user: _propTypes2.default.shape({
        login: _propTypes2.default.string.isRequired
      })
    }).isRequired
  }).isRequired).isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareCommitsView, {
  nodes: function () {
    const node = require('./__generated__/commitsView_nodes.graphql');

    if (node.hash && node.hash !== 'd0a17f07d02df54341e950344ec41a7f') {
      console.error('The definition of \'commitsView_nodes\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/commitsView_nodes.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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