'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareCommitView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareCommitView extends _react2.default.Component {

  authoredByCommitter(commit) {
    if (commit.authoredByCommitter) {
      return true;
    }
    // If you commit on GitHub online the committer details would be:
    //
    //    name: "GitHub"
    //    email: "noreply@github.com"
    //    user: null
    //
    if (commit.committer.email === 'noreply@github.com') {
      return true;
    }
    if (commit.committer.name === 'GitHub' && commit.committer.user === null) {
      return true;
    }

    return false;
  }

  renderCommitter(commit) {
    if (!this.authoredByCommitter(commit)) {
      return _react2.default.createElement('img', {
        className: 'author-avatar', alt: 'author\'s avatar', src: commit.committer.avatarUrl,
        title: commit.committer.user ? commit.committer.user.login : commit.committer.name
      });
    } else {
      return null;
    }
  }

  render() {
    const commit = this.props.item;
    return _react2.default.createElement(
      'div',
      { className: 'commit' },
      _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'git-commit' }),
      _react2.default.createElement(
        'span',
        { className: 'commit-author' },
        _react2.default.createElement('img', {
          className: 'author-avatar', alt: 'author\'s avatar', src: commit.author.avatarUrl,
          title: commit.author.user ? commit.author.user.login : commit.author.name
        }),
        this.renderCommitter(commit)
      ),
      _react2.default.createElement('span', {
        className: 'commit-message-headline',
        title: commit.message,
        dangerouslySetInnerHTML: { __html: commit.messageHeadlineHTML }
      }),
      _react2.default.createElement(
        'a',
        { className: 'commit-sha', href: commit.commitUrl },
        commit.oid.slice(0, 8)
      )
    );
  }
}

exports.BareCommitView = BareCommitView;
BareCommitView.propTypes = {
  item: _propTypes2.default.object.isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareCommitView, {
  item: function () {
    const node = require('./__generated__/commitView_item.graphql');

    if (node.hash && node.hash !== '4030a81cc744eed1200ebf85a60082c9') {
      console.error('The definition of \'commitView_item\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/commitView_item.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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