'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareCommitCommentView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _timeago = require('../timeago');

var _timeago2 = _interopRequireDefault(_timeago);

var _githubDotcomMarkdown = require('../github-dotcom-markdown');

var _githubDotcomMarkdown2 = _interopRequireDefault(_githubDotcomMarkdown);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareCommitCommentView extends _react2.default.Component {

  render() {
    const comment = this.props.item;
    return _react2.default.createElement(
      'div',
      { className: 'issue' },
      _react2.default.createElement(
        'div',
        { className: 'info-row' },
        this.props.isReply ? null : _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'comment' }),
        _react2.default.createElement('img', { className: 'author-avatar',
          src: comment.author.avatarUrl, alt: comment.author.login, title: comment.author.login
        }),
        this.renderHeader(comment)
      ),
      _react2.default.createElement(_githubDotcomMarkdown2.default, { html: comment.bodyHTML, switchToIssueish: this.props.switchToIssueish })
    );
  }

  renderHeader(comment) {
    if (this.props.isReply) {
      return _react2.default.createElement(
        'span',
        { className: 'comment-message-header' },
        comment.author.login,
        ' replied ',
        _react2.default.createElement(_timeago2.default, { time: comment.createdAt })
      );
    } else {
      return _react2.default.createElement(
        'span',
        { className: 'comment-message-header' },
        comment.author.login,
        ' commented ',
        this.renderPath(),
        ' in',
        ' ',
        comment.commit.oid.substr(0, 7),
        ' ',
        _react2.default.createElement(_timeago2.default, { time: comment.createdAt })
      );
    }
  }

  renderPath() {
    if (this.props.item.path) {
      return _react2.default.createElement(
        'span',
        null,
        'on ',
        _react2.default.createElement(
          'code',
          null,
          this.props.item.path
        )
      );
    } else {
      return null;
    }
  }
}

exports.BareCommitCommentView = BareCommitCommentView;
BareCommitCommentView.propTypes = {
  item: _propTypes2.default.object.isRequired,
  isReply: _propTypes2.default.bool.isRequired,
  switchToIssueish: _propTypes2.default.func.isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareCommitCommentView, {
  item: function () {
    const node = require('./__generated__/commitCommentView_item.graphql');

    if (node.hash && node.hash !== 'f3e868b343fe8d6fee958d5339b554dc') {
      console.error('The definition of \'commitCommentView_item\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/commitCommentView_item.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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