'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareCommitCommentThreadView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _commitCommentView = require('./commit-comment-view');

var _commitCommentView2 = _interopRequireDefault(_commitCommentView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareCommitCommentThreadView extends _react2.default.Component {

  render() {
    const { item } = this.props;
    return _react2.default.createElement(
      'div',
      { className: 'commit-comment-thread timeline-item' },
      item.comments.edges.map((edge, i) => _react2.default.createElement(_commitCommentView2.default, {
        isReply: i !== 0,
        key: edge.node.id,
        item: edge.node,
        switchToIssueish: this.props.switchToIssueish
      }))
    );
  }
}

exports.BareCommitCommentThreadView = BareCommitCommentThreadView;
BareCommitCommentThreadView.propTypes = {
  item: _propTypes2.default.shape({
    commit: _propTypes2.default.shape({
      oid: _propTypes2.default.string.isRequired
    }).isRequired,
    comments: _propTypes2.default.shape({
      edges: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        node: _propTypes2.default.object.isRequired
      }).isRequired).isRequired
    }).isRequired
  }).isRequired,
  switchToIssueish: _propTypes2.default.func.isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareCommitCommentThreadView, {
  item: function () {
    const node = require('./__generated__/commitCommentThreadView_item.graphql');

    if (node.hash && node.hash !== '8d9762b31747ddf9be48e163b09a45bc') {
      console.error('The definition of \'commitCommentThreadView_item\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/commitCommentThreadView_item.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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