'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _donutChart = require('./donut-chart');

var _donutChart2 = _interopRequireDefault(_donutChart);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class StatusDonutChart extends _react2.default.Component {

  render() {
    const slices = ['pending', 'failure', 'success'].reduce((acc, type) => {
      const count = this.props[type];
      if (count > 0) {
        acc.push({ type, className: type, count });
      }
      return acc;
    }, []);

    return _react2.default.createElement(_donutChart2.default, _extends({}, (0, _helpers.unusedProps)(this.props, this.constructor.propTypes), { slices: slices }));
  }
}
exports.default = StatusDonutChart;
StatusDonutChart.propTypes = {
  pending: _propTypes2.default.number,
  failure: _propTypes2.default.number,
  success: _propTypes2.default.number
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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