'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _nodeEmoji = require('node-emoji');

var _timeago = require('./timeago');

var _timeago2 = _interopRequireDefault(_timeago);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class RecentCommitView extends _react2.default.Component {

  render() {
    const authorMoment = (0, _moment2.default)(this.props.commit.getAuthorDate() * 1000);
    const fullMessage = this.props.commit.getFullMessage();

    return _react2.default.createElement(
      'li',
      { className: (0, _classnames2.default)('github-RecentCommit', { 'most-recent': this.props.isMostRecent }) },
      this.renderAuthors(),
      _react2.default.createElement(
        'span',
        {
          className: 'github-RecentCommit-message',
          title: (0, _nodeEmoji.emojify)(fullMessage) },
        (0, _nodeEmoji.emojify)(this.props.commit.getMessageSubject())
      ),
      this.props.isMostRecent && _react2.default.createElement(
        'button',
        {
          className: 'btn github-RecentCommit-undoButton',
          onClick: this.props.undoLastCommit },
        'Undo'
      ),
      _react2.default.createElement(_timeago2.default, {
        className: 'github-RecentCommit-time',
        type: 'time',
        displayStyle: 'short',
        time: authorMoment,
        title: authorMoment.format('MMM Do, YYYY')
      })
    );
  }

  renderAuthor(email) {
    const match = email.match(/^(\d+)\+[^@]+@users.noreply.github.com$/);

    let avatarUrl;
    if (match) {
      avatarUrl = 'https://avatars.githubusercontent.com/u/' + match[1] + '?s=32';
    } else {
      avatarUrl = 'https://avatars.githubusercontent.com/u/e?email=' + encodeURIComponent(email) + '&s=32';
    }

    return _react2.default.createElement('img', { className: 'github-RecentCommit-avatar',
      key: email,
      src: avatarUrl,
      title: email,
      alt: `${email}'s avatar'`
    });
  }

  renderAuthors() {
    const coAuthorEmails = this.props.commit.getCoAuthors().map(author => author.email);
    const authorEmails = [this.props.commit.getAuthorEmail(), ...coAuthorEmails];

    return _react2.default.createElement(
      'span',
      { className: 'github-RecentCommit-authors' },
      authorEmails.map(this.renderAuthor)
    );
  }
}

RecentCommitView.propTypes = {
  commit: _propTypes2.default.object.isRequired,
  undoLastCommit: _propTypes2.default.func.isRequired,
  isMostRecent: _propTypes2.default.bool.isRequired
};
class RecentCommitsView extends _react2.default.Component {

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-RecentCommits' },
      this.renderCommits()
    );
  }

  renderCommits() {
    if (this.props.commits.length === 0) {
      if (this.props.isLoading) {
        return _react2.default.createElement(
          'div',
          { className: 'github-RecentCommits-message' },
          'Recent commits'
        );
      } else {
        return _react2.default.createElement(
          'div',
          { className: 'github-RecentCommits-message' },
          'Make your first commit'
        );
      }
    } else {
      return _react2.default.createElement(
        'ul',
        { className: 'github-RecentCommits-list' },
        this.props.commits.map((commit, i) => {
          return _react2.default.createElement(RecentCommitView, {
            key: commit.getSha(),
            isMostRecent: i === 0,
            commit: commit,
            undoLastCommit: this.props.undoLastCommit
          });
        })
      );
    }
  }
}
exports.default = RecentCommitsView;
RecentCommitsView.propTypes = {
  commits: _propTypes2.default.arrayOf(_propTypes2.default.object).isRequired,
  isLoading: _propTypes2.default.bool.isRequired,
  undoLastCommit: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJlY2VudC1jb21taXRzLXZpZXcuanMiXSwibmFtZXMiOlsiUmVjZW50Q29tbWl0VmlldyIsIlJlYWN0IiwiQ29tcG9uZW50IiwicmVuZGVyIiwiYXV0aG9yTW9tZW50IiwicHJvcHMiLCJjb21taXQiLCJnZXRBdXRob3JEYXRlIiwiZnVsbE1lc3NhZ2UiLCJnZXRGdWxsTWVzc2FnZSIsImlzTW9zdFJlY2VudCIsInJlbmRlckF1dGhvcnMiLCJnZXRNZXNzYWdlU3ViamVjdCIsInVuZG9MYXN0Q29tbWl0IiwiZm9ybWF0IiwicmVuZGVyQXV0aG9yIiwiZW1haWwiLCJtYXRjaCIsImF2YXRhclVybCIsImVuY29kZVVSSUNvbXBvbmVudCIsImNvQXV0aG9yRW1haWxzIiwiZ2V0Q29BdXRob3JzIiwibWFwIiwiYXV0aG9yIiwiYXV0aG9yRW1haWxzIiwiZ2V0QXV0aG9yRW1haWwiLCJwcm9wVHlwZXMiLCJQcm9wVHlwZXMiLCJvYmplY3QiLCJpc1JlcXVpcmVkIiwiZnVuYyIsImJvb2wiLCJSZWNlbnRDb21taXRzVmlldyIsInJlbmRlckNvbW1pdHMiLCJjb21taXRzIiwibGVuZ3RoIiwiaXNMb2FkaW5nIiwiaSIsImdldFNoYSIsImFycmF5T2YiXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7O0FBRUE7Ozs7OztBQUVBLE1BQU1BLGdCQUFOLFNBQStCQyxnQkFBTUMsU0FBckMsQ0FBK0M7O0FBTzdDQyxXQUFTO0FBQ1AsVUFBTUMsZUFBZSxzQkFBTyxLQUFLQyxLQUFMLENBQVdDLE1BQVgsQ0FBa0JDLGFBQWxCLEtBQW9DLElBQTNDLENBQXJCO0FBQ0EsVUFBTUMsY0FBYyxLQUFLSCxLQUFMLENBQVdDLE1BQVgsQ0FBa0JHLGNBQWxCLEVBQXBCOztBQUVBLFdBQ0U7QUFBQTtBQUFBLFFBQUksV0FBVywwQkFBRyxxQkFBSCxFQUEwQixFQUFDLGVBQWUsS0FBS0osS0FBTCxDQUFXSyxZQUEzQixFQUExQixDQUFmO0FBQ0csV0FBS0MsYUFBTCxFQURIO0FBRUU7QUFBQTtBQUFBO0FBQ0UscUJBQVUsNkJBRFo7QUFFRSxpQkFBTyx3QkFBUUgsV0FBUixDQUZUO0FBR0csZ0NBQVEsS0FBS0gsS0FBTCxDQUFXQyxNQUFYLENBQWtCTSxpQkFBbEIsRUFBUjtBQUhILE9BRkY7QUFPRyxXQUFLUCxLQUFMLENBQVdLLFlBQVgsSUFDQztBQUFBO0FBQUE7QUFDRSxxQkFBVSxvQ0FEWjtBQUVFLG1CQUFTLEtBQUtMLEtBQUwsQ0FBV1EsY0FGdEI7QUFBQTtBQUFBLE9BUko7QUFjRSxvQ0FBQyxpQkFBRDtBQUNFLG1CQUFVLDBCQURaO0FBRUUsY0FBSyxNQUZQO0FBR0Usc0JBQWEsT0FIZjtBQUlFLGNBQU1ULFlBSlI7QUFLRSxlQUFPQSxhQUFhVSxNQUFiLENBQW9CLGNBQXBCO0FBTFQ7QUFkRixLQURGO0FBd0JEOztBQUVEQyxlQUFhQyxLQUFiLEVBQW9CO0FBQ2xCLFVBQU1DLFFBQVFELE1BQU1DLEtBQU4sQ0FBWSx5Q0FBWixDQUFkOztBQUVBLFFBQUlDLFNBQUo7QUFDQSxRQUFJRCxLQUFKLEVBQVc7QUFDVEMsa0JBQVksNkNBQTZDRCxNQUFNLENBQU4sQ0FBN0MsR0FBd0QsT0FBcEU7QUFDRCxLQUZELE1BRU87QUFDTEMsa0JBQVkscURBQXFEQyxtQkFBbUJILEtBQW5CLENBQXJELEdBQWlGLE9BQTdGO0FBQ0Q7O0FBRUQsV0FDRSx1Q0FBSyxXQUFVLDRCQUFmO0FBQ0UsV0FBS0EsS0FEUDtBQUVFLFdBQUtFLFNBRlA7QUFHRSxhQUFPRixLQUhUO0FBSUUsV0FBTSxHQUFFQSxLQUFNO0FBSmhCLE1BREY7QUFRRDs7QUFFREwsa0JBQWdCO0FBQ2QsVUFBTVMsaUJBQWlCLEtBQUtmLEtBQUwsQ0FBV0MsTUFBWCxDQUFrQmUsWUFBbEIsR0FBaUNDLEdBQWpDLENBQXFDQyxVQUFVQSxPQUFPUCxLQUF0RCxDQUF2QjtBQUNBLFVBQU1RLGVBQWUsQ0FBQyxLQUFLbkIsS0FBTCxDQUFXQyxNQUFYLENBQWtCbUIsY0FBbEIsRUFBRCxFQUFxQyxHQUFHTCxjQUF4QyxDQUFyQjs7QUFFQSxXQUNFO0FBQUE7QUFBQSxRQUFNLFdBQVUsNkJBQWhCO0FBQ0dJLG1CQUFhRixHQUFiLENBQWlCLEtBQUtQLFlBQXRCO0FBREgsS0FERjtBQUtEO0FBbEU0Qzs7QUFBekNmLGdCLENBQ0cwQixTLEdBQVk7QUFDakJwQixVQUFRcUIsb0JBQVVDLE1BQVYsQ0FBaUJDLFVBRFI7QUFFakJoQixrQkFBZ0JjLG9CQUFVRyxJQUFWLENBQWVELFVBRmQ7QUFHakJuQixnQkFBY2lCLG9CQUFVSSxJQUFWLENBQWVGO0FBSFosQztBQW9FTixNQUFNRyxpQkFBTixTQUFnQy9CLGdCQUFNQyxTQUF0QyxDQUFnRDs7QUFPN0RDLFdBQVM7QUFDUCxXQUNFO0FBQUE7QUFBQSxRQUFLLFdBQVUsc0JBQWY7QUFDRyxXQUFLOEIsYUFBTDtBQURILEtBREY7QUFLRDs7QUFFREEsa0JBQWdCO0FBQ2QsUUFBSSxLQUFLNUIsS0FBTCxDQUFXNkIsT0FBWCxDQUFtQkMsTUFBbkIsS0FBOEIsQ0FBbEMsRUFBcUM7QUFDbkMsVUFBSSxLQUFLOUIsS0FBTCxDQUFXK0IsU0FBZixFQUEwQjtBQUN4QixlQUNFO0FBQUE7QUFBQSxZQUFLLFdBQVUsOEJBQWY7QUFBQTtBQUFBLFNBREY7QUFLRCxPQU5ELE1BTU87QUFDTCxlQUNFO0FBQUE7QUFBQSxZQUFLLFdBQVUsOEJBQWY7QUFBQTtBQUFBLFNBREY7QUFLRDtBQUNGLEtBZEQsTUFjTztBQUNMLGFBQ0U7QUFBQTtBQUFBLFVBQUksV0FBVSwyQkFBZDtBQUNHLGFBQUsvQixLQUFMLENBQVc2QixPQUFYLENBQW1CWixHQUFuQixDQUF1QixDQUFDaEIsTUFBRCxFQUFTK0IsQ0FBVCxLQUFlO0FBQ3JDLGlCQUNFLDhCQUFDLGdCQUFEO0FBQ0UsaUJBQUsvQixPQUFPZ0MsTUFBUCxFQURQO0FBRUUsMEJBQWNELE1BQU0sQ0FGdEI7QUFHRSxvQkFBUS9CLE1BSFY7QUFJRSw0QkFBZ0IsS0FBS0QsS0FBTCxDQUFXUTtBQUo3QixZQURGO0FBUUQsU0FUQTtBQURILE9BREY7QUFjRDtBQUVGO0FBL0M0RDtrQkFBMUNtQixpQjtBQUFBQSxpQixDQUNaTixTLEdBQVk7QUFDakJRLFdBQVNQLG9CQUFVWSxPQUFWLENBQWtCWixvQkFBVUMsTUFBNUIsRUFBb0NDLFVBRDVCO0FBRWpCTyxhQUFXVCxvQkFBVUksSUFBVixDQUFlRixVQUZUO0FBR2pCaEIsa0JBQWdCYyxvQkFBVUcsSUFBVixDQUFlRDtBQUhkLEMiLCJmaWxlIjoicmVjZW50LWNvbW1pdHMtdmlldy5qcyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM0LjAvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViL2xpYi92aWV3cyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IG1vbWVudCBmcm9tICdtb21lbnQnO1xuaW1wb3J0IGN4IGZyb20gJ2NsYXNzbmFtZXMnO1xuaW1wb3J0IHtlbW9qaWZ5fSBmcm9tICdub2RlLWVtb2ppJztcblxuaW1wb3J0IFRpbWVhZ28gZnJvbSAnLi90aW1lYWdvJztcblxuY2xhc3MgUmVjZW50Q29tbWl0VmlldyBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgY29tbWl0OiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgdW5kb0xhc3RDb21taXQ6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgaXNNb3N0UmVjZW50OiBQcm9wVHlwZXMuYm9vbC5pc1JlcXVpcmVkLFxuICB9O1xuXG4gIHJlbmRlcigpIHtcbiAgICBjb25zdCBhdXRob3JNb21lbnQgPSBtb21lbnQodGhpcy5wcm9wcy5jb21taXQuZ2V0QXV0aG9yRGF0ZSgpICogMTAwMCk7XG4gICAgY29uc3QgZnVsbE1lc3NhZ2UgPSB0aGlzLnByb3BzLmNvbW1pdC5nZXRGdWxsTWVzc2FnZSgpO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxsaSBjbGFzc05hbWU9e2N4KCdnaXRodWItUmVjZW50Q29tbWl0Jywgeydtb3N0LXJlY2VudCc6IHRoaXMucHJvcHMuaXNNb3N0UmVjZW50fSl9PlxuICAgICAgICB7dGhpcy5yZW5kZXJBdXRob3JzKCl9XG4gICAgICAgIDxzcGFuXG4gICAgICAgICAgY2xhc3NOYW1lPVwiZ2l0aHViLVJlY2VudENvbW1pdC1tZXNzYWdlXCJcbiAgICAgICAgICB0aXRsZT17ZW1vamlmeShmdWxsTWVzc2FnZSl9PlxuICAgICAgICAgIHtlbW9qaWZ5KHRoaXMucHJvcHMuY29tbWl0LmdldE1lc3NhZ2VTdWJqZWN0KCkpfVxuICAgICAgICA8L3NwYW4+XG4gICAgICAgIHt0aGlzLnByb3BzLmlzTW9zdFJlY2VudCAmJiAoXG4gICAgICAgICAgPGJ1dHRvblxuICAgICAgICAgICAgY2xhc3NOYW1lPVwiYnRuIGdpdGh1Yi1SZWNlbnRDb21taXQtdW5kb0J1dHRvblwiXG4gICAgICAgICAgICBvbkNsaWNrPXt0aGlzLnByb3BzLnVuZG9MYXN0Q29tbWl0fT5cbiAgICAgICAgICAgIFVuZG9cbiAgICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgKX1cbiAgICAgICAgPFRpbWVhZ29cbiAgICAgICAgICBjbGFzc05hbWU9XCJnaXRodWItUmVjZW50Q29tbWl0LXRpbWVcIlxuICAgICAgICAgIHR5cGU9XCJ0aW1lXCJcbiAgICAgICAgICBkaXNwbGF5U3R5bGU9XCJzaG9ydFwiXG4gICAgICAgICAgdGltZT17YXV0aG9yTW9tZW50fVxuICAgICAgICAgIHRpdGxlPXthdXRob3JNb21lbnQuZm9ybWF0KCdNTU0gRG8sIFlZWVknKX1cbiAgICAgICAgLz5cbiAgICAgIDwvbGk+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlckF1dGhvcihlbWFpbCkge1xuICAgIGNvbnN0IG1hdGNoID0gZW1haWwubWF0Y2goL14oXFxkKylcXCtbXkBdK0B1c2Vycy5ub3JlcGx5LmdpdGh1Yi5jb20kLyk7XG5cbiAgICBsZXQgYXZhdGFyVXJsO1xuICAgIGlmIChtYXRjaCkge1xuICAgICAgYXZhdGFyVXJsID0gJ2h0dHBzOi8vYXZhdGFycy5naXRodWJ1c2VyY29udGVudC5jb20vdS8nICsgbWF0Y2hbMV0gKyAnP3M9MzInO1xuICAgIH0gZWxzZSB7XG4gICAgICBhdmF0YXJVcmwgPSAnaHR0cHM6Ly9hdmF0YXJzLmdpdGh1YnVzZXJjb250ZW50LmNvbS91L2U/ZW1haWw9JyArIGVuY29kZVVSSUNvbXBvbmVudChlbWFpbCkgKyAnJnM9MzInO1xuICAgIH1cblxuICAgIHJldHVybiAoXG4gICAgICA8aW1nIGNsYXNzTmFtZT1cImdpdGh1Yi1SZWNlbnRDb21taXQtYXZhdGFyXCJcbiAgICAgICAga2V5PXtlbWFpbH1cbiAgICAgICAgc3JjPXthdmF0YXJVcmx9XG4gICAgICAgIHRpdGxlPXtlbWFpbH1cbiAgICAgICAgYWx0PXtgJHtlbWFpbH0ncyBhdmF0YXInYH1cbiAgICAgIC8+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlckF1dGhvcnMoKSB7XG4gICAgY29uc3QgY29BdXRob3JFbWFpbHMgPSB0aGlzLnByb3BzLmNvbW1pdC5nZXRDb0F1dGhvcnMoKS5tYXAoYXV0aG9yID0+IGF1dGhvci5lbWFpbCk7XG4gICAgY29uc3QgYXV0aG9yRW1haWxzID0gW3RoaXMucHJvcHMuY29tbWl0LmdldEF1dGhvckVtYWlsKCksIC4uLmNvQXV0aG9yRW1haWxzXTtcblxuICAgIHJldHVybiAoXG4gICAgICA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItUmVjZW50Q29tbWl0LWF1dGhvcnNcIj5cbiAgICAgICAge2F1dGhvckVtYWlscy5tYXAodGhpcy5yZW5kZXJBdXRob3IpfVxuICAgICAgPC9zcGFuPlxuICAgICk7XG4gIH1cbn1cblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgUmVjZW50Q29tbWl0c1ZpZXcgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIGNvbW1pdHM6IFByb3BUeXBlcy5hcnJheU9mKFByb3BUeXBlcy5vYmplY3QpLmlzUmVxdWlyZWQsXG4gICAgaXNMb2FkaW5nOiBQcm9wVHlwZXMuYm9vbC5pc1JlcXVpcmVkLFxuICAgIHVuZG9MYXN0Q29tbWl0OiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICB9O1xuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItUmVjZW50Q29tbWl0c1wiPlxuICAgICAgICB7dGhpcy5yZW5kZXJDb21taXRzKCl9XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyQ29tbWl0cygpIHtcbiAgICBpZiAodGhpcy5wcm9wcy5jb21taXRzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgaWYgKHRoaXMucHJvcHMuaXNMb2FkaW5nKSB7XG4gICAgICAgIHJldHVybiAoXG4gICAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItUmVjZW50Q29tbWl0cy1tZXNzYWdlXCI+XG4gICAgICAgICAgICBSZWNlbnQgY29tbWl0c1xuICAgICAgICAgIDwvZGl2PlxuICAgICAgICApO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1SZWNlbnRDb21taXRzLW1lc3NhZ2VcIj5cbiAgICAgICAgICAgIE1ha2UgeW91ciBmaXJzdCBjb21taXRcbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgKTtcbiAgICAgIH1cbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPHVsIGNsYXNzTmFtZT1cImdpdGh1Yi1SZWNlbnRDb21taXRzLWxpc3RcIj5cbiAgICAgICAgICB7dGhpcy5wcm9wcy5jb21taXRzLm1hcCgoY29tbWl0LCBpKSA9PiB7XG4gICAgICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgICA8UmVjZW50Q29tbWl0Vmlld1xuICAgICAgICAgICAgICAgIGtleT17Y29tbWl0LmdldFNoYSgpfVxuICAgICAgICAgICAgICAgIGlzTW9zdFJlY2VudD17aSA9PT0gMH1cbiAgICAgICAgICAgICAgICBjb21taXQ9e2NvbW1pdH1cbiAgICAgICAgICAgICAgICB1bmRvTGFzdENvbW1pdD17dGhpcy5wcm9wcy51bmRvTGFzdENvbW1pdH1cbiAgICAgICAgICAgICAgLz5cbiAgICAgICAgICAgICk7XG4gICAgICAgICAgfSl9XG4gICAgICAgIDwvdWw+XG4gICAgICApO1xuICAgIH1cblxuICB9XG59XG4iXX0=