'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarePrStatusesView = exports.stateToIconAndStyle = undefined;
exports.category = category;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _helpers = require('../helpers');

var _prStatusContextView = require('./pr-status-context-view');

var _prStatusContextView2 = _interopRequireDefault(_prStatusContextView);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _statusDonutChart = require('./status-donut-chart');

var _statusDonutChart2 = _interopRequireDefault(_statusDonutChart);

var _periodicRefresher = require('../periodic-refresher');

var _periodicRefresher2 = _interopRequireDefault(_periodicRefresher);

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const stateToIconAndStyle = exports.stateToIconAndStyle = {
  EXPECTED: { category: 'PENDING', icon: 'primitive-dot', style: 'github-PrStatuses--warning' },
  PENDING: { category: 'PENDING', icon: 'primitive-dot', style: 'github-PrStatuses--warning' },
  SUCCESS: { category: 'SUCCESS', icon: 'check', style: 'github-PrStatuses--success' },
  ERROR: { category: 'FAILURE', icon: 'alert', style: 'github-PrStatuses--error' },
  FAILURE: { category: 'FAILURE', icon: 'x', style: 'github-PrStatuses--error' }
};

function category(state) {
  const info = stateToIconAndStyle[state];
  if (!info) {
    throw new Error(`Unknown state ${state}`);
  }
  return info.category;
}

class BarePrStatusesView extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'refresh');
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher2.default(this.constructor, {
      interval: () => {
        if (this.isPendingResults()) {
          return this.constructor.PENDING_REFRESH_TIMEOUT;
        } else {
          return this.constructor.SUCCESS_REFRESH_TIMEOUT;
        }
      },
      getCurrentId: () => this.props.pullRequest.id,
      refresh: this.refresh,
      minimumIntervalPerId: this.constructor.MINIMUM_REFRESH_INTERVAL
    });
    this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  refresh() {
    this.props.relay.refetch({
      id: this.props.pullRequest.id
    }, null, null, { force: true });
  }

  render() {
    const headCommit = this.props.pullRequest.recentCommits.edges[0].node.commit;
    if (!headCommit.status) {
      return null;
    }
    const { state, contexts } = headCommit.status;

    if (this.props.displayType === 'check') {
      const { icon, style } = stateToIconAndStyle[state];
      return _react2.default.createElement(_octicon2.default, { icon: icon, className: style });
    } else if (this.props.displayType === 'full') {
      return _react2.default.createElement(
        'div',
        { className: 'github-PrStatuses' },
        _react2.default.createElement(
          'div',
          { className: 'github-PrStatuses-header' },
          _react2.default.createElement(
            'div',
            { className: 'github-PrStatuses-donut-chart' },
            this.renderDonutChart(headCommit.status)
          ),
          _react2.default.createElement(
            'div',
            { className: 'github-PrStatuses-summary' },
            this.summarySentence(headCommit.status)
          )
        ),
        _react2.default.createElement(
          'ul',
          { className: 'github-PrStatuses-list' },
          contexts.map(context => _react2.default.createElement(_prStatusContextView2.default, { key: context.id, context: context }))
        )
      );
    } else {
      throw new Error(`Invalid \`displayType\` prop value: ${this.props.displayType}`);
    }
  }

  isPendingResults() {
    const headCommit = this.props.pullRequest.recentCommits.edges[0].node.commit;
    if (!headCommit.status) {
      return false;
    }
    const { contexts } = headCommit.status;
    return contexts.some(c => category(c.state) === 'PENDING');
  }

  renderDonutChart(status) {
    const { contexts } = status;
    const pendingLen = contexts.filter(c => category(c.state) === 'PENDING').length;
    const failedLen = contexts.filter(c => category(c.state) === 'FAILURE').length;
    const succeededLen = contexts.filter(c => category(c.state) === 'SUCCESS').length;

    return _react2.default.createElement(_statusDonutChart2.default, {
      pending: pendingLen,
      failure: failedLen,
      success: succeededLen
    });
  }

  summarySentence(status) {
    if (this.isAllSucceeded(status)) {
      return 'All checks succeeded';
    } else if (this.isAllFailed(status)) {
      return 'All checks failed';
    } else {
      const { contexts } = status;
      const noun = contexts.length === 1 ? 'check' : 'checks';
      const parts = [];
      const pending = contexts.filter(c => category(c.state) === 'PENDING');
      const failing = contexts.filter(c => category(c.state) === 'FAILURE');
      const succeeded = contexts.filter(c => category(c.state) === 'SUCCESS');
      if (pending.length) {
        parts.push(`${pending.length} pending`);
      }
      if (failing.length) {
        parts.push(`${failing.length} failing`);
      }
      if (succeeded.length) {
        parts.push(`${succeeded.length} successful`);
      }
      return (0, _helpers.toSentence)(parts) + ` ${noun}`;
    }
  }

  isAllSucceeded(status) {
    return category(status.state) === 'SUCCESS';
  }

  isAllFailed(status) {
    return status.contexts.every(c => category(c.state) === 'FAILURE');
  }
}

exports.BarePrStatusesView = BarePrStatusesView;
BarePrStatusesView.propTypes = {
  relay: _propTypes2.default.shape({
    refetch: _propTypes2.default.func.isRequired
  }).isRequired,
  displayType: _propTypes2.default.oneOf(['check', 'full']),
  pullRequest: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    recentCommits: (0, _propTypes3.RelayConnectionPropType)(_propTypes2.default.shape({
      commit: _propTypes2.default.shape({
        status: _propTypes2.default.shape({
          state: _propTypes2.default.string.isRequired,
          contexts: _propTypes2.default.arrayOf(_propTypes2.default.shape({
            id: _propTypes2.default.string.isRequired
          }).isRequired).isRequired
        })
      }).isRequired
    }).isRequired).isRequired
  }).isRequired
};
BarePrStatusesView.defaultProps = {
  displayType: 'full'
};
BarePrStatusesView.lastRefreshPerPr = new Map();
BarePrStatusesView.SUCCESS_REFRESH_TIMEOUT = 3 * 60 * 1000;
BarePrStatusesView.PENDING_REFRESH_TIMEOUT = 30 * 1000;
BarePrStatusesView.MINIMUM_REFRESH_INTERVAL = 15 * 1000;
exports.default = (0, _reactRelay.createRefetchContainer)(BarePrStatusesView, {
  pullRequest: function () {
    const node = require('./__generated__/prStatusesView_pullRequest.graphql');

    if (node.hash && node.hash !== '96a5a2c7004e7526967de3b7b551a54b') {
      console.error('The definition of \'prStatusesView_pullRequest\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/prStatusesView_pullRequest.graphql');
  }
}, function () {
  const node = require('./__generated__/prStatusesViewRefetchQuery.graphql');

  if (node.hash && node.hash !== 'a7600333b3bc426d899c4d0183095a1f') {
    console.error('The definition of \'prStatusesViewRefetchQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
  }

  return require('./__generated__/prStatusesViewRefetchQuery.graphql');
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInByLXN0YXR1c2VzLXZpZXcuanMiXSwibmFtZXMiOlsiY2F0ZWdvcnkiLCJzdGF0ZVRvSWNvbkFuZFN0eWxlIiwiRVhQRUNURUQiLCJpY29uIiwic3R5bGUiLCJQRU5ESU5HIiwiU1VDQ0VTUyIsIkVSUk9SIiwiRkFJTFVSRSIsInN0YXRlIiwiaW5mbyIsIkVycm9yIiwiQmFyZVByU3RhdHVzZXNWaWV3IiwiUmVhY3QiLCJDb21wb25lbnQiLCJjb25zdHJ1Y3RvciIsInByb3BzIiwiY29tcG9uZW50RGlkTW91bnQiLCJyZWZyZXNoZXIiLCJQZXJpb2RpY1JlZnJlc2hlciIsImludGVydmFsIiwiaXNQZW5kaW5nUmVzdWx0cyIsIlBFTkRJTkdfUkVGUkVTSF9USU1FT1VUIiwiU1VDQ0VTU19SRUZSRVNIX1RJTUVPVVQiLCJnZXRDdXJyZW50SWQiLCJwdWxsUmVxdWVzdCIsImlkIiwicmVmcmVzaCIsIm1pbmltdW1JbnRlcnZhbFBlcklkIiwiTUlOSU1VTV9SRUZSRVNIX0lOVEVSVkFMIiwic3RhcnQiLCJjb21wb25lbnRXaWxsVW5tb3VudCIsImRlc3Ryb3kiLCJyZWxheSIsInJlZmV0Y2giLCJmb3JjZSIsInJlbmRlciIsImhlYWRDb21taXQiLCJyZWNlbnRDb21taXRzIiwiZWRnZXMiLCJub2RlIiwiY29tbWl0Iiwic3RhdHVzIiwiY29udGV4dHMiLCJkaXNwbGF5VHlwZSIsInJlbmRlckRvbnV0Q2hhcnQiLCJzdW1tYXJ5U2VudGVuY2UiLCJtYXAiLCJjb250ZXh0Iiwic29tZSIsImMiLCJwZW5kaW5nTGVuIiwiZmlsdGVyIiwibGVuZ3RoIiwiZmFpbGVkTGVuIiwic3VjY2VlZGVkTGVuIiwiaXNBbGxTdWNjZWVkZWQiLCJpc0FsbEZhaWxlZCIsIm5vdW4iLCJwYXJ0cyIsInBlbmRpbmciLCJmYWlsaW5nIiwic3VjY2VlZGVkIiwicHVzaCIsImV2ZXJ5IiwicHJvcFR5cGVzIiwiUHJvcFR5cGVzIiwic2hhcGUiLCJmdW5jIiwiaXNSZXF1aXJlZCIsIm9uZU9mIiwic3RyaW5nIiwiYXJyYXlPZiIsImRlZmF1bHRQcm9wcyIsImxhc3RSZWZyZXNoUGVyUHIiLCJNYXAiXSwibWFwcGluZ3MiOiI7Ozs7OztRQW1CZ0JBLFEsR0FBQUEsUTs7QUFuQmhCOzs7O0FBQ0E7O0FBQ0E7Ozs7QUFFQTs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBRU8sTUFBTUMsb0RBQXNCO0FBQ2pDQyxZQUFVLEVBQUNGLFVBQVUsU0FBWCxFQUFzQkcsTUFBTSxlQUE1QixFQUE2Q0MsT0FBTyw0QkFBcEQsRUFEdUI7QUFFakNDLFdBQVMsRUFBQ0wsVUFBVSxTQUFYLEVBQXNCRyxNQUFNLGVBQTVCLEVBQTZDQyxPQUFPLDRCQUFwRCxFQUZ3QjtBQUdqQ0UsV0FBUyxFQUFDTixVQUFVLFNBQVgsRUFBc0JHLE1BQU0sT0FBNUIsRUFBcUNDLE9BQU8sNEJBQTVDLEVBSHdCO0FBSWpDRyxTQUFPLEVBQUNQLFVBQVUsU0FBWCxFQUFzQkcsTUFBTSxPQUE1QixFQUFxQ0MsT0FBTywwQkFBNUMsRUFKMEI7QUFLakNJLFdBQVMsRUFBQ1IsVUFBVSxTQUFYLEVBQXNCRyxNQUFNLEdBQTVCLEVBQWlDQyxPQUFPLDBCQUF4QztBQUx3QixDQUE1Qjs7QUFRQSxTQUFTSixRQUFULENBQWtCUyxLQUFsQixFQUF5QjtBQUM5QixRQUFNQyxPQUFPVCxvQkFBb0JRLEtBQXBCLENBQWI7QUFDQSxNQUFJLENBQUNDLElBQUwsRUFBVztBQUNULFVBQU0sSUFBSUMsS0FBSixDQUFXLGlCQUFnQkYsS0FBTSxFQUFqQyxDQUFOO0FBQ0Q7QUFDRCxTQUFPQyxLQUFLVixRQUFaO0FBQ0Q7O0FBRU0sTUFBTVksa0JBQU4sU0FBaUNDLGdCQUFNQyxTQUF2QyxDQUFpRDs7QUFvQ3REQyxjQUFZQyxLQUFaLEVBQW1CO0FBQ2pCLFVBQU1BLEtBQU47QUFDQSwyQkFBUyxJQUFULEVBQWUsU0FBZjtBQUNEOztBQUVEQyxzQkFBb0I7QUFDbEIsU0FBS0MsU0FBTCxHQUFpQixJQUFJQywyQkFBSixDQUFzQixLQUFLSixXQUEzQixFQUF3QztBQUN2REssZ0JBQVUsTUFBTTtBQUNkLFlBQUksS0FBS0MsZ0JBQUwsRUFBSixFQUE2QjtBQUMzQixpQkFBTyxLQUFLTixXQUFMLENBQWlCTyx1QkFBeEI7QUFDRCxTQUZELE1BRU87QUFDTCxpQkFBTyxLQUFLUCxXQUFMLENBQWlCUSx1QkFBeEI7QUFDRDtBQUNGLE9BUHNEO0FBUXZEQyxvQkFBYyxNQUFNLEtBQUtSLEtBQUwsQ0FBV1MsV0FBWCxDQUF1QkMsRUFSWTtBQVN2REMsZUFBUyxLQUFLQSxPQVR5QztBQVV2REMsNEJBQXNCLEtBQUtiLFdBQUwsQ0FBaUJjO0FBVmdCLEtBQXhDLENBQWpCO0FBWUEsU0FBS1gsU0FBTCxDQUFlWSxLQUFmO0FBQ0Q7O0FBRURDLHlCQUF1QjtBQUNyQixTQUFLYixTQUFMLENBQWVjLE9BQWY7QUFDRDs7QUFFREwsWUFBVTtBQUNSLFNBQUtYLEtBQUwsQ0FBV2lCLEtBQVgsQ0FBaUJDLE9BQWpCLENBQXlCO0FBQ3ZCUixVQUFJLEtBQUtWLEtBQUwsQ0FBV1MsV0FBWCxDQUF1QkM7QUFESixLQUF6QixFQUVHLElBRkgsRUFFUyxJQUZULEVBRWUsRUFBQ1MsT0FBTyxJQUFSLEVBRmY7QUFHRDs7QUFFREMsV0FBUztBQUNQLFVBQU1DLGFBQWEsS0FBS3JCLEtBQUwsQ0FBV1MsV0FBWCxDQUF1QmEsYUFBdkIsQ0FBcUNDLEtBQXJDLENBQTJDLENBQTNDLEVBQThDQyxJQUE5QyxDQUFtREMsTUFBdEU7QUFDQSxRQUFJLENBQUNKLFdBQVdLLE1BQWhCLEVBQXdCO0FBQUUsYUFBTyxJQUFQO0FBQWM7QUFDeEMsVUFBTSxFQUFDakMsS0FBRCxFQUFRa0MsUUFBUixLQUFvQk4sV0FBV0ssTUFBckM7O0FBRUEsUUFBSSxLQUFLMUIsS0FBTCxDQUFXNEIsV0FBWCxLQUEyQixPQUEvQixFQUF3QztBQUN0QyxZQUFNLEVBQUN6QyxJQUFELEVBQU9DLEtBQVAsS0FBZ0JILG9CQUFvQlEsS0FBcEIsQ0FBdEI7QUFDQSxhQUFPLDhCQUFDLGlCQUFELElBQVMsTUFBTU4sSUFBZixFQUFxQixXQUFXQyxLQUFoQyxHQUFQO0FBQ0QsS0FIRCxNQUdPLElBQUksS0FBS1ksS0FBTCxDQUFXNEIsV0FBWCxLQUEyQixNQUEvQixFQUF1QztBQUM1QyxhQUNFO0FBQUE7QUFBQSxVQUFLLFdBQVUsbUJBQWY7QUFDRTtBQUFBO0FBQUEsWUFBSyxXQUFVLDBCQUFmO0FBQ0U7QUFBQTtBQUFBLGNBQUssV0FBVSwrQkFBZjtBQUNHLGlCQUFLQyxnQkFBTCxDQUFzQlIsV0FBV0ssTUFBakM7QUFESCxXQURGO0FBSUU7QUFBQTtBQUFBLGNBQUssV0FBVSwyQkFBZjtBQUNHLGlCQUFLSSxlQUFMLENBQXFCVCxXQUFXSyxNQUFoQztBQURIO0FBSkYsU0FERjtBQVNFO0FBQUE7QUFBQSxZQUFJLFdBQVUsd0JBQWQ7QUFDR0MsbUJBQVNJLEdBQVQsQ0FBYUMsV0FBVyw4QkFBQyw2QkFBRCxJQUFxQixLQUFLQSxRQUFRdEIsRUFBbEMsRUFBc0MsU0FBU3NCLE9BQS9DLEdBQXhCO0FBREg7QUFURixPQURGO0FBZUQsS0FoQk0sTUFnQkE7QUFDTCxZQUFNLElBQUlyQyxLQUFKLENBQVcsdUNBQXNDLEtBQUtLLEtBQUwsQ0FBVzRCLFdBQVksRUFBeEUsQ0FBTjtBQUNEO0FBQ0Y7O0FBRUR2QixxQkFBbUI7QUFDakIsVUFBTWdCLGFBQWEsS0FBS3JCLEtBQUwsQ0FBV1MsV0FBWCxDQUF1QmEsYUFBdkIsQ0FBcUNDLEtBQXJDLENBQTJDLENBQTNDLEVBQThDQyxJQUE5QyxDQUFtREMsTUFBdEU7QUFDQSxRQUFJLENBQUNKLFdBQVdLLE1BQWhCLEVBQXdCO0FBQUUsYUFBTyxLQUFQO0FBQWU7QUFDekMsVUFBTSxFQUFDQyxRQUFELEtBQWFOLFdBQVdLLE1BQTlCO0FBQ0EsV0FBT0MsU0FBU00sSUFBVCxDQUFjQyxLQUFLbEQsU0FBU2tELEVBQUV6QyxLQUFYLE1BQXNCLFNBQXpDLENBQVA7QUFDRDs7QUFFRG9DLG1CQUFpQkgsTUFBakIsRUFBeUI7QUFDdkIsVUFBTSxFQUFDQyxRQUFELEtBQWFELE1BQW5CO0FBQ0EsVUFBTVMsYUFBYVIsU0FBU1MsTUFBVCxDQUFnQkYsS0FBS2xELFNBQVNrRCxFQUFFekMsS0FBWCxNQUFzQixTQUEzQyxFQUFzRDRDLE1BQXpFO0FBQ0EsVUFBTUMsWUFBWVgsU0FBU1MsTUFBVCxDQUFnQkYsS0FBS2xELFNBQVNrRCxFQUFFekMsS0FBWCxNQUFzQixTQUEzQyxFQUFzRDRDLE1BQXhFO0FBQ0EsVUFBTUUsZUFBZVosU0FBU1MsTUFBVCxDQUFnQkYsS0FBS2xELFNBQVNrRCxFQUFFekMsS0FBWCxNQUFzQixTQUEzQyxFQUFzRDRDLE1BQTNFOztBQUVBLFdBQ0UsOEJBQUMsMEJBQUQ7QUFDRSxlQUFTRixVQURYO0FBRUUsZUFBU0csU0FGWDtBQUdFLGVBQVNDO0FBSFgsTUFERjtBQU9EOztBQUVEVCxrQkFBZ0JKLE1BQWhCLEVBQXdCO0FBQ3RCLFFBQUksS0FBS2MsY0FBTCxDQUFvQmQsTUFBcEIsQ0FBSixFQUFpQztBQUMvQixhQUFPLHNCQUFQO0FBQ0QsS0FGRCxNQUVPLElBQUksS0FBS2UsV0FBTCxDQUFpQmYsTUFBakIsQ0FBSixFQUE4QjtBQUNuQyxhQUFPLG1CQUFQO0FBQ0QsS0FGTSxNQUVBO0FBQ0wsWUFBTSxFQUFDQyxRQUFELEtBQWFELE1BQW5CO0FBQ0EsWUFBTWdCLE9BQU9mLFNBQVNVLE1BQVQsS0FBb0IsQ0FBcEIsR0FBd0IsT0FBeEIsR0FBa0MsUUFBL0M7QUFDQSxZQUFNTSxRQUFRLEVBQWQ7QUFDQSxZQUFNQyxVQUFVakIsU0FBU1MsTUFBVCxDQUFnQkYsS0FBS2xELFNBQVNrRCxFQUFFekMsS0FBWCxNQUFzQixTQUEzQyxDQUFoQjtBQUNBLFlBQU1vRCxVQUFVbEIsU0FBU1MsTUFBVCxDQUFnQkYsS0FBS2xELFNBQVNrRCxFQUFFekMsS0FBWCxNQUFzQixTQUEzQyxDQUFoQjtBQUNBLFlBQU1xRCxZQUFZbkIsU0FBU1MsTUFBVCxDQUFnQkYsS0FBS2xELFNBQVNrRCxFQUFFekMsS0FBWCxNQUFzQixTQUEzQyxDQUFsQjtBQUNBLFVBQUltRCxRQUFRUCxNQUFaLEVBQW9CO0FBQ2xCTSxjQUFNSSxJQUFOLENBQVksR0FBRUgsUUFBUVAsTUFBTyxVQUE3QjtBQUNEO0FBQ0QsVUFBSVEsUUFBUVIsTUFBWixFQUFvQjtBQUNsQk0sY0FBTUksSUFBTixDQUFZLEdBQUVGLFFBQVFSLE1BQU8sVUFBN0I7QUFDRDtBQUNELFVBQUlTLFVBQVVULE1BQWQsRUFBc0I7QUFDcEJNLGNBQU1JLElBQU4sQ0FBWSxHQUFFRCxVQUFVVCxNQUFPLGFBQS9CO0FBQ0Q7QUFDRCxhQUFPLHlCQUFXTSxLQUFYLElBQXFCLElBQUdELElBQUssRUFBcEM7QUFDRDtBQUNGOztBQUVERixpQkFBZWQsTUFBZixFQUF1QjtBQUNyQixXQUFPMUMsU0FBUzBDLE9BQU9qQyxLQUFoQixNQUEyQixTQUFsQztBQUNEOztBQUVEZ0QsY0FBWWYsTUFBWixFQUFvQjtBQUNsQixXQUFPQSxPQUFPQyxRQUFQLENBQWdCcUIsS0FBaEIsQ0FBc0JkLEtBQUtsRCxTQUFTa0QsRUFBRXpDLEtBQVgsTUFBc0IsU0FBakQsQ0FBUDtBQUNEO0FBckpxRDs7UUFBM0NHLGtCLEdBQUFBLGtCO0FBQUFBLGtCLENBQ0pxRCxTLEdBQVk7QUFDakJoQyxTQUFPaUMsb0JBQVVDLEtBQVYsQ0FBZ0I7QUFDckJqQyxhQUFTZ0Msb0JBQVVFLElBQVYsQ0FBZUM7QUFESCxHQUFoQixFQUVKQSxVQUhjO0FBSWpCekIsZUFBYXNCLG9CQUFVSSxLQUFWLENBQWdCLENBQzNCLE9BRDJCLEVBQ2xCLE1BRGtCLENBQWhCLENBSkk7QUFPakI3QyxlQUFheUMsb0JBQVVDLEtBQVYsQ0FBZ0I7QUFDM0J6QyxRQUFJd0Msb0JBQVVLLE1BQVYsQ0FBaUJGLFVBRE07QUFFM0IvQixtQkFBZSx5Q0FDYjRCLG9CQUFVQyxLQUFWLENBQWdCO0FBQ2QxQixjQUFReUIsb0JBQVVDLEtBQVYsQ0FBZ0I7QUFDdEJ6QixnQkFBUXdCLG9CQUFVQyxLQUFWLENBQWdCO0FBQ3RCMUQsaUJBQU95RCxvQkFBVUssTUFBVixDQUFpQkYsVUFERjtBQUV0QjFCLG9CQUFVdUIsb0JBQVVNLE9BQVYsQ0FDUk4sb0JBQVVDLEtBQVYsQ0FBZ0I7QUFDZHpDLGdCQUFJd0Msb0JBQVVLLE1BQVYsQ0FBaUJGO0FBRFAsV0FBaEIsRUFFR0EsVUFISyxFQUlSQTtBQU5vQixTQUFoQjtBQURjLE9BQWhCLEVBU0xBO0FBVlcsS0FBaEIsRUFXR0EsVUFaVSxFQWFiQTtBQWZ5QixHQUFoQixFQWdCVkE7QUF2QmMsQztBQURSekQsa0IsQ0EyQko2RCxZLEdBQWU7QUFDcEI3QixlQUFhO0FBRE8sQztBQTNCWGhDLGtCLENBK0JKOEQsZ0IsR0FBbUIsSUFBSUMsR0FBSixFO0FBL0JmL0Qsa0IsQ0FnQ0pXLHVCLEdBQTBCLElBQUksRUFBSixHQUFTLEk7QUFoQy9CWCxrQixDQWlDSlUsdUIsR0FBMEIsS0FBSyxJO0FBakMzQlYsa0IsQ0FrQ0ppQix3QixHQUEyQixLQUFLLEk7a0JBc0gxQix3Q0FBdUJqQixrQkFBdkIsRUFBMkM7QUFDeERhO0FBQUE7O0FBQUE7QUFBQTtBQUFBOztBQUFBO0FBQUE7QUFEd0QsQ0FBM0M7QUFBQTs7QUFBQTtBQUFBO0FBQUE7O0FBQUE7QUFBQSxFIiwiZmlsZSI6InByLXN0YXR1c2VzLXZpZXcuanMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNC4wL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1Yi9saWIvdmlld3MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IHtjcmVhdGVSZWZldGNoQ29udGFpbmVyLCBncmFwaHFsfSBmcm9tICdyZWFjdC1yZWxheSc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuXG5pbXBvcnQge3RvU2VudGVuY2UsIGF1dG9iaW5kfSBmcm9tICcuLi9oZWxwZXJzJztcbmltcG9ydCBQclN0YXR1c0NvbnRleHRWaWV3IGZyb20gJy4vcHItc3RhdHVzLWNvbnRleHQtdmlldyc7XG5pbXBvcnQgT2N0aWNvbiBmcm9tICcuLi9hdG9tL29jdGljb24nO1xuaW1wb3J0IFN0YXR1c0RvbnV0Q2hhcnQgZnJvbSAnLi9zdGF0dXMtZG9udXQtY2hhcnQnO1xuaW1wb3J0IFBlcmlvZGljUmVmcmVzaGVyIGZyb20gJy4uL3BlcmlvZGljLXJlZnJlc2hlcic7XG5pbXBvcnQge1JlbGF5Q29ubmVjdGlvblByb3BUeXBlfSBmcm9tICcuLi9wcm9wLXR5cGVzJztcblxuZXhwb3J0IGNvbnN0IHN0YXRlVG9JY29uQW5kU3R5bGUgPSB7XG4gIEVYUEVDVEVEOiB7Y2F0ZWdvcnk6ICdQRU5ESU5HJywgaWNvbjogJ3ByaW1pdGl2ZS1kb3QnLCBzdHlsZTogJ2dpdGh1Yi1QclN0YXR1c2VzLS13YXJuaW5nJ30sXG4gIFBFTkRJTkc6IHtjYXRlZ29yeTogJ1BFTkRJTkcnLCBpY29uOiAncHJpbWl0aXZlLWRvdCcsIHN0eWxlOiAnZ2l0aHViLVByU3RhdHVzZXMtLXdhcm5pbmcnfSxcbiAgU1VDQ0VTUzoge2NhdGVnb3J5OiAnU1VDQ0VTUycsIGljb246ICdjaGVjaycsIHN0eWxlOiAnZ2l0aHViLVByU3RhdHVzZXMtLXN1Y2Nlc3MnfSxcbiAgRVJST1I6IHtjYXRlZ29yeTogJ0ZBSUxVUkUnLCBpY29uOiAnYWxlcnQnLCBzdHlsZTogJ2dpdGh1Yi1QclN0YXR1c2VzLS1lcnJvcid9LFxuICBGQUlMVVJFOiB7Y2F0ZWdvcnk6ICdGQUlMVVJFJywgaWNvbjogJ3gnLCBzdHlsZTogJ2dpdGh1Yi1QclN0YXR1c2VzLS1lcnJvcid9LFxufTtcblxuZXhwb3J0IGZ1bmN0aW9uIGNhdGVnb3J5KHN0YXRlKSB7XG4gIGNvbnN0IGluZm8gPSBzdGF0ZVRvSWNvbkFuZFN0eWxlW3N0YXRlXTtcbiAgaWYgKCFpbmZvKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKGBVbmtub3duIHN0YXRlICR7c3RhdGV9YCk7XG4gIH1cbiAgcmV0dXJuIGluZm8uY2F0ZWdvcnk7XG59XG5cbmV4cG9ydCBjbGFzcyBCYXJlUHJTdGF0dXNlc1ZpZXcgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIHJlbGF5OiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgcmVmZXRjaDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICB9KS5pc1JlcXVpcmVkLFxuICAgIGRpc3BsYXlUeXBlOiBQcm9wVHlwZXMub25lT2YoW1xuICAgICAgJ2NoZWNrJywgJ2Z1bGwnLFxuICAgIF0pLFxuICAgIHB1bGxSZXF1ZXN0OiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgaWQ6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgIHJlY2VudENvbW1pdHM6IFJlbGF5Q29ubmVjdGlvblByb3BUeXBlKFxuICAgICAgICBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICAgIGNvbW1pdDogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgICAgICAgIHN0YXR1czogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgICAgICAgICAgc3RhdGU6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgICAgICAgICAgY29udGV4dHM6IFByb3BUeXBlcy5hcnJheU9mKFxuICAgICAgICAgICAgICAgIFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgICAgICAgICAgICBpZDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgICAgICAgICAgIH0pLmlzUmVxdWlyZWQsXG4gICAgICAgICAgICAgICkuaXNSZXF1aXJlZCxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgIH0pLmlzUmVxdWlyZWQsXG4gICAgICAgIH0pLmlzUmVxdWlyZWQsXG4gICAgICApLmlzUmVxdWlyZWQsXG4gICAgfSkuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHN0YXRpYyBkZWZhdWx0UHJvcHMgPSB7XG4gICAgZGlzcGxheVR5cGU6ICdmdWxsJyxcbiAgfVxuXG4gIHN0YXRpYyBsYXN0UmVmcmVzaFBlclByID0gbmV3IE1hcCgpXG4gIHN0YXRpYyBTVUNDRVNTX1JFRlJFU0hfVElNRU9VVCA9IDMgKiA2MCAqIDEwMDBcbiAgc3RhdGljIFBFTkRJTkdfUkVGUkVTSF9USU1FT1VUID0gMzAgKiAxMDAwXG4gIHN0YXRpYyBNSU5JTVVNX1JFRlJFU0hfSU5URVJWQUwgPSAxNSAqIDEwMDBcblxuICBjb25zdHJ1Y3Rvcihwcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgICBhdXRvYmluZCh0aGlzLCAncmVmcmVzaCcpO1xuICB9XG5cbiAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgdGhpcy5yZWZyZXNoZXIgPSBuZXcgUGVyaW9kaWNSZWZyZXNoZXIodGhpcy5jb25zdHJ1Y3Rvciwge1xuICAgICAgaW50ZXJ2YWw6ICgpID0+IHtcbiAgICAgICAgaWYgKHRoaXMuaXNQZW5kaW5nUmVzdWx0cygpKSB7XG4gICAgICAgICAgcmV0dXJuIHRoaXMuY29uc3RydWN0b3IuUEVORElOR19SRUZSRVNIX1RJTUVPVVQ7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgcmV0dXJuIHRoaXMuY29uc3RydWN0b3IuU1VDQ0VTU19SRUZSRVNIX1RJTUVPVVQ7XG4gICAgICAgIH1cbiAgICAgIH0sXG4gICAgICBnZXRDdXJyZW50SWQ6ICgpID0+IHRoaXMucHJvcHMucHVsbFJlcXVlc3QuaWQsXG4gICAgICByZWZyZXNoOiB0aGlzLnJlZnJlc2gsXG4gICAgICBtaW5pbXVtSW50ZXJ2YWxQZXJJZDogdGhpcy5jb25zdHJ1Y3Rvci5NSU5JTVVNX1JFRlJFU0hfSU5URVJWQUwsXG4gICAgfSk7XG4gICAgdGhpcy5yZWZyZXNoZXIuc3RhcnQoKTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIHRoaXMucmVmcmVzaGVyLmRlc3Ryb3koKTtcbiAgfVxuXG4gIHJlZnJlc2goKSB7XG4gICAgdGhpcy5wcm9wcy5yZWxheS5yZWZldGNoKHtcbiAgICAgIGlkOiB0aGlzLnByb3BzLnB1bGxSZXF1ZXN0LmlkLFxuICAgIH0sIG51bGwsIG51bGwsIHtmb3JjZTogdHJ1ZX0pO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGNvbnN0IGhlYWRDb21taXQgPSB0aGlzLnByb3BzLnB1bGxSZXF1ZXN0LnJlY2VudENvbW1pdHMuZWRnZXNbMF0ubm9kZS5jb21taXQ7XG4gICAgaWYgKCFoZWFkQ29tbWl0LnN0YXR1cykgeyByZXR1cm4gbnVsbDsgfVxuICAgIGNvbnN0IHtzdGF0ZSwgY29udGV4dHN9ID0gaGVhZENvbW1pdC5zdGF0dXM7XG5cbiAgICBpZiAodGhpcy5wcm9wcy5kaXNwbGF5VHlwZSA9PT0gJ2NoZWNrJykge1xuICAgICAgY29uc3Qge2ljb24sIHN0eWxlfSA9IHN0YXRlVG9JY29uQW5kU3R5bGVbc3RhdGVdO1xuICAgICAgcmV0dXJuIDxPY3RpY29uIGljb249e2ljb259IGNsYXNzTmFtZT17c3R5bGV9IC8+O1xuICAgIH0gZWxzZSBpZiAodGhpcy5wcm9wcy5kaXNwbGF5VHlwZSA9PT0gJ2Z1bGwnKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1QclN0YXR1c2VzXCI+XG4gICAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItUHJTdGF0dXNlcy1oZWFkZXJcIj5cbiAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLVByU3RhdHVzZXMtZG9udXQtY2hhcnRcIj5cbiAgICAgICAgICAgICAge3RoaXMucmVuZGVyRG9udXRDaGFydChoZWFkQ29tbWl0LnN0YXR1cyl9XG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLVByU3RhdHVzZXMtc3VtbWFyeVwiPlxuICAgICAgICAgICAgICB7dGhpcy5zdW1tYXJ5U2VudGVuY2UoaGVhZENvbW1pdC5zdGF0dXMpfVxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPHVsIGNsYXNzTmFtZT1cImdpdGh1Yi1QclN0YXR1c2VzLWxpc3RcIj5cbiAgICAgICAgICAgIHtjb250ZXh0cy5tYXAoY29udGV4dCA9PiA8UHJTdGF0dXNDb250ZXh0VmlldyBrZXk9e2NvbnRleHQuaWR9IGNvbnRleHQ9e2NvbnRleHR9IC8+KX1cbiAgICAgICAgICA8L3VsPlxuICAgICAgICA8L2Rpdj5cbiAgICAgICk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgSW52YWxpZCBcXGBkaXNwbGF5VHlwZVxcYCBwcm9wIHZhbHVlOiAke3RoaXMucHJvcHMuZGlzcGxheVR5cGV9YCk7XG4gICAgfVxuICB9XG5cbiAgaXNQZW5kaW5nUmVzdWx0cygpIHtcbiAgICBjb25zdCBoZWFkQ29tbWl0ID0gdGhpcy5wcm9wcy5wdWxsUmVxdWVzdC5yZWNlbnRDb21taXRzLmVkZ2VzWzBdLm5vZGUuY29tbWl0O1xuICAgIGlmICghaGVhZENvbW1pdC5zdGF0dXMpIHsgcmV0dXJuIGZhbHNlOyB9XG4gICAgY29uc3Qge2NvbnRleHRzfSA9IGhlYWRDb21taXQuc3RhdHVzO1xuICAgIHJldHVybiBjb250ZXh0cy5zb21lKGMgPT4gY2F0ZWdvcnkoYy5zdGF0ZSkgPT09ICdQRU5ESU5HJyk7XG4gIH1cblxuICByZW5kZXJEb251dENoYXJ0KHN0YXR1cykge1xuICAgIGNvbnN0IHtjb250ZXh0c30gPSBzdGF0dXM7XG4gICAgY29uc3QgcGVuZGluZ0xlbiA9IGNvbnRleHRzLmZpbHRlcihjID0+IGNhdGVnb3J5KGMuc3RhdGUpID09PSAnUEVORElORycpLmxlbmd0aDtcbiAgICBjb25zdCBmYWlsZWRMZW4gPSBjb250ZXh0cy5maWx0ZXIoYyA9PiBjYXRlZ29yeShjLnN0YXRlKSA9PT0gJ0ZBSUxVUkUnKS5sZW5ndGg7XG4gICAgY29uc3Qgc3VjY2VlZGVkTGVuID0gY29udGV4dHMuZmlsdGVyKGMgPT4gY2F0ZWdvcnkoYy5zdGF0ZSkgPT09ICdTVUNDRVNTJykubGVuZ3RoO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxTdGF0dXNEb251dENoYXJ0XG4gICAgICAgIHBlbmRpbmc9e3BlbmRpbmdMZW59XG4gICAgICAgIGZhaWx1cmU9e2ZhaWxlZExlbn1cbiAgICAgICAgc3VjY2Vzcz17c3VjY2VlZGVkTGVufVxuICAgICAgLz5cbiAgICApO1xuICB9XG5cbiAgc3VtbWFyeVNlbnRlbmNlKHN0YXR1cykge1xuICAgIGlmICh0aGlzLmlzQWxsU3VjY2VlZGVkKHN0YXR1cykpIHtcbiAgICAgIHJldHVybiAnQWxsIGNoZWNrcyBzdWNjZWVkZWQnO1xuICAgIH0gZWxzZSBpZiAodGhpcy5pc0FsbEZhaWxlZChzdGF0dXMpKSB7XG4gICAgICByZXR1cm4gJ0FsbCBjaGVja3MgZmFpbGVkJztcbiAgICB9IGVsc2Uge1xuICAgICAgY29uc3Qge2NvbnRleHRzfSA9IHN0YXR1cztcbiAgICAgIGNvbnN0IG5vdW4gPSBjb250ZXh0cy5sZW5ndGggPT09IDEgPyAnY2hlY2snIDogJ2NoZWNrcyc7XG4gICAgICBjb25zdCBwYXJ0cyA9IFtdO1xuICAgICAgY29uc3QgcGVuZGluZyA9IGNvbnRleHRzLmZpbHRlcihjID0+IGNhdGVnb3J5KGMuc3RhdGUpID09PSAnUEVORElORycpO1xuICAgICAgY29uc3QgZmFpbGluZyA9IGNvbnRleHRzLmZpbHRlcihjID0+IGNhdGVnb3J5KGMuc3RhdGUpID09PSAnRkFJTFVSRScpO1xuICAgICAgY29uc3Qgc3VjY2VlZGVkID0gY29udGV4dHMuZmlsdGVyKGMgPT4gY2F0ZWdvcnkoYy5zdGF0ZSkgPT09ICdTVUNDRVNTJyk7XG4gICAgICBpZiAocGVuZGluZy5sZW5ndGgpIHtcbiAgICAgICAgcGFydHMucHVzaChgJHtwZW5kaW5nLmxlbmd0aH0gcGVuZGluZ2ApO1xuICAgICAgfVxuICAgICAgaWYgKGZhaWxpbmcubGVuZ3RoKSB7XG4gICAgICAgIHBhcnRzLnB1c2goYCR7ZmFpbGluZy5sZW5ndGh9IGZhaWxpbmdgKTtcbiAgICAgIH1cbiAgICAgIGlmIChzdWNjZWVkZWQubGVuZ3RoKSB7XG4gICAgICAgIHBhcnRzLnB1c2goYCR7c3VjY2VlZGVkLmxlbmd0aH0gc3VjY2Vzc2Z1bGApO1xuICAgICAgfVxuICAgICAgcmV0dXJuIHRvU2VudGVuY2UocGFydHMpICsgYCAke25vdW59YDtcbiAgICB9XG4gIH1cblxuICBpc0FsbFN1Y2NlZWRlZChzdGF0dXMpIHtcbiAgICByZXR1cm4gY2F0ZWdvcnkoc3RhdHVzLnN0YXRlKSA9PT0gJ1NVQ0NFU1MnO1xuICB9XG5cbiAgaXNBbGxGYWlsZWQoc3RhdHVzKSB7XG4gICAgcmV0dXJuIHN0YXR1cy5jb250ZXh0cy5ldmVyeShjID0+IGNhdGVnb3J5KGMuc3RhdGUpID09PSAnRkFJTFVSRScpO1xuICB9XG59XG5cbmV4cG9ydCBkZWZhdWx0IGNyZWF0ZVJlZmV0Y2hDb250YWluZXIoQmFyZVByU3RhdHVzZXNWaWV3LCB7XG4gIHB1bGxSZXF1ZXN0OiBncmFwaHFsYFxuICAgIGZyYWdtZW50IHByU3RhdHVzZXNWaWV3X3B1bGxSZXF1ZXN0IG9uIFB1bGxSZXF1ZXN0IHtcbiAgICAgIGlkXG4gICAgICByZWNlbnRDb21taXRzOiBjb21taXRzKGxhc3Q6MSkge1xuICAgICAgICBlZGdlcyB7XG4gICAgICAgICAgbm9kZSB7XG4gICAgICAgICAgICBjb21taXQge1xuICAgICAgICAgICAgICBzdGF0dXMge1xuICAgICAgICAgICAgICAgIHN0YXRlXG4gICAgICAgICAgICAgICAgY29udGV4dHMge1xuICAgICAgICAgICAgICAgICAgaWRcbiAgICAgICAgICAgICAgICAgIHN0YXRlXG4gICAgICAgICAgICAgICAgICAuLi5wclN0YXR1c0NvbnRleHRWaWV3X2NvbnRleHRcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gIGAsXG59LCBncmFwaHFsYFxuICBxdWVyeSBwclN0YXR1c2VzVmlld1JlZmV0Y2hRdWVyeSgkaWQ6IElEISkge1xuICAgIG5vZGUoaWQ6ICRpZCkge1xuICAgICAgLi4uIG9uIFB1bGxSZXF1ZXN0IHtcbiAgICAgICAgLi4ucHJTdGF0dXNlc1ZpZXdfcHVsbFJlcXVlc3RcbiAgICAgIH1cbiAgICB9XG4gIH1cbmApO1xuIl19