'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrCommitsView = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRelay = require('react-relay');

var _propTypes3 = require('../prop-types');

var _prCommitView = require('./pr-commit-view');

var _prCommitView2 = _interopRequireDefault(_prCommitView);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const PAGE_SIZE = 50;

class PrCommitsView extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'loadMore');
  }

  loadMore() {
    this.props.relay.loadMore(PAGE_SIZE, () => {
      this.forceUpdate();
    });
    this.forceUpdate();
  }
  render() {
    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(
        'div',
        { className: 'github-PrCommitsView-commitWrapper' },
        this.renderCommits()
      ),
      this.renderLoadMore()
    );
  }

  renderLoadMore() {
    if (!this.props.relay.hasMore()) {
      return null;
    }
    return _react2.default.createElement(
      'button',
      { className: 'github-PrCommitsView-load-more-button btn', onClick: this.loadMore },
      'Load more'
    );
  }

  renderCommits() {
    return this.props.pullRequest.commits.edges.map(edge => {
      const commit = edge.node.commit;
      return _react2.default.createElement(_prCommitView2.default, {
        key: commit.id,
        item: commit
      });
    });
  }
}

exports.PrCommitsView = PrCommitsView;
PrCommitsView.propTypes = {
  relay: _propTypes2.default.shape({
    hasMore: _propTypes2.default.func.isRequired,
    loadMore: _propTypes2.default.func.isRequired,
    isLoading: _propTypes2.default.func.isRequired
  }).isRequired,
  pullRequest: _propTypes2.default.shape({
    commits: (0, _propTypes3.RelayConnectionPropType)(_propTypes2.default.shape({
      commit: _propTypes2.default.shape({
        committer: _propTypes2.default.shape({
          avatarUrl: _propTypes2.default.string.isRequired,
          name: _propTypes2.default.string.isRequired,
          date: _propTypes2.default.string.isRequired
        }),
        messageBody: _propTypes2.default.string,
        messageHeadline: _propTypes2.default.string.isRequired,
        abbreviatedOid: _propTypes2.default.string.isRequired,
        url: _propTypes2.default.string.isRequired
      })
    }))
  })
};
exports.default = (0, _reactRelay.createPaginationContainer)(PrCommitsView, {
  pullRequest: function () {
    const node = require('./__generated__/prCommitsView_pullRequest.graphql');

    if (node.hash && node.hash !== '4945c525c20aac5e24befbe8b217c2c9') {
      console.error('The definition of \'prCommitsView_pullRequest\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/prCommitsView_pullRequest.graphql');
  }
}, {
  direction: 'forward',
  getConnectionFromProps(props) {
    return props.pullRequest.commits;
  },
  getFragmentVariables(prevVars, totalCount) {
    return _extends({}, prevVars, {
      commitCount: totalCount
    });
  },
  getVariables(props, { count, cursor }, fragmentVariables) {
    return {
      commitCount: count,
      commitCursor: cursor,
      url: props.pullRequest.url
    };
  },
  query: function () {
    const node = require('./__generated__/prCommitsViewQuery.graphql');

    if (node.hash && node.hash !== '5fae6bf54831a4d4a70eda4117e56b7f') {
      console.error('The definition of \'prCommitsViewQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/prCommitsViewQuery.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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