'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrCommitView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _nodeEmoji = require('node-emoji');

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _reactRelay = require('react-relay');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const avatarAltText = 'committer avatar';

class PrCommitView extends _react2.default.Component {

  constructor(props) {
    super(props);
    this.state = { showMessageBody: false };
    (0, _helpers.autobind)(this, 'toggleShowCommitMessageBody', 'humanizeTimeSince');
  }

  toggleShowCommitMessageBody() {
    this.setState({ showMessageBody: !this.state.showMessageBody });
  }

  humanizeTimeSince(date) {
    return (0, _moment2.default)(date).fromNow();
  }

  render() {
    const { messageHeadline, messageBody, abbreviatedOid, url } = this.props.item;
    const { avatarUrl, name, date } = this.props.item.committer;
    return _react2.default.createElement(
      'div',
      { className: 'github-PrCommitView-container' },
      _react2.default.createElement(
        'div',
        { className: 'github-PrCommitView-commit' },
        _react2.default.createElement(
          'h3',
          { className: 'github-PrCommitView-title' },
          (0, _nodeEmoji.emojify)(messageHeadline),
          messageBody ? _react2.default.createElement(
            'button',
            {
              className: 'github-PrCommitView-moreButton',
              onClick: this.toggleShowCommitMessageBody },
            this.state.showMessageBody ? 'hide' : 'show',
            ' more...'
          ) : null
        ),
        _react2.default.createElement(
          'div',
          { className: 'github-PrCommitView-meta' },
          _react2.default.createElement('img', { className: 'github-PrCommitView-avatar',
            src: avatarUrl,
            alt: avatarAltText, title: avatarAltText
          }),
          _react2.default.createElement(
            'span',
            { className: 'github-PrCommitView-metaText' },
            name,
            ' committed ',
            this.humanizeTimeSince(date)
          )
        ),
        this.state.showMessageBody ? _react2.default.createElement(
          'pre',
          { className: 'github-PrCommitView-moreText' },
          (0, _nodeEmoji.emojify)(messageBody)
        ) : null
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-PrCommitView-sha' },
        _react2.default.createElement(
          'a',
          { href: url,
            title: `open commit ${abbreviatedOid} on GitHub.com` },
          abbreviatedOid
        )
      )
    );
  }
}

exports.PrCommitView = PrCommitView;
PrCommitView.propTypes = {
  item: _propTypes2.default.shape({
    committer: _propTypes2.default.shape({
      avatarUrl: _propTypes2.default.string.isRequired,
      name: _propTypes2.default.string.isRequired,
      date: _propTypes2.default.string.isRequired
    }).isRequired,
    messageBody: _propTypes2.default.string,
    messageHeadline: _propTypes2.default.string.isRequired,
    abbreviatedOid: _propTypes2.default.string.isRequired,
    url: _propTypes2.default.string.isRequired
  }).isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(PrCommitView, {
  item: function () {
    const node = require('./__generated__/prCommitView_item.graphql');

    if (node.hash && node.hash !== 'c7c00b19a2fd2a18e4c1bab7f5f252ff') {
      console.error('The definition of \'prCommitView_item\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/prCommitView_item.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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