'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _modelObserver = require('../models/model-observer');

var _modelObserver2 = _interopRequireDefault(_modelObserver);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ObserveModel extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'fetchData', 'didUpdate');
    this.state = { data: null };
    this.modelObserver = new _modelObserver2.default({ fetchData: this.fetchData, didUpdate: this.didUpdate });
  }

  componentWillMount() {
    this.mounted = true;
    this.modelObserver.setActiveModel(this.props.model);
  }

  componentWillReceiveProps(nextProps) {
    this.modelObserver.setActiveModel(nextProps.model);
  }

  fetchData(model) {
    return this.props.fetchData(model);
  }

  didUpdate(model) {
    if (this.mounted) {
      const data = this.modelObserver.getActiveModelData();
      this.setState({ data });
    }
  }

  render() {
    return this.props.children(this.state.data);
  }

  componentWillUnmount() {
    this.mounted = false;
    this.modelObserver.destroy();
  }
}
exports.default = ObserveModel;
ObserveModel.propTypes = {
  model: _propTypes2.default.shape({
    onDidUpdate: _propTypes2.default.func.isRequired
  }),
  fetchData: _propTypes2.default.func.isRequired,
  children: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm9ic2VydmUtbW9kZWwuanMiXSwibmFtZXMiOlsiT2JzZXJ2ZU1vZGVsIiwiUmVhY3QiLCJDb21wb25lbnQiLCJjb25zdHJ1Y3RvciIsInByb3BzIiwiY29udGV4dCIsInN0YXRlIiwiZGF0YSIsIm1vZGVsT2JzZXJ2ZXIiLCJNb2RlbE9ic2VydmVyIiwiZmV0Y2hEYXRhIiwiZGlkVXBkYXRlIiwiY29tcG9uZW50V2lsbE1vdW50IiwibW91bnRlZCIsInNldEFjdGl2ZU1vZGVsIiwibW9kZWwiLCJjb21wb25lbnRXaWxsUmVjZWl2ZVByb3BzIiwibmV4dFByb3BzIiwiZ2V0QWN0aXZlTW9kZWxEYXRhIiwic2V0U3RhdGUiLCJyZW5kZXIiLCJjaGlsZHJlbiIsImNvbXBvbmVudFdpbGxVbm1vdW50IiwiZGVzdHJveSIsInByb3BUeXBlcyIsIlByb3BUeXBlcyIsInNoYXBlIiwib25EaWRVcGRhdGUiLCJmdW5jIiwiaXNSZXF1aXJlZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7Ozs7QUFDQTs7OztBQUVBOzs7O0FBQ0E7Ozs7QUFFZSxNQUFNQSxZQUFOLFNBQTJCQyxnQkFBTUMsU0FBakMsQ0FBMkM7O0FBU3hEQyxjQUFZQyxLQUFaLEVBQW1CQyxPQUFuQixFQUE0QjtBQUMxQixVQUFNRCxLQUFOLEVBQWFDLE9BQWI7QUFDQSwyQkFBUyxJQUFULEVBQWUsV0FBZixFQUE0QixXQUE1QjtBQUNBLFNBQUtDLEtBQUwsR0FBYSxFQUFDQyxNQUFNLElBQVAsRUFBYjtBQUNBLFNBQUtDLGFBQUwsR0FBcUIsSUFBSUMsdUJBQUosQ0FBa0IsRUFBQ0MsV0FBVyxLQUFLQSxTQUFqQixFQUE0QkMsV0FBVyxLQUFLQSxTQUE1QyxFQUFsQixDQUFyQjtBQUNEOztBQUVEQyx1QkFBcUI7QUFDbkIsU0FBS0MsT0FBTCxHQUFlLElBQWY7QUFDQSxTQUFLTCxhQUFMLENBQW1CTSxjQUFuQixDQUFrQyxLQUFLVixLQUFMLENBQVdXLEtBQTdDO0FBQ0Q7O0FBRURDLDRCQUEwQkMsU0FBMUIsRUFBcUM7QUFDbkMsU0FBS1QsYUFBTCxDQUFtQk0sY0FBbkIsQ0FBa0NHLFVBQVVGLEtBQTVDO0FBQ0Q7O0FBRURMLFlBQVVLLEtBQVYsRUFBaUI7QUFDZixXQUFPLEtBQUtYLEtBQUwsQ0FBV00sU0FBWCxDQUFxQkssS0FBckIsQ0FBUDtBQUNEOztBQUVESixZQUFVSSxLQUFWLEVBQWlCO0FBQ2YsUUFBSSxLQUFLRixPQUFULEVBQWtCO0FBQ2hCLFlBQU1OLE9BQU8sS0FBS0MsYUFBTCxDQUFtQlUsa0JBQW5CLEVBQWI7QUFDQSxXQUFLQyxRQUFMLENBQWMsRUFBQ1osSUFBRCxFQUFkO0FBQ0Q7QUFDRjs7QUFFRGEsV0FBUztBQUNQLFdBQU8sS0FBS2hCLEtBQUwsQ0FBV2lCLFFBQVgsQ0FBb0IsS0FBS2YsS0FBTCxDQUFXQyxJQUEvQixDQUFQO0FBQ0Q7O0FBRURlLHlCQUF1QjtBQUNyQixTQUFLVCxPQUFMLEdBQWUsS0FBZjtBQUNBLFNBQUtMLGFBQUwsQ0FBbUJlLE9BQW5CO0FBQ0Q7QUEzQ3VEO2tCQUFyQ3ZCLFk7QUFBQUEsWSxDQUNad0IsUyxHQUFZO0FBQ2pCVCxTQUFPVSxvQkFBVUMsS0FBVixDQUFnQjtBQUNyQkMsaUJBQWFGLG9CQUFVRyxJQUFWLENBQWVDO0FBRFAsR0FBaEIsQ0FEVTtBQUlqQm5CLGFBQVdlLG9CQUFVRyxJQUFWLENBQWVDLFVBSlQ7QUFLakJSLFlBQVVJLG9CQUFVRyxJQUFWLENBQWVDO0FBTFIsQyIsImZpbGUiOiJvYnNlcnZlLW1vZGVsLmpzIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzQuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIvbGliL3ZpZXdzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5cbmltcG9ydCBNb2RlbE9ic2VydmVyIGZyb20gJy4uL21vZGVscy9tb2RlbC1vYnNlcnZlcic7XG5pbXBvcnQge2F1dG9iaW5kfSBmcm9tICcuLi9oZWxwZXJzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgT2JzZXJ2ZU1vZGVsIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBtb2RlbDogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgIG9uRGlkVXBkYXRlOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIH0pLFxuICAgIGZldGNoRGF0YTogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBjaGlsZHJlbjogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzLCBjb250ZXh0KSB7XG4gICAgc3VwZXIocHJvcHMsIGNvbnRleHQpO1xuICAgIGF1dG9iaW5kKHRoaXMsICdmZXRjaERhdGEnLCAnZGlkVXBkYXRlJyk7XG4gICAgdGhpcy5zdGF0ZSA9IHtkYXRhOiBudWxsfTtcbiAgICB0aGlzLm1vZGVsT2JzZXJ2ZXIgPSBuZXcgTW9kZWxPYnNlcnZlcih7ZmV0Y2hEYXRhOiB0aGlzLmZldGNoRGF0YSwgZGlkVXBkYXRlOiB0aGlzLmRpZFVwZGF0ZX0pO1xuICB9XG5cbiAgY29tcG9uZW50V2lsbE1vdW50KCkge1xuICAgIHRoaXMubW91bnRlZCA9IHRydWU7XG4gICAgdGhpcy5tb2RlbE9ic2VydmVyLnNldEFjdGl2ZU1vZGVsKHRoaXMucHJvcHMubW9kZWwpO1xuICB9XG5cbiAgY29tcG9uZW50V2lsbFJlY2VpdmVQcm9wcyhuZXh0UHJvcHMpIHtcbiAgICB0aGlzLm1vZGVsT2JzZXJ2ZXIuc2V0QWN0aXZlTW9kZWwobmV4dFByb3BzLm1vZGVsKTtcbiAgfVxuXG4gIGZldGNoRGF0YShtb2RlbCkge1xuICAgIHJldHVybiB0aGlzLnByb3BzLmZldGNoRGF0YShtb2RlbCk7XG4gIH1cblxuICBkaWRVcGRhdGUobW9kZWwpIHtcbiAgICBpZiAodGhpcy5tb3VudGVkKSB7XG4gICAgICBjb25zdCBkYXRhID0gdGhpcy5tb2RlbE9ic2VydmVyLmdldEFjdGl2ZU1vZGVsRGF0YSgpO1xuICAgICAgdGhpcy5zZXRTdGF0ZSh7ZGF0YX0pO1xuICAgIH1cbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gdGhpcy5wcm9wcy5jaGlsZHJlbih0aGlzLnN0YXRlLmRhdGEpO1xuICB9XG5cbiAgY29tcG9uZW50V2lsbFVubW91bnQoKSB7XG4gICAgdGhpcy5tb3VudGVkID0gZmFsc2U7XG4gICAgdGhpcy5tb2RlbE9ic2VydmVyLmRlc3Ryb3koKTtcbiAgfVxufVxuIl19