'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

class MergeConflictListItemView extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.refItem = new _refHolder2.default();
    this.subs = new _eventKit.CompositeDisposable(this.refItem.observe(item => this.props.registerItemElement(this.props.mergeConflict, item)));
  }

  render() {
    const _props = this.props,
          { mergeConflict, selected } = _props,
          others = _objectWithoutProperties(_props, ['mergeConflict', 'selected']);
    delete others.remainingConflicts;
    delete others.registerItemElement;
    const fileStatus = _helpers.classNameForStatus[mergeConflict.status.file];
    const oursStatus = _helpers.classNameForStatus[mergeConflict.status.ours];
    const theirsStatus = _helpers.classNameForStatus[mergeConflict.status.theirs];
    const className = selected ? 'is-selected' : '';

    return _react2.default.createElement(
      'div',
      _extends({
        ref: this.refItem.setter
      }, others, {
        className: `github-MergeConflictListView-item is-${fileStatus} ${className}` }),
      _react2.default.createElement(
        'div',
        { className: 'github-FilePatchListView-item github-FilePatchListView-pathItem' },
        _react2.default.createElement('span', { className: `github-FilePatchListView-icon icon icon-diff-${fileStatus} status-${fileStatus}` }),
        _react2.default.createElement(
          'span',
          { className: 'github-FilePatchListView-path' },
          mergeConflict.filePath
        ),
        _react2.default.createElement(
          'span',
          { className: 'github-FilePatchListView ours-theirs-info' },
          _react2.default.createElement('span', { className: `github-FilePatchListView-icon icon icon-diff-${oursStatus}` }),
          _react2.default.createElement('span', { className: `github-FilePatchListView-icon icon icon-diff-${theirsStatus}` })
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-FilePatchListView-item github-FilePatchListView-resolutionItem' },
        this.renderRemainingConflicts()
      )
    );
  }

  renderRemainingConflicts() {
    if (this.props.remainingConflicts === 0) {
      return _react2.default.createElement(
        'span',
        { className: 'icon icon-check github-RemainingConflicts text-success' },
        'ready'
      );
    } else if (this.props.remainingConflicts !== undefined) {
      const pluralConflicts = this.props.remainingConflicts === 1 ? '' : 's';

      return _react2.default.createElement(
        'span',
        { className: 'github-RemainingConflicts text-warning' },
        this.props.remainingConflicts,
        ' conflict',
        pluralConflicts,
        ' remaining'
      );
    } else {
      return _react2.default.createElement(
        'span',
        { className: 'github-RemainingConflicts text-subtle' },
        'calculating'
      );
    }
  }

  componentWillUnmount() {
    this.subs.dispose();
  }
}
exports.default = MergeConflictListItemView;
MergeConflictListItemView.propTypes = {
  mergeConflict: _propTypes3.MergeConflictItemPropType.isRequired,
  selected: _propTypes2.default.bool.isRequired,
  remainingConflicts: _propTypes2.default.number,
  registerItemElement: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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