'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.collectionRenderer = collectionRenderer;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _commitsView = require('./timeline-items/commits-view.js');

var _commitsView2 = _interopRequireDefault(_commitsView);

var _issueCommentView = require('./timeline-items/issue-comment-view.js');

var _issueCommentView2 = _interopRequireDefault(_issueCommentView);

var _mergedEventView = require('./timeline-items/merged-event-view.js');

var _mergedEventView2 = _interopRequireDefault(_mergedEventView);

var _headRefForcePushedEventView = require('./timeline-items/head-ref-force-pushed-event-view.js');

var _headRefForcePushedEventView2 = _interopRequireDefault(_headRefForcePushedEventView);

var _crossReferencedEventsView = require('./timeline-items/cross-referenced-events-view.js');

var _crossReferencedEventsView2 = _interopRequireDefault(_crossReferencedEventsView);

var _commitCommentThreadView = require('./timeline-items/commit-comment-thread-view');

var _commitCommentThreadView2 = _interopRequireDefault(_commitCommentThreadView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function collectionRenderer(Component, styleAsTimelineItem = true) {
  var _class, _temp;

  return _temp = _class = class GroupedComponent extends _react2.default.Component {

    static getFragment(fragName, ...args) {
      const frag = fragName === 'nodes' ? 'item' : fragName;
      return Component.getFragment(frag, ...args);
    }

    constructor(props) {
      super(props);
      (0, _helpers.autobind)(this, 'renderNode');
    }

    render() {
      return _react2.default.createElement(
        'div',
        { className: styleAsTimelineItem ? 'timeline-item' : '' },
        this.props.nodes.map(this.renderNode)
      );
    }

    renderNode(node, i) {
      return _react2.default.createElement(Component, {
        key: i,
        item: node,
        issueish: this.props.issueish,
        switchToIssueish: this.props.switchToIssueish
      });
    }
  }, _class.displayName = `Grouped(${Component.displayName})`, _class.propTypes = {
    nodes: _propTypes2.default.array.isRequired,
    issueish: _propTypes2.default.object.isRequired,
    switchToIssueish: _propTypes2.default.func.isRequired
  }, _temp;
}

const timelineItems = {
  Commit: _commitsView2.default,
  CommitCommentThread: collectionRenderer(_commitCommentThreadView2.default, false),
  IssueComment: collectionRenderer(_issueCommentView2.default, false),
  MergedEvent: collectionRenderer(_mergedEventView2.default),
  HeadRefForcePushedEvent: collectionRenderer(_headRefForcePushedEventView2.default),
  CrossReferencedEvent: _crossReferencedEventsView2.default
};

const TimelineConnectionPropType = (0, _propTypes3.RelayConnectionPropType)(_propTypes2.default.shape({
  __typename: _propTypes2.default.string.isRequired
})).isRequired;

class IssueishTimelineView extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'loadMore');
  }

  loadMore() {
    this.props.relay.loadMore(10, () => {
      this.forceUpdate();
    });
    this.forceUpdate();
  }

  render() {
    const issueish = this.props.issue || this.props.pullRequest;
    const groupedEdges = this.groupEdges(issueish.timeline.edges);
    return _react2.default.createElement(
      'div',
      { className: 'github-PrTimeline' },
      groupedEdges.map(({ type, edges }) => {
        const Component = timelineItems[type];
        if (Component) {
          return _react2.default.createElement(Component, {
            key: `${type}-${edges[0].cursor}`,
            nodes: edges.map(e => e.node),
            issueish: issueish,
            switchToIssueish: this.props.switchToIssueish
          });
        } else {
          // eslint-disable-next-line no-console
          console.warn(`unrecognized timeline event type: ${type}`);
          return null;
        }
      }),
      this.renderLoadMore()
    );
  }

  renderLoadMore() {
    if (!this.props.relay.hasMore()) {
      return null;
    }

    return _react2.default.createElement(
      'div',
      { className: 'github-PrTimeline-loadMore' },
      _react2.default.createElement(
        'button',
        { className: 'github-PrTimeline-loadMoreButton btn', onClick: this.loadMore },
        this.props.relay.isLoading() ? _react2.default.createElement(_octicon2.default, { icon: 'ellipsis' }) : 'Load More'
      )
    );
  }

  groupEdges(edges) {
    let currentGroup;
    const groupedEdges = [];
    let lastEdgeType;
    edges.forEach(({ node, cursor }) => {
      const currentEdgeType = node.__typename;
      if (currentEdgeType === lastEdgeType) {
        currentGroup.edges.push({ node, cursor });
      } else {
        currentGroup = {
          type: currentEdgeType,
          edges: [{ node, cursor }]
        };
        groupedEdges.push(currentGroup);
      }
      lastEdgeType = currentEdgeType;
    });
    return groupedEdges;
  }
}
exports.default = IssueishTimelineView;
IssueishTimelineView.propTypes = {
  switchToIssueish: _propTypes2.default.func.isRequired,
  relay: _propTypes2.default.shape({
    hasMore: _propTypes2.default.func.isRequired,
    loadMore: _propTypes2.default.func.isRequired,
    isLoading: _propTypes2.default.func.isRequired
  }).isRequired,
  issue: _propTypes2.default.shape({
    timeline: TimelineConnectionPropType
  }),
  pullRequest: _propTypes2.default.shape({
    timeline: TimelineConnectionPropType
  })
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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