'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _accordion = require('./accordion');

var _accordion2 = _interopRequireDefault(_accordion);

var _timeago = require('./timeago');

var _timeago2 = _interopRequireDefault(_timeago);

var _statusDonutChart = require('./status-donut-chart');

var _statusDonutChart2 = _interopRequireDefault(_statusDonutChart);

var _queryErrorTile = require('./query-error-tile');

var _queryErrorTile2 = _interopRequireDefault(_queryErrorTile);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class IssueishListView extends _react2.default.Component {

  constructor(props) {
    super(props);

    (0, _helpers.autobind)(this, 'renderIssueish', 'renderLoadingTile', 'renderEmptyTile', 'renderMoreTile');
  }

  render() {
    return _react2.default.createElement(
      _accordion2.default,
      {
        leftTitle: this.props.title,
        isLoading: this.props.isLoading,
        results: this.props.issueishes,
        total: this.props.total,
        loadingComponent: this.renderLoadingTile,
        emptyComponent: this.renderEmptyTile,
        moreComponent: this.renderMoreTile,
        onClickItem: this.props.onIssueishClick },
      this.renderIssueish
    );
  }

  renderIssueish(issueish) {
    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement('img', {
        className: 'github-IssueishList-item github-IssueishList-item--avatar',
        src: issueish.getAuthorAvatarURL(32),
        title: issueish.getAuthorLogin(),
        alt: issueish.getAuthorLogin()
      }),
      _react2.default.createElement(
        'span',
        { className: 'github-IssueishList-item github-IssueishList-item--title' },
        issueish.getTitle()
      ),
      _react2.default.createElement(
        'span',
        { className: 'github-IssueishList-item github-IssueishList-item--number' },
        '#',
        issueish.getNumber()
      ),
      this.renderStatusSummary(issueish.getStatusCounts()),
      _react2.default.createElement(_timeago2.default, {
        time: issueish.getCreatedAt(),
        displayStyle: 'short',
        className: 'github-IssueishList-item github-IssueishList-item--age'
      })
    );
  }

  renderStatusSummary(statusCounts) {
    if (['success', 'failure', 'pending'].every(kind => statusCounts[kind] === 0)) {
      return _react2.default.createElement(_octicon2.default, { className: 'github-IssueishList-item github-IssueishList-item--status', icon: 'dash' });
    }

    if (statusCounts.success > 0 && statusCounts.failure === 0 && statusCounts.pending === 0) {
      return _react2.default.createElement(_octicon2.default, { className: 'github-IssueishList-item github-IssueishList-item--status', icon: 'check' });
    }

    if (statusCounts.success === 0 && statusCounts.failure > 0 && statusCounts.pending === 0) {
      return _react2.default.createElement(_octicon2.default, { className: 'github-IssueishList-item github-IssueishList-item--status', icon: 'x' });
    }

    return _react2.default.createElement(_statusDonutChart2.default, _extends({}, statusCounts, { className: 'github-IssueishList-item github-IssueishList-item--status' }));
  }

  renderLoadingTile() {
    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishList-loading' },
      'Loading'
    );
  }

  renderEmptyTile() {
    if (this.props.error) {
      return _react2.default.createElement(_queryErrorTile2.default, { error: this.props.error });
    }

    if (this.props.emptyComponent) {
      const EmptyComponent = this.props.emptyComponent;
      return _react2.default.createElement(EmptyComponent, null);
    }

    return null;
  }

  renderMoreTile() {
    /* eslint-disable jsx-a11y/anchor-is-valid */
    if (this.props.onMoreClick) {
      return _react2.default.createElement(
        'div',
        { className: 'github-IssueishList-more' },
        _react2.default.createElement(
          'a',
          { onClick: this.props.onMoreClick },
          'More...'
        )
      );
    }

    return null;
  }
}
exports.default = IssueishListView;
IssueishListView.propTypes = {
  title: _propTypes2.default.string.isRequired,
  isLoading: _propTypes2.default.bool.isRequired,
  total: _propTypes2.default.number.isRequired,
  issueishes: _propTypes2.default.arrayOf(_propTypes3.IssueishPropType).isRequired,

  repository: _propTypes2.default.shape({
    defaultBranchRef: _propTypes2.default.shape({
      prefix: _propTypes2.default.string.isRequired,
      name: _propTypes2.default.string.isRequired
    })
  }),

  onIssueishClick: _propTypes2.default.func.isRequired,
  onMoreClick: _propTypes2.default.func,

  emptyComponent: _propTypes2.default.func,
  error: _propTypes2.default.object
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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