'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareIssueishDetailView = exports.checkoutStates = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _reactTabs = require('react-tabs');

var _issueTimelineController = require('../controllers/issue-timeline-controller');

var _issueTimelineController2 = _interopRequireDefault(_issueTimelineController);

var _prTimelineController = require('../controllers/pr-timeline-controller');

var _prTimelineController2 = _interopRequireDefault(_prTimelineController);

var _prStatusesView = require('../views/pr-statuses-view');

var _prStatusesView2 = _interopRequireDefault(_prStatusesView);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _issueishBadge = require('../views/issueish-badge');

var _issueishBadge2 = _interopRequireDefault(_issueishBadge);

var _githubDotcomMarkdown = require('../views/github-dotcom-markdown');

var _githubDotcomMarkdown2 = _interopRequireDefault(_githubDotcomMarkdown);

var _periodicRefresher = require('../periodic-refresher');

var _periodicRefresher2 = _interopRequireDefault(_periodicRefresher);

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

var _reporterProxy = require('../reporter-proxy');

var _prCommitsView = require('../views/pr-commits-view');

var _prCommitsView2 = _interopRequireDefault(_prCommitsView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const reactionTypeToEmoji = {
  THUMBS_UP: '👍',
  THUMBS_DOWN: '👎',
  LAUGH: '😆',
  HOORAY: '🎉',
  CONFUSED: '😕',
  HEART: '❤️'
};

function createCheckoutState(name) {
  return function (cases) {
    return cases[name] || cases.default;
  };
}

const checkoutStates = exports.checkoutStates = {
  HIDDEN: createCheckoutState('hidden'),
  DISABLED: createCheckoutState('disabled'),
  BUSY: createCheckoutState('busy'),
  CURRENT: createCheckoutState('current')
};

class BareIssueishDetailView extends _react2.default.Component {

  constructor(props) {
    super(props);
    this.state = {
      refreshing: false
    };
    (0, _helpers.autobind)(this, 'handleRefreshClick', 'refresh', 'renderEmojiReactions', 'renderIssueBody', 'renderPullRequestBody');
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher2.default(BareIssueishDetailView, {
      interval: () => 5 * 60 * 1000,
      getCurrentId: () => this.props.issueish.id,
      refresh: this.refresh,
      minimumIntervalPerId: 2 * 60 * 1000
    });
    // auto-refresh disabled for now until pagination is handled
    // this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  renderPrMetadata(issueish, repo) {
    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishDetailView-headerRow' },
      _react2.default.createElement(
        'span',
        { className: 'github-IssueishDetailView-meta' },
        _react2.default.createElement(
          'a',
          { className: 'github-IssueishDetailView-metaAuthor',
            href: issueish.author.url },
          issueish.author.login
        ),
        ' wants to merge',
        ' ',
        _react2.default.createElement(
          'a',
          { className: 'github-IssueishDetailView-commitCount',
            href: issueish.url + '/commits' },
          issueish.countedCommits.totalCount,
          ' commits'
        ),
        ' and',
        ' ',
        _react2.default.createElement(
          'a',
          { className: 'github-IssueishDetailView-fileCount',
            href: issueish.url + '/files' },
          issueish.changedFiles,
          ' changed files'
        ),
        ' into',
        ' ',
        _react2.default.createElement(
          'code',
          { className: 'github-IssueishDetailView-baseRefName' },
          issueish.isCrossRepository ? `${repo.owner.login}/${issueish.baseRefName}` : issueish.baseRefName
        ),
        ' from',
        ' ',
        _react2.default.createElement(
          'code',
          { className: 'github-IssueishDetailView-headRefName' },
          issueish.isCrossRepository ? `${issueish.author.login}/${issueish.headRefName}` : issueish.headRefName
        )
      )
    );
  }

  renderIssueBody(issueish, childProps) {
    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(_githubDotcomMarkdown2.default, {
        html: issueish.bodyHTML || '<em>No description provided.</em>',
        switchToIssueish: this.props.switchToIssueish
      }),
      this.renderEmojiReactions(issueish),
      _react2.default.createElement(_issueTimelineController2.default, _extends({}, childProps, {
        switchToIssueish: this.props.switchToIssueish
      }))
    );
  }

  renderPullRequestBody(issueish, childProps) {
    return _react2.default.createElement(
      _reactTabs.Tabs,
      null,
      _react2.default.createElement(
        _reactTabs.TabList,
        { className: 'github-IssueishDetailView-tablist' },
        _react2.default.createElement(
          _reactTabs.Tab,
          { className: 'github-IssueishDetailView-tab' },
          _react2.default.createElement(_octicon2.default, { icon: 'info', className: 'github-IssueishDetailView-tab-icon' }),
          'Overview'
        ),
        _react2.default.createElement(
          _reactTabs.Tab,
          { className: 'github-IssueishDetailView-tab' },
          _react2.default.createElement(_octicon2.default, { icon: 'checklist', className: 'github-IssueishDetailView-tab-icon' }),
          'Build Status'
        ),
        _react2.default.createElement(
          _reactTabs.Tab,
          { className: 'github-IssueishDetailView-tab' },
          _react2.default.createElement(_octicon2.default, { icon: 'git-commit',
            className: 'github-IssueishDetailView-tab-icon'
          }),
          'Commits'
        )
      ),
      _react2.default.createElement(
        _reactTabs.TabPanel,
        null,
        _react2.default.createElement(_githubDotcomMarkdown2.default, {
          html: issueish.bodyHTML || '<em>No description provided.</em>',
          switchToIssueish: this.props.switchToIssueish
        }),
        this.renderEmojiReactions(issueish),
        _react2.default.createElement(_prTimelineController2.default, _extends({}, childProps, {
          switchToIssueish: this.props.switchToIssueish
        }))
      ),
      _react2.default.createElement(
        _reactTabs.TabPanel,
        null,
        _react2.default.createElement(
          'div',
          { className: 'github-IssueishDetailView-buildStatus' },
          _react2.default.createElement(_prStatusesView2.default, { pullRequest: issueish, displayType: 'full' })
        )
      ),
      _react2.default.createElement(
        _reactTabs.TabPanel,
        null,
        _react2.default.createElement(_prCommitsView2.default, { pullRequest: issueish })
      )
    );
  }

  renderEmojiReactions(issueish) {
    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishDetailView-reactions' },
      issueish.reactionGroups.map(group => group.users.totalCount > 0 ? _react2.default.createElement(
        'span',
        { className: (0, _classnames2.default)('github-IssueishDetailView-reactionsGroup', group.content.toLowerCase()),
          key: group.content },
        reactionTypeToEmoji[group.content],
        ' \xA0 ',
        group.users.totalCount
      ) : null)
    );
  }

  render() {
    const repo = this.props.repository;
    const issueish = this.props.issueish;
    const isPr = issueish.__typename === 'PullRequest';
    const childProps = {
      issue: issueish.__typename === 'Issue' ? issueish : null,
      pullRequest: issueish.__typename === 'PullRequest' ? issueish : null
    };
    // todo(tt, 9/2018): it could enhance readability to extract header rendering into
    // 2 functions: one for rendering an issue header, and one for rendering a pr header.
    // however, the tradeoff there is having some repetitive code.
    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishDetailView native-key-bindings' },
      _react2.default.createElement(
        'div',
        { className: 'github-IssueishDetailView-container' },
        _react2.default.createElement(
          'header',
          { className: 'github-IssueishDetailView-header' },
          _react2.default.createElement(
            'div',
            { className: 'github-IssueishDetailView-headerRow' },
            _react2.default.createElement(
              'div',
              { className: 'github-IssueishDetailView-headerGroup' },
              _react2.default.createElement(
                'a',
                { className: 'github-IssueishDetailView-avatar', href: issueish.author.url },
                _react2.default.createElement('img', { className: 'github-IssueishDetailView-avatarImage',
                  src: issueish.author.avatarUrl,
                  title: issueish.author.login,
                  alt: issueish.author.login
                })
              ),
              _react2.default.createElement(
                'a',
                { className: 'github-IssueishDetailView-title', href: issueish.url },
                issueish.title
              )
            ),
            _react2.default.createElement(
              'div',
              { className: 'github-IssueishDetailView-headerGroup' },
              _react2.default.createElement(_octicon2.default, {
                icon: 'repo-sync',
                className: (0, _classnames2.default)('github-IssueishDetailView-headerRefreshButton', { refreshing: this.state.refreshing }),
                onClick: this.handleRefreshClick
              })
            )
          ),
          isPr && this.renderPrMetadata(issueish, repo),
          _react2.default.createElement(
            'div',
            { className: 'github-IssueishDetailView-headerRow' },
            _react2.default.createElement(
              'div',
              { className: 'github-IssueishDetailView-headerGroup' },
              _react2.default.createElement(_issueishBadge2.default, { className: 'github-IssueishDetailView-headerBadge',
                type: issueish.__typename,
                state: issueish.state
              }),
              _react2.default.createElement(
                'a',
                { className: 'github-IssueishDetailView-headerLink',
                  title: 'open on GitHub.com',
                  href: issueish.url, onClick: this.recordOpenInBrowserEvent },
                repo.owner.login,
                '/',
                repo.name,
                '#',
                issueish.number
              ),
              isPr && _react2.default.createElement(
                'span',
                { className: 'github-IssueishDetailView-headerStatus' },
                _react2.default.createElement(_prStatusesView2.default, { pullRequest: issueish, displayType: 'check' })
              )
            ),
            _react2.default.createElement(
              'div',
              { className: 'github-IssueishDetailView-headerGroup' },
              this.renderCheckoutButton()
            )
          )
        ),
        isPr ? this.renderPullRequestBody(issueish, childProps) : this.renderIssueBody(issueish, childProps),
        _react2.default.createElement(
          'footer',
          { className: 'github-IssueishDetailView-footer' },
          _react2.default.createElement(
            'a',
            { className: 'github-IssueishDetailView-footerLink icon icon-mark-github',
              href: issueish.url },
            repo.owner.login,
            '/',
            repo.name,
            '#',
            issueish.number
          )
        )
      )
    );
  }

  renderCheckoutButton() {
    const { checkoutOp } = this.props;
    let extraClass = null;
    let buttonText = 'Checkout';
    let buttonTitle = null;

    if (!checkoutOp.isEnabled()) {
      buttonTitle = checkoutOp.getMessage();
      const reason = checkoutOp.why();
      if (reason({ hidden: true, default: false })) {
        return null;
      }

      buttonText = reason({
        current: 'Checked out',
        default: 'Checkout'
      });

      extraClass = 'github-IssueishDetailView-checkoutButton--' + reason({
        disabled: 'disabled',
        busy: 'busy',
        current: 'current'
      });
    }

    const classNames = (0, _classnames2.default)('btn', 'btn-primary', 'github-IssueishDetailView-checkoutButton', extraClass);
    return _react2.default.createElement(
      'button',
      {
        className: classNames,
        disabled: !checkoutOp.isEnabled(),
        title: buttonTitle,
        onClick: () => checkoutOp.run() },
      buttonText
    );
  }

  handleRefreshClick(e) {
    e.preventDefault();
    this.refresher.refreshNow(true);
  }

  recordOpenInBrowserEvent() {
    (0, _reporterProxy.addEvent)('open-issueish-in-browser', { package: 'github', from: 'issueish-header' });
  }

  refresh() {
    if (this.state.refreshing) {
      return;
    }

    this.setState({ refreshing: true });
    this.props.relay.refetch({
      repoId: this.props.repository.id,
      issueishId: this.props.issueish.id,
      timelineCount: 100,
      timelineCursor: null,
      commitCount: 100,
      commitCursor: null
    }, null, () => {
      this.setState({ refreshing: false });
    }, { force: true });
  }
}

exports.BareIssueishDetailView = BareIssueishDetailView;
BareIssueishDetailView.propTypes = {
  relay: _propTypes2.default.shape({
    refetch: _propTypes2.default.func.isRequired
  }),
  switchToIssueish: _propTypes2.default.func.isRequired,
  checkoutOp: _propTypes3.EnableableOperationPropType.isRequired,
  repository: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    name: _propTypes2.default.string.isRequired,
    owner: _propTypes2.default.shape({
      login: _propTypes2.default.string
    })
  }),
  issueish: _propTypes2.default.shape({
    __typename: _propTypes2.default.string.isRequired,
    id: _propTypes2.default.string.isRequired,
    title: _propTypes2.default.string,
    countedCommits: _propTypes2.default.shape({
      totalCount: _propTypes2.default.number.isRequired
    }).isRequired,
    isCrossRepository: _propTypes2.default.bool,
    changedFiles: _propTypes2.default.number.isRequired,
    url: _propTypes2.default.string.isRequired,
    bodyHTML: _propTypes2.default.string,
    number: _propTypes2.default.number,
    state: _propTypes2.default.oneOf(['OPEN', 'CLOSED', 'MERGED']).isRequired,
    author: _propTypes2.default.shape({
      login: _propTypes2.default.string.isRequired,
      avatarUrl: _propTypes2.default.string.isRequired,
      url: _propTypes2.default.string.isRequired
    }).isRequired,
    reactionGroups: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      content: _propTypes2.default.string.isRequired,
      users: _propTypes2.default.shape({
        totalCount: _propTypes2.default.number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired
};
exports.default = (0, _reactRelay.createRefetchContainer)(BareIssueishDetailView, {
  repository: function () {
    const node = require('./__generated__/issueishDetailView_repository.graphql');

    if (node.hash && node.hash !== '816e09e12a5fbb89558b0ae0bfdc76af') {
      console.error('The definition of \'issueishDetailView_repository\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/issueishDetailView_repository.graphql');
  },

  issueish: function () {
    const node = require('./__generated__/issueishDetailView_issueish.graphql');

    if (node.hash && node.hash !== 'c24859a915333972a63ccb57c0c937f0') {
      console.error('The definition of \'issueishDetailView_issueish\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/issueishDetailView_issueish.graphql');
  }
}, function () {
  const node = require('./__generated__/issueishDetailViewRefetchQuery.graphql');

  if (node.hash && node.hash !== '5bd2024f45eb948618868b403f1c29f9') {
    console.error('The definition of \'issueishDetailViewRefetchQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
  }

  return require('./__generated__/issueishDetailViewRefetchQuery.graphql');
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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