'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

const typeAndStateToIcon = {
  Issue: {
    OPEN: 'issue-opened',
    CLOSED: 'issue-closed'
  },
  PullRequest: {
    OPEN: 'git-pull-request',
    CLOSED: 'git-pull-request',
    MERGED: 'git-merge'
  }
};

class IssueishBadge extends _react2.default.Component {

  render() {
    const _props = this.props,
          { type, state } = _props,
          others = _objectWithoutProperties(_props, ['type', 'state']);
    const icons = typeAndStateToIcon[type] || {};
    const icon = icons[state] || 'question';

    const { className } = others,
          otherProps = _objectWithoutProperties(others, ['className']);
    return _react2.default.createElement(
      'span',
      _extends({ className: (0, _classnames2.default)(className, 'github-IssueishBadge', state.toLowerCase()) }, otherProps),
      _react2.default.createElement(_octicon2.default, { icon: icon }),
      state.toLowerCase()
    );
  }
}
exports.default = IssueishBadge;
IssueishBadge.propTypes = {
  type: _propTypes2.default.oneOf(['Issue', 'PullRequest', 'Unknown']).isRequired,
  state: _propTypes2.default.oneOf(['OPEN', 'CLOSED', 'MERGED', 'UNKNOWN']).isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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