'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class InitDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'init', 'cancel', 'editorRef', 'setInitEnablement');

    this.state = {
      initDisabled: false
    };

    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.projectPathEditor) {
      this.projectPathEditor.setText(this.props.initPath || this.props.config.get('core.projectHome'));
      this.projectPathModified = false;
    }

    if (this.projectPathElement) {
      setTimeout(() => this.projectPathElement.focus());
    }
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Init modal' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-Init' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.init })
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-ProjectPath' },
          'Initialize git repository in directory',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRef(), tabIndex: '2' })
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-DialogButtons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', onClick: this.cancel, tabIndex: '3' },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          {
            className: 'btn btn-primary icon icon-repo-create',
            onClick: this.init,
            disabled: this.state.initDisabled,
            tabIndex: '4' },
          'Init'
        )
      )
    );
  }

  init() {
    if (this.getProjectPath().length === 0) {
      return;
    }

    this.props.didAccept(this.getProjectPath());
  }

  cancel() {
    this.props.didCancel();
  }

  editorRef() {
    return element => {
      if (!element) {
        return;
      }

      this.projectPathElement = element;
      const editor = element.getModel();
      if (this.projectPathEditor !== editor) {
        this.projectPathEditor = editor;

        if (this.projectPathSubs) {
          this.projectPathSubs.dispose();
          this.subs.remove(this.projectPathSubs);
        }

        this.projectPathSubs = editor.onDidChange(this.setInitEnablement);
        this.subs.add(this.projectPathSubs);
      }
    };
  }

  getProjectPath() {
    return this.projectPathEditor ? this.projectPathEditor.getText() : '';
  }

  getRemoteUrl() {
    return this.remoteUrlEditor ? this.remoteUrlEditor.getText() : '';
  }

  setInitEnablement() {
    this.setState({ initDisabled: this.getProjectPath().length === 0 });
  }
}
exports.default = InitDialog;
InitDialog.propTypes = {
  config: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  didAccept: _propTypes2.default.func,
  didCancel: _propTypes2.default.func,
  initPath: _propTypes2.default.string
};
InitDialog.defaultProps = {
  didAccept: () => {},
  didCancel: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImluaXQtZGlhbG9nLmpzIl0sIm5hbWVzIjpbIkluaXREaWFsb2ciLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJjb250ZXh0Iiwic3RhdGUiLCJpbml0RGlzYWJsZWQiLCJzdWJzIiwiQ29tcG9zaXRlRGlzcG9zYWJsZSIsImNvbXBvbmVudERpZE1vdW50IiwicHJvamVjdFBhdGhFZGl0b3IiLCJzZXRUZXh0IiwiaW5pdFBhdGgiLCJjb25maWciLCJnZXQiLCJwcm9qZWN0UGF0aE1vZGlmaWVkIiwicHJvamVjdFBhdGhFbGVtZW50Iiwic2V0VGltZW91dCIsImZvY3VzIiwicmVuZGVyIiwiY29tbWFuZFJlZ2lzdHJ5IiwiY2FuY2VsIiwiaW5pdCIsImVkaXRvclJlZiIsImdldFByb2plY3RQYXRoIiwibGVuZ3RoIiwiZGlkQWNjZXB0IiwiZGlkQ2FuY2VsIiwiZWxlbWVudCIsImVkaXRvciIsImdldE1vZGVsIiwicHJvamVjdFBhdGhTdWJzIiwiZGlzcG9zZSIsInJlbW92ZSIsIm9uRGlkQ2hhbmdlIiwic2V0SW5pdEVuYWJsZW1lbnQiLCJhZGQiLCJnZXRUZXh0IiwiZ2V0UmVtb3RlVXJsIiwicmVtb3RlVXJsRWRpdG9yIiwic2V0U3RhdGUiLCJwcm9wVHlwZXMiLCJQcm9wVHlwZXMiLCJvYmplY3QiLCJpc1JlcXVpcmVkIiwiZnVuYyIsInN0cmluZyIsImRlZmF1bHRQcm9wcyJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7Ozs7QUFDQTs7OztBQUNBOztBQUVBOzs7O0FBQ0E7Ozs7QUFFZSxNQUFNQSxVQUFOLFNBQXlCQyxnQkFBTUMsU0FBL0IsQ0FBeUM7O0FBY3REQyxjQUFZQyxLQUFaLEVBQW1CQyxPQUFuQixFQUE0QjtBQUMxQixVQUFNRCxLQUFOLEVBQWFDLE9BQWI7QUFDQSwyQkFBUyxJQUFULEVBQWUsTUFBZixFQUF1QixRQUF2QixFQUFpQyxXQUFqQyxFQUE4QyxtQkFBOUM7O0FBRUEsU0FBS0MsS0FBTCxHQUFhO0FBQ1hDLG9CQUFjO0FBREgsS0FBYjs7QUFJQSxTQUFLQyxJQUFMLEdBQVksSUFBSUMsNkJBQUosRUFBWjtBQUNEOztBQUVEQyxzQkFBb0I7QUFDbEIsUUFBSSxLQUFLQyxpQkFBVCxFQUE0QjtBQUMxQixXQUFLQSxpQkFBTCxDQUF1QkMsT0FBdkIsQ0FBK0IsS0FBS1IsS0FBTCxDQUFXUyxRQUFYLElBQXVCLEtBQUtULEtBQUwsQ0FBV1UsTUFBWCxDQUFrQkMsR0FBbEIsQ0FBc0Isa0JBQXRCLENBQXREO0FBQ0EsV0FBS0MsbUJBQUwsR0FBMkIsS0FBM0I7QUFDRDs7QUFFRCxRQUFJLEtBQUtDLGtCQUFULEVBQTZCO0FBQzNCQyxpQkFBVyxNQUFNLEtBQUtELGtCQUFMLENBQXdCRSxLQUF4QixFQUFqQjtBQUNEO0FBQ0Y7O0FBRURDLFdBQVM7QUFDUCxXQUNFO0FBQUE7QUFBQSxRQUFLLFdBQVUsaUNBQWY7QUFDRTtBQUFDLDBCQUFEO0FBQUEsVUFBVSxVQUFVLEtBQUtoQixLQUFMLENBQVdpQixlQUEvQixFQUFnRCxRQUFPLGNBQXZEO0FBQ0Usc0NBQUMsaUJBQUQsSUFBUyxTQUFRLGFBQWpCLEVBQStCLFVBQVUsS0FBS0MsTUFBOUMsR0FERjtBQUVFLHNDQUFDLGlCQUFELElBQVMsU0FBUSxjQUFqQixFQUFnQyxVQUFVLEtBQUtDLElBQS9DO0FBRkYsT0FERjtBQUtFO0FBQUE7QUFBQSxVQUFNLFdBQVUscUJBQWhCO0FBQ0U7QUFBQTtBQUFBLFlBQU8sV0FBVSx1Q0FBakI7QUFBQTtBQUVFLDhEQUFrQixNQUFNLElBQXhCLEVBQThCLEtBQUssS0FBS0MsU0FBTCxFQUFuQyxFQUFxRCxVQUFTLEdBQTlEO0FBRkY7QUFERixPQUxGO0FBV0U7QUFBQTtBQUFBLFVBQUssV0FBVSxzQkFBZjtBQUNFO0FBQUE7QUFBQSxZQUFRLFdBQVUseUJBQWxCLEVBQTRDLFNBQVMsS0FBS0YsTUFBMUQsRUFBa0UsVUFBUyxHQUEzRTtBQUFBO0FBQUEsU0FERjtBQUlFO0FBQUE7QUFBQTtBQUNFLHVCQUFVLHVDQURaO0FBRUUscUJBQVMsS0FBS0MsSUFGaEI7QUFHRSxzQkFBVSxLQUFLakIsS0FBTCxDQUFXQyxZQUh2QjtBQUlFLHNCQUFTLEdBSlg7QUFBQTtBQUFBO0FBSkY7QUFYRixLQURGO0FBMEJEOztBQUVEZ0IsU0FBTztBQUNMLFFBQUksS0FBS0UsY0FBTCxHQUFzQkMsTUFBdEIsS0FBaUMsQ0FBckMsRUFBd0M7QUFDdEM7QUFDRDs7QUFFRCxTQUFLdEIsS0FBTCxDQUFXdUIsU0FBWCxDQUFxQixLQUFLRixjQUFMLEVBQXJCO0FBQ0Q7O0FBRURILFdBQVM7QUFDUCxTQUFLbEIsS0FBTCxDQUFXd0IsU0FBWDtBQUNEOztBQUVESixjQUFZO0FBQ1YsV0FBT0ssV0FBVztBQUNoQixVQUFJLENBQUNBLE9BQUwsRUFBYztBQUNaO0FBQ0Q7O0FBRUQsV0FBS1osa0JBQUwsR0FBMEJZLE9BQTFCO0FBQ0EsWUFBTUMsU0FBU0QsUUFBUUUsUUFBUixFQUFmO0FBQ0EsVUFBSSxLQUFLcEIsaUJBQUwsS0FBMkJtQixNQUEvQixFQUF1QztBQUNyQyxhQUFLbkIsaUJBQUwsR0FBeUJtQixNQUF6Qjs7QUFFQSxZQUFJLEtBQUtFLGVBQVQsRUFBMEI7QUFDeEIsZUFBS0EsZUFBTCxDQUFxQkMsT0FBckI7QUFDQSxlQUFLekIsSUFBTCxDQUFVMEIsTUFBVixDQUFpQixLQUFLRixlQUF0QjtBQUNEOztBQUVELGFBQUtBLGVBQUwsR0FBdUJGLE9BQU9LLFdBQVAsQ0FBbUIsS0FBS0MsaUJBQXhCLENBQXZCO0FBQ0EsYUFBSzVCLElBQUwsQ0FBVTZCLEdBQVYsQ0FBYyxLQUFLTCxlQUFuQjtBQUNEO0FBQ0YsS0FsQkQ7QUFtQkQ7O0FBRURQLG1CQUFpQjtBQUNmLFdBQU8sS0FBS2QsaUJBQUwsR0FBeUIsS0FBS0EsaUJBQUwsQ0FBdUIyQixPQUF2QixFQUF6QixHQUE0RCxFQUFuRTtBQUNEOztBQUVEQyxpQkFBZTtBQUNiLFdBQU8sS0FBS0MsZUFBTCxHQUF1QixLQUFLQSxlQUFMLENBQXFCRixPQUFyQixFQUF2QixHQUF3RCxFQUEvRDtBQUNEOztBQUVERixzQkFBb0I7QUFDbEIsU0FBS0ssUUFBTCxDQUFjLEVBQUNsQyxjQUFjLEtBQUtrQixjQUFMLEdBQXNCQyxNQUF0QixLQUFpQyxDQUFoRCxFQUFkO0FBQ0Q7QUE3R3FEO2tCQUFuQzFCLFU7QUFBQUEsVSxDQUNaMEMsUyxHQUFZO0FBQ2pCNUIsVUFBUTZCLG9CQUFVQyxNQUFWLENBQWlCQyxVQURSO0FBRWpCeEIsbUJBQWlCc0Isb0JBQVVDLE1BQVYsQ0FBaUJDLFVBRmpCO0FBR2pCbEIsYUFBV2dCLG9CQUFVRyxJQUhKO0FBSWpCbEIsYUFBV2Usb0JBQVVHLElBSko7QUFLakJqQyxZQUFVOEIsb0JBQVVJO0FBTEgsQztBQURBL0MsVSxDQVNaZ0QsWSxHQUFlO0FBQ3BCckIsYUFBVyxNQUFNLENBQUUsQ0FEQztBQUVwQkMsYUFBVyxNQUFNLENBQUU7QUFGQyxDIiwiZmlsZSI6ImluaXQtZGlhbG9nLmpzIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzQuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIvbGliL3ZpZXdzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQge0NvbXBvc2l0ZURpc3Bvc2FibGV9IGZyb20gJ2V2ZW50LWtpdCc7XG5cbmltcG9ydCBDb21tYW5kcywge0NvbW1hbmR9IGZyb20gJy4uL2F0b20vY29tbWFuZHMnO1xuaW1wb3J0IHthdXRvYmluZH0gZnJvbSAnLi4vaGVscGVycyc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEluaXREaWFsb2cgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIGNvbmZpZzogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGNvbW1hbmRSZWdpc3RyeTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGRpZEFjY2VwdDogUHJvcFR5cGVzLmZ1bmMsXG4gICAgZGlkQ2FuY2VsOiBQcm9wVHlwZXMuZnVuYyxcbiAgICBpbml0UGF0aDogUHJvcFR5cGVzLnN0cmluZyxcbiAgfVxuXG4gIHN0YXRpYyBkZWZhdWx0UHJvcHMgPSB7XG4gICAgZGlkQWNjZXB0OiAoKSA9PiB7fSxcbiAgICBkaWRDYW5jZWw6ICgpID0+IHt9LFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMsIGNvbnRleHQpIHtcbiAgICBzdXBlcihwcm9wcywgY29udGV4dCk7XG4gICAgYXV0b2JpbmQodGhpcywgJ2luaXQnLCAnY2FuY2VsJywgJ2VkaXRvclJlZicsICdzZXRJbml0RW5hYmxlbWVudCcpO1xuXG4gICAgdGhpcy5zdGF0ZSA9IHtcbiAgICAgIGluaXREaXNhYmxlZDogZmFsc2UsXG4gICAgfTtcblxuICAgIHRoaXMuc3VicyA9IG5ldyBDb21wb3NpdGVEaXNwb3NhYmxlKCk7XG4gIH1cblxuICBjb21wb25lbnREaWRNb3VudCgpIHtcbiAgICBpZiAodGhpcy5wcm9qZWN0UGF0aEVkaXRvcikge1xuICAgICAgdGhpcy5wcm9qZWN0UGF0aEVkaXRvci5zZXRUZXh0KHRoaXMucHJvcHMuaW5pdFBhdGggfHwgdGhpcy5wcm9wcy5jb25maWcuZ2V0KCdjb3JlLnByb2plY3RIb21lJykpO1xuICAgICAgdGhpcy5wcm9qZWN0UGF0aE1vZGlmaWVkID0gZmFsc2U7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMucHJvamVjdFBhdGhFbGVtZW50KSB7XG4gICAgICBzZXRUaW1lb3V0KCgpID0+IHRoaXMucHJvamVjdFBhdGhFbGVtZW50LmZvY3VzKCkpO1xuICAgIH1cbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItRGlhbG9nIGdpdGh1Yi1Jbml0IG1vZGFsXCI+XG4gICAgICAgIDxDb21tYW5kcyByZWdpc3RyeT17dGhpcy5wcm9wcy5jb21tYW5kUmVnaXN0cnl9IHRhcmdldD1cIi5naXRodWItSW5pdFwiPlxuICAgICAgICAgIDxDb21tYW5kIGNvbW1hbmQ9XCJjb3JlOmNhbmNlbFwiIGNhbGxiYWNrPXt0aGlzLmNhbmNlbH0gLz5cbiAgICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwiY29yZTpjb25maXJtXCIgY2FsbGJhY2s9e3RoaXMuaW5pdH0gLz5cbiAgICAgICAgPC9Db21tYW5kcz5cbiAgICAgICAgPG1haW4gY2xhc3NOYW1lPVwiZ2l0aHViLURpYWxvZ0lucHV0c1wiPlxuICAgICAgICAgIDxsYWJlbCBjbGFzc05hbWU9XCJnaXRodWItRGlhbG9nTGFiZWwgZ2l0aHViLVByb2plY3RQYXRoXCI+XG4gICAgICAgICAgICBJbml0aWFsaXplIGdpdCByZXBvc2l0b3J5IGluIGRpcmVjdG9yeVxuICAgICAgICAgICAgPGF0b20tdGV4dC1lZGl0b3IgbWluaT17dHJ1ZX0gcmVmPXt0aGlzLmVkaXRvclJlZigpfSB0YWJJbmRleD1cIjJcIiAvPlxuICAgICAgICAgIDwvbGFiZWw+XG4gICAgICAgIDwvbWFpbj5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItRGlhbG9nQnV0dG9uc1wiPlxuICAgICAgICAgIDxidXR0b24gY2xhc3NOYW1lPVwiYnRuIGdpdGh1Yi1DYW5jZWxCdXR0b25cIiBvbkNsaWNrPXt0aGlzLmNhbmNlbH0gdGFiSW5kZXg9XCIzXCI+XG4gICAgICAgICAgICBDYW5jZWxcbiAgICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgICA8YnV0dG9uXG4gICAgICAgICAgICBjbGFzc05hbWU9XCJidG4gYnRuLXByaW1hcnkgaWNvbiBpY29uLXJlcG8tY3JlYXRlXCJcbiAgICAgICAgICAgIG9uQ2xpY2s9e3RoaXMuaW5pdH1cbiAgICAgICAgICAgIGRpc2FibGVkPXt0aGlzLnN0YXRlLmluaXREaXNhYmxlZH1cbiAgICAgICAgICAgIHRhYkluZGV4PVwiNFwiPlxuICAgICAgICAgICAgSW5pdFxuICAgICAgICAgIDwvYnV0dG9uPlxuICAgICAgICA8L2Rpdj5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICBpbml0KCkge1xuICAgIGlmICh0aGlzLmdldFByb2plY3RQYXRoKCkubGVuZ3RoID09PSAwKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgdGhpcy5wcm9wcy5kaWRBY2NlcHQodGhpcy5nZXRQcm9qZWN0UGF0aCgpKTtcbiAgfVxuXG4gIGNhbmNlbCgpIHtcbiAgICB0aGlzLnByb3BzLmRpZENhbmNlbCgpO1xuICB9XG5cbiAgZWRpdG9yUmVmKCkge1xuICAgIHJldHVybiBlbGVtZW50ID0+IHtcbiAgICAgIGlmICghZWxlbWVudCkge1xuICAgICAgICByZXR1cm47XG4gICAgICB9XG5cbiAgICAgIHRoaXMucHJvamVjdFBhdGhFbGVtZW50ID0gZWxlbWVudDtcbiAgICAgIGNvbnN0IGVkaXRvciA9IGVsZW1lbnQuZ2V0TW9kZWwoKTtcbiAgICAgIGlmICh0aGlzLnByb2plY3RQYXRoRWRpdG9yICE9PSBlZGl0b3IpIHtcbiAgICAgICAgdGhpcy5wcm9qZWN0UGF0aEVkaXRvciA9IGVkaXRvcjtcblxuICAgICAgICBpZiAodGhpcy5wcm9qZWN0UGF0aFN1YnMpIHtcbiAgICAgICAgICB0aGlzLnByb2plY3RQYXRoU3Vicy5kaXNwb3NlKCk7XG4gICAgICAgICAgdGhpcy5zdWJzLnJlbW92ZSh0aGlzLnByb2plY3RQYXRoU3Vicyk7XG4gICAgICAgIH1cblxuICAgICAgICB0aGlzLnByb2plY3RQYXRoU3VicyA9IGVkaXRvci5vbkRpZENoYW5nZSh0aGlzLnNldEluaXRFbmFibGVtZW50KTtcbiAgICAgICAgdGhpcy5zdWJzLmFkZCh0aGlzLnByb2plY3RQYXRoU3Vicyk7XG4gICAgICB9XG4gICAgfTtcbiAgfVxuXG4gIGdldFByb2plY3RQYXRoKCkge1xuICAgIHJldHVybiB0aGlzLnByb2plY3RQYXRoRWRpdG9yID8gdGhpcy5wcm9qZWN0UGF0aEVkaXRvci5nZXRUZXh0KCkgOiAnJztcbiAgfVxuXG4gIGdldFJlbW90ZVVybCgpIHtcbiAgICByZXR1cm4gdGhpcy5yZW1vdGVVcmxFZGl0b3IgPyB0aGlzLnJlbW90ZVVybEVkaXRvci5nZXRUZXh0KCkgOiAnJztcbiAgfVxuXG4gIHNldEluaXRFbmFibGVtZW50KCkge1xuICAgIHRoaXMuc2V0U3RhdGUoe2luaXREaXNhYmxlZDogdGhpcy5nZXRQcm9qZWN0UGF0aCgpLmxlbmd0aCA9PT0gMH0pO1xuICB9XG59XG4iXX0=