'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _tooltip = require('../atom/tooltip');

var _tooltip2 = _interopRequireDefault(_tooltip);

var _keystroke = require('../atom/keystroke');

var _keystroke2 = _interopRequireDefault(_keystroke);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function theBuckStopsHere(event) {
  event.stopPropagation();
}

class HunkHeaderView extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'didMouseDown');

    this.refDiscardButton = new _refHolder2.default();
  }

  render() {
    const conditional = {
      'github-HunkHeaderView--isSelected': this.props.isSelected,
      'github-HunkHeaderView--isHunkMode': this.props.selectionMode === 'hunk'
    };

    return _react2.default.createElement(
      'div',
      { className: (0, _classnames2.default)('github-HunkHeaderView', conditional), onMouseDown: this.didMouseDown },
      _react2.default.createElement(
        'span',
        { className: 'github-HunkHeaderView-title' },
        this.props.hunk.getHeader().trim(),
        ' ',
        this.props.hunk.getSectionHeading().trim()
      ),
      _react2.default.createElement(
        'button',
        {
          className: 'github-HunkHeaderView-stageButton',
          onClick: this.props.toggleSelection,
          onMouseDown: theBuckStopsHere },
        _react2.default.createElement(_keystroke2.default, { keymaps: this.props.keymaps, command: 'core:confirm', refTarget: this.props.refTarget }),
        this.props.toggleSelectionLabel
      ),
      this.props.stagingStatus === 'unstaged' && _react2.default.createElement(
        _react.Fragment,
        null,
        _react2.default.createElement('button', {
          ref: this.refDiscardButton.setter,
          className: 'icon-trashcan github-HunkHeaderView-discardButton',
          onClick: this.props.discardSelection,
          onMouseDown: theBuckStopsHere
        }),
        _react2.default.createElement(_tooltip2.default, {
          manager: this.props.tooltips,
          target: this.refDiscardButton,
          title: this.props.discardSelectionLabel
        })
      )
    );
  }

  didMouseDown(event) {
    return this.props.mouseDown(event, this.props.hunk);
  }
}
exports.default = HunkHeaderView;
HunkHeaderView.propTypes = {
  refTarget: _propTypes3.RefHolderPropType.isRequired,
  hunk: _propTypes2.default.object.isRequired,
  isSelected: _propTypes2.default.bool.isRequired,
  stagingStatus: _propTypes2.default.oneOf(['unstaged', 'staged']).isRequired,
  selectionMode: _propTypes2.default.oneOf(['hunk', 'line']).isRequired,
  toggleSelectionLabel: _propTypes2.default.string.isRequired,
  discardSelectionLabel: _propTypes2.default.string.isRequired,

  tooltips: _propTypes2.default.object.isRequired,
  keymaps: _propTypes2.default.object.isRequired,

  toggleSelection: _propTypes2.default.func.isRequired,
  discardSelection: _propTypes2.default.func.isRequired,
  mouseDown: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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