'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _propTypes3 = require('../prop-types');

var _loadingView = require('./loading-view');

var _loadingView2 = _interopRequireDefault(_loadingView);

var _remoteSelectorView = require('./remote-selector-view');

var _remoteSelectorView2 = _interopRequireDefault(_remoteSelectorView);

var _remoteContainer = require('../containers/remote-container');

var _remoteContainer2 = _interopRequireDefault(_remoteContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitHubTabView extends _react2.default.Component {

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-GitHub', ref: this.props.rootHolder.setter },
      _react2.default.createElement(
        'div',
        { className: 'github-GitHub-content' },
        this.renderRemote()
      )
    );
  }

  renderRemote() {
    if (this.props.isLoading) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    if (this.props.currentRemote.isPresent()) {
      // Single, chosen or unambiguous remote
      // only supporting GH.com for now, hardcoded values
      return _react2.default.createElement(_remoteContainer2.default, {
        host: 'https://api.github.com',
        loginModel: this.props.loginModel,
        remoteOperationObserver: this.props.remoteOperationObserver,
        workingDirectory: this.props.workingDirectory,
        workspace: this.props.workspace,
        onPushBranch: () => this.props.handlePushBranch(this.props.currentBranch, this.props.currentRemote),
        remote: this.props.currentRemote,
        remotes: this.props.remotes,
        branches: this.props.branches,
        aheadCount: this.props.aheadCount,
        pushInProgress: this.props.pushInProgress
      });
    }

    if (this.props.manyRemotesAvailable) {
      // No chosen remote, multiple remotes hosted on GitHub instances
      return _react2.default.createElement(_remoteSelectorView2.default, {
        remotes: this.props.remotes,
        currentBranch: this.props.currentBranch,
        selectRemote: this.props.handleRemoteSelect
      });
    }

    // No remotes available
    // TODO: display a view that lets you create a repository on GitHub
    return _react2.default.createElement(
      'div',
      { className: 'github-GitHub-noRemotes' },
      'This repository does not have any remotes hosted at GitHub.com.'
    );
  }
}
exports.default = GitHubTabView;
GitHubTabView.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,
  loginModel: _propTypes3.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes3.RefHolderPropType.isRequired,

  workingDirectory: _propTypes2.default.string.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  currentBranch: _propTypes3.BranchPropType.isRequired,
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  currentRemote: _propTypes3.RemotePropType.isRequired,
  manyRemotesAvailable: _propTypes2.default.bool.isRequired,
  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,
  isLoading: _propTypes2.default.bool.isRequired,

  handlePushBranch: _propTypes2.default.func.isRequired,
  handleRemoteSelect: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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