'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _atom = require('atom');

var _stagingView = require('./staging-view');

var _stagingView2 = _interopRequireDefault(_stagingView);

var _gitLogo = require('./git-logo');

var _gitLogo2 = _interopRequireDefault(_gitLogo);

var _commitController = require('../controllers/commit-controller');

var _commitController2 = _interopRequireDefault(_commitController);

var _recentCommitsController = require('../controllers/recent-commits-controller');

var _recentCommitsController2 = _interopRequireDefault(_recentCommitsController);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitTabView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'initializeRepo', 'blur', 'advanceFocus', 'retreatFocus', 'quietlySelectItem');

    this.subscriptions = new _atom.CompositeDisposable();

    this.refCommitController = new _refHolder2.default();
  }

  componentDidMount() {
    this.props.refRoot.map(root => {
      return this.subscriptions.add(this.props.commandRegistry.add(root, {
        'tool-panel:unfocus': this.blur,
        'core:focus-next': this.advanceFocus,
        'core:focus-previous': this.retreatFocus
      }));
    });
  }

  render() {
    if (this.props.repository.isTooLarge()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-Git is-empty', tabIndex: '-1', ref: this.props.refRoot.setter },
        _react2.default.createElement(
          'div',
          { ref: 'noRepoMessage', className: 'github-Git no-repository' },
          _react2.default.createElement(
            'div',
            { className: 'large-icon' },
            _react2.default.createElement(_gitLogo2.default, null)
          ),
          _react2.default.createElement(
            'h3',
            null,
            'Too many changes'
          ),
          _react2.default.createElement(
            'div',
            { className: 'initialize-repo-description' },
            'The repository at ',
            _react2.default.createElement(
              'strong',
              null,
              this.props.workingDirectoryPath
            ),
            ' has too many changed files to display in Atom. Ensure that you have set up an appropriate ',
            _react2.default.createElement(
              'code',
              null,
              '.gitignore'
            ),
            ' file.'
          )
        )
      );
    } else if (this.props.repository.hasDirectory() && !(0, _helpers.isValidWorkdir)(this.props.repository.getWorkingDirectoryPath())) {
      return _react2.default.createElement(
        'div',
        { className: 'github-Git is-empty', tabIndex: '-1', ref: this.props.refRoot.setter },
        _react2.default.createElement(
          'div',
          { ref: 'noRepoMessage', className: 'github-Git no-repository' },
          _react2.default.createElement(
            'div',
            { className: 'large-icon' },
            _react2.default.createElement(_gitLogo2.default, null)
          ),
          _react2.default.createElement(
            'h3',
            null,
            'Unsupported directory'
          ),
          _react2.default.createElement(
            'div',
            { className: 'initialize-repo-description' },
            'Atom does not support managing Git repositories in your home or root directories.'
          )
        )
      );
    } else if (this.props.repository.showGitTabInit()) {
      const inProgress = this.props.repository.showGitTabInitInProgress();
      const message = this.props.repository.hasDirectory() ? _react2.default.createElement(
        'span',
        null,
        'Initialize ',
        _react2.default.createElement(
          'strong',
          null,
          this.props.workingDirectoryPath
        ),
        ' with a Git repository'
      ) : _react2.default.createElement(
        'span',
        null,
        'Initialize a new project directory with a Git repository'
      );

      return _react2.default.createElement(
        'div',
        { className: 'github-Git is-empty', tabIndex: '-1', ref: this.props.refRoot.setter },
        _react2.default.createElement(
          'div',
          { ref: 'noRepoMessage', className: 'github-Git no-repository' },
          _react2.default.createElement(
            'div',
            { className: 'large-icon' },
            _react2.default.createElement(_gitLogo2.default, null)
          ),
          _react2.default.createElement(
            'div',
            { className: 'initialize-repo-description' },
            message
          ),
          _react2.default.createElement(
            'button',
            { onClick: this.initializeRepo, disabled: inProgress, className: 'btn btn-primary' },
            inProgress ? 'Creating repository...' : 'Create repository'
          )
        )
      );
    } else {
      const isLoading = this.props.isLoading || this.props.repository.showGitTabLoading();

      return _react2.default.createElement(
        'div',
        {
          className: (0, _classnames2.default)('github-Git', { 'is-loading': isLoading }),
          tabIndex: '-1',
          ref: this.props.refRoot.setter },
        _react2.default.createElement(_stagingView2.default, {
          ref: this.props.refStagingView.setter,
          commandRegistry: this.props.commandRegistry,
          notificationManager: this.props.notificationManager,
          workspace: this.props.workspace,
          stagedChanges: this.props.stagedChanges,
          unstagedChanges: this.props.unstagedChanges,
          mergeConflicts: this.props.mergeConflicts,
          workingDirectoryPath: this.props.workingDirectoryPath,
          resolutionProgress: this.props.resolutionProgress,
          openFiles: this.props.openFiles,
          discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
          attemptFileStageOperation: this.props.attemptFileStageOperation,
          attemptStageAllOperation: this.props.attemptStageAllOperation,
          undoLastDiscard: this.props.undoLastDiscard,
          abortMerge: this.props.abortMerge,
          resolveAsOurs: this.props.resolveAsOurs,
          resolveAsTheirs: this.props.resolveAsTheirs,
          lastCommit: this.props.lastCommit,
          isLoading: this.props.isLoading,
          hasUndoHistory: this.props.hasUndoHistory,
          isMerging: this.props.isMerging
        }),
        _react2.default.createElement(_commitController2.default, {
          ref: this.refCommitController.setter,
          tooltips: this.props.tooltips,
          config: this.props.config,
          stagedChangesExist: this.props.stagedChanges.length > 0,
          mergeConflictsExist: this.props.mergeConflicts.length > 0,
          prepareToCommit: this.props.prepareToCommit,
          commit: this.props.commit,
          abortMerge: this.props.abortMerge,
          currentBranch: this.props.currentBranch,
          workspace: this.props.workspace,
          commandRegistry: this.props.commandRegistry,
          notificationManager: this.props.notificationManager,
          grammars: this.props.grammars,
          mergeMessage: this.props.mergeMessage,
          isMerging: this.props.isMerging,
          isLoading: this.props.isLoading,
          lastCommit: this.props.lastCommit,
          repository: this.props.repository,
          userStore: this.props.userStore,
          selectedCoAuthors: this.props.selectedCoAuthors,
          updateSelectedCoAuthors: this.props.updateSelectedCoAuthors
        }),
        _react2.default.createElement(_recentCommitsController2.default, {
          commits: this.props.recentCommits,
          isLoading: this.props.isLoading,
          undoLastCommit: this.props.undoLastCommit
        })
      );
    }
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }

  initializeRepo(event) {
    event.preventDefault();
    let initPath = null;
    const activeEditor = this.props.workspace.getActiveTextEditor();
    if (activeEditor) {
      const [projectPath] = this.props.project.relativizePath(activeEditor.getPath());
      if (projectPath) {
        initPath = projectPath;
      }
    }
    this.props.initializeRepo(initPath);
  }

  rememberFocus(event) {
    let currentFocus = null;

    currentFocus = this.props.refStagingView.map(view => view.rememberFocus(event)).getOr(null);

    if (!currentFocus) {
      currentFocus = this.refCommitController.map(controller => controller.rememberFocus(event)).getOr(null);
    }

    return currentFocus;
  }

  setFocus(focus) {
    if (this.props.refStagingView.map(view => view.setFocus(focus)).getOr(false)) {
      return true;
    }

    if (this.refCommitController.map(controller => controller.setFocus(focus)).getOr(false)) {
      return true;
    }

    return false;
  }

  blur() {
    this.props.workspace.getCenter().activate();
  }

  async advanceFocus(evt) {
    // Advance focus within the CommitView if it's there
    if (this.refCommitController.map(c => c.advanceFocus(evt)).getOr(false)) {
      return;
    }

    // Advance focus to the next staging view list, if it's there
    if (await this.props.refStagingView.map(view => view.activateNextList()).getOr(false)) {
      evt.stopPropagation();
      return;
    }

    // Advance focus from the staging view lists to the CommitView
    if (this.refCommitController.map(c => c.setFocus(GitTabView.focus.COMMIT_PREVIEW_BUTTON)).getOr(false)) {
      evt.stopPropagation();
    }
  }

  async retreatFocus(evt) {
    // Retreat focus within the CommitView if it's there
    if (this.refCommitController.map(c => c.retreatFocus(evt)).getOr(false)) {
      return;
    }

    if (this.refCommitController.map(c => c.hasFocusAtBeginning()).getOr(false)) {
      // Retreat focus from the beginning of the CommitView to the end of the StagingView
      if (await this.props.refStagingView.map(view => view.activateLastList()).getOr(null)) {
        this.setFocus(GitTabView.focus.STAGING);
        evt.stopPropagation();
      }
    } else if (await this.props.refStagingView.map(c => c.activatePreviousList()).getOr(null)) {
      // Retreat focus within the StagingView
      this.setFocus(GitTabView.focus.STAGING);
      evt.stopPropagation();
    }
  }

  async focusAndSelectStagingItem(filePath, stagingStatus) {
    await this.quietlySelectItem(filePath, stagingStatus);
    this.setFocus(GitTabView.focus.STAGING);
  }

  focusAndSelectCommitPreviewButton() {
    this.setFocus(GitTabView.focus.COMMIT_PREVIEW_BUTTON);
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.props.refStagingView.map(view => view.quietlySelectItem(filePath, stagingStatus)).getOr(false);
  }

  hasFocus() {
    return this.props.refRoot.map(root => root.contains(document.activeElement)).getOr(false);
  }
}
exports.default = GitTabView;
GitTabView.focus = _extends({}, _stagingView2.default.focus, _commitController2.default.focus, _recentCommitsController2.default.focus);
GitTabView.propTypes = {
  refRoot: _propTypes3.RefHolderPropType,
  refStagingView: _propTypes3.RefHolderPropType,

  repository: _propTypes2.default.object.isRequired,
  isLoading: _propTypes2.default.bool.isRequired,

  lastCommit: _propTypes2.default.object.isRequired,
  currentBranch: _propTypes2.default.object,
  recentCommits: _propTypes2.default.arrayOf(_propTypes2.default.object).isRequired,
  isMerging: _propTypes2.default.bool,
  isRebasing: _propTypes2.default.bool,
  hasUndoHistory: _propTypes2.default.bool,
  unstagedChanges: _propTypes2.default.arrayOf(_propTypes2.default.object),
  stagedChanges: _propTypes2.default.arrayOf(_propTypes2.default.object),
  mergeConflicts: _propTypes2.default.arrayOf(_propTypes2.default.object),
  workingDirectoryPath: _propTypes2.default.string,
  mergeMessage: _propTypes2.default.string,
  userStore: _propTypes3.UserStorePropType.isRequired,
  selectedCoAuthors: _propTypes2.default.arrayOf(_propTypes3.AuthorPropType),
  updateSelectedCoAuthors: _propTypes2.default.func.isRequired,

  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  grammars: _propTypes2.default.object.isRequired,
  resolutionProgress: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,
  project: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,

  initializeRepo: _propTypes2.default.func.isRequired,
  abortMerge: _propTypes2.default.func.isRequired,
  commit: _propTypes2.default.func.isRequired,
  undoLastCommit: _propTypes2.default.func.isRequired,
  prepareToCommit: _propTypes2.default.func.isRequired,
  resolveAsOurs: _propTypes2.default.func.isRequired,
  resolveAsTheirs: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  attemptStageAllOperation: _propTypes2.default.func.isRequired,
  attemptFileStageOperation: _propTypes2.default.func.isRequired,
  discardWorkDirChangesForPaths: _propTypes2.default.func.isRequired,
  openFiles: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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