'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _changedFileItem = require('../items/changed-file-item');

var _changedFileItem2 = _interopRequireDefault(_changedFileItem);

var _commitPreviewItem = require('../items/commit-preview-item');

var _commitPreviewItem2 = _interopRequireDefault(_commitPreviewItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class FilePatchHeaderView extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.refMirrorButton = new _refHolder2.default();
    this.refOpenFileButton = new _refHolder2.default();
  }

  render() {
    return _react2.default.createElement(
      'header',
      { className: 'github-FilePatchView-header' },
      _react2.default.createElement(
        'span',
        { className: 'github-FilePatchView-title' },
        this.renderTitle()
      ),
      this.renderButtonGroup()
    );
  }

  renderTitle() {
    if (this.props.itemType === _changedFileItem2.default) {
      const status = this.props.stagingStatus;
      return _react2.default.createElement(
        'span',
        null,
        status[0].toUpperCase(),
        status.slice(1),
        ' Changes for ',
        this.renderPath()
      );
    } else {
      return this.renderPath();
    }
  }

  renderPath() {
    const dirname = _path2.default.dirname(this.props.relPath);
    const basename = _path2.default.basename(this.props.relPath);

    if (dirname === '.') {
      return _react2.default.createElement(
        'span',
        { className: 'gitub-FilePatchHeaderView-basename' },
        basename
      );
    } else {
      return _react2.default.createElement(
        'span',
        null,
        dirname,
        _path2.default.sep,
        _react2.default.createElement(
          'span',
          { className: 'gitub-FilePatchHeaderView-basename' },
          basename
        )
      );
    }
  }

  renderButtonGroup() {
    return _react2.default.createElement(
      'span',
      { className: 'btn-group' },
      this.renderUndoDiscardButton(),
      this.renderMirrorPatchButton(),
      this.renderOpenFileButton(),
      this.renderToggleFileButton()
    );
  }

  renderUndoDiscardButton() {
    const unstagedChangedFileItem = this.props.itemType === _changedFileItem2.default && this.props.stagingStatus === 'unstaged';
    if (unstagedChangedFileItem && this.props.hasUndoHistory) {
      return _react2.default.createElement(
        'button',
        { className: 'btn icon icon-history', onClick: this.props.undoLastDiscard },
        'Undo Discard'
      );
    } else {
      return null;
    }
  }

  renderMirrorPatchButton() {
    if (!this.props.isPartiallyStaged && this.props.hasHunks) {
      return null;
    }

    const attrs = this.props.stagingStatus === 'unstaged' ? {
      iconClass: 'icon-tasklist',
      buttonText: 'View Staged'
    } : {
      iconClass: 'icon-list-unordered',
      buttonText: 'View Unstaged'
    };

    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(
        'button',
        {
          ref: this.refMirrorButton.setter,
          className: (0, _classnames2.default)('btn', 'icon', attrs.iconClass),
          onClick: this.props.diveIntoMirrorPatch },
        attrs.buttonText
      )
    );
  }

  renderOpenFileButton() {
    let buttonText = 'Jump To File';
    if (this.props.hasMultipleFileSelections) {
      buttonText += 's';
    }

    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(
        'button',
        {
          ref: this.refOpenFileButton.setter,
          className: 'btn icon icon-code github-FilePatchHeaderView-jumpToFileButton',
          onClick: this.props.openFile },
        buttonText
      )
    );
  }

  renderToggleFileButton() {
    const attrs = this.props.stagingStatus === 'unstaged' ? {
      buttonClass: 'icon-move-down',
      buttonText: 'Stage File'
    } : {
      buttonClass: 'icon-move-up',
      buttonText: 'Unstage File'
    };

    return _react2.default.createElement(
      'button',
      { className: (0, _classnames2.default)('btn', 'icon', attrs.buttonClass), onClick: this.props.toggleFile },
      attrs.buttonText
    );
  }
}
exports.default = FilePatchHeaderView;
FilePatchHeaderView.propTypes = {
  relPath: _propTypes2.default.string.isRequired,
  stagingStatus: _propTypes2.default.oneOf(['staged', 'unstaged']).isRequired,
  isPartiallyStaged: _propTypes2.default.bool,
  hasHunks: _propTypes2.default.bool.isRequired,
  hasUndoHistory: _propTypes2.default.bool,
  hasMultipleFileSelections: _propTypes2.default.bool.isRequired,

  tooltips: _propTypes2.default.object.isRequired,

  undoLastDiscard: _propTypes2.default.func.isRequired,
  diveIntoMirrorPatch: _propTypes2.default.func.isRequired,
  openFile: _propTypes2.default.func.isRequired,
  toggleFile: _propTypes2.default.func.isRequired,

  itemType: _propTypes2.default.oneOf([_changedFileItem2.default, _commitPreviewItem2.default]).isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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