'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ErrorView extends _react2.default.Component {

  constructor(props) {
    super(props);

    (0, _helpers.autobind)(this, 'renderDescription');
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Message' },
      _react2.default.createElement(
        'div',
        { className: 'github-Message-wrapper' },
        _react2.default.createElement(
          'h1',
          { className: 'github-Message-title' },
          this.props.title
        ),
        this.props.descriptions.map(this.renderDescription),
        _react2.default.createElement(
          'div',
          { className: 'github-Message-action' },
          this.props.retry && _react2.default.createElement(
            'button',
            { className: 'github-Message-button btn btn-primary', onClick: this.props.retry },
            'Try Again'
          ),
          _react2.default.createElement(
            'button',
            { className: 'github-Message-button btn', onClick: this.props.logout },
            'Logout'
          )
        )
      )
    );
  }

  renderDescription(description, key) {
    if (this.props.preformatted) {
      return _react2.default.createElement(
        'pre',
        { key: key, className: 'github-Message-description' },
        description
      );
    } else {
      return _react2.default.createElement(
        'p',
        { key: key, className: 'github-Message-description' },
        description
      );
    }
  }
}
exports.default = ErrorView;
ErrorView.propTypes = {
  title: _propTypes2.default.string,
  descriptions: _propTypes2.default.arrayOf(_propTypes2.default.string),
  preformatted: _propTypes2.default.bool,

  retry: _propTypes2.default.func,
  logout: _propTypes2.default.func
};
ErrorView.defaultProps = {
  title: 'Error',
  descriptions: ['An unknown error occurred'],
  preformatted: false
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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